/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.Named;
import org.gradle.nativeplatform.platform.Architecture;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.ArchitectureDescriptor;
import org.gradle.util.VersionNumber;

public class VisualCppInstall
implements Named {
    private static final String COMPILER_FILENAME = "cl.exe";
    private static final String LINKER_FILENAME = "link.exe";
    private static final String ARCHIVER_FILENAME = "lib.exe";
    private final Map<Architecture, ArchitectureDescriptor> architectureDescriptors;
    private final String name;
    private final VersionNumber version;

    public VisualCppInstall(String name, VersionNumber version, Map<Architecture, ArchitectureDescriptor> architectureDescriptors) {
        this.name = name;
        this.version = version;
        this.architectureDescriptors = architectureDescriptors;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public boolean isSupportedPlatform(NativePlatformInternal targetPlatform) {
        return targetPlatform.getOperatingSystem().isWindows() && this.architectureDescriptors.containsKey(this.getPlatformArchitecture(targetPlatform));
    }

    public List<File> getPath(NativePlatformInternal targetPlatform) {
        return this.getDescriptor(targetPlatform).getPaths();
    }

    public File getCompiler(NativePlatformInternal targetPlatform) {
        return new File(this.getDescriptor(targetPlatform).getBinaryPath(), COMPILER_FILENAME);
    }

    public File getLinker(NativePlatformInternal targetPlatform) {
        return new File(this.getDescriptor(targetPlatform).getBinaryPath(), LINKER_FILENAME);
    }

    public File getArchiver(NativePlatformInternal targetPlatform) {
        return new File(this.getDescriptor(targetPlatform).getBinaryPath(), ARCHIVER_FILENAME);
    }

    public File getAssembler(NativePlatformInternal targetPlatform) {
        ArchitectureDescriptor architectureDescriptor = this.getDescriptor(targetPlatform);
        return new File(architectureDescriptor.getBinaryPath(), architectureDescriptor.getAssemblerFilename());
    }

    public File getBinaryPath(NativePlatformInternal targetPlatform) {
        return this.getDescriptor(targetPlatform).getBinaryPath();
    }

    public File getLibraryPath(NativePlatformInternal targetPlatform) {
        return this.getDescriptor(targetPlatform).getLibraryPath();
    }

    public Map<String, String> getDefinitions(NativePlatformInternal targetPlatform) {
        return this.getDescriptor(targetPlatform).getDefinitions();
    }

    public File getIncludePath(NativePlatformInternal targetPlatform) {
        return this.getDescriptor(targetPlatform).getIncludePath();
    }

    private Architecture getPlatformArchitecture(NativePlatformInternal targetPlatform) {
        return targetPlatform.getArchitecture();
    }

    private ArchitectureDescriptor getDescriptor(NativePlatformInternal targetPlatform) {
        return this.architectureDescriptors.get(this.getPlatformArchitecture(targetPlatform));
    }
}

