/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseWtp;
import org.gradle.plugins.ide.eclipse.model.EclipseWtpComponent;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;

public class WtpClasspathAttributeSupport {
    private final String libDirName;
    private final boolean isUtilityProject;
    private final Set<File> rootConfigFiles;
    private final Set<File> libConfigFiles;

    public WtpClasspathAttributeSupport(Project project, EclipseModel model) {
        this.isUtilityProject = !project.getPlugins().hasPlugin(WarPlugin.class) && !project.getPlugins().hasPlugin(EarPlugin.class);
        EclipseWtp eclipseWtp = model.getWtp();
        EclipseWtpComponent wtpComponent = eclipseWtp.getComponent();
        this.libDirName = wtpComponent.getLibDeployPath();
        Set<Configuration> rootConfigs = wtpComponent.getRootConfigurations();
        Set<Configuration> libConfigs = wtpComponent.getLibConfigurations();
        Set<Configuration> minusConfigs = wtpComponent.getMinusConfigurations();
        this.rootConfigFiles = WtpClasspathAttributeSupport.collectFilesFromConfigs(rootConfigs, minusConfigs);
        this.libConfigFiles = WtpClasspathAttributeSupport.collectFilesFromConfigs(libConfigs, minusConfigs);
    }

    private static Set<File> collectFilesFromConfigs(Set<Configuration> configs, Set<Configuration> minusConfigs) {
        HashSet resultFiles = Sets.newHashSet();
        IdeDependenciesExtractor extractor = new IdeDependenciesExtractor();
        Collection<IdeExtendedRepoFileDependency> dependencies = extractor.resolvedExternalDependencies(configs, minusConfigs);
        for (IdeExtendedRepoFileDependency dependency : dependencies) {
            resultFiles.add(dependency.getFile());
        }
        Collection<IdeLocalFileDependency> localDependencies = extractor.extractLocalFileDependencies(configs, minusConfigs);
        for (IdeLocalFileDependency dependency : localDependencies) {
            resultFiles.add(dependency.getFile());
        }
        return resultFiles;
    }

    public void enhance(Classpath classpath) {
        for (ClasspathEntry entry : classpath.getEntries()) {
            if (!(entry instanceof AbstractClasspathEntry)) continue;
            AbstractClasspathEntry classpathEntry = (AbstractClasspathEntry)entry;
            Map<String, Object> wtpEntries = this.createDeploymentAttribute(classpathEntry);
            classpathEntry.getEntryAttributes().putAll(wtpEntries);
        }
    }

    private Map<String, Object> createDeploymentAttribute(ClasspathEntry entry) {
        if (entry instanceof AbstractLibrary) {
            return this.createDeploymentAttribute((AbstractLibrary)entry);
        }
        if (entry instanceof ProjectDependency) {
            return this.createDeploymentAttribute((ProjectDependency)entry);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> createDeploymentAttribute(AbstractLibrary entry) {
        File file = entry.getLibrary().getFile();
        if (!this.isUtilityProject) {
            if (this.rootConfigFiles.contains(file)) {
                return WtpClasspathAttributeSupport.singleEntryMap("org.eclipse.jst.component.dependency", "/");
            }
            if (this.libConfigFiles.contains(file)) {
                return WtpClasspathAttributeSupport.singleEntryMap("org.eclipse.jst.component.dependency", this.libDirName);
            }
        }
        return WtpClasspathAttributeSupport.singleEntryMap("org.eclipse.jst.component.nondependency", "");
    }

    private Map<String, Object> createDeploymentAttribute(ProjectDependency entry) {
        return WtpClasspathAttributeSupport.singleEntryMap("org.eclipse.jst.component.nondependency", "");
    }

    private static Map<String, Object> singleEntryMap(String key, String value) {
        return ImmutableMap.of((Object)key, (Object)value);
    }
}

