/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightUtilCore
extends FileModificationService {
    public static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language) {
        if (file2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(0);
        }
        if (klass == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(1);
        }
        if (language == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(2);
        }
        return CodeInsightUtilCore.findElementInRange(file2, startOffset, endOffset, klass, language, null);
    }

    private static <T extends PsiElement> T findElementInRange(@NotNull PsiFile file2, int startOffset, int endOffset, @NotNull Class<T> klass, @NotNull Language language, @Nullable PsiElement initialElement) {
        PsiElement element;
        if (file2 == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(3);
        }
        if (klass == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(4);
        }
        if (language == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(5);
        }
        PsiElement element1 = file2.getViewProvider().findElementAt(startOffset, language);
        PsiElement element2 = file2.getViewProvider().findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file2.getViewProvider().findElementAt(startOffset, language);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file2.getViewProvider().findElementAt(endOffset - 1, language);
        }
        if (element2 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        PsiElement psiElement = element = ReflectionUtil.isAssignable(klass, commonParent.getClass()) ? commonParent : PsiTreeUtil.getParentOfType((PsiElement)commonParent, klass);
        if (element == initialElement) {
            return (T)element;
        }
        if (element == null || element.getTextRange().getStartOffset() != startOffset || element.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)element;
    }

    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element) {
        if (element == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(6);
        }
        return CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element, false);
    }

    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(@NotNull T element, boolean useFileLanguage) {
        if (element == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(7);
        }
        PsiFile psiFile = element.getContainingFile();
        Document document = psiFile.getViewProvider().getDocument();
        Language language = useFileLanguage ? psiFile.getLanguage() : PsiUtilCore.getDialect(element);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        RangeMarker rangeMarker = document.createRangeMarker(element.getTextRange());
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        documentManager.commitDocument(document);
        Object elementInRange = CodeInsightUtilCore.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), element.getClass(), language, element);
        rangeMarker.dispose();
        return (T)elementInRange;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(8);
        }
        if (outChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(9);
        }
        return CodeInsightUtilCore.parseStringCharacters(chars, outChars, sourceOffsets, '\"', '\'');
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets, char ... endChars) {
        if (chars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(10);
        }
        if (outChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(11);
        }
        if (endChars == null) {
            CodeInsightUtilCore.$$$reportNull$$$0(12);
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index < chars.length()) {
                        if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index < chars.length()) {
                                if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'u': {
                    while (index != chars.length() && chars.charAt(index) == 'u') {
                        ++index;
                    }
                    if (index + 4 <= chars.length()) {
                        try {
                            int code2 = Integer.parseInt(chars.substring(index, index + 4), 16);
                            if (code2 == 10 || code2 == 13) {
                                return false;
                            }
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code2);
                            index += 4;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    if (CharArrayUtil.indexOf((char[])endChars, (char)c, (int)0, (int)endChars.length) != -1) {
                        outChars.append(c);
                        break;
                    }
                    return false;
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/CodeInsightUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "forcePsiPostprocessAndRestoreElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "parseStringCharacters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

