/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.PresentationInvariant;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionLookupArranger
extends LookupArranger {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionLookupArranger");
    private static final Key<PresentationInvariant> PRESENTATION_INVARIANT = Key.create((String)"PRESENTATION_INVARIANT");
    private final Comparator<LookupElement> BY_PRESENTATION_COMPARATOR = (o1, o2) -> {
        PresentationInvariant invariant = (PresentationInvariant)PRESENTATION_INVARIANT.get((UserDataHolder)o1);
        assert (invariant != null);
        return invariant.compareTo((PresentationInvariant)PRESENTATION_INVARIANT.get((UserDataHolder)o2));
    };
    static final int MAX_PREFERRED_COUNT = 5;
    public static final String OVERFLOW_MESSAGE = "Not all variants are shown, please type more letters to see the rest";
    public static final Key<WeighingContext> WEIGHING_CONTEXT = Key.create((String)"WEIGHING_CONTEXT");
    public static final Key<Integer> PREFIX_CHANGES = Key.create((String)"PREFIX_CHANGES");
    private static final UISettings ourUISettings = UISettings.getInstance();
    private final List<LookupElement> myFrozenItems = new ArrayList<LookupElement>();
    private final int myLimit = Registry.intValue((String)"ide.completion.variant.limit");
    private boolean myOverflow;
    @Nullable
    private CompletionLocation myLocation;
    private final CompletionProgressIndicator myProcess;
    private final Map<CompletionSorterImpl, Classifier<LookupElement>> myClassifiers = new java.util.LinkedHashMap<CompletionSorterImpl, Classifier<LookupElement>>();
    private final Key<CompletionSorterImpl> mySorterKey = Key.create((String)"SORTER_KEY");
    private final CompletionFinalSorter myFinalSorter = CompletionFinalSorter.newSorter();
    private int myPrefixChanges;

    CompletionLookupArranger(CompletionProgressIndicator process2) {
        this.myProcess = process2;
    }

    private MultiMap<CompletionSorterImpl, LookupElement> groupItemsBySorter(Iterable<LookupElement> source) {
        MultiMap inputBySorter = MultiMap.createLinked();
        for (LookupElement element : source) {
            inputBySorter.putValue((Object)this.obtainSorter(element), (Object)element);
        }
        for (CompletionSorterImpl sorter : inputBySorter.keySet()) {
            inputBySorter.put((Object)sorter, this.sortByPresentation(inputBySorter.get((Object)sorter)));
        }
        return inputBySorter;
    }

    @NotNull
    private CompletionSorterImpl obtainSorter(LookupElement element) {
        CompletionSorterImpl completionSorterImpl = (CompletionSorterImpl)((Object)element.getUserData(this.mySorterKey));
        if (completionSorterImpl == null) {
            CompletionLookupArranger.$$$reportNull$$$0(0);
        }
        return completionSorterImpl;
    }

    @Override
    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<LookupElement> items, boolean hideSingleValued) {
        if (items == null) {
            CompletionLookupArranger.$$$reportNull$$$0(1);
        }
        IdentityHashMap map = ContainerUtil.newIdentityHashMap();
        MultiMap<CompletionSorterImpl, LookupElement> inputBySorter = this.groupItemsBySorter(items);
        int sorterNumber = 0;
        for (CompletionSorterImpl sorter : inputBySorter.keySet()) {
            ++sorterNumber;
            Collection thisSorterItems = inputBySorter.get((Object)sorter);
            for (LookupElement element : thisSorterItems) {
                map.put(element, ContainerUtil.newArrayList((Object[])new Pair[]{new Pair((Object)"frozen", (Object)this.myFrozenItems.contains(element)), new Pair((Object)"sorter", (Object)sorterNumber)}));
            }
            ProcessingContext context = this.createContext();
            for (Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter); classifier != null; classifier = classifier.getNext()) {
                THashSet itemSet = ContainerUtil.newIdentityTroveSet((Collection)thisSorterItems);
                List unsortedItems = ContainerUtil.filter((Collection)this.myItems, lookupElement -> itemSet.contains(lookupElement));
                List<Pair<LookupElement, Object>> pairs = classifier.getSortingWeights(unsortedItems, context);
                if (hideSingleValued && CompletionLookupArranger.haveSameWeights(pairs)) continue;
                for (Pair<LookupElement, Object> pair : pairs) {
                    ((List)map.get(pair.first)).add(Pair.create((Object)classifier.getPresentableName(), (Object)pair.second));
                }
            }
        }
        LinkedHashMap result2 = new LinkedHashMap(EqualityPolicy.IDENTITY);
        Map<LookupElement, List<Pair<String, Object>>> additional = this.myFinalSorter.getRelevanceObjects(items);
        for (LookupElement item : items) {
            List mainRelevance = (List)map.get(item);
            List<Pair<String, Object>> additionalRelevance = additional.get(item);
            result2.put(item, additionalRelevance == null ? mainRelevance : ContainerUtil.concat((List)mainRelevance, additionalRelevance));
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            CompletionLookupArranger.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    void associateSorter(LookupElement element, CompletionSorterImpl sorter) {
        element.putUserData(this.mySorterKey, (Object)sorter);
    }

    private static boolean haveSameWeights(List<Pair<LookupElement, Object>> pairs) {
        if (pairs.isEmpty()) {
            return true;
        }
        for (int i = 1; i < pairs.size(); ++i) {
            if (Comparing.equal((Object)pairs.get((int)i).second, (Object)pairs.get((int)0).second)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addElement(LookupElement element, LookupElementPresentation presentation) {
        StatisticsWeigher.clearBaseStatisticsInfo(element);
        PresentationInvariant invariant = new PresentationInvariant(presentation.getItemText(), presentation.getTailText(), presentation.getTypeText());
        element.putUserData(PRESENTATION_INVARIANT, (Object)invariant);
        CompletionSorterImpl sorter = this.obtainSorter(element);
        Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter);
        if (classifier == null) {
            classifier = sorter.buildClassifier(new EmptyClassifier());
            this.myClassifiers.put(sorter, classifier);
        }
        ProcessingContext context = this.createContext();
        classifier.addElement(element, context);
        super.addElement(element, presentation);
        this.trimToLimit(context);
    }

    @Override
    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
        this.myProcess.itemSelected(lookupItem, completionChar);
    }

    private void trimToLimit(ProcessingContext context) {
        if (this.myItems.size() < this.myLimit) {
            return;
        }
        List<LookupElement> items = this.getMatchingItems();
        Iterator<LookupElement> iterator = this.sortByRelevance(this.groupItemsBySorter(items)).iterator();
        THashSet retainedSet = ContainerUtil.newIdentityTroveSet();
        retainedSet.addAll(this.getPrefixItems(true));
        retainedSet.addAll(this.getPrefixItems(false));
        retainedSet.addAll(this.myFrozenItems);
        while (retainedSet.size() < this.myLimit / 2 && iterator.hasNext()) {
            retainedSet.add(iterator.next());
        }
        if (!iterator.hasNext()) {
            return;
        }
        List<LookupElement> removed = this.retainItems((Set<LookupElement>)retainedSet);
        for (LookupElement element : removed) {
            this.removeItem(element, context);
        }
        if (!this.myOverflow) {
            this.myOverflow = true;
            this.myProcess.addAdvertisement(OVERFLOW_MESSAGE, null);
            this.myProcess.addWatchedPrefix(0, (ElementPattern<String>)StandardPatterns.string());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.printTestWarning();
            }
        }
    }

    private void printTestWarning() {
        System.err.println("Your test might miss some lookup items, because only " + this.myLimit / 2 + " most relevant items are guaranteed to be shown in the lookup. You can:");
        System.err.println("1. Make the prefix used for completion longer, so that there are less suggestions.");
        System.err.println("2. Increase 'ide.completion.variant.limit' (using RegistryValue#setValue with a test root disposable).");
        System.err.println("3. Ignore this warning.");
    }

    private void removeItem(LookupElement element, ProcessingContext context) {
        CompletionSorterImpl sorter = this.obtainSorter(element);
        Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter);
        classifier.removeElement(element, context);
    }

    private List<LookupElement> sortByPresentation(Iterable<LookupElement> source) {
        ArrayList startMatches = ContainerUtil.newArrayList();
        ArrayList middleMatches = ContainerUtil.newArrayList();
        for (LookupElement element : source) {
            (this.itemMatcher(element).isStartMatch(element) ? startMatches : middleMatches).add(element);
        }
        ContainerUtil.sort((List)startMatches, this.BY_PRESENTATION_COMPARATOR);
        ContainerUtil.sort((List)middleMatches, this.BY_PRESENTATION_COMPARATOR);
        startMatches.addAll(middleMatches);
        return startMatches;
    }

    private static boolean isAlphaSorted() {
        return ourUISettings.getSortLookupElementsLexicographically();
    }

    @Override
    public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
        if (lookup == null) {
            CompletionLookupArranger.$$$reportNull$$$0(3);
        }
        List<LookupElement> items = this.getMatchingItems();
        Iterable<LookupElement> sortedByRelevance = this.sortByRelevance(this.groupItemsBySorter(items));
        LookupElement relevantSelection = this.findMostRelevantItem(sortedByRelevance);
        LookupImpl lookupImpl = (LookupImpl)lookup;
        List<LookupElement> listModel = CompletionLookupArranger.isAlphaSorted() ? this.sortByPresentation(items) : this.fillModelByRelevance(lookupImpl, (Set<LookupElement>)ContainerUtil.newIdentityTroveSet(items), sortedByRelevance, relevantSelection);
        int toSelect2 = this.getItemToSelect(lookupImpl, listModel, onExplicitAction, relevantSelection);
        LOG.assertTrue(toSelect2 >= 0);
        CompletionLookupArranger.addDummyItems(items.size() - listModel.size(), listModel);
        return new Pair(listModel, (Object)toSelect2);
    }

    private static void addDummyItems(int count, List<LookupElement> listModel) {
        EmptyLookupItem dummy = new EmptyLookupItem("loading...", true);
        for (int i = count; i > 0; --i) {
            listModel.add(dummy);
        }
    }

    private List<LookupElement> fillModelByRelevance(LookupImpl lookup, Set<LookupElement> items, Iterable<LookupElement> sortedElements, @Nullable LookupElement relevantSelection) {
        Iterator<LookupElement> byRelevance = sortedElements.iterator();
        LinkedHashSet<LookupElement> model = new LinkedHashSet<LookupElement>();
        this.addPrefixItems(model);
        this.addFrozenItems(items, model);
        if (model.size() < 5) {
            CompletionLookupArranger.addSomeItems(model, byRelevance, (Condition<LookupElement>)((Condition)lastAdded -> model.size() >= 5));
        }
        CompletionLookupArranger.addCurrentlySelectedItemToTop(lookup, items, model);
        this.freezeTopItems(lookup, model);
        CompletionLookupArranger.ensureItemAdded(items, model, byRelevance, lookup.getCurrentItem());
        CompletionLookupArranger.ensureItemAdded(items, model, byRelevance, relevantSelection);
        CompletionLookupArranger.ensureEverythingVisibleAdded(lookup, model, byRelevance);
        return new ArrayList<LookupElement>(model);
    }

    private static void ensureEverythingVisibleAdded(LookupImpl lookup, LinkedHashSet<LookupElement> model, Iterator<LookupElement> byRelevance) {
        JList list2 = lookup.getList();
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        int limit = Math.max(list2.getLastVisibleIndex(), model.size()) + ourUISettings.getMaxLookupListHeight() * 3;
        CompletionLookupArranger.addSomeItems(model, byRelevance, (Condition<LookupElement>)((Condition)lastAdded -> !testMode && model.size() >= limit));
    }

    private static void ensureItemAdded(Set<LookupElement> items, LinkedHashSet<LookupElement> model, Iterator<LookupElement> byRelevance, @Nullable LookupElement item) {
        if (item != null && items.contains(item) && !model.contains(item)) {
            CompletionLookupArranger.addSomeItems(model, byRelevance, (Condition<LookupElement>)((Condition)lastAdded -> lastAdded == item));
        }
    }

    private void freezeTopItems(LookupImpl lookup, LinkedHashSet<LookupElement> model) {
        this.myFrozenItems.clear();
        if (lookup.isShown()) {
            this.myFrozenItems.addAll(model);
        }
    }

    private void addFrozenItems(Set<LookupElement> items, LinkedHashSet<LookupElement> model) {
        Iterator<LookupElement> iterator = this.myFrozenItems.iterator();
        while (iterator.hasNext()) {
            LookupElement element = iterator.next();
            if (element.isValid() && items.contains(element)) continue;
            iterator.remove();
        }
        model.addAll(this.myFrozenItems);
    }

    private void addPrefixItems(LinkedHashSet<LookupElement> model) {
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(true))));
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(false))));
    }

    private static void addCurrentlySelectedItemToTop(Lookup lookup, Set<LookupElement> items, LinkedHashSet<LookupElement> model) {
        LookupElement lastSelection;
        if (!lookup.isSelectionTouched() && items.contains(lastSelection = lookup.getCurrentItem())) {
            model.add(lastSelection);
        }
    }

    private static void addSomeItems(LinkedHashSet<LookupElement> model, Iterator<LookupElement> iterator, Condition<LookupElement> stopWhen) {
        while (iterator.hasNext()) {
            LookupElement item = iterator.next();
            model.add(item);
            if (!stopWhen.value((Object)item)) continue;
            break;
        }
    }

    private Iterable<LookupElement> sortByRelevance(MultiMap<CompletionSorterImpl, LookupElement> inputBySorter) {
        if (inputBySorter.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList byClassifier = ContainerUtil.newArrayList();
        for (CompletionSorterImpl sorter : this.myClassifiers.keySet()) {
            ProcessingContext context = this.createContext();
            byClassifier.add(this.myClassifiers.get((Object)sorter).classify(inputBySorter.get((Object)sorter), context));
        }
        Iterable result2 = ContainerUtil.concat((Iterable[])byClassifier.toArray(new Iterable[0]));
        return this.myFinalSorter.sort(result2, Objects.requireNonNull(this.myProcess.getParameters()));
    }

    private ProcessingContext createContext() {
        ProcessingContext context = new ProcessingContext();
        context.put(PREFIX_CHANGES, (Object)this.myPrefixChanges);
        context.put(WEIGHING_CONTEXT, (Object)this);
        return context;
    }

    @Override
    public LookupArranger createEmptyCopy() {
        return new CompletionLookupArranger(this.myProcess);
    }

    private int getItemToSelect(LookupImpl lookup, List<LookupElement> items, boolean onExplicitAction, @Nullable LookupElement mostRelevant) {
        LookupElement exactMatch;
        if (items.isEmpty() || lookup.getFocusDegree() == LookupImpl.FocusDegree.UNFOCUSED) {
            return 0;
        }
        if (lookup.isSelectionTouched() || !onExplicitAction) {
            int index;
            LookupElement lastSelection = lookup.getCurrentItem();
            int old = ContainerUtil.indexOfIdentity(items, (Object)lastSelection);
            if (old >= 0) {
                return old;
            }
            Object selectedValue = lookup.getList().getSelectedValue();
            if (selectedValue instanceof EmptyLookupItem && ((EmptyLookupItem)((Object)selectedValue)).isLoading() && (index = lookup.getList().getSelectedIndex()) >= 0 && index < items.size()) {
                return index;
            }
            for (int i = 0; i < items.size(); ++i) {
                PresentationInvariant invariant = (PresentationInvariant)PRESENTATION_INVARIANT.get((UserDataHolder)items.get(i));
                if (invariant == null || !invariant.equals(PRESENTATION_INVARIANT.get((UserDataHolder)lastSelection))) continue;
                return i;
            }
        }
        return Math.max(0, ContainerUtil.indexOfIdentity(items, (Object)((exactMatch = this.getBestExactMatch(lookup, items)) != null ? exactMatch : mostRelevant)));
    }

    private List<LookupElement> getExactMatches(LookupImpl lookup, List<LookupElement> items) {
        String selectedText = lookup.getTopLevelEditor().getSelectionModel().getSelectedText();
        SmartList exactMatches = new SmartList();
        for (int i = 0; i < items.size(); ++i) {
            LookupElement item = items.get(i);
            boolean isSuddenLiveTemplate = CompletionLookupArranger.isSuddenLiveTemplate(item);
            if (this.isPrefixItem(item, true) && !isSuddenLiveTemplate || item.getLookupString().equals(selectedText)) {
                if (item instanceof LiveTemplateLookupElement) {
                    return Collections.singletonList(item);
                }
                exactMatches.add(item);
                continue;
            }
            if (i != 0 || !isSuddenLiveTemplate || items.size() <= 1 || CompletionServiceImpl.isStartMatch(items.get(1), this)) continue;
            return Collections.singletonList(item);
        }
        return exactMatches;
    }

    @Nullable
    private LookupElement getBestExactMatch(LookupImpl lookup, List<LookupElement> items) {
        List<LookupElement> exactMatches = this.getExactMatches(lookup, items);
        if (exactMatches.isEmpty()) {
            return null;
        }
        if (exactMatches.size() == 1) {
            return exactMatches.get(0);
        }
        return this.sortByRelevance(this.groupItemsBySorter(exactMatches)).iterator().next();
    }

    @Nullable
    private LookupElement findMostRelevantItem(Iterable<LookupElement> sorted) {
        CompletionPreselectSkipper[] skippers = (CompletionPreselectSkipper[])CompletionPreselectSkipper.EP_NAME.getExtensions();
        for (LookupElement element : sorted) {
            if (this.shouldSkip(skippers, element)) continue;
            return element;
        }
        return null;
    }

    private static boolean isSuddenLiveTemplate(LookupElement element) {
        return element instanceof LiveTemplateLookupElement && ((LiveTemplateLookupElement)element).sudden;
    }

    private boolean shouldSkip(CompletionPreselectSkipper[] skippers, LookupElement element) {
        CompletionLocation location = this.myLocation;
        if (location == null) {
            location = new CompletionLocation(Objects.requireNonNull(this.myProcess.getParameters()));
        }
        for (CompletionPreselectSkipper skipper : skippers) {
            if (!skipper.skipElement(element, location)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped element " + element + " by " + skipper);
            }
            return true;
        }
        return false;
    }

    @Override
    public void prefixChanged(Lookup lookup) {
        ++this.myPrefixChanges;
        this.myFrozenItems.clear();
        super.prefixChanged(lookup);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionLookupArranger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainSorter";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionLookupArranger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevanceObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRelevanceObjects";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "arrangeItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyClassifier
    extends Classifier<LookupElement> {
        private EmptyClassifier() {
            super(null, "empty");
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<LookupElement> items, @NotNull ProcessingContext context) {
            if (items == null) {
                EmptyClassifier.$$$reportNull$$$0(0);
            }
            if (context == null) {
                EmptyClassifier.$$$reportNull$$$0(1);
            }
            List<Pair<LookupElement, Object>> list2 = Collections.emptyList();
            if (list2 == null) {
                EmptyClassifier.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<LookupElement> source, @NotNull ProcessingContext context) {
            if (source == null) {
                EmptyClassifier.$$$reportNull$$$0(3);
            }
            if (context == null) {
                EmptyClassifier.$$$reportNull$$$0(4);
            }
            Iterable<LookupElement> iterable = source;
            if (iterable == null) {
                EmptyClassifier.$$$reportNull$$$0(5);
            }
            return iterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/CompletionLookupArranger$EmptyClassifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/CompletionLookupArranger$EmptyClassifier";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortingWeights";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classify";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortingWeights";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "classify";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

