/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.KdbxEncryption;
import com.intellij.credentialStore.kdbx.KdbxStreamFormat;
import com.intellij.credentialStore.kdbx.KeePassCredentials;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.util.JdomKt;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Base64;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001aH\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000326\u0010\u0016\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002\u001a \u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"SALSA20_IV", "", "createEmptyDatabase", "Lorg/jdom/Element;", "load", "inputStream", "Ljava/io/InputStream;", "encryption", "Lcom/intellij/credentialStore/kdbx/KdbxEncryption;", "loadKdbx", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "file", "Ljava/nio/file/Path;", "credentials", "Lcom/intellij/credentialStore/kdbx/KeePassCredentials;", "parseTime", "", "value", "", "processEntries", "", "groupElement", "processor", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "container", "valueElement", "save", "rootElement", "outputStream", "Ljava/io/OutputStream;", "intellij.platform.credentialStore"})
public final class KdbxKt {
    private static final byte[] SALSA20_IV = new byte[]{-24, 48, 9, 75, -105, 32, 93, 42};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final KeePassDatabase loadKdbx(@NotNull Path file2, @NotNull KeePassCredentials credentials) {
        KeePassDatabase keePassDatabase;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        InputStream inputStream = PathKt.inputStreamIfExists((Path)file2);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                KeePassDatabase keePassDatabase2 = new KeePassDatabase(new KdbxStreamFormat().load(credentials, it));
                keePassDatabase = keePassDatabase2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            keePassDatabase = null;
        }
        return keePassDatabase;
    }

    public static final void save(@NotNull Element rootElement, @NotNull OutputStream outputStream, @NotNull KdbxEncryption encryption) {
        Element meta;
        Intrinsics.checkParameterIsNotNull((Object)rootElement, (String)"rootElement");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Intrinsics.checkParameterIsNotNull((Object)encryption, (String)"encryption");
        Element element = rootElement.getChild("Meta");
        Object object = meta = element != null ? element.getChild("MemoryProtection") : null;
        if (meta != null) {
            SmartList propertiesToProtect = new SmartList();
            Iterator iterator = meta.getChildren().iterator();
            while (iterator.hasNext()) {
                Element element2;
                Element element3 = element2 = (Element)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"element");
                String string = element3.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.name");
                String propertyName = StringsKt.removePrefix((String)string, (CharSequence)"Protect");
                if (!(Intrinsics.areEqual((Object)propertyName, (Object)element2.getName()) ^ true) || !StringsKt.equals((String)element2.getText(), (String)"true", (boolean)true)) continue;
                propertiesToProtect.add((Object)propertyName);
            }
            Element element4 = rootElement.getChild("Root");
            if (element4 != null && (element4 = element4.getChild("Group")) != null) {
                Element element5;
                Element rootGroupElement = element5 = element4;
                KdbxKt.processEntries(rootGroupElement, (Function2<? super Element, ? super Element, Unit>)((Function2)new Function2<Element, Element, Unit>(propertiesToProtect, encryption){
                    final /* synthetic */ SmartList $propertiesToProtect$inlined;
                    final /* synthetic */ KdbxEncryption $encryption$inlined;
                    {
                        this.$propertiesToProtect$inlined = smartList;
                        this.$encryption$inlined = kdbxEncryption;
                        super(2);
                    }

                    public final void invoke(@NotNull Element container, @NotNull Element valueElement) {
                        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
                        Intrinsics.checkParameterIsNotNull((Object)valueElement, (String)"valueElement");
                        String string = container.getChildText("Key");
                        if (string == null) {
                            return;
                        }
                        String key = string;
                        for (String propertyName : this.$propertiesToProtect$inlined) {
                            byte[] byArray;
                            String string2;
                            if (!Intrinsics.areEqual((Object)key, (Object)propertyName)) continue;
                            valueElement.setAttribute("Protected", "True");
                            Base64.Encoder encoder = Base64.getEncoder();
                            Intrinsics.checkExpressionValueIsNotNull((Object)valueElement.getText(), (String)"valueElement.text");
                            KdbxEncryption kdbxEncryption = this.$encryption$inlined;
                            Base64.Encoder encoder2 = encoder;
                            Element element = valueElement;
                            Charset charset = Charsets.UTF_8;
                            String string3 = string2;
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
                            element.setText(encoder2.encodeToString(kdbxEncryption.encrypt(byArray)));
                        }
                    }
                }));
            }
        }
        JdomKt.write$default((Parent)((Parent)rootElement), (OutputStream)outputStream, null, null, (int)6, null);
    }

    private static final Element load(InputStream inputStream, KdbxEncryption encryption) {
        Element rootElement;
        block0: {
            Element element;
            rootElement = JdomKt.loadElement((InputStream)inputStream);
            Element element2 = rootElement.getChild("Root");
            if (element2 == null || (element2 = element2.getChild("Group")) == null) break block0;
            Element rootGroupElement = element = element2;
            KdbxKt.processEntries(rootGroupElement, (Function2<? super Element, ? super Element, Unit>)((Function2)new Function2<Element, Element, Unit>(encryption){
                final /* synthetic */ KdbxEncryption $encryption$inlined;
                {
                    this.$encryption$inlined = kdbxEncryption;
                    super(2);
                }

                public final void invoke(@NotNull Element $noName_0, @NotNull Element valueElement) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkParameterIsNotNull((Object)valueElement, (String)"valueElement");
                    if (StringsKt.equals((String)valueElement.getAttributeValue("Protected", "false"), (String)"true", (boolean)true)) {
                        byte[] byArray = Base64.getDecoder().decode(valueElement.getText());
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(valueElement.text)");
                        byte[] byArray2 = this.$encryption$inlined.decrypt(byArray);
                        Charset charset = Charsets.UTF_8;
                        Element element = valueElement;
                        String string = new String(byArray2, charset);
                        element.setText(string);
                        valueElement.removeAttribute("Protected");
                    }
                }
            }));
        }
        return rootElement;
    }

    private static final void processEntries(Element groupElement, Function2<? super Element, ? super Element, Unit> processor2) {
        Iterator iterator = groupElement.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element;
            Element element2 = element = (Element)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
            if (Intrinsics.areEqual((Object)element2.getName(), (Object)"Group")) {
                KdbxKt.processEntries(element, processor2);
                continue;
            }
            if (!Intrinsics.areEqual((Object)element.getName(), (Object)"Entry")) continue;
            for (Element container : element.getChildren("String")) {
                Element valueElement;
                if (container.getChild("Value") == null) {
                    continue;
                }
                Element element3 = container;
                Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"container");
                processor2.invoke((Object)element3, (Object)valueElement);
            }
        }
    }

    @NotNull
    public static final Element createEmptyDatabase() {
        String creationDate = KeePassDatabaseKt.formattedNow();
        return JdomKt.loadElement((CharSequence)("<KeePassFile>\n    <Meta>\n      <Generator>IJ</Generator>\n      <HeaderHash></HeaderHash>\n      <DatabaseName>New Database</DatabaseName>\n      <DatabaseNameChanged>" + creationDate + "</DatabaseNameChanged>\n      <DatabaseDescription>Empty Database</DatabaseDescription>\n      <DatabaseDescriptionChanged>" + creationDate + "</DatabaseDescriptionChanged>\n      <DefaultUserName/>\n      <DefaultUserNameChanged>" + creationDate + "</DefaultUserNameChanged>\n      <MaintenanceHistoryDays>365</MaintenanceHistoryDays>\n      <Color/>\n      <MasterKeyChanged>" + creationDate + "</MasterKeyChanged>\n      <MasterKeyChangeRec>-1</MasterKeyChangeRec>\n      <MasterKeyChangeForce>-1</MasterKeyChangeForce>\n      <MemoryProtection>\n          <ProtectTitle>False</ProtectTitle>\n          <ProtectUserName>False</ProtectUserName>\n          <ProtectPassword>True</ProtectPassword>\n          <ProtectURL>False</ProtectURL>\n          <ProtectNotes>False</ProtectNotes>\n      </MemoryProtection>\n      <CustomIcons/>\n      <RecycleBinEnabled>True</RecycleBinEnabled>\n      <RecycleBinUUID>AAAAAAAAAAAAAAAAAAAAAA==</RecycleBinUUID>\n      <RecycleBinChanged>" + creationDate + "</RecycleBinChanged>\n      <EntryTemplatesGroup>AAAAAAAAAAAAAAAAAAAAAA==</EntryTemplatesGroup>\n      <EntryTemplatesGroupChanged>" + creationDate + "</EntryTemplatesGroupChanged>\n      <LastSelectedGroup>AAAAAAAAAAAAAAAAAAAAAA==</LastSelectedGroup>\n      <LastTopVisibleGroup>AAAAAAAAAAAAAAAAAAAAAA==</LastTopVisibleGroup>\n      <HistoryMaxItems>10</HistoryMaxItems>\n      <HistoryMaxSize>6291456</HistoryMaxSize>\n      <Binaries/>\n      <CustomData/>\n    </Meta>\n  </KeePassFile>"));
    }

    public static final long parseTime(@NotNull String value) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        try {
            l = ZonedDateTime.parse(value).toEpochSecond();
        }
        catch (DateTimeParseException e) {
            l = 0L;
        }
        return l;
    }

    @NotNull
    public static final /* synthetic */ Element access$load(@NotNull InputStream inputStream, @NotNull KdbxEncryption encryption) {
        return KdbxKt.load(inputStream, encryption);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$getSALSA20_IV$p() {
        return SALSA20_IV;
    }
}

