/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison.iterables;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.util.Range;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

abstract class ChangeDiffIterableBase
implements DiffIterable {
    private final int myLength1;
    private final int myLength2;

    public ChangeDiffIterableBase(int length1, int length2) {
        this.myLength1 = length1;
        this.myLength2 = length2;
    }

    @Override
    public int getLength1() {
        return this.myLength1;
    }

    @Override
    public int getLength2() {
        return this.myLength2;
    }

    @Override
    @NotNull
    public Iterator<Range> changes() {
        Iterator<Range> iterator = new Iterator<Range>(){
            @NotNull
            private final ChangeIterable myIterable;
            {
                this.myIterable = ChangeDiffIterableBase.this.createChangeIterable();
            }

            @Override
            public boolean hasNext() {
                return this.myIterable.valid();
            }

            @Override
            public Range next() {
                Range range2 = new Range(this.myIterable.getStart1(), this.myIterable.getEnd1(), this.myIterable.getStart2(), this.myIterable.getEnd2());
                this.myIterable.next();
                return range2;
            }
        };
        if (iterator == null) {
            ChangeDiffIterableBase.$$$reportNull$$$0(0);
        }
        return iterator;
    }

    @Override
    @NotNull
    public Iterator<Range> unchanged() {
        Iterator<Range> iterator = new Iterator<Range>(){
            @NotNull
            private final ChangeIterable myIterable;
            int lastIndex1;
            int lastIndex2;
            {
                this.myIterable = ChangeDiffIterableBase.this.createChangeIterable();
                this.lastIndex1 = 0;
                this.lastIndex2 = 0;
                if (this.myIterable.valid() && this.myIterable.getStart1() == 0 && this.myIterable.getStart2() == 0) {
                    this.lastIndex1 = this.myIterable.getEnd1();
                    this.lastIndex2 = this.myIterable.getEnd2();
                    this.myIterable.next();
                }
            }

            @Override
            public boolean hasNext() {
                return this.myIterable.valid() || this.lastIndex1 != ChangeDiffIterableBase.this.myLength1 || this.lastIndex2 != ChangeDiffIterableBase.this.myLength2;
            }

            @Override
            public Range next() {
                if (this.myIterable.valid()) {
                    assert (this.myIterable.getStart1() - this.lastIndex1 != 0 || this.myIterable.getStart2() - this.lastIndex2 != 0);
                    Range chunk = new Range(this.lastIndex1, this.myIterable.getStart1(), this.lastIndex2, this.myIterable.getStart2());
                    this.lastIndex1 = this.myIterable.getEnd1();
                    this.lastIndex2 = this.myIterable.getEnd2();
                    this.myIterable.next();
                    return chunk;
                }
                assert (ChangeDiffIterableBase.this.myLength1 - this.lastIndex1 != 0 || ChangeDiffIterableBase.this.myLength2 - this.lastIndex2 != 0);
                Range chunk = new Range(this.lastIndex1, ChangeDiffIterableBase.this.myLength1, this.lastIndex2, ChangeDiffIterableBase.this.myLength2);
                this.lastIndex1 = ChangeDiffIterableBase.this.myLength1;
                this.lastIndex2 = ChangeDiffIterableBase.this.myLength2;
                return chunk;
            }
        };
        if (iterator == null) {
            ChangeDiffIterableBase.$$$reportNull$$$0(1);
        }
        return iterator;
    }

    @NotNull
    protected abstract ChangeIterable createChangeIterable();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/diff/comparison/iterables/ChangeDiffIterableBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "changes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "unchanged";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    protected static interface ChangeIterable {
        public boolean valid();

        public void next();

        public int getStart1();

        public int getStart2();

        public int getEnd1();

        public int getEnd2();
    }
}

