/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.OperationCanceledDiffRequest;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Function;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDiffRequestProcessor<T>
extends DiffRequestProcessor {
    private static final Logger LOG = Logger.getInstance(CacheDiffRequestProcessor.class);
    @NotNull
    private final SoftHardCacheMap<T, DiffRequest> myRequestCache;
    @NotNull
    private final DiffTaskQueue myQueue;

    public CacheDiffRequestProcessor(@Nullable Project project) {
        super(project);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    public CacheDiffRequestProcessor(@Nullable Project project, @NotNull String place) {
        if (place == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        super(project, place);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    public CacheDiffRequestProcessor(@Nullable Project project, @NotNull UserDataHolder context) {
        if (context == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        super(project, context);
        this.myRequestCache = new SoftHardCacheMap(5, 5);
        this.myQueue = new DiffTaskQueue();
    }

    @Nullable
    protected abstract String getRequestName(@NotNull T var1);

    protected abstract T getCurrentRequestProvider();

    @NotNull
    protected abstract DiffRequest loadRequest(@NotNull T var1, @NotNull ProgressIndicator var2) throws ProcessCanceledException, DiffRequestProducerException;

    @Override
    protected void reloadRequest() {
        this.updateRequest(true, false, null);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.updateRequest(force, true, scrollToChangePolicy);
    }

    public void updateRequest(boolean force, boolean useCache, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        DiffRequest cachedRequest;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        T requestProvider = this.getCurrentRequestProvider();
        if (requestProvider == null) {
            this.applyRequest((DiffRequest)NoDiffRequest.INSTANCE, force, scrollToChangePolicy);
            return;
        }
        DiffRequest diffRequest = cachedRequest = useCache ? this.loadRequestFast(requestProvider) : null;
        if (cachedRequest != null) {
            this.applyRequest(cachedRequest, force, scrollToChangePolicy);
            return;
        }
        this.myQueue.executeAndTryWait((Function<ProgressIndicator, Runnable>)((Function)indicator -> {
            DiffRequest request = this.doLoadRequest(requestProvider, (ProgressIndicator)indicator);
            return () -> {
                this.myRequestCache.put(requestProvider, request);
                this.applyRequest(request, force, scrollToChangePolicy);
            };
        }), () -> this.applyRequest((DiffRequest)new LoadingDiffRequest(this.getRequestName(requestProvider)), force, scrollToChangePolicy), 300L);
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull T provider) {
        if (provider == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return this.myRequestCache.get(provider);
    }

    @NotNull
    private DiffRequest doLoadRequest(@NotNull T provider, @NotNull ProgressIndicator indicator) {
        DiffRequest diffRequest;
        if (provider == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(4);
        }
        String name = this.getRequestName(provider);
        try {
            diffRequest = this.loadRequest(provider, indicator);
        }
        catch (ProcessCanceledException e) {
            OperationCanceledDiffRequest request = new OperationCanceledDiffRequest(name);
            request.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new ReloadRequestAction(provider)));
            OperationCanceledDiffRequest operationCanceledDiffRequest = request;
            if (operationCanceledDiffRequest == null) {
                CacheDiffRequestProcessor.$$$reportNull$$$0(6);
            }
            return operationCanceledDiffRequest;
        }
        catch (DiffRequestProducerException e) {
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest(name, (Throwable)e);
            if (errorDiffRequest == null) {
                CacheDiffRequestProcessor.$$$reportNull$$$0(7);
            }
            return errorDiffRequest;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            ErrorDiffRequest errorDiffRequest = new ErrorDiffRequest(name, (Throwable)e);
            if (errorDiffRequest == null) {
                CacheDiffRequestProcessor.$$$reportNull$$$0(8);
            }
            return errorDiffRequest;
        }
        if (diffRequest == null) {
            CacheDiffRequestProcessor.$$$reportNull$$$0(5);
        }
        return diffRequest;
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.myQueue.abort();
        this.myRequestCache.clear();
    }

    protected void dropCaches() {
        this.myRequestCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/impl/CacheDiffRequestProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doLoadRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadRequestFast";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doLoadRequest";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ReloadRequestAction
    extends DumbAwareAction {
        @NotNull
        private final T myProducer;

        public ReloadRequestAction(T provider) {
            if (provider == null) {
                ReloadRequestAction.$$$reportNull$$$0(0);
            }
            super("Reload", null, AllIcons.Actions.Refresh);
            this.myProducer = provider;
        }

        public void actionPerformed(AnActionEvent e) {
            CacheDiffRequestProcessor.this.myRequestCache.remove(this.myProducer);
            CacheDiffRequestProcessor.this.updateRequest(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diff/impl/CacheDiffRequestProcessor$ReloadRequestAction", "<init>"));
        }
    }
}

