/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.lang.DiffIgnoredRangeProvider;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProviderBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTextDiffProvider
extends TwosideTextDiffProviderBase
implements TwosideTextDiffProvider {
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES_CHUNKS, IgnorePolicy.FORMATTING};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD, HighlightPolicy.BY_WORD_SPLIT, HighlightPolicy.DO_NOT_HIGHLIGHT};
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContent myContent1;
    @NotNull
    private final DiffContent myContent2;
    @NotNull
    private final DiffIgnoredRangeProvider myProvider;

    @Nullable
    public static TwosideTextDiffProvider create(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffContent content2;
        DiffContent content1;
        DiffIgnoredRangeProvider ignoredRangeProvider;
        if (request == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(1);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(3);
        }
        if ((ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project, content1 = (DiffContent)Side.LEFT.select(request.getContents()), content2 = (DiffContent)Side.RIGHT.select(request.getContents()))) == null) {
            return null;
        }
        return new SmartTextDiffProvider(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider);
    }

    @Nullable
    public static TwosideTextDiffProvider.NoIgnore createNoIgnore(@Nullable Project project, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffContent content2;
        DiffContent content1;
        DiffIgnoredRangeProvider ignoredRangeProvider;
        if (request == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(5);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(7);
        }
        if ((ignoredRangeProvider = SmartTextDiffProvider.getIgnoredRangeProvider(project, content1 = (DiffContent)Side.LEFT.select(request.getContents()), content2 = (DiffContent)Side.RIGHT.select(request.getContents()))) == null) {
            return null;
        }
        return new NoIgnore(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider);
    }

    private SmartTextDiffProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(8);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(9);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(10);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(11);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(12);
        }
        if (ignoredRangeProvider == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(13);
        }
        this(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
    }

    private SmartTextDiffProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(14);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(15);
        }
        if (settings == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(16);
        }
        if (rediff == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(17);
        }
        if (disposable == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(18);
        }
        if (ignoredRangeProvider == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(19);
        }
        if (ignorePolicies == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(20);
        }
        if (highlightPolicies == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(21);
        }
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
        this.myProject = project;
        this.myContent1 = content1;
        this.myContent2 = content2;
        this.myProvider = ignoredRangeProvider;
    }

    @Override
    @Nullable
    protected String getText(@NotNull IgnorePolicy option) {
        if (option == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(22);
        }
        if (option == IgnorePolicy.FORMATTING) {
            return this.myProvider.getDescription();
        }
        return null;
    }

    @Override
    @NotNull
    protected List<List<LineFragment>> doCompare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull List<Range> linesRanges, @NotNull IgnorePolicy ignorePolicy, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(23);
        }
        if (text2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(24);
        }
        if (lineOffsets1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(25);
        }
        if (lineOffsets2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(26);
        }
        if (linesRanges == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(27);
        }
        if (ignorePolicy == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(28);
        }
        if (indicator == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(29);
        }
        if (ignorePolicy == IgnorePolicy.FORMATTING) {
            List<List<LineFragment>> list2 = this.compareIgnoreFormatting(text1, text2, lineOffsets1, lineOffsets2, linesRanges, innerFragments, indicator);
            if (list2 == null) {
                SmartTextDiffProvider.$$$reportNull$$$0(30);
            }
            return list2;
        }
        List<List<LineFragment>> list3 = SimpleTextDiffProvider.compareRange(SimpleTextDiffProvider.DEFAULT_COMPUTER, text1, text2, lineOffsets1, lineOffsets2, linesRanges, ignorePolicy, innerFragments, indicator);
        if (list3 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(31);
        }
        return list3;
    }

    @NotNull
    private List<List<LineFragment>> compareIgnoreFormatting(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull List<Range> linesRanges, boolean innerFragments, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(32);
        }
        if (text2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(33);
        }
        if (lineOffsets1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(34);
        }
        if (lineOffsets2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(35);
        }
        if (linesRanges == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(36);
        }
        if (indicator == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(37);
        }
        List<TextRange> ranges1 = this.myProvider.getIgnoredRanges(this.myProject, text1, this.myContent1);
        List<TextRange> ranges2 = this.myProvider.getIgnoredRanges(this.myProject, text2, this.myContent2);
        ArrayList<List<LineFragment>> result2 = new ArrayList<List<LineFragment>>();
        for (Range range2 : linesRanges) {
            TextRange offsets1 = DiffUtil.getLinesRange(lineOffsets1, range2.start1, range2.end1, true);
            TextRange offsets2 = DiffUtil.getLinesRange(lineOffsets2, range2.start2, range2.end2, true);
            CharSequence subText1 = offsets1.subSequence(text1);
            CharSequence subText2 = offsets2.subSequence(text2);
            List<TextRange> subRanges1 = SmartTextDiffProvider.getSubRanges(ranges1, offsets1);
            List<TextRange> subRanges2 = SmartTextDiffProvider.getSubRanges(ranges2, offsets2);
            ComparisonManagerImpl comparisonManager = ComparisonManagerImpl.getInstanceImpl();
            List<LineFragment> fragments = comparisonManager.compareLinesWithIgnoredRanges(subText1, subText2, subRanges1, subRanges2, innerFragments, indicator);
            int startOffset1 = offsets1.getStartOffset();
            int startOffset2 = offsets2.getStartOffset();
            result2.add(ContainerUtil.map(fragments, fragment -> SimpleTextDiffProvider.transferFragment(fragment, range2.start1, range2.start2, startOffset1, startOffset2)));
        }
        ArrayList<List<LineFragment>> arrayList = result2;
        if (arrayList == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    private static List<TextRange> getSubRanges(@NotNull List<TextRange> ignoredRanges, @NotNull TextRange offsets) {
        if (ignoredRanges == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(39);
        }
        if (offsets == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(40);
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        for (TextRange range2 : ignoredRanges) {
            TextRange intersection = range2.intersection(offsets);
            if (intersection == null) continue;
            result2.add(new TextRange(intersection.getStartOffset() - offsets.getStartOffset(), intersection.getEndOffset() - offsets.getStartOffset()));
        }
        ArrayList<TextRange> arrayList = result2;
        if (arrayList == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @Nullable
    private static DiffIgnoredRangeProvider getIgnoredRangeProvider(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2) {
        if (content1 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(42);
        }
        if (content2 == null) {
            SmartTextDiffProvider.$$$reportNull$$$0(43);
        }
        if (!Registry.is((String)"diff.smart.ignore.enabled")) {
            return null;
        }
        for (DiffIgnoredRangeProvider provider : (DiffIgnoredRangeProvider[])DiffIgnoredRangeProvider.EP_NAME.getExtensions()) {
            if (!provider.accepts(project, content1) || !provider.accepts(project, content2)) continue;
            return provider;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 30: 
            case 31: 
            case 38: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 30: 
            case 31: 
            case 38: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 3: 
            case 7: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 8: 
            case 14: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content1";
                break;
            }
            case 9: 
            case 15: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content2";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRangeProvider";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicies";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightPolicies";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 24: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets1";
                break;
            }
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets2";
                break;
            }
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesRanges";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePolicy";
                break;
            }
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 30: 
            case 31: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRanges";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompare";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "compareIgnoreFormatting";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNoIgnore";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doCompare";
                break;
            }
            case 30: 
            case 31: 
            case 38: 
            case 41: {
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "compareIgnoreFormatting";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSubRanges";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredRangeProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 30: 
            case 31: 
            case 38: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NoIgnore
    extends SmartTextDiffProvider
    implements TwosideTextDiffProvider.NoIgnore {
        private NoIgnore(@Nullable Project project, @NotNull DiffContent content1, @NotNull DiffContent content2, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull DiffIgnoredRangeProvider ignoredRangeProvider) {
            if (content1 == null) {
                NoIgnore.$$$reportNull$$$0(0);
            }
            if (content2 == null) {
                NoIgnore.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                NoIgnore.$$$reportNull$$$0(2);
            }
            if (rediff == null) {
                NoIgnore.$$$reportNull$$$0(3);
            }
            if (disposable == null) {
                NoIgnore.$$$reportNull$$$0(4);
            }
            if (ignoredRangeProvider == null) {
                NoIgnore.$$$reportNull$$$0(5);
            }
            super(project, content1, content2, settings, rediff, disposable, ignoredRangeProvider, IGNORE_POLICIES, (HighlightPolicy[])ArrayUtil.remove((Object[])HIGHLIGHT_POLICIES, (Object)((Object)HighlightPolicy.DO_NOT_HIGHLIGHT)));
        }

        @Override
        @NotNull
        public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(7);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(8);
            }
            List list2 = super.compare(text1, text2, indicator);
            if (list2 == null) {
                NoIgnore.$$$reportNull$$$0(9);
            }
            return list2;
        }

        @Override
        @NotNull
        public List<List<LineFragment>> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<Range> linesRanges, @NotNull ProgressIndicator indicator) {
            if (text1 == null) {
                NoIgnore.$$$reportNull$$$0(10);
            }
            if (text2 == null) {
                NoIgnore.$$$reportNull$$$0(11);
            }
            if (linesRanges == null) {
                NoIgnore.$$$reportNull$$$0(12);
            }
            if (indicator == null) {
                NoIgnore.$$$reportNull$$$0(13);
            }
            List list2 = super.compare(text1, text2, (List)linesRanges, indicator);
            if (list2 == null) {
                NoIgnore.$$$reportNull$$$0(14);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rediff";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredRangeProvider";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text1";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text2";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linesRanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/text/SmartTextDiffProvider$NoIgnore";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compare";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 9: 
                case 14: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

