/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.IdeView;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesAutoscrollFromSourceHandler;
import com.intellij.ide.favoritesTreeView.FavoritesComparator;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeStructure;
import com.intellij.ide.favoritesTreeView.FavoritesTreeUtil;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.DeleteFromFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesAbbreviatePackageNamesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesAutoScrollToSourceAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesCompactEmptyMiddlePackagesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesFlattenPackagesAction;
import com.intellij.ide.favoritesTreeView.actions.FavoritesShowMembersAction;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.DockableContent;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FavoritesTreeViewPanel
extends JPanel
implements DataProvider,
DockContainer {
    private final FavoritesTreeStructure myFavoritesTreeStructure;
    private FavoritesViewTreeBuilder myBuilder;
    private final CopyPasteDelegator myCopyPasteDelegator;
    private final MouseListener myTreePopupHandler;
    public static final DataKey<FavoritesTreeNodeDescriptor[]> CONTEXT_FAVORITES_ROOTS_DATA_KEY = DataKey.create((String)"FavoritesRoot");
    public static final DataKey<DnDAwareTree> FAVORITES_TREE_KEY = DataKey.create((String)"Favorites.Tree");
    public static final DataKey<FavoritesViewTreeBuilder> FAVORITES_TREE_BUILDER_KEY = DataKey.create((String)"Favorites.Tree.Builder");
    public static final DataKey<String> FAVORITES_LIST_NAME_DATA_KEY = DataKey.create((String)"FavoritesListName");
    protected Project myProject;
    protected DnDAwareTree myTree;
    private final AutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final IdeView myIdeView = new MyIdeView();
    private final FavoritesManager myFavoritesManager;

    public FavoritesTreeViewPanel(Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.myFavoritesManager = FavoritesManager.getInstance(this.myProject);
        this.myFavoritesTreeStructure = new FavoritesTreeStructure(project);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject(this.myFavoritesTreeStructure.getRootElement());
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.myTree = new DnDAwareTree(treeModel);
        this.myBuilder = new FavoritesViewTreeBuilder(this.myProject, (JTree)((Object)this.myTree), treeModel, this.myFavoritesTreeStructure);
        DockManager.getInstance((Project)project).register((DockContainer)this);
        TreeUtil.installActions((JTree)((Object)this.myTree));
        UIUtil.setLineStyleAngled((JTree)((Object)this.myTree));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLargeModel(true);
        new TreeSpeedSearch((JTree)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        FavoritesComparator favoritesComparator = new FavoritesComparator(ProjectView.getInstance(project), "Favorites");
        this.myBuilder.setNodeDescriptorComparator((o1, o2) -> {
            FavoritesListNode listNode2;
            FavoritesListNode listNode1;
            if (o1 instanceof FavoritesTreeNodeDescriptor && o2 instanceof FavoritesTreeNodeDescriptor && (listNode1 = FavoritesTreeUtil.extractParentList((FavoritesTreeNodeDescriptor)((Object)o1))).equals((Object)(listNode2 = FavoritesTreeUtil.extractParentList((FavoritesTreeNodeDescriptor)((Object)o2))))) {
                Comparator<FavoritesTreeNodeDescriptor> comparator2 = this.myFavoritesManager.getCustomComparator(listNode1.getName());
                if (comparator2 != null) {
                    return comparator2.compare((FavoritesTreeNodeDescriptor)((Object)o1), (FavoritesTreeNodeDescriptor)((Object)o2));
                }
                return favoritesComparator.compare((NodeDescriptor)o1, (NodeDescriptor)o2);
            }
            return o1.getIndex() - o2.getIndex();
        });
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node;
                Object userObject;
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof FavoritesTreeNodeDescriptor) {
                    String location;
                    FavoritesTreeNodeDescriptor favoritesTreeNodeDescriptor = (FavoritesTreeNodeDescriptor)((Object)userObject);
                    AbstractTreeNode treeNode = favoritesTreeNodeDescriptor.getElement();
                    FavoritesListProvider provider = FavoritesTreeUtil.getProvider(FavoritesTreeViewPanel.this.myFavoritesManager, favoritesTreeNodeDescriptor);
                    if (provider != null) {
                        Object o = FavoritesTreeViewPanel.this.myBuilder.getUi().getElementFor(value);
                        if (o instanceof AbstractTreeNode) {
                            o = ((AbstractTreeNode)o).getValue();
                        }
                        provider.customizeRenderer((ColoredTreeCellRenderer)this, tree, o, selected, expanded, leaf, row, hasFocus);
                        return;
                    }
                    PresentationData presentation = treeNode.getPresentation();
                    String locationString = presentation.getLocationString();
                    if (locationString == null && node.getParent() != null && node.getParent().getParent() != null && node.getParent().getParent().getParent() == null && (location = favoritesTreeNodeDescriptor.getLocation()) != null && location.length() > 0) {
                        this.append(" (" + location + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
                    }
                }
            }
        });
        this.myTreePopupHandler = CustomizationUtil.installPopupHandler((JComponent)((Object)this.myTree), "FavoritesViewPopupMenu", "FavoritesPopup");
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this.myTree));
        this.myCopyPasteDelegator = new CopyPasteDelegator(this.myProject, this){

            @Override
            @NotNull
            protected PsiElement[] getSelectedElements() {
                PsiElement[] psiElementArray = FavoritesTreeViewPanel.this.getSelectedPsiElements();
                if (psiElementArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiElementArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel$2", "getSelectedElements"));
            }
        };
        AnActionButton addActionButton = AnActionButton.fromAction((AnAction)ActionManager.getInstance().getAction("AddNewFavoritesList"));
        addActionButton.getTemplatePresentation().setIcon(CommonActionsPanel.Buttons.ADD.getIcon());
        addActionButton.setShortcut(CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD));
        AnActionButton editActionButton = AnActionButton.fromAction((AnAction)ActionManager.getInstance().getAction("EditFavorites"));
        editActionButton.setShortcut(CommonShortcuts.CTRL_ENTER);
        DeleteFromFavoritesAction deleteActionButton = new DeleteFromFavoritesAction();
        deleteActionButton.setShortcut((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTree)).initPosition().disableAddAction().disableRemoveAction().disableDownAction().disableUpAction().addExtraAction(addActionButton).addExtraAction(editActionButton).addExtraAction((AnActionButton)deleteActionButton);
        AnAction action = ActionManager.getInstance().getAction("NewElement");
        action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)((Object)this.myTree));
        JPanel panel2 = decorator.createPanel();
        panel2.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)panel2, "Center");
        this.setBorder((Border)JBUI.Borders.empty());
        this.myAutoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return FavoritesTreeViewPanel.this.myFavoritesManager.getViewSettings().isAutoScrollToSource();
            }

            protected void setAutoScrollMode(boolean state) {
                FavoritesTreeViewPanel.this.myFavoritesManager.getViewSettings().setAutoScrollToSource(state);
            }
        };
        this.myAutoScrollToSourceHandler.install((JTree)((Object)this.myTree));
        this.myFavoritesManager.addFavoritesListener(new FavoritesListener(){

            @Override
            public void rootsChanged() {
                FavoritesTreeViewPanel.this.myBuilder.updateFromRoot();
                FavoritesTreeViewPanel.this.myTree.repaint();
            }

            @Override
            public void listAdded(String listName) {
                FavoritesTreeViewPanel.this.myBuilder.updateFromRoot();
                FavoritesTreeViewPanel.this.myTree.repaint();
            }

            @Override
            public void listRemoved(String listName) {
                FavoritesTreeViewPanel.this.myBuilder.updateFromRoot();
                FavoritesTreeViewPanel.this.myTree.repaint();
            }
        }, (Disposable)this);
    }

    private ExporterToTextFile createTextExporter() {
        return new ExporterToTextFile(){

            @NotNull
            public String getReportText() {
                final StringBuilder sb = new StringBuilder();
                Object[] elements = FavoritesTreeViewPanel.this.myBuilder.getStructure().getChildElements(FavoritesTreeViewPanel.this.myBuilder.getRoot());
                TreeUtil.Traverse traverse = new TreeUtil.Traverse(){

                    public boolean accept(Object node) {
                        if (node instanceof LoadingNode) {
                            return true;
                        }
                        AbstractTreeNode abstractTreeNode = (AbstractTreeNode)node;
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        int deepLevel = this.getDeepLevel((AbstractTreeNode)node);
                        for (int i = 1; i < deepLevel; ++i) {
                            sb.append('\t');
                        }
                        abstractTreeNode.update();
                        PresentationData presentation = abstractTreeNode.getPresentation();
                        sb.append(presentation.getPresentableText());
                        String locationString = presentation.getLocationString();
                        if (locationString == null) {
                            locationString = FavoritesTreeNodeDescriptor.getLocation(abstractTreeNode, FavoritesTreeViewPanel.this.myProject);
                        }
                        if (locationString != null) {
                            sb.append(" (").append(locationString).append(")");
                        }
                        return true;
                    }

                    public int getDeepLevel(AbstractTreeNode node) {
                        int result2 = 0;
                        while (node.getParent() != null) {
                            ++result2;
                            node = node.getParent();
                        }
                        return result2;
                    }
                };
                for (Object element : elements) {
                    FavoritesTreeViewPanel.traverseDepth((AbstractTreeNode)element, traverse);
                }
                String string = sb.toString();
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getDefaultFilePath() {
                String string = FavoritesTreeViewPanel.this.myProject.getBasePath() + File.separator + "Favorites.txt";
                if (string == null) {
                    5.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean canExport() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReportText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultFilePath";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static boolean traverseDepth(AbstractTreeNode node, TreeUtil.Traverse traverse) {
        if (!traverse.accept((Object)node)) {
            return false;
        }
        Collection children2 = node.getChildren();
        for (AbstractTreeNode child : children2) {
            child.setParent(node);
            if (FavoritesTreeViewPanel.traverseDepth(child, traverse)) continue;
            return false;
        }
        return true;
    }

    public void selectElement(Object selector, VirtualFile file2, boolean requestFocus) {
        this.myBuilder.select(selector, file2, requestFocus);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myBuilder);
        this.myBuilder = null;
    }

    public DnDAwareTree getTree() {
        return this.myTree;
    }

    @NotNull
    private PsiElement[] getSelectedPsiElements() {
        Object[] elements = this.getSelectedNodeElements();
        if (elements == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                FavoritesTreeViewPanel.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        block0: for (Object element : elements) {
            if (element instanceof Bookmark) {
                element = ((Bookmark)element).getFile();
            }
            if (element instanceof PsiElement) {
                result2.add((PsiElement)element);
                continue;
            }
            if (element instanceof SmartPsiElementPointer) {
                PsiElement psiElement = ((SmartPsiElementPointer)element).getElement();
                if (psiElement == null) continue;
                result2.add(psiElement);
                continue;
            }
            for (FavoriteNodeProvider provider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)this.myProject)) {
                PsiElement psiElement = provider.getPsiElement(element);
                if (psiElement == null) continue;
                result2.add(psiElement);
                continue block0;
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            FavoritesTreeViewPanel.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    public FavoritesTreeStructure getFavoritesTreeStructure() {
        return this.myFavoritesTreeStructure;
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            FavoritesTreeNodeDescriptor[] selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
            return selectedNodeDescriptors.length == 1 ? selectedNodeDescriptors[0].getElement() : null;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            List<Navigatable> selectedElements = this.getSelectedElements(Navigatable.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new Navigatable[0]);
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCutProvider();
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getCopyProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myCopyPasteDelegator.getPasteProvider();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.toolWindows.favorites";
        }
        if (LangDataKeys.NO_NEW_ACTION.is(dataId)) {
            return Boolean.TRUE;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            PsiElement[] elements = this.getSelectedPsiElements();
            if (elements.length != 1) {
                return null;
            }
            return elements[0] != null && elements[0].isValid() ? elements[0] : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            PsiElement[] elements = this.getSelectedPsiElements();
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (PsiElement element : elements) {
                if (!element.isValid()) continue;
                result2.add(element);
            }
            return result2.isEmpty() ? null : PsiUtilCore.toPsiElementArray(result2);
        }
        if (LangDataKeys.IDE_VIEW.is(dataId)) {
            return this.myIdeView;
        }
        if (LangDataKeys.TARGET_PSI_ELEMENT.is(dataId)) {
            return null;
        }
        if (LangDataKeys.MODULE_CONTEXT.is(dataId)) {
            Module[] selected = this.getSelectedModules();
            return selected != null && selected.length == 1 ? selected[0] : null;
        }
        if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(dataId)) {
            return this.getSelectedModules();
        }
        if (ModuleGroup.ARRAY_DATA_KEY.is(dataId)) {
            List<ModuleGroup> selectedElements = this.getSelectedElements(ModuleGroup.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ModuleGroup[0]);
        }
        if (LibraryGroupElement.ARRAY_DATA_KEY.is(dataId)) {
            List<LibraryGroupElement> selectedElements = this.getSelectedElements(LibraryGroupElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new LibraryGroupElement[0]);
        }
        if (NamedLibraryElement.ARRAY_DATA_KEY.is(dataId)) {
            List<NamedLibraryElement> selectedElements = this.getSelectedElements(NamedLibraryElement.class);
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new NamedLibraryElement[0]);
        }
        if (CONTEXT_FAVORITES_ROOTS_DATA_KEY.is(dataId)) {
            FavoritesTreeNodeDescriptor[] selectedNodeDescriptors;
            ArrayList<FavoritesTreeNodeDescriptor> result3 = new ArrayList<FavoritesTreeNodeDescriptor>();
            for (FavoritesTreeNodeDescriptor selectedNodeDescriptor : selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree)) {
                FavoritesTreeNodeDescriptor root;
                if (FavoritesTreeUtil.getProvider(this.myFavoritesManager, selectedNodeDescriptor) != null || (root = selectedNodeDescriptor.getFavoritesRoot()) == null || !(root.getElement() instanceof FavoritesListNode)) continue;
                result3.add(selectedNodeDescriptor);
            }
            return result3.toArray(FavoritesTreeNodeDescriptor.EMPTY_ARRAY);
        }
        if (FAVORITES_TREE_KEY.is(dataId)) {
            return this.myTree;
        }
        if (FAVORITES_TREE_BUILDER_KEY.is(dataId)) {
            return this.myBuilder;
        }
        if (FAVORITES_LIST_NAME_DATA_KEY.is(dataId)) {
            FavoritesTreeNodeDescriptor[] descriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
            HashSet<Object> selectedNames = new HashSet<Object>();
            for (FavoritesTreeNodeDescriptor descriptor : descriptors) {
                FavoritesListNode node = FavoritesTreeUtil.extractParentList(descriptor);
                if (node == null) continue;
                selectedNames.add(node.getValue());
            }
            if (selectedNames.size() == 1) {
                return selectedNames.iterator().next();
            }
            return null;
        }
        FavoritesTreeNodeDescriptor[] descriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
        if (descriptors.length > 0) {
            ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
            for (FavoritesTreeNodeDescriptor descriptor : descriptors) {
                nodes.add(descriptor.getElement());
            }
            return this.myFavoritesTreeStructure.getDataFromProviders(nodes, dataId);
        }
        return null;
    }

    private Set<FavoritesListNode> getSelectedListsNodes() {
        FavoritesTreeNodeDescriptor[] descriptors;
        HashSet<FavoritesListNode> result2 = new HashSet<FavoritesListNode>();
        for (FavoritesTreeNodeDescriptor descriptor : descriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree)) {
            FavoritesListNode listNode = FavoritesTreeUtil.extractParentList(descriptor);
            if (listNode == null) continue;
            result2.add(listNode);
        }
        return result2;
    }

    private <T> List<T> getSelectedElements(Class<T> klass) {
        Object[] elements = this.getSelectedNodeElements();
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (elements == null) {
            return result2;
        }
        for (Object element : elements) {
            if (element == null || !klass.isAssignableFrom(element.getClass())) continue;
            result2.add(element);
        }
        return result2;
    }

    private Module[] getSelectedModules() {
        Object[] elements = this.getSelectedNodeElements();
        if (elements == null) {
            return null;
        }
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (Object element : elements) {
            if (element instanceof Module) {
                result2.add((Module)element);
                continue;
            }
            if (!(element instanceof ModuleGroup)) continue;
            result2.addAll(((ModuleGroup)element).modulesInGroup(this.myProject, true));
        }
        return result2.isEmpty() ? null : result2.toArray(Module.EMPTY_ARRAY);
    }

    private Object[] getSelectedNodeElements() {
        FavoritesTreeNodeDescriptor[] selectedNodeDescriptors = FavoritesTreeUtil.getSelectedNodeDescriptors(this.myTree);
        ArrayList<Object> result2 = new ArrayList<Object>();
        for (FavoritesTreeNodeDescriptor selectedNodeDescriptor : selectedNodeDescriptors) {
            if (selectedNodeDescriptor == null) continue;
            Object value = selectedNodeDescriptor.getElement().getValue();
            if (value instanceof SmartPsiElementPointer) {
                value = ((SmartPsiElementPointer)value).getElement();
            }
            result2.add(value);
        }
        return ArrayUtil.toObjectArray(result2);
    }

    public void setupToolWindow(ToolWindowEx window) {
        CollapseAllAction collapseAction = new CollapseAllAction((JTree)((Object)this.myTree));
        collapseAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
        collapseAction.getTemplatePresentation().setHoveredIcon(AllIcons.General.CollapseAllHover);
        window.setTitleActions(new AnAction[]{collapseAction});
        DefaultActionGroup group = new DefaultActionGroup();
        ProjectViewDirectoryHelper helper = ProjectViewDirectoryHelper.getInstance(this.myProject);
        if (helper.supportsFlattenPackages()) {
            group.add((AnAction)new FavoritesFlattenPackagesAction(this.myProject, this.myBuilder));
        }
        if (helper.supportsHideEmptyMiddlePackages()) {
            group.add((AnAction)new FavoritesCompactEmptyMiddlePackagesAction(this.myProject, this.myBuilder));
        }
        if (helper.supportsFlattenPackages()) {
            group.addAction((AnAction)new FavoritesAbbreviatePackageNamesAction(this.myProject, this.myBuilder));
        }
        if (!PlatformUtils.isCidr()) {
            group.add((AnAction)new FavoritesShowMembersAction(this.myProject, this.myBuilder));
        }
        FavoritesAutoscrollFromSourceHandler handler2 = new FavoritesAutoscrollFromSourceHandler(this.myProject, this.myBuilder);
        handler2.install();
        group.add((AnAction)handler2.createToggleAction());
        group.add((AnAction)new FavoritesAutoScrollToSourceAction(this.myProject, this.myAutoScrollToSourceHandler, this.myBuilder));
        window.setAdditionalGearActions((ActionGroup)group);
    }

    public static String getQualifiedName(VirtualFile file2) {
        return file2.getPresentableUrl();
    }

    public FavoritesViewTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    @Nullable
    FavoritesListNode findFavoritesListNode(Point point) {
        TreePath path = this.myTree.getClosestPathForLocation(point.x, point.y);
        FavoritesListNode node = FavoritesTreeViewPanel.getListNodeFromPath(path);
        return node == null ? (FavoritesListNode)((FavoritesRootNode)((Object)this.myFavoritesTreeStructure.getRootElement())).getChildren().iterator().next() : node;
    }

    static FavoritesListNode getListNodeFromPath(TreePath path) {
        AbstractTreeNode node;
        Object obj;
        Object o;
        if (path != null && path.getPathCount() > 1 && (o = path.getPath()[1]) instanceof DefaultMutableTreeNode && (obj = ((DefaultMutableTreeNode)o).getUserObject()) instanceof FavoritesTreeNodeDescriptor && (node = ((FavoritesTreeNodeDescriptor)((Object)obj)).getElement()) instanceof FavoritesListNode) {
            return (FavoritesListNode)node;
        }
        return null;
    }

    void dropPsiElements(FavoritesManager mgr, FavoritesListNode node, PsiElement[] elements) {
        if (elements != null && elements.length > 0) {
            ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
            for (PsiElement element : elements) {
                if (element instanceof SmartPsiElementPointer) {
                    element = ((SmartPsiElementPointer)element).getElement();
                }
                Collection<AbstractTreeNode> tmp = AddToFavoritesAction.createNodes(this.myProject, null, element, true, FavoritesManager.getInstance(this.myProject).getViewSettings());
                nodes.addAll(tmp);
                mgr.addRoots((String)node.getValue(), nodes);
            }
            this.myBuilder.select(nodes.toArray(), null);
        }
    }

    public RelativeRectangle getAcceptArea() {
        return new RelativeRectangle((JComponent)((Object)this.myTree));
    }

    public RelativeRectangle getAcceptAreaFallback() {
        return this.getAcceptArea();
    }

    @NotNull
    public DockContainer.ContentResponse getContentResponse(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            FavoritesTreeViewPanel.$$$reportNull$$$0(2);
        }
        if (content.getKey() instanceof VirtualFile) {
            DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.ACCEPT_COPY;
            if (contentResponse == null) {
                FavoritesTreeViewPanel.$$$reportNull$$$0(3);
            }
            return contentResponse;
        }
        DockContainer.ContentResponse contentResponse = DockContainer.ContentResponse.DENY;
        if (contentResponse == null) {
            FavoritesTreeViewPanel.$$$reportNull$$$0(4);
        }
        return contentResponse;
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public void add(@NotNull DockableContent content, RelativePoint dropTarget) {
        if (content == null) {
            FavoritesTreeViewPanel.$$$reportNull$$$0(5);
        }
        if (content.getKey() instanceof VirtualFile) {
            VirtualFile vFile = (VirtualFile)content.getKey();
            PsiDirectory psiFile = vFile.isDirectory() ? PsiManager.getInstance((Project)this.myProject).findDirectory(vFile) : PsiManager.getInstance((Project)this.myProject).findFile(vFile);
            Point p = dropTarget.getScreenPoint();
            SwingUtilities.convertPointFromScreen(p, (Component)((Object)this.myTree));
            FavoritesListNode node = this.findFavoritesListNode(p);
            if (node != null && psiFile != null) {
                this.dropPsiElements(this.myFavoritesManager, node, new PsiElement[]{psiFile});
            }
        }
    }

    public void closeAll() {
    }

    public void addListener(DockContainer.Listener listener2, Disposable parent) {
        throw new UnsupportedOperationException("Method is not supported");
    }

    public boolean isEmpty() {
        return this.myTree.isEmpty();
    }

    @Nullable
    public Image startDropOver(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            FavoritesTreeViewPanel.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Nullable
    public Image processDropOver(@NotNull DockableContent content, RelativePoint point) {
        if (content == null) {
            FavoritesTreeViewPanel.$$$reportNull$$$0(7);
        }
        Point p = point.getScreenPoint();
        SwingUtilities.convertPointFromScreen(p, (Component)((Object)this.myTree));
        TreePath treePath = this.myTree.getClosestPathForLocation(p.x, p.y);
        FavoritesListNode node = FavoritesTreeViewPanel.getListNodeFromPath(treePath);
        TreePath treePath2 = treePath = node != null ? this.myTree.getPath((PresentableNodeDescriptor)node) : null;
        if (treePath != null) {
            this.myTree.setSelectionPath(treePath);
        }
        return null;
    }

    public void resetDropOver(@NotNull DockableContent content) {
        if (content == null) {
            FavoritesTreeViewPanel.$$$reportNull$$$0(8);
        }
    }

    public boolean isDisposeWhenEmpty() {
        return false;
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPsiElements";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentResponse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContentResponse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startDropOver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDropOver";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resetDropOver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyIdeView
    implements IdeView {
        private MyIdeView() {
        }

        public void selectElement(PsiElement element) {
            if (element != null) {
                Editor editor;
                this.selectPsiElement(element, false);
                boolean requestFocus = true;
                boolean isDirectory = element instanceof PsiDirectory;
                if (!isDirectory && (editor = EditorHelper.openInEditor(element)) != null) {
                    ToolWindowManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).activateEditorComponent();
                    requestFocus = false;
                }
                if (requestFocus) {
                    this.selectPsiElement(element, true);
                }
            }
        }

        private void selectPsiElement(PsiElement element, boolean requestFocus) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            FavoritesTreeViewPanel.this.selectElement(element, virtualFile, requestFocus);
        }

        @Nullable
        private PsiDirectory[] getSelectedDirectories() {
            PsiDirectory[] psiDirectoryArray;
            if (FavoritesTreeViewPanel.this.myBuilder == null) {
                return null;
            }
            Object[] selectedNodeElements = FavoritesTreeViewPanel.this.getSelectedNodeElements();
            if (selectedNodeElements.length != 1) {
                return null;
            }
            for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])Extensions.getExtensions((ExtensionPointName)FavoriteNodeProvider.EP_NAME, (AreaInstance)FavoritesTreeViewPanel.this.myProject)) {
                PsiDirectory parent;
                PsiFile file2;
                PsiElement psiElement = nodeProvider.getPsiElement(selectedNodeElements[0]);
                if (psiElement instanceof PsiDirectory) {
                    return new PsiDirectory[]{(PsiDirectory)psiElement};
                }
                if (psiElement instanceof PsiDirectoryContainer) {
                    Module module;
                    String moduleName = nodeProvider.getElementModuleName(selectedNodeElements[0]);
                    GlobalSearchScope searchScope = GlobalSearchScope.projectScope((Project)FavoritesTreeViewPanel.this.myProject);
                    if (moduleName != null && (module = ModuleManager.getInstance((Project)FavoritesTreeViewPanel.this.myProject).findModuleByName(moduleName)) != null) {
                        searchScope = GlobalSearchScope.moduleScope((Module)module);
                    }
                    return ((PsiDirectoryContainer)psiElement).getDirectories(searchScope);
                }
                if (psiElement == null || (file2 = psiElement.getContainingFile()) == null || (parent = file2.getParent()) == null) continue;
                return new PsiDirectory[]{parent};
            }
            if (selectedNodeElements[0] instanceof PsiDirectory) {
                PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                psiDirectoryArray = psiDirectoryArray2;
                psiDirectoryArray2[0] = (PsiDirectory)selectedNodeElements[0];
            } else {
                psiDirectoryArray = null;
            }
            return psiDirectoryArray;
        }

        @NotNull
        public PsiDirectory[] getDirectories() {
            PsiDirectory[] directories = this.getSelectedDirectories();
            PsiDirectory[] psiDirectoryArray = directories == null ? PsiDirectory.EMPTY_ARRAY : directories;
            if (psiDirectoryArray == null) {
                MyIdeView.$$$reportNull$$$0(0);
            }
            return psiDirectoryArray;
        }

        public PsiDirectory getOrChooseDirectory() {
            return DirectoryChooserUtil.getOrChooseDirectory(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/favoritesTreeView/FavoritesTreeViewPanel$MyIdeView", "getDirectories"));
        }
    }
}

