/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import sun.swing.SwingUtilities2;

public class DarculaButtonUI
extends BasicButtonUI {
    private final Rectangle viewRect = new Rectangle();
    private final Rectangle textRect = new Rectangle();
    private final Rectangle iconRect = new Rectangle();
    static int HELP_BUTTON_DIAMETER = 22;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaButtonUI();
    }

    public static boolean isSquare(Component c) {
        return c instanceof JButton && "square".equals(((JButton)c).getClientProperty("JButton.buttonType"));
    }

    public static boolean isDefaultButton(JComponent c) {
        return c instanceof JButton && ((JButton)c).isDefaultButton();
    }

    public static boolean isComboButton(JComponent c) {
        return c instanceof AbstractButton && c.getClientProperty("styleCombo") == Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean paintDecorations(Graphics2D g, JComponent c) {
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
        if (UIUtil.isHelpButton((Component)c)) {
            g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getButtonColorEnd()));
            int diam = JBUI.scale((int)HELP_BUTTON_DIAMETER);
            int x = r.x + (r.width - diam) / 2;
            int y = r.x + (r.height - diam) / 2;
            g.fill(new Ellipse2D.Float(x, y, diam, diam));
            AllIcons.Actions.Help.paintIcon(c, g, x + JBUI.scale((int)3), y + JBUI.scale((int)3));
            return false;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float arc = DarculaUIUtil.buttonArc();
            float bw = DarculaUIUtil.bw();
            if (c.isEnabled()) {
                if (DarculaButtonUI.isSquare(c)) {
                    g2.setPaint(UIUtil.getGradientPaint((float)r.x, (float)r.y, (Color)this.getButtonColorStart(), (float)(r.x + r.width), (float)(r.y + r.height), (Color)this.getButtonColorEnd()));
                    g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
                } else {
                    g2.setPaint(DarculaButtonUI.isDefaultButton(c) ? UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getDefaultButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getDefaultButtonColorEnd()) : UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)this.getButtonColorStart(), (float)0.0f, (float)r.height, (Color)this.getButtonColorEnd()));
                    g2.fill(new RoundRectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f, arc, arc));
                }
            }
        }
        finally {
            g2.dispose();
        }
        return true;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.paintDecorations((Graphics2D)g, c)) {
            super.paint(g, c);
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        int mnemonicIndex;
        if (UIUtil.isHelpButton((Component)c)) {
            return;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        g.setColor(DarculaButtonUI.getTextColor(button));
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g);
        int n = mnemonicIndex = DarculaLaf.isAltPressed() ? button.getDisplayedMnemonicIndex() : -1;
        if (model.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c, g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
        } else {
            this.paintDisabledText(g, text, c, textRect, metrics);
        }
    }

    public static Color getTextColor(@NotNull AbstractButton button) {
        Color selectedFg;
        Color fg;
        if (button == null) {
            DarculaButtonUI.$$$reportNull$$$0(0);
        }
        if ((fg = button.getForeground()) instanceof UIResource && DarculaButtonUI.isDefaultButton(button) && (selectedFg = UIManager.getColor("Button.darcula.selectedButtonForeground")) != null) {
            fg = selectedFg;
        }
        return fg;
    }

    public static Color getDisabledTextColor() {
        return UIManager.getColor("Button.disabledText");
    }

    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        g.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, textRect.x + this.getTextShiftOffset(), textRect.y + metrics.getAscent() + this.getTextShiftOffset());
    }

    protected void paintContents(Graphics g, AbstractButton b) {
        FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)b, g);
        boolean isDotButton = DarculaButtonUI.isSquare(b) && b.getIcon() == AllIcons.General.Ellipsis;
        String text = isDotButton ? "..." : b.getText();
        Icon icon = isDotButton ? null : b.getIcon();
        text = this.layout(b, text, icon, fm, b.getWidth(), b.getHeight());
        if (DarculaButtonUI.isSquare(b)) {
            if (b.getIcon() == AllIcons.General.Ellipsis) {
                UISettings.setupAntialiasing((Graphics)g);
                this.paintText(g, b, this.textRect, text);
            } else if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
        } else {
            if (b.getIcon() != null) {
                this.paintIcon(g, b, this.iconRect);
            }
            if (text != null && !text.isEmpty()) {
                View v = (View)b.getClientProperty("html");
                if (v != null) {
                    v.paint(g, this.textRect);
                } else {
                    UISettings.setupAntialiasing((Graphics)g);
                    this.paintText(g, b, this.textRect, text);
                }
            }
        }
    }

    protected Dimension getDarculaButtonSize(JComponent c, Dimension prefSize) {
        float bw = DarculaUIUtil.bw();
        Insets i = c.getInsets();
        int helpDiam = JBUI.scale((int)HELP_BUTTON_DIAMETER);
        return UIUtil.isHelpButton((Component)c) ? new Dimension(Math.max(prefSize.width, helpDiam + i.left + i.right), Math.max(prefSize.height, helpDiam + i.top + i.bottom)) : new Dimension(Math.max(prefSize.width, (int)((float)JBUI.scale((int)74) + bw * 2.0f)), Math.max(prefSize.height, (int)((float)JBUI.scale((int)26) + bw * 2.0f)));
    }

    @Override
    public final Dimension getPreferredSize(JComponent c) {
        return this.getDarculaButtonSize(c, super.getPreferredSize(c));
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        if (DarculaButtonUI.isDefaultButton(c)) {
            this.setupDefaultButton((JButton)c);
        }
    }

    protected void setupDefaultButton(JButton button) {
        if (!SystemInfo.isMac && !button.getFont().isBold()) {
            button.setFont(new FontUIResource(button.getFont().deriveFont(1)));
        }
    }

    protected Color getButtonColorStart() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.startColor"), (Object)new ColorUIResource(0x555A5C));
    }

    protected Color getButtonColorEnd() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.endColor"), (Object)new ColorUIResource(4277832));
    }

    protected Color getDefaultButtonColorStart() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.defaultStartColor"), (Object)new ColorUIResource(3690347));
    }

    protected Color getDefaultButtonColorEnd() {
        return (Color)ObjectUtils.notNull((Object)UIManager.getColor("Button.darcula.defaultEndColor"), (Object)new ColorUIResource(2306371));
    }

    protected String layout(AbstractButton b, String text, Icon icon, FontMetrics fm, int width, int height) {
        this.textRect.setBounds(0, 0, 0, 0);
        this.iconRect.setBounds(0, 0, 0, 0);
        this.viewRect.setBounds(0, 0, width, height);
        this.modifyViewRect(b, this.viewRect);
        return SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, text == null ? 0 : b.getIconTextGap());
    }

    protected void modifyViewRect(AbstractButton b, Rectangle rect) {
        JBInsets.removeFrom((Rectangle)rect, (Insets)b.getInsets());
        if (DarculaButtonUI.isComboButton(b)) {
            rect.x += 6;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/ide/ui/laf/darcula/ui/DarculaButtonUI", "getTextColor"));
    }
}

