/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextBorder;
import com.intellij.ide.ui.laf.intellij.WinIntelliJTextFieldUI;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;

public class WinIntelliJPasswordFieldUI
extends BasicPasswordFieldUI {
    private MouseListener hoverListener;
    private FocusListener focusListener;

    public static ComponentUI createUI(JComponent c) {
        return new WinIntelliJPasswordFieldUI();
    }

    @Override
    public void installListeners() {
        super.installListeners();
        final JTextComponent passwordField = this.getComponent();
        this.hoverListener = new DarculaUIUtil.MouseHoverPropertyTrigger(passwordField, "JTextField.hover");
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                passwordField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                passwordField.repaint();
            }
        };
        passwordField.addMouseListener(this.hoverListener);
        passwordField.addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        JTextComponent passwordField = this.getComponent();
        if (this.hoverListener != null) {
            passwordField.removeMouseListener(this.hoverListener);
        }
        if (this.focusListener != null) {
            passwordField.removeFocusListener(this.focusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Container parent = c.getParent();
            if (c.isOpaque() && parent != null) {
                g2.setColor(parent.getBackground());
                g2.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            if (c.getBorder() instanceof WinIntelliJTextBorder) {
                WinIntelliJTextFieldUI.paintTextFieldBackground(c, g2);
            }
        }
        finally {
            g2.dispose();
        }
    }
}

