/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.legacy.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0017\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/collectors/legacy/ui/LegacyFontSizeInfoUsageCollector;", "Lcom/intellij/internal/statistic/UsagesCollector;", "()V", "getGroupId", "Lcom/intellij/internal/statistic/beans/GroupDescriptor;", "getUsages", "", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "intellij.platform.ide.impl"})
public final class LegacyFontSizeInfoUsageCollector
extends UsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
        String quickDocFontSize;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme scheme2 = editorColorsManager.getGlobalScheme();
        UISettings ui = UISettings.Companion.getShadowInstance();
        Set usages = SetsKt.setOf((Object[])new UsageDescriptor[]{new UsageDescriptor("UI font size: " + ui.getFontSize()), new UsageDescriptor("UI font name: " + ui.getFontFace()), new UsageDescriptor("Presentation mode font size: " + ui.getPresentationModeFontSize())});
        EditorColorsScheme editorColorsScheme = scheme2;
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"scheme");
        if (!editorColorsScheme.isUseAppFontPreferencesInEditor()) {
            usages = SetsKt.plus((Set)usages, (Iterable)SetsKt.setOf((Object[])new UsageDescriptor[]{new UsageDescriptor("Editor font size: " + scheme2.getEditorFontSize()), new UsageDescriptor("Editor font name:  " + scheme2.getEditorFontName())}));
        } else {
            AppEditorFontOptions appEditorFontOptions = AppEditorFontOptions.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)appEditorFontOptions, (String)"AppEditorFontOptions.getInstance()");
            FontPreferences appPrefs = appEditorFontOptions.getFontPreferences();
            Object[] objectArray = new UsageDescriptor[2];
            StringBuilder stringBuilder = new StringBuilder().append("IDE editor font size: ");
            FontPreferences fontPreferences = appPrefs;
            Intrinsics.checkExpressionValueIsNotNull((Object)fontPreferences, (String)"appPrefs");
            objectArray[0] = new UsageDescriptor(stringBuilder.append(appPrefs.getSize(fontPreferences.getFontFamily())).toString());
            objectArray[1] = new UsageDescriptor("IDE editor font name: " + appPrefs.getFontFamily());
            usages = SetsKt.plus((Set)usages, (Iterable)SetsKt.setOf((Object[])objectArray));
        }
        if (!scheme2.isUseEditorFontPreferencesInConsole()) {
            usages = SetsKt.plus((Set)usages, (Iterable)SetsKt.setOf((Object[])new UsageDescriptor[]{new UsageDescriptor("Console font size: " + scheme2.getConsoleFontSize()), new UsageDescriptor("Console font name: " + scheme2.getConsoleFontName())}));
        }
        if ((quickDocFontSize = PropertiesComponent.getInstance().getValue("quick.doc.font.size")) != null) {
            usages = SetsKt.plus((Set)usages, (Iterable)SetsKt.setOf((Object)new UsageDescriptor("QuickDoc font size:" + quickDocFontSize)));
        }
        return usages;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create("Fonts");
        Intrinsics.checkExpressionValueIsNotNull((Object)groupDescriptor, (String)"GroupDescriptor.create(\"Fonts\")");
        return groupDescriptor;
    }
}

