/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.service.fus.collectors.FUSUsageTriggerCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUSession;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="FUSUsageTrigger")
public class FUSUsageTrigger
implements UsagesCollectorConsumer,
PersistentStateComponent<State> {
    private final Project myProject;
    private State myState = new State();

    public FUSUsageTrigger(Project project) {
        this.myProject = project;
    }

    public void trigger(@NotNull Class<? extends FUSUsageTriggerCollector> fusClass, @NotNull @NonNls String feature) {
        ProjectUsagesCollector collector;
        if (fusClass == null) {
            FUSUsageTrigger.$$$reportNull$$$0(0);
        }
        if (feature == null) {
            FUSUsageTrigger.$$$reportNull$$$0(1);
        }
        if ((collector = this.getUsageCollector(fusClass)) != null) {
            this.doTrigger(collector.getGroupId(), feature);
        }
    }

    private void doTrigger(@NotNull String usageCollectorId, @NotNull String feature) {
        if (usageCollectorId == null) {
            FUSUsageTrigger.$$$reportNull$$$0(2);
        }
        if (feature == null) {
            FUSUsageTrigger.$$$reportNull$$$0(3);
        }
        SessionInfo sessionInfo = this.getOrCreateSessionInfo();
        UsagesCollectorInfo collectorInfo = sessionInfo.getUsageCollectorInfo(usageCollectorId);
        Integer count = collectorInfo.counts.get(feature);
        if (count == null) {
            collectorInfo.counts.put(feature, 1);
        } else {
            collectorInfo.counts.put(feature, count + 1);
        }
    }

    public ProjectUsagesCollector getUsageCollector(@NotNull Class<? extends FUSUsageTriggerCollector> fusClass) {
        if (fusClass == null) {
            FUSUsageTrigger.$$$reportNull$$$0(4);
        }
        for (ProjectUsagesCollector collector : ProjectUsagesCollector.getExtensions(this)) {
            if (!fusClass.equals(collector.getClass())) continue;
            return collector;
        }
        return null;
    }

    public static FUSUsageTrigger getInstance(@NotNull Project project) {
        if (project == null) {
            FUSUsageTrigger.$$$reportNull$$$0(5);
        }
        return (FUSUsageTrigger)ServiceManager.getService((Project)project, FUSUsageTrigger.class);
    }

    @NotNull
    public Map<String, Integer> getData(@NotNull String usageCollectorId) {
        SessionInfo info;
        if (usageCollectorId == null) {
            FUSUsageTrigger.$$$reportNull$$$0(6);
        }
        if ((info = this.geExistingSessionInfo()) != null) {
            Map<String, Integer> map = info.getUsageCollectorInfo((String)usageCollectorId).counts;
            if (map == null) {
                FUSUsageTrigger.$$$reportNull$$$0(7);
            }
            return map;
        }
        Map<String, Integer> map = Collections.emptyMap();
        if (map == null) {
            FUSUsageTrigger.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    private SessionInfo getOrCreateSessionInfo() {
        SessionInfo info = this.geExistingSessionInfo();
        if (info != null) {
            SessionInfo sessionInfo = info;
            if (sessionInfo == null) {
                FUSUsageTrigger.$$$reportNull$$$0(9);
            }
            return sessionInfo;
        }
        SessionInfo sessionInfo = SessionInfo.create(FUSession.create(this.getProject()).getId());
        this.myState.sessions.add(sessionInfo);
        SessionInfo sessionInfo2 = sessionInfo;
        if (sessionInfo2 == null) {
            FUSUsageTrigger.$$$reportNull$$$0(10);
        }
        return sessionInfo2;
    }

    @Nullable
    private SessionInfo geExistingSessionInfo() {
        FUSession session2 = FUSession.create(this.getProject());
        for (SessionInfo info : this.myState.sessions) {
            if (info.id != session2.getId()) continue;
            return info;
        }
        return null;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            FUSUsageTrigger.$$$reportNull$$$0(11);
        }
        this.myState = state;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fusClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageCollectorId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FUSUsageTrigger";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FUSUsageTrigger";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSessionInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "trigger";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doTrigger";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUsageCollector";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="usages-collector")
    public static class UsagesCollectorInfo {
        @Attribute(value="id")
        public String id;
        @Tag(value="counts")
        @MapAnnotation(surroundWithTag=false)
        public Map<String, Integer> counts = new HashMap<String, Integer>();
    }

    @Tag(value="session")
    public static class SessionInfo {
        @Attribute(value="id")
        public int id;
        @Property(surroundWithTag=false)
        @XCollection
        List<UsagesCollectorInfo> collectors = ContainerUtil.newSmartList();

        @NotNull
        public UsagesCollectorInfo getUsageCollectorInfo(String id) {
            UsagesCollectorInfo collector = this.findUsageCollectorInfo(id);
            if (collector != null) {
                UsagesCollectorInfo usagesCollectorInfo = collector;
                if (usagesCollectorInfo == null) {
                    SessionInfo.$$$reportNull$$$0(0);
                }
                return usagesCollectorInfo;
            }
            UsagesCollectorInfo info = new UsagesCollectorInfo();
            info.id = id;
            this.collectors.add(info);
            UsagesCollectorInfo usagesCollectorInfo = info;
            if (usagesCollectorInfo == null) {
                SessionInfo.$$$reportNull$$$0(1);
            }
            return usagesCollectorInfo;
        }

        @Nullable
        public UsagesCollectorInfo findUsageCollectorInfo(String id) {
            for (UsagesCollectorInfo collector : this.collectors) {
                if (!id.equals(collector.id)) continue;
                return collector;
            }
            return null;
        }

        public static SessionInfo create(int id) {
            SessionInfo info = new SessionInfo();
            info.id = id;
            return info;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/service/fus/collectors/FUSUsageTrigger$SessionInfo", "getUsageCollectorInfo"));
        }
    }

    static final class State {
        @Property(surroundWithTag=false)
        @XCollection
        List<SessionInfo> sessions = ContainerUtil.newSmartList();

        State() {
        }
    }
}

