/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.IdeaLogger;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.AbbreviationManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ChameleonAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionManagerImpl
extends ActionManagerEx
implements Disposable {
    @NonNls
    public static final String ACTION_ELEMENT_NAME = "action";
    @NonNls
    public static final String GROUP_ELEMENT_NAME = "group";
    @NonNls
    public static final String CLASS_ATTR_NAME = "class";
    @NonNls
    public static final String ID_ATTR_NAME = "id";
    @NonNls
    public static final String INTERNAL_ATTR_NAME = "internal";
    @NonNls
    public static final String ICON_ATTR_NAME = "icon";
    @NonNls
    public static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    @NonNls
    public static final String SHORTCUT_ELEMENT_NAME = "keyboard-shortcut";
    @NonNls
    public static final String MOUSE_SHORTCUT_ELEMENT_NAME = "mouse-shortcut";
    @NonNls
    public static final String DESCRIPTION = "description";
    @NonNls
    public static final String TEXT_ATTR_NAME = "text";
    @NonNls
    public static final String POPUP_ATTR_NAME = "popup";
    @NonNls
    public static final String COMPACT_ATTR_NAME = "compact";
    @NonNls
    public static final String SEPARATOR_ELEMENT_NAME = "separator";
    @NonNls
    public static final String REFERENCE_ELEMENT_NAME = "reference";
    @NonNls
    public static final String ABBREVIATION_ELEMENT_NAME = "abbreviation";
    @NonNls
    public static final String GROUPID_ATTR_NAME = "group-id";
    @NonNls
    public static final String ANCHOR_ELEMENT_NAME = "anchor";
    @NonNls
    public static final String FIRST = "first";
    @NonNls
    public static final String LAST = "last";
    @NonNls
    public static final String BEFORE = "before";
    @NonNls
    public static final String AFTER = "after";
    @NonNls
    public static final String SECONDARY = "secondary";
    @NonNls
    public static final String RELATIVE_TO_ACTION_ATTR_NAME = "relative-to-action";
    @NonNls
    public static final String FIRST_KEYSTROKE_ATTR_NAME = "first-keystroke";
    @NonNls
    public static final String SECOND_KEYSTROKE_ATTR_NAME = "second-keystroke";
    @NonNls
    public static final String REMOVE_SHORTCUT_ATTR_NAME = "remove";
    @NonNls
    public static final String REPLACE_SHORTCUT_ATTR_NAME = "replace-all";
    @NonNls
    public static final String KEYMAP_ATTR_NAME = "keymap";
    @NonNls
    public static final String KEYSTROKE_ATTR_NAME = "keystroke";
    @NonNls
    public static final String REF_ATTR_NAME = "ref";
    @NonNls
    public static final String VALUE_ATTR_NAME = "value";
    @NonNls
    public static final String ACTIONS_BUNDLE = "messages.ActionsBundle";
    @NonNls
    public static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    @NonNls
    public static final String OVERRIDES_ATTR_NAME = "overrides";
    @NonNls
    public static final String KEEP_CONTENT_ATTR_NAME = "keep-content";
    @NonNls
    public static final String PROJECT_TYPE = "project-type";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.ActionManagerImpl");
    private static final int DEACTIVATED_TIMER_DELAY = 5000;
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock;
    private final Map<String, AnAction> myId2Action;
    private final Map<PluginId, THashSet<String>> myPlugin2Id;
    private final TObjectIntHashMap<String> myId2Index;
    private final Map<Object, String> myAction2Id;
    private final MultiMap<String, String> myId2GroupId;
    private final List<String> myNotRegisteredInternalActionIds;
    private final List<AnActionListener> myActionListeners;
    private final KeymapManagerEx myKeymapManager;
    private final DataManager myDataManager;
    private final List<ActionPopupMenuImpl> myPopups;
    private final Map<AnAction, DataContext> myQueuedNotifications;
    private final Map<AnAction, AnActionEvent> myQueuedNotificationsEvents;
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private String myLastPreformedActionId;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn;
    private boolean myTransparentOnlyUpdate;

    ActionManagerImpl(@NotNull KeymapManager keymapManager2, DataManager dataManager) {
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myId2Action = new THashMap();
        this.myPlugin2Id = new THashMap();
        this.myId2Index = new TObjectIntHashMap();
        this.myAction2Id = new THashMap();
        this.myId2GroupId = new MultiMap();
        this.myNotRegisteredInternalActionIds = new ArrayList<String>();
        this.myActionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPopups = new ArrayList<ActionPopupMenuImpl>();
        this.myQueuedNotifications = new LinkedHashMap<AnAction, DataContext>();
        this.myQueuedNotificationsEvents = new LinkedHashMap<AnAction, AnActionEvent>();
        this.myKeymapManager = (KeymapManagerEx)keymapManager2;
        this.myDataManager = dataManager;
        this.registerPluginActions();
    }

    @Nullable
    static AnAction convertStub(ActionStub stub) {
        String iconPath;
        Object obj;
        String className = stub.getClassName();
        try {
            Class<?> aClass = Class.forName(className, true, stub.getLoader());
            obj = ReflectionUtil.newInstance(aClass);
        }
        catch (ClassNotFoundException e) {
            throw ActionManagerImpl.error(stub, e, "class with name ''{0}'' not found", className);
        }
        catch (NoClassDefFoundError e) {
            throw ActionManagerImpl.error(stub, e, "class with name ''{0}'' cannot be loaded", className);
        }
        catch (UnsupportedClassVersionError e) {
            throw ActionManagerImpl.error(stub, e, "error loading class ''{0}''", className);
        }
        catch (Exception e) {
            throw ActionManagerImpl.error(stub, e, "cannot create class ''{0}''", className);
        }
        if (!(obj instanceof AnAction)) {
            LOG.error("class with name '" + className + "' must be an instance of '" + AnAction.class.getName() + "'; got " + obj);
            return null;
        }
        AnAction anAction = (AnAction)obj;
        stub.initAction(anAction);
        if (StringUtil.isNotEmpty((String)stub.getText())) {
            anAction.getTemplatePresentation().setText(stub.getText());
        }
        if ((iconPath = stub.getIconPath()) != null) {
            Class<?> actionClass = anAction.getClass();
            ActionManagerImpl.setIconFromClass(actionClass, actionClass.getClassLoader(), iconPath, anAction.getTemplatePresentation(), stub.getPluginId());
        }
        return anAction;
    }

    @NotNull
    @Contract(pure=true)
    private static RuntimeException error(@NotNull ActionStub stub, @NotNull Throwable original, @NotNull String template, @NotNull String className) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(1);
        }
        if (original == null) {
            ActionManagerImpl.$$$reportNull$$$0(2);
        }
        if (template == null) {
            ActionManagerImpl.$$$reportNull$$$0(3);
        }
        if (className == null) {
            ActionManagerImpl.$$$reportNull$$$0(4);
        }
        PluginId pluginId = stub.getPluginId();
        String text = MessageFormat.format(template, className);
        if (pluginId == null) {
            IllegalStateException illegalStateException = new IllegalStateException(text);
            if (illegalStateException == null) {
                ActionManagerImpl.$$$reportNull$$$0(5);
            }
            return illegalStateException;
        }
        PluginException pluginException = new PluginException(text, original, pluginId);
        if (pluginException == null) {
            ActionManagerImpl.$$$reportNull$$$0(6);
        }
        return pluginException;
    }

    private static void processAbbreviationNode(Element e, String id) {
        String abbr = e.getAttributeValue(VALUE_ATTR_NAME);
        if (!StringUtil.isEmpty((String)abbr)) {
            AbbreviationManagerImpl abbreviationManager = (AbbreviationManagerImpl)AbbreviationManager.getInstance();
            abbreviationManager.register(abbr, id, true);
        }
    }

    @Nullable
    private static ResourceBundle getActionsResourceBundle(ClassLoader loader, IdeaPluginDescriptor plugin) {
        String resBundleName = plugin != null && !"com.intellij".equals(plugin.getPluginId().getIdString()) ? plugin.getResourceBundleBaseName() : ACTIONS_BUNDLE;
        ResourceBundle bundle = null;
        if (resBundleName != null) {
            bundle = AbstractBundle.getResourceBundle((String)resBundleName, (ClassLoader)loader);
        }
        return bundle;
    }

    private static boolean isSecondary(Element element) {
        return "true".equalsIgnoreCase(element.getAttributeValue(SECONDARY));
    }

    private static void setIcon(@Nullable String iconPath, @NotNull String className, @NotNull ClassLoader loader, @NotNull Presentation presentation, PluginId pluginId) {
        if (className == null) {
            ActionManagerImpl.$$$reportNull$$$0(7);
        }
        if (loader == null) {
            ActionManagerImpl.$$$reportNull$$$0(8);
        }
        if (presentation == null) {
            ActionManagerImpl.$$$reportNull$$$0(9);
        }
        if (iconPath == null) {
            return;
        }
        try {
            Class<?> actionClass = Class.forName(className, true, loader);
            ActionManagerImpl.setIconFromClass(actionClass, loader, iconPath, presentation, pluginId);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            LOG.error(e);
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
        }
    }

    private static void setIconFromClass(final @NotNull Class actionClass, final @NotNull ClassLoader classLoader, final @NotNull String iconPath, @NotNull Presentation presentation, final PluginId pluginId) {
        if (actionClass == null) {
            ActionManagerImpl.$$$reportNull$$$0(10);
        }
        if (classLoader == null) {
            ActionManagerImpl.$$$reportNull$$$0(11);
        }
        if (iconPath == null) {
            ActionManagerImpl.$$$reportNull$$$0(12);
        }
        if (presentation == null) {
            ActionManagerImpl.$$$reportNull$$$0(13);
        }
        IconLoader.LazyIcon lazyIcon = new IconLoader.LazyIcon(){

            protected Icon compute() {
                Icon icon = IconLoader.findIcon((String)iconPath, (Class)actionClass, (boolean)true, (boolean)false);
                if (icon == null) {
                    icon = IconLoader.findIcon((String)iconPath, (ClassLoader)classLoader);
                }
                if (icon == null) {
                    ActionManagerImpl.reportActionError(pluginId, "Icon cannot be found in '" + iconPath + "', action '" + actionClass + "'");
                }
                return icon;
            }

            public String toString() {
                return "LazyIcon@ActionManagerImpl (path: " + iconPath + ", action class: " + actionClass + ")";
            }
        };
        if (!Registry.is((String)"ide.lazyIconLoading")) {
            lazyIcon.load();
        }
        presentation.setIcon((Icon)lazyIcon);
    }

    private static String loadDescriptionForElement(Element element, ResourceBundle bundle, String id, String elementType) {
        String value = element.getAttributeValue(DESCRIPTION);
        if (bundle != null) {
            String key = elementType + "." + id + ".description";
            return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)(value == null ? "" : value), (Object[])new Object[0]);
        }
        return value;
    }

    private static String loadTextForElement(Element element, ResourceBundle bundle, String id, String elementType) {
        String value = element.getAttributeValue(TEXT_ATTR_NAME);
        return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)(elementType + "." + id + "." + TEXT_ATTR_NAME), (String)(value == null ? "" : value), (Object[])new Object[0]);
    }

    public static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor2, @NotNull String actionName, @Nullable PluginId pluginId) {
        if (anchor2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(14);
        }
        if (actionName == null) {
            ActionManagerImpl.$$$reportNull$$$0(15);
        }
        if ((Anchor.BEFORE == anchor2 || Anchor.AFTER == anchor2) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    public static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            return Anchor.LAST;
        }
        if (FIRST.equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if (LAST.equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if (BEFORE.equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if (AFTER.equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    private void processMouseShortcutNode(Element element, String actionId, PluginId pluginId) {
        MouseShortcut shortcut;
        String keystrokeString = element.getAttributeValue(KEYSTROKE_ATTR_NAME);
        if (keystrokeString == null || keystrokeString.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = this.myKeymapManager.getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionError(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        ActionManagerImpl.processRemoveAndReplace(element, actionId, keymap, (Shortcut)shortcut);
    }

    private static void assertActionIsGroupOrStub(AnAction action) {
        if (!(action instanceof ActionGroup || action instanceof ActionStub || action instanceof ChameleonAction)) {
            LOG.error("Action : " + action + "; class: " + action.getClass());
        }
    }

    private static void reportActionError(PluginId pluginId, @NonNls @NotNull String message) {
        if (message == null) {
            ActionManagerImpl.$$$reportNull$$$0(16);
        }
        if (pluginId == null) {
            LOG.error(message);
        } else {
            LOG.error((Throwable)new PluginException(message, null, pluginId));
        }
    }

    private static void reportActionWarning(PluginId pluginId, @NonNls @NotNull String message) {
        if (message == null) {
            ActionManagerImpl.$$$reportNull$$$0(17);
        }
        if (pluginId == null) {
            LOG.warn(message);
        } else {
            LOG.warn(new PluginException(message, null, pluginId).getMessage());
        }
    }

    @NonNls
    private static String getPluginInfo(@Nullable PluginId id) {
        IdeaPluginDescriptor plugin;
        if (id != null && (plugin = PluginManager.getPlugin(id)) != null) {
            String name = plugin.getName();
            if (name == null) {
                name = id.getIdString();
            }
            return " Plugin: " + name;
        }
        return "";
    }

    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        return contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
    }

    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public void addTimerListener(int delay, TimerListener listener2) {
        this._addTimerListener(listener2, false);
    }

    public void removeTimerListener(TimerListener listener2) {
        this._removeTimerListener(listener2, false);
    }

    public void addTransparentTimerListener(int delay, TimerListener listener2) {
        this._addTimerListener(listener2, true);
    }

    public void removeTransparentTimerListener(TimerListener listener2) {
        this._removeTimerListener(listener2, true);
    }

    private void _addTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.addTimerListener(listener2, transparent);
    }

    private void _removeTimerListener(TimerListener listener2, boolean transparent) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (LOG.assertTrue(this.myTimer != null)) {
            this.myTimer.removeTimerListener(listener2, transparent);
        }
    }

    public ActionPopupMenu createActionPopupMenu(String place, @NotNull ActionGroup group, @Nullable PresentationFactory presentationFactory) {
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(18);
        }
        return new ActionPopupMenuImpl(place, group, this, presentationFactory);
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(String place, @NotNull ActionGroup group) {
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(19);
        }
        ActionPopupMenuImpl actionPopupMenuImpl = new ActionPopupMenuImpl(place, group, this, null);
        if (actionPopupMenuImpl == null) {
            ActionManagerImpl.$$$reportNull$$$0(20);
        }
        return actionPopupMenuImpl;
    }

    @NotNull
    public ActionToolbar createActionToolbar(String place, @NotNull ActionGroup group, boolean horizontal) {
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(21);
        }
        ActionToolbar actionToolbar = this.createActionToolbar(place, group, horizontal, false);
        if (actionToolbar == null) {
            ActionManagerImpl.$$$reportNull$$$0(22);
        }
        return actionToolbar;
    }

    @NotNull
    public ActionToolbar createActionToolbar(String place, @NotNull ActionGroup group, boolean horizontal, boolean decorateButtons) {
        if (group == null) {
            ActionManagerImpl.$$$reportNull$$$0(23);
        }
        ActionToolbarImpl actionToolbarImpl = new ActionToolbarImpl(place, group, horizontal, decorateButtons, this.myDataManager, this, this.myKeymapManager);
        if (actionToolbarImpl == null) {
            ActionManagerImpl.$$$reportNull$$$0(24);
        }
        return actionToolbarImpl;
    }

    private void registerPluginActions() {
        IdeaPluginDescriptor[] plugins2;
        for (IdeaPluginDescriptor plugin : plugins2 = PluginManagerCore.getPlugins()) {
            List elementList;
            if (PluginManagerCore.shouldSkipPlugin(plugin) || (elementList = plugin.getActionsDescriptionElements()) == null) continue;
            for (Element e : elementList) {
                this.processActionsChildElement(plugin.getPluginClassLoader(), plugin.getPluginId(), e);
            }
        }
    }

    @Nullable
    public AnAction getAction(@NotNull String id) {
        if (id == null) {
            ActionManagerImpl.$$$reportNull$$$0(25);
        }
        return this.getActionImpl(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction getActionImpl(String id, boolean canReturnStub) {
        AnAction action;
        Object object = this.myLock;
        synchronized (object) {
            action = this.myId2Action.get(id);
            if (canReturnStub || !(action instanceof ActionStub)) {
                return action;
            }
        }
        AnAction converted = ActionManagerImpl.convertStub((ActionStub)action);
        if (converted == null) {
            return null;
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            action = this.myId2Action.get(id);
            if (action instanceof ActionStub) {
                action = this.replaceStub((ActionStub)action, converted);
            }
            return action;
        }
    }

    @NotNull
    private AnAction replaceStub(@NotNull ActionStub stub, AnAction anAction) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(26);
        }
        LOG.assertTrue(this.myAction2Id.containsKey(stub));
        this.myAction2Id.remove(stub);
        LOG.assertTrue(this.myId2Action.containsKey(stub.getId()));
        AnAction action = this.myId2Action.remove(stub.getId());
        LOG.assertTrue(action != null);
        LOG.assertTrue(action.equals(stub));
        this.myAction2Id.put(anAction, stub.getId());
        AnAction anAction2 = this.addToMap(stub.getId(), anAction, stub.getPluginId(), stub.getProjectType());
        if (anAction2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(27);
        }
        return anAction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(@NotNull AnAction action) {
        if (action == null) {
            ActionManagerImpl.$$$reportNull$$$0(28);
        }
        LOG.assertTrue(!(action instanceof ActionStub));
        Object object = this.myLock;
        synchronized (object) {
            return this.myAction2Id.get(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getActionIds(@NotNull String idPrefix) {
        if (idPrefix == null) {
            ActionManagerImpl.$$$reportNull$$$0(29);
        }
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<String> idList = new ArrayList<String>();
            for (String id : this.myId2Action.keySet()) {
                if (!id.startsWith(idPrefix)) continue;
                idList.add(id);
            }
            return ArrayUtil.toStringArray(idList);
        }
    }

    public boolean isGroup(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(30);
        }
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    @NotNull
    public JComponent createButtonToolbar(String actionPlace, @NotNull ActionGroup messageActionGroup) {
        if (messageActionGroup == null) {
            ActionManagerImpl.$$$reportNull$$$0(31);
        }
        ButtonToolbarImpl buttonToolbarImpl = new ButtonToolbarImpl(actionPlace, messageActionGroup, this.myDataManager, this);
        if (buttonToolbarImpl == null) {
            ActionManagerImpl.$$$reportNull$$$0(32);
        }
        return buttonToolbarImpl;
    }

    public AnAction getActionOrStub(String id) {
        return this.getActionImpl(id, true);
    }

    @Nullable
    private AnAction processActionElement(Element element, ClassLoader loader, PluginId pluginId) {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
        if (!ACTION_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null || className.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "action element should have specified \"class\" attribute");
            return null;
        }
        String id = element.getAttributeValue(ID_ATTR_NAME);
        if (id == null || id.isEmpty()) {
            id = StringUtil.getShortName((String)className);
        }
        if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id);
            return null;
        }
        String text = ActionManagerImpl.loadTextForElement(element, bundle, id, ACTION_ELEMENT_NAME);
        String iconPath = element.getAttributeValue(ICON_ATTR_NAME);
        if (text == null) {
            String message = "'text' attribute is mandatory (action ID=" + id + ";" + (plugin == null ? "" : " plugin path: " + plugin.getPath()) + ")";
            ActionManagerImpl.reportActionError(pluginId, message);
            return null;
        }
        String projectType = element.getAttributeValue(PROJECT_TYPE);
        ActionStub stub = new ActionStub(className, id, text, loader, pluginId, iconPath, projectType);
        Presentation presentation = stub.getTemplatePresentation();
        presentation.setText(text);
        presentation.setDescription(ActionManagerImpl.loadDescriptionForElement(element, bundle, id, ACTION_ELEMENT_NAME));
        for (Element e : element.getChildren()) {
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(e.getName())) {
                this.processAddToGroupNode((AnAction)stub, e, pluginId, ActionManagerImpl.isSecondary(e));
                continue;
            }
            if (SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                this.processKeyboardShortcutNode(e, id, pluginId);
                continue;
            }
            if (MOUSE_SHORTCUT_ELEMENT_NAME.equals(e.getName())) {
                this.processMouseShortcutNode(e, id, pluginId);
                continue;
            }
            if (ABBREVIATION_ELEMENT_NAME.equals(e.getName())) {
                ActionManagerImpl.processAbbreviationNode(e, id);
                continue;
            }
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + e.getName() + "\"");
            return null;
        }
        if (element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME) != null) {
            this.myKeymapManager.bindShortcuts(element.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME), id);
        }
        this.registerOrReplaceActionInner(element, id, (AnAction)stub, pluginId);
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOrReplaceActionInner(@NotNull Element element, @NotNull String id, @NotNull AnAction action, @Nullable PluginId pluginId) {
        if (element == null) {
            ActionManagerImpl.$$$reportNull$$$0(33);
        }
        if (id == null) {
            ActionManagerImpl.$$$reportNull$$$0(34);
        }
        if (action == null) {
            ActionManagerImpl.$$$reportNull$$$0(35);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (Boolean.valueOf(element.getAttributeValue(OVERRIDES_ATTR_NAME)).booleanValue()) {
                if (this.getActionOrStub(id) == null) {
                    throw new RuntimeException(element.getName() + " '" + id + "' doesn't override anything");
                }
                AnAction prev2 = this.replaceAction(id, action, pluginId);
                if (action instanceof DefaultActionGroup && prev2 instanceof DefaultActionGroup && Boolean.valueOf(element.getAttributeValue(KEEP_CONTENT_ATTR_NAME)).booleanValue()) {
                    ((DefaultActionGroup)action).copyFromGroup((DefaultActionGroup)prev2);
                }
            } else {
                this.registerAction(id, action, pluginId, element.getAttributeValue(PROJECT_TYPE));
            }
        }
    }

    private AnAction processGroupElement(Element element, ClassLoader loader, PluginId pluginId) {
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        ResourceBundle bundle = ActionManagerImpl.getActionsResourceBundle(loader, plugin);
        if (!GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String className = element.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null) {
            className = "true".equals(element.getAttributeValue(COMPACT_ATTR_NAME)) ? DefaultCompactActionGroup.class.getName() : DefaultActionGroup.class.getName();
        }
        try {
            String description;
            DefaultActionGroup group;
            if (DefaultActionGroup.class.getName().equals(className)) {
                group = new DefaultActionGroup();
            } else if (DefaultCompactActionGroup.class.getName().equals(className)) {
                group = new DefaultCompactActionGroup();
            } else {
                Class<?> aClass = Class.forName(className, true, loader);
                Object obj = new CachingConstructorInjectionComponentAdapter((Object)className, aClass).getComponentInstance(ApplicationManager.getApplication().getPicoContainer());
                if (!(obj instanceof ActionGroup)) {
                    ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                    return null;
                }
                if (element.getChildren().size() != element.getChildren(ADD_TO_GROUP_ELEMENT_NAME).size() && !(obj instanceof DefaultActionGroup)) {
                    ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                    return null;
                }
                group = (ActionGroup)obj;
            }
            String id = element.getAttributeValue(ID_ATTR_NAME);
            if (id != null && id.isEmpty()) {
                ActionManagerImpl.reportActionError(pluginId, "ID of the group cannot be an empty string");
                return null;
            }
            if (Boolean.valueOf(element.getAttributeValue(INTERNAL_ATTR_NAME)).booleanValue() && !ApplicationManagerEx.getApplicationEx().isInternal()) {
                this.myNotRegisteredInternalActionIds.add(id);
                return null;
            }
            if (id != null) {
                this.registerOrReplaceActionInner(element, id, (AnAction)group, pluginId);
            }
            Presentation presentation = group.getTemplatePresentation();
            String text = ActionManagerImpl.loadTextForElement(element, bundle, id, GROUP_ELEMENT_NAME);
            if (!StringUtil.isEmpty((String)text) || presentation.getText() == null) {
                presentation.setText(text);
            }
            if (!StringUtil.isEmpty((String)(description = ActionManagerImpl.loadDescriptionForElement(element, bundle, id, GROUP_ELEMENT_NAME))) || presentation.getDescription() == null) {
                presentation.setDescription(description);
            }
            ActionManagerImpl.setIcon(element.getAttributeValue(ICON_ATTR_NAME), className, loader, presentation, pluginId);
            String popup2 = element.getAttributeValue(POPUP_ATTR_NAME);
            if (popup2 != null) {
                group.setPopup(Boolean.valueOf(popup2).booleanValue());
            }
            for (Element child : element.getChildren()) {
                AnAction action;
                String name = child.getName();
                if (ACTION_ELEMENT_NAME.equals(name)) {
                    action = this.processActionElement(child, loader, pluginId);
                    if (action == null) continue;
                    ActionManagerImpl.assertActionIsGroupOrStub(action);
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, ActionManagerImpl.isSecondary(child));
                    continue;
                }
                if (SEPARATOR_ELEMENT_NAME.equals(name)) {
                    this.processSeparatorNode(group, child, pluginId);
                    continue;
                }
                if (GROUP_ELEMENT_NAME.equals(name)) {
                    action = this.processGroupElement(child, loader, pluginId);
                    if (action == null) continue;
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, false);
                    continue;
                }
                if (ADD_TO_GROUP_ELEMENT_NAME.equals(name)) {
                    this.processAddToGroupNode((AnAction)group, child, pluginId, ActionManagerImpl.isSecondary(child));
                    continue;
                }
                if (REFERENCE_ELEMENT_NAME.equals(name)) {
                    action = this.processReferenceElement(child, pluginId);
                    if (action == null) continue;
                    this.addToGroupInner((AnAction)group, action, Constraints.LAST, ActionManagerImpl.isSecondary(child));
                    continue;
                }
                ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
                return null;
            }
            return group;
        }
        catch (ClassNotFoundException e) {
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + className + "\" not found");
            return null;
        }
        catch (NoClassDefFoundError e) {
            ActionManagerImpl.reportActionError(pluginId, "class with name \"" + e.getMessage() + "\" not found");
            return null;
        }
        catch (UnsupportedClassVersionError e) {
            ActionManagerImpl.reportActionError(pluginId, "unsupported class version for " + className);
            return null;
        }
        catch (Exception e) {
            String message = "cannot create class \"" + className + "\"";
            if (pluginId == null) {
                LOG.error(message, (Throwable)e);
            } else {
                LOG.error((Throwable)new PluginException(message, (Throwable)e, pluginId));
            }
            return null;
        }
    }

    private void processReferenceNode(Element element, PluginId pluginId) {
        AnAction action = this.processReferenceElement(element, pluginId);
        if (action == null) {
            return;
        }
        for (Element child : element.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child.getName())) continue;
            this.processAddToGroupNode(action, child, pluginId, ActionManagerImpl.isSecondary(child));
        }
    }

    private void processAddToGroupNode(AnAction action, Element element, PluginId pluginId, boolean secondary) {
        if (!(action instanceof Separator)) {
            ActionManagerImpl.assertActionIsGroupOrStub(action);
        }
        String actionName = String.format("%s (%s)", action instanceof ActionStub ? ((ActionStub)action).getClassName() : action.getClass().getName(), action instanceof ActionStub ? ((ActionStub)action).getId() : this.myAction2Id.get(action));
        if (!ADD_TO_GROUP_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        AnAction parentGroup = this.getParentGroup(element.getAttributeValue(GROUPID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor2 = ActionManagerImpl.parseAnchor(element.getAttributeValue(ANCHOR_ELEMENT_NAME), actionName, pluginId);
        if (anchor2 == null) {
            return;
        }
        String relativeToActionId = element.getAttributeValue(RELATIVE_TO_ACTION_ATTR_NAME);
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor2, actionName, pluginId)) {
            return;
        }
        this.addToGroupInner(parentGroup, action, new Constraints(anchor2, relativeToActionId), secondary);
    }

    private void addToGroupInner(AnAction group, AnAction action, Constraints constraints, boolean secondary) {
        String actionId = action instanceof ActionStub ? ((ActionStub)action).getId() : this.myAction2Id.get(action);
        ((DefaultActionGroup)group).addAction(action, constraints, (ActionManager)this).setAsSecondary(secondary);
        this.myId2GroupId.putValue((Object)actionId, (Object)this.myAction2Id.get(group));
    }

    @Nullable
    public AnAction getParentGroup(String groupId, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId == null || groupId.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId + "\" isn't registered; action will be added to the \"Other\" group");
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + parentGroup.getClass());
            return null;
        }
        return parentGroup;
    }

    private void processSeparatorNode(@Nullable DefaultActionGroup parentGroup, Element element, PluginId pluginId) {
        Separator separator;
        if (!SEPARATOR_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return;
        }
        String text = element.getAttributeValue(TEXT_ATTR_NAME);
        Separator separator2 = separator = text != null ? new Separator(text) : Separator.getInstance();
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, (ActionManager)this);
        }
        for (Element child : element.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child.getName())) continue;
            this.processAddToGroupNode((AnAction)separator, child, pluginId, ActionManagerImpl.isSecondary(child));
        }
    }

    private void processKeyboardShortcutNode(Element element, String actionId, PluginId pluginId) {
        String firstStrokeString = element.getAttributeValue(FIRST_KEYSTROKE_ATTR_NAME);
        if (firstStrokeString == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke((String)firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = element.getAttributeValue(SECOND_KEYSTROKE_ATTR_NAME);
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke((String)secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap = this.myKeymapManager.getKeymap(keymapName);
        if (keymap == null) {
            ActionManagerImpl.reportActionWarning(pluginId, "keymap \"" + keymapName + "\" not found");
            return;
        }
        KeyboardShortcut shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
        ActionManagerImpl.processRemoveAndReplace(element, actionId, keymap, (Shortcut)shortcut);
    }

    private static void processRemoveAndReplace(@NotNull Element element, String actionId, @NotNull Keymap keymap, @NotNull Shortcut shortcut) {
        if (element == null) {
            ActionManagerImpl.$$$reportNull$$$0(36);
        }
        if (keymap == null) {
            ActionManagerImpl.$$$reportNull$$$0(37);
        }
        if (shortcut == null) {
            ActionManagerImpl.$$$reportNull$$$0(38);
        }
        boolean remove = Boolean.parseBoolean(element.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME));
        boolean replace = Boolean.parseBoolean(element.getAttributeValue(REPLACE_SHORTCUT_ATTR_NAME));
        if (remove) {
            keymap.removeShortcut(actionId, shortcut);
        }
        if (replace) {
            keymap.removeAllActionShortcuts(actionId);
        }
        if (!remove) {
            keymap.addShortcut(actionId, shortcut);
        }
    }

    @Nullable
    private AnAction processReferenceElement(Element element, PluginId pluginId) {
        if (!REFERENCE_ELEMENT_NAME.equals(element.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element.getName() + "\"");
            return null;
        }
        String ref = element.getAttributeValue(REF_ATTR_NAME);
        if (ref == null) {
            ref = element.getAttributeValue(ID_ATTR_NAME);
        }
        if (ref == null || ref.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined");
            return null;
        }
        AnAction action = this.getActionImpl(ref, true);
        if (action == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")");
            }
            return null;
        }
        ActionManagerImpl.assertActionIsGroupOrStub(action);
        return action;
    }

    private void processActionsChildElement(ClassLoader loader, PluginId pluginId, Element child) {
        String name = child.getName();
        if (ACTION_ELEMENT_NAME.equals(name)) {
            AnAction action = this.processActionElement(child, loader, pluginId);
            if (action != null) {
                ActionManagerImpl.assertActionIsGroupOrStub(action);
            }
        } else if (GROUP_ELEMENT_NAME.equals(name)) {
            this.processGroupElement(child, loader, pluginId);
        } else if (SEPARATOR_ELEMENT_NAME.equals(name)) {
            this.processSeparatorNode(null, child, pluginId);
        } else if (REFERENCE_ELEMENT_NAME.equals(name)) {
            this.processReferenceNode(child, pluginId);
        } else {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + name + "\n");
        }
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action, @Nullable PluginId pluginId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(39);
        }
        if (action == null) {
            ActionManagerImpl.$$$reportNull$$$0(40);
        }
        this.registerAction(actionId, action, pluginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(@NotNull String actionId, @NotNull AnAction action, @Nullable PluginId pluginId, @Nullable String projectType) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(41);
        }
        if (action == null) {
            ActionManagerImpl.$$$reportNull$$$0(42);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.addToMap(actionId, action, pluginId, projectType) == null) {
                return;
            }
            if (this.myAction2Id.containsKey(action)) {
                ActionManagerImpl.reportActionError(pluginId, "action was already registered for another ID. ID is " + this.myAction2Id.get(action) + ActionManagerImpl.getPluginInfo(pluginId));
                return;
            }
            this.myId2Index.put((Object)actionId, this.myRegisteredActionsCount++);
            this.myAction2Id.put(action, actionId);
            if (pluginId != null && !(action instanceof ActionGroup)) {
                this.myPlugin2Id.computeIfAbsent(pluginId, k -> new THashSet()).add((Object)actionId);
            }
            action.registerCustomShortcutSet((ShortcutSet)new ProxyShortcutSet(actionId, this.myKeymapManager), null);
        }
    }

    private AnAction addToMap(String actionId, AnAction action, PluginId pluginId, String projectType) {
        if (projectType != null || this.myId2Action.containsKey(actionId)) {
            return this.registerChameleon(actionId, action, pluginId, projectType);
        }
        this.myId2Action.put(actionId, action);
        return action;
    }

    private AnAction registerChameleon(String actionId, AnAction action, PluginId pluginId, String projectType) {
        ChameleonAction chameleonAction;
        ProjectType type = projectType == null ? null : new ProjectType(projectType);
        AnAction o = this.myId2Action.get(actionId);
        if (o == null) {
            ChameleonAction chameleonAction2 = new ChameleonAction(action, type);
            this.myId2Action.put(actionId, chameleonAction2);
            return chameleonAction2;
        }
        if (o instanceof ChameleonAction) {
            chameleonAction = (ChameleonAction)o;
        } else {
            chameleonAction = new ChameleonAction(o, type);
            this.myId2Action.put(actionId, chameleonAction);
        }
        AnAction old = chameleonAction.addAction(action, type);
        if (old != null) {
            ActionManagerImpl.reportActionError(pluginId, "action with the ID \"" + actionId + "\" was already registered. Action being registered is " + action + "; Registered action is " + this.myId2Action.get(actionId) + ActionManagerImpl.getPluginInfo(pluginId));
            return null;
        }
        return chameleonAction;
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(43);
        }
        if (action == null) {
            ActionManagerImpl.$$$reportNull$$$0(44);
        }
        this.registerAction(actionId, action, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(45);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myId2Action.containsKey(actionId) && LOG.isDebugEnabled()) {
                LOG.debug("action with ID " + actionId + " wasn't registered");
                return;
            }
            AnAction oldValue = this.myId2Action.remove(actionId);
            this.myAction2Id.remove(oldValue);
            this.myId2Index.remove((Object)actionId);
            for (PluginId pluginName : this.myPlugin2Id.keySet()) {
                THashSet<String> pluginActions = this.myPlugin2Id.get(pluginName);
                if (pluginActions == null) continue;
                pluginActions.remove((Object)actionId);
            }
        }
    }

    @NotNull
    public Comparator<String> getRegistrationOrderComparator() {
        Comparator<String> comparator2 = Comparator.comparingInt(arg_0 -> this.myId2Index.get(arg_0));
        if (comparator2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(46);
        }
        return comparator2;
    }

    @NotNull
    public String[] getPluginActions(@NotNull PluginId pluginName) {
        if (pluginName == null) {
            ActionManagerImpl.$$$reportNull$$$0(47);
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)((Collection)this.myPlugin2Id.get(pluginName)));
        if (stringArray == null) {
            ActionManagerImpl.$$$reportNull$$$0(48);
        }
        return stringArray;
    }

    public void addActionPopup(ActionPopupMenuImpl menu) {
        this.myPopups.add(menu);
    }

    public void removeActionPopup(ActionPopupMenuImpl menu) {
        boolean removed = this.myPopups.remove(menu);
        if (removed && this.myPopups.isEmpty()) {
            this.flushActionPerformed();
        }
    }

    public void queueActionPerformedEvent(AnAction action, DataContext context, AnActionEvent event) {
        if (!this.myPopups.isEmpty()) {
            this.myQueuedNotifications.put(action, context);
        } else {
            this.fireAfterActionPerformed(action, context, event);
        }
    }

    public boolean isToolWindowContextMenuVisible() {
        for (ActionPopupMenuImpl popup2 : this.myPopups) {
            if (!popup2.isToolWindowContextMenu()) continue;
            return true;
        }
        return false;
    }

    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    public boolean isTransparentOnlyActionsUpdateNow() {
        return this.myTransparentOnlyUpdate;
    }

    private AnAction replaceAction(@NotNull String actionId, @NotNull AnAction newAction, @Nullable PluginId pluginId) {
        AnAction oldAction;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(49);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(50);
        }
        if ((oldAction = this.getActionOrStub(actionId)) != null) {
            boolean isGroup = oldAction instanceof ActionGroup;
            if (isGroup != newAction instanceof ActionGroup) {
                throw new IllegalStateException("cannot replace a group with an action and vice versa: " + actionId);
            }
            for (String groupId : this.myId2GroupId.get((Object)actionId)) {
                DefaultActionGroup group = (DefaultActionGroup)ObjectUtils.assertNotNull((Object)((DefaultActionGroup)this.getActionOrStub(groupId)));
                group.replaceAction(oldAction, newAction);
            }
            this.unregisterAction(actionId);
            if (isGroup) {
                this.myId2GroupId.values().remove(actionId);
            }
        }
        this.registerAction(actionId, newAction, pluginId);
        return oldAction;
    }

    private void flushActionPerformed() {
        Set<AnAction> actions = this.myQueuedNotifications.keySet();
        for (AnAction eachAction : actions) {
            DataContext eachContext = this.myQueuedNotifications.get(eachAction);
            this.fireAfterActionPerformed(eachAction, eachContext, this.myQueuedNotificationsEvents.get(eachAction));
        }
        this.myQueuedNotifications.clear();
        this.myQueuedNotificationsEvents.clear();
    }

    public void addAnActionListener(AnActionListener listener2) {
        this.myActionListeners.add(listener2);
    }

    public void addAnActionListener(final AnActionListener listener2, Disposable parentDisposable) {
        this.addAnActionListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ActionManagerImpl.this.removeAnActionListener(listener2);
            }
        });
    }

    public void removeAnActionListener(AnActionListener listener2) {
        this.myActionListeners.remove(listener2);
    }

    public void fireBeforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        if (action != null) {
            this.myPrevPerformedActionId = this.myLastPreformedActionId;
            this.myLastPreformedActionId = this.getId(action);
            if (this.myLastPreformedActionId == null && action instanceof ActionIdProvider) {
                this.myLastPreformedActionId = ((ActionIdProvider)action).getId();
            }
            IdeaLogger.ourLastActionId = this.myLastPreformedActionId;
            ActionsCollectorImpl.getInstance().record(this.myLastPreformedActionId);
        }
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeActionPerformed(action, dataContext, event);
        }
    }

    public void fireAfterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        if (action != null) {
            this.myPrevPerformedActionId = this.myLastPreformedActionId;
            IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action);
        }
        for (AnActionListener listener2 : this.myActionListeners) {
            try {
                listener2.afterActionPerformed(action, dataContext, event);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
    }

    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(51);
        }
        AnAction action = ActionManager.getInstance().getAction(actionId);
        ShortcutSet shortcutSet = action.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    public void fireBeforeEditorTyping(char c, DataContext dataContext) {
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeEditorTyping(c, dataContext);
        }
    }

    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getActionIds() {
        Object object = this.myLock;
        synchronized (object) {
            return new HashSet<String>(this.myId2Action.keySet());
        }
    }

    public void preloadActions(ProgressIndicator indicator) {
        Application application = ApplicationManager.getApplication();
        for (String id : this.getActionIds()) {
            indicator.checkCanceled();
            if (application.isDisposed()) {
                return;
            }
            AnAction action = this.getAction(id);
            if (!(action instanceof PreloadableAction)) continue;
            ((PreloadableAction)action).preload();
        }
    }

    public ActionCallback tryToExecute(@NotNull AnAction action, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, @Nullable String place, boolean now) {
        if (action == null) {
            ActionManagerImpl.$$$reportNull$$$0(52);
        }
        if (inputEvent == null) {
            ActionManagerImpl.$$$reportNull$$$0(53);
        }
        Application app = ApplicationManager.getApplication();
        assert (app.isDispatchThread());
        ActionCallback result2 = new ActionCallback();
        Runnable doRunnable = () -> {
            if (action == null) {
                ActionManagerImpl.$$$reportNull$$$0(54);
            }
            if (inputEvent == null) {
                ActionManagerImpl.$$$reportNull$$$0(55);
            }
            this.tryToExecuteNow(action, inputEvent, contextComponent, place, result2);
        };
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        return result2;
    }

    private void tryToExecuteNow(AnAction action, InputEvent inputEvent, Component contextComponent, String place, final ActionCallback result2) {
        Presentation presentation = action.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext((DataContext)ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(() -> ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> {
            DataContext context = ActionManagerImpl.getContextBy(contextComponent);
            AnActionEvent event = new AnActionEvent(inputEvent, context, place != null ? place : "unknown", presentation, (ActionManager)this, inputEvent.getModifiersEx());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
            if (component != null && !component.isShowing()) {
                result2.setRejected();
                return;
            }
            this.fireBeforeActionPerformed(action, context, event);
            UIUtil.addAwtListener((AWTEventListener)new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (!(event.getID() != 200 && event.getID() != 205 || result2.isProcessed())) {
                        WindowEvent we = (WindowEvent)event;
                        IdeFocusManager.findInstanceByComponent((Component)we.getWindow()).doWhenFocusSettlesDown(result2.createSetDoneRunnable());
                    }
                }
            }, (long)64L, (Disposable)result2);
            ActionUtil.performActionDumbAware((AnAction)action, (AnActionEvent)event);
            result2.setDone();
            this.queueActionPerformedEvent(action, context, event);
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 46: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 46: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapManager";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = ANCHOR_ELEMENT_NAME;
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP_ELEMENT_NAME;
                break;
            }
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_ATTR_NAME;
                break;
            }
            case 28: 
            case 35: 
            case 40: 
            case 42: 
            case 44: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = ACTION_ELEMENT_NAME;
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPrefix";
                break;
            }
            case 30: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageActionGroup";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEYMAP_ATTR_NAME;
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "error";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopupMenu";
                break;
            }
            case 22: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceStub";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtonToolbar";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationOrderComparator";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 46: 
            case 48: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIcon";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setIconFromClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkRelativeToAction";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportActionError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reportActionWarning";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopupMenu";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceStub";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getActionIds";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isGroup";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createButtonToolbar";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerOrReplaceActionInner";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processRemoveAndReplace";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAction";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPluginActions";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getKeyboardShortcut";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecute";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryToExecute$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 32: 
            case 46: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTimer
    extends Timer
    implements ActionListener {
        private final List<TimerListener> myTimerListeners;
        private final List<TimerListener> myTransparentTimerListeners;
        private int myLastTimePerformed;

        private MyTimer() {
            super(500, null);
            this.myTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.myTransparentTimerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.addActionListener(this);
            this.setRepeats(true);
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(IdeFrame ideFrame) {
                    MyTimer.this.setDelay(500);
                    MyTimer.this.restart();
                }

                public void applicationDeactivated(IdeFrame ideFrame) {
                    MyTimer.this.setDelay(5000);
                }
            });
        }

        public String toString() {
            return "Action manager timer";
        }

        public void addTimerListener(TimerListener listener2, boolean transparent) {
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).add(listener2);
        }

        public void removeTimerListener(TimerListener listener2, boolean transparent) {
            (transparent ? this.myTransparentTimerListeners : this.myTimerListeners).remove(listener2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            boolean transparentOnly = this.myLastTimePerformed == lastEventCount;
            try {
                HashSet<TimerListener> notified = new HashSet<TimerListener>();
                ActionManagerImpl.this.myTransparentOnlyUpdate = transparentOnly;
                this.notifyListeners(this.myTransparentTimerListeners, notified);
                if (transparentOnly) {
                    return;
                }
                this.notifyListeners(this.myTimerListeners, notified);
            }
            finally {
                ActionManagerImpl.this.myTransparentOnlyUpdate = false;
            }
        }

        private void notifyListeners(List<TimerListener> timerListeners, Set<TimerListener> notified) {
            for (TimerListener listener2 : timerListeners) {
                if (!notified.add(listener2)) continue;
                this.runListenerAction(listener2);
            }
        }

        private void runListenerAction(TimerListener listener2) {
            ModalityState modalityState = listener2.getModalityState();
            if (modalityState == null) {
                return;
            }
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener2.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }
}

