/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoveBomAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoveBomAction.class));

    public RemoveBomAction() {
        super("Remove BOM");
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files2 == null) {
            return;
        }
        List<VirtualFile> filesToProcess = RemoveBomAction.getFilesWithBom(files2, true);
        for (VirtualFile virtualFile : filesToProcess) {
            byte[] bom = virtualFile.getBOM();
            assert (bom != null);
            if (!(virtualFile instanceof NewVirtualFile)) continue;
            virtualFile.setBOM(null);
            NewVirtualFile file2 = (NewVirtualFile)virtualFile;
            try {
                byte[] bytes = file2.contentsToByteArray();
                byte[] contentWithStrippedBom = new byte[bytes.length - bom.length];
                System.arraycopy(bytes, bom.length, contentWithStrippedBom, 0, contentWithStrippedBom.length);
                WriteAction.run(() -> file2.setBinaryContent(contentWithStrippedBom));
            }
            catch (IOException ex) {
                LOG.warn("Unexpected exception occurred on attempt to remove BOM from file " + file2, (Throwable)ex);
            }
        }
    }

    public void update(AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(e.getDataContext());
        if (files2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (VirtualFile file2 : files2) {
            if (file2.isDirectory()) {
                enabled = true;
                break;
            }
            if (file2.getBOM() == null) continue;
            enabled = true;
            break;
        }
        e.getPresentation().setEnabled(enabled);
    }

    @NotNull
    private static List<VirtualFile> getFilesWithBom(@NotNull VirtualFile[] roots, boolean all) {
        if (roots == null) {
            RemoveBomAction.$$$reportNull$$$0(0);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile root : roots) {
            if (!all && !result2.isEmpty()) break;
            RemoveBomAction.getFilesWithBom(root, result2, all);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            RemoveBomAction.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void getFilesWithBom(@NotNull VirtualFile root, final @NotNull List<VirtualFile> result2, final boolean all) {
        if (root == null) {
            RemoveBomAction.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            RemoveBomAction.$$$reportNull$$$0(3);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2.isDirectory()) {
                    if (!all && !result2.isEmpty()) {
                        return false;
                    }
                } else if (file2.getBOM() != null) {
                    result2.add(file2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/RemoveBomAction$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/RemoveBomAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/RemoveBomAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithBom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithBom";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

