/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.wm.impl.content.AdditionalIcon;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.ui.EngravedTextGraphics;
import com.intellij.ui.Gray;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ContentTabLabel
extends BaseLabel {
    private final ActiveIcon closeIcon;
    private final Content myContent;
    private final TabContentLayout myLayout;
    protected static final int ICONS_GAP = 3;
    private final List<AdditionalIcon> additionalIcon;
    private final AdditionalIcon closeTabIcon;
    private CurrentTooltip currentIconTooltip;
    BaseButtonBehavior behavior;

    private void showTooltip(AdditionalIcon icon) {
        String toolText;
        if (this.currentIconTooltip != null) {
            if (this.currentIconTooltip.icon == icon) {
                IdeTooltipManager.getInstance().show(this.currentIconTooltip.currentTooltip, false, false);
                return;
            }
            this.hideCurrentTooltip();
        }
        if ((toolText = icon.getTooltip()) != null && !toolText.isEmpty()) {
            IdeTooltip tooltip = new IdeTooltip(this, icon.getCenterPoint(), new JLabel(toolText), new Object[0]);
            this.currentIconTooltip = new CurrentTooltip(IdeTooltipManager.getInstance().show(tooltip, false, false), icon);
        }
    }

    private void hideCurrentTooltip() {
        if (this.currentIconTooltip == null) {
            return;
        }
        this.currentIconTooltip.currentTooltip.hide();
        this.currentIconTooltip = null;
    }

    protected final boolean mouseOverIcon(AdditionalIcon icon) {
        if (!this.isHovered() || !icon.getAvailable()) {
            return false;
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        return icon.contains(point);
    }

    public ContentTabLabel(@NotNull Content content, @NotNull TabContentLayout layout) {
        if (content == null) {
            ContentTabLabel.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            ContentTabLabel.$$$reportNull$$$0(1);
        }
        super(layout.myUi, true);
        this.closeIcon = new ActiveIcon(JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)true), JBUI.CurrentTheme.ToolWindow.closeTabIcon((boolean)false));
        this.additionalIcon = new ArrayList<AdditionalIcon>();
        this.closeTabIcon = new AdditionalIcon(this.closeIcon){
            private static final String ACTION_NAME = "Close tab";

            @Override
            @NotNull
            public Rectangle getRectangle() {
                Rectangle rectangle = new Rectangle(this.getX(), 0, this.getIconWidth(), ContentTabLabel.this.getHeight());
                if (rectangle == null) {
                    1.$$$reportNull$$$0(0);
                }
                return rectangle;
            }

            @Override
            public boolean getActive() {
                return ContentTabLabel.this.mouseOverIcon(this);
            }

            @Override
            public boolean getAvailable() {
                return ContentTabLabel.this.canBeClosed();
            }

            @Override
            @Nullable
            public String getTooltip() {
                String text = KeymapUtil.getShortcutsText((Shortcut[])KeymapManager.getInstance().getActiveKeymap().getShortcuts("CloseActiveTab"));
                return text.isEmpty() || !ContentTabLabel.this.isSelected() ? ACTION_NAME : "Close tab (" + text + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/content/ContentTabLabel$1", "getRectangle"));
            }
        };
        this.behavior = new BaseButtonBehavior(this){

            protected void execute(MouseEvent e) {
                if (ContentTabLabel.this.canBeClosed() && ContentTabLabel.this.mouseOverIcon(ContentTabLabel.this.closeTabIcon)) {
                    ContentTabLabel.this.contentManager().removeContent(ContentTabLabel.this.getContent(), true);
                } else {
                    ContentTabLabel.this.selectContent();
                }
            }
        };
        this.myLayout = layout;
        this.myContent = content;
        this.fillIcons(this.additionalIcon);
        this.behavior.setActionTrigger(502);
        this.behavior.setMouseDeadzone(TimedDeadzone.NULL);
        this.myContent.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getPropertyName();
                if ("isClosable".equals(property)) {
                    ContentTabLabel.this.repaint();
                }
            }
        });
    }

    protected void fillIcons(List<AdditionalIcon> icons) {
        icons.add(this.closeTabIcon);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent event) {
        super.processMouseMotionEvent(event);
        boolean hovered = this.isHovered();
        if (hovered) {
            Optional<AdditionalIcon> first;
            if (this.invalid()) {
                this.repaint();
            }
            if ((first = this.additionalIcon.stream().filter(icon -> this.mouseOverIcon((AdditionalIcon)icon)).findFirst()).isPresent()) {
                this.showTooltip(first.get());
                return;
            }
        }
        this.hideCurrentTooltip();
    }

    protected boolean invalid() {
        return this.additionalIcon.stream().anyMatch(icon -> icon.getAvailable());
    }

    public final boolean canBeClosed() {
        return this.myContent.isCloseable() && this.contentManager().canCloseContents();
    }

    protected void selectContent() {
        ContentManager mgr = this.contentManager();
        if (mgr.getIndexOfContent(this.myContent) >= 0) {
            mgr.setSelectedContent(this.myContent, true);
        }
    }

    public void update() {
        if (!this.myLayout.isToDrawTabs()) {
            this.setHorizontalAlignment(2);
            this.setBorder(null);
        } else if (this.additionalIcon.stream().anyMatch(icon -> icon.getAvailable())) {
            this.setHorizontalAlignment(2);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12, (int)0, (int)3));
        } else {
            this.setHorizontalAlignment(0);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
        }
        this.updateTextAndIcon(this.myContent, this.isSelected());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int w = size.width;
        for (AdditionalIcon icon : this.additionalIcon) {
            if (!icon.getAvailable()) continue;
            icon.setX(w + 3 - this.getInsets().right);
            w += icon.getIconWidth() + 3;
        }
        return new Dimension(w, size.height);
    }

    @Override
    protected boolean allowEngravement() {
        return this.isSelected() || this.myUi != null && this.myUi.myWindow.isActive();
    }

    @Override
    protected Color getActiveFg(boolean selected) {
        if (this.contentManager().getContentCount() > 1) {
            return JBUI.CurrentTheme.Label.foreground((boolean)selected);
        }
        return super.getActiveFg(selected);
    }

    @Override
    protected Color getPassiveFg(boolean selected) {
        if (this.contentManager().getContentCount() > 1) {
            return JBUI.CurrentTheme.Label.foreground((boolean)selected);
        }
        return super.getPassiveFg(selected);
    }

    private void paintIcons(Graphics g) {
        for (AdditionalIcon icon : this.additionalIcon) {
            if (!icon.getAvailable()) continue;
            icon.paintIcon(this, g);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintIcons(g);
    }

    public boolean isSelected() {
        return this.contentManager().isSelected(this.myContent);
    }

    public boolean isHovered() {
        return this.behavior.isHovered();
    }

    @Override
    protected Graphics _getGraphics(Graphics2D g) {
        if (this.isSelected() && this.contentManager().getContentCount() > 1) {
            return new EngravedTextGraphics(g, 1, 1, Gray._0.withAlpha(this.myUi.myWindow.isActive() ? 120 : 130));
        }
        return super._getGraphics(g);
    }

    private ContentManager contentManager() {
        return this.myUi.myWindow.getContentManager();
    }

    @Override
    @NotNull
    public Content getContent() {
        Content content = this.myContent;
        if (content == null) {
            ContentTabLabel.$$$reportNull$$$0(2);
        }
        return content;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/content/ContentTabLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/content/ContentTabLabel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CurrentTooltip {
        final IdeTooltip currentTooltip;
        final AdditionalIcon icon;

        public CurrentTooltip(IdeTooltip currentTooltip, AdditionalIcon icon) {
            this.currentTooltip = currentTooltip;
            this.icon = icon;
        }
    }
}

