/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.PlatformIcons;
import com.intellij.xml.XmlExtension;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaPrefix
extends RenameableFakePsiElement {
    private final TextRange myRange;
    private final String myName;

    public SchemaPrefix(XmlAttribute parent, TextRange range2, String name) {
        super((PsiElement)parent);
        this.myRange = range2;
        this.myName = name;
    }

    public static SchemaPrefix createJspPrefix(XmlAttributeValue element, String prefix) {
        TextRange range2 = ElementManipulators.getValueTextRange((PsiElement)element).shiftRight(element.getStartOffsetInParent());
        return new SchemaPrefix((XmlAttribute)element.getParent(), range2, prefix){

            @Override
            protected String getNamespace() {
                return ((XmlAttribute)this.getParent()).getParent().getAttributeValue("uri");
            }
        };
    }

    public String getTypeName() {
        return "XML Namespace Prefix";
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    public int getTextOffset() {
        return this.getParent().getTextRange().getStartOffset() + this.myRange.getStartOffset();
    }

    @Override
    public int getTextLength() {
        return this.myName.length();
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public XmlAttribute getDeclaration() {
        return (XmlAttribute)this.getParent();
    }

    @Override
    public TextRange getTextRange() {
        return TextRange.from((int)this.getTextOffset(), (int)this.getTextLength());
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = XmlExtension.getExtension(this.getContainingFile()).getNsPrefixScope(this.getDeclaration());
        if (searchScope == null) {
            SchemaPrefix.$$$reportNull$$$0(0);
        }
        return searchScope;
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof SchemaPrefix && ((SchemaPrefix)another).getDeclaration() == this.getDeclaration();
    }

    public String getQuickNavigateInfo() {
        String ns = this.getNamespace();
        StringBuilder builder = new StringBuilder().append(this.getTypeName()).append(" \"").append(this.getName()).append("\"");
        if (ns != null) {
            builder.append(" (").append(ns).append(")");
        }
        return builder.toString();
    }

    @Nullable
    protected String getNamespace() {
        XmlAttribute parent = (XmlAttribute)this.getParent();
        return parent == null ? null : parent.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/xml/SchemaPrefix", "getUseScope"));
    }
}

