/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.FileNameIndexService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilenameIndex {
    @Deprecated
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"FilenameIndex");

    @NotNull
    public static String[] getAllFilenames(Project project) {
        THashSet names = new THashSet();
        FilenameIndex.getService().processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getAllFilenames$0((Set)names, arg_0)), (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project)), null);
        String[] stringArray = ArrayUtil.toStringArray((Collection)names);
        if (stringArray == null) {
            FilenameIndex.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    public static void processAllFileNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter2) {
        FilenameIndex.getService().processAllFileNames(processor2, scope, filter2);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project, String name, GlobalSearchScope scope) {
        return FilenameIndex.getService().getVirtualFilesByName(project, name, scope, null);
    }

    public static Collection<VirtualFile> getVirtualFilesByName(Project project, String name, boolean caseSensitively, GlobalSearchScope scope) {
        if (caseSensitively) {
            return FilenameIndex.getVirtualFilesByName(project, name, scope);
        }
        return FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project, null);
    }

    @NotNull
    public static PsiFile[] getFilesByName(Project project, String name, GlobalSearchScope scope) {
        PsiFile[] psiFileArray = (PsiFile[])FilenameIndex.getFilesByName(project, name, scope, false);
        if (psiFileArray == null) {
            FilenameIndex.$$$reportNull$$$0(1);
        }
        return psiFileArray;
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            FilenameIndex.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(4);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(5);
        }
        return FilenameIndex.processFilesByName(name, directories, true, processor2, scope, project, idFilter);
    }

    public static boolean processFilesByName(@NotNull String name, boolean directories, boolean caseSensitively, @NotNull Processor<? super PsiFileSystemItem> processor2, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        Collection<VirtualFile> files2;
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            FilenameIndex.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(8);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(9);
        }
        if ((files2 = caseSensitively ? FilenameIndex.getService().getVirtualFilesByName(project, name, scope, idFilter) : FilenameIndex.getVirtualFilesByNameIgnoringCase(name, scope, project, idFilter)).isEmpty()) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        int processedFiles = 0;
        for (VirtualFile file2 : files2) {
            PsiDirectory dir;
            if (!file2.isValid()) continue;
            if (!directories && !file2.isDirectory()) {
                PsiFile psiFile = psiManager.findFile(file2);
                if (psiFile == null) continue;
                if (!processor2.process((Object)psiFile)) {
                    return true;
                }
                ++processedFiles;
                continue;
            }
            if (!directories || !file2.isDirectory() || (dir = psiManager.findDirectory(file2)) == null) continue;
            if (!processor2.process((Object)dir)) {
                return true;
            }
            ++processedFiles;
        }
        return processedFiles > 0;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesByNameIgnoringCase(@NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Project project, @Nullable IdFilter idFilter) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(11);
        }
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(12);
        }
        THashSet keys = new THashSet();
        FileNameIndexService fileNameIndexService = FilenameIndex.getService();
        fileNameIndexService.processAllFileNames((Processor<String>)((Processor)arg_0 -> FilenameIndex.lambda$getVirtualFilesByNameIgnoringCase$1(name, (Set)keys, arg_0)), scope, idFilter);
        THashSet files2 = new THashSet();
        for (String each : keys) {
            files2.addAll(fileNameIndexService.getVirtualFilesByName(project, each, scope, idFilter));
        }
        THashSet tHashSet = files2;
        if (tHashSet == null) {
            FilenameIndex.$$$reportNull$$$0(13);
        }
        return tHashSet;
    }

    @NotNull
    public static PsiFileSystemItem[] getFilesByName(Project project, String name, @NotNull GlobalSearchScope scope, boolean includeDirs) {
        if (scope == null) {
            FilenameIndex.$$$reportNull$$$0(14);
        }
        SmartList result2 = new SmartList();
        Processor processor2 = Processors.cancelableCollectProcessor((Collection)result2);
        FilenameIndex.processFilesByName(name, includeDirs, (Processor<? super PsiFileSystemItem>)processor2, scope, project, null);
        if (includeDirs) {
            PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])ArrayUtil.toObjectArray((Collection)result2, PsiFileSystemItem.class);
            if (psiFileSystemItemArray == null) {
                FilenameIndex.$$$reportNull$$$0(15);
            }
            return psiFileSystemItemArray;
        }
        PsiFileSystemItem[] psiFileSystemItemArray = (PsiFileSystemItem[])result2.toArray((Object[])PsiFile.EMPTY_ARRAY);
        if (psiFileSystemItemArray == null) {
            FilenameIndex.$$$reportNull$$$0(16);
        }
        return psiFileSystemItemArray;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext) {
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(17);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(18);
        }
        Collection<VirtualFile> collection = FilenameIndex.getAllFilesByExt(project, ext, GlobalSearchScope.allScope((Project)project));
        if (collection == null) {
            FilenameIndex.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getAllFilesByExt(@NotNull Project project, @NotNull String ext, @NotNull GlobalSearchScope searchScope) {
        int len;
        if (project == null) {
            FilenameIndex.$$$reportNull$$$0(20);
        }
        if (ext == null) {
            FilenameIndex.$$$reportNull$$$0(21);
        }
        if (searchScope == null) {
            FilenameIndex.$$$reportNull$$$0(22);
        }
        if ((len = ext.length()) == 0) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                FilenameIndex.$$$reportNull$$$0(23);
            }
            return list2;
        }
        ext = "." + ext;
        ++len;
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (String name : FilenameIndex.getAllFilenames(project)) {
            int length = name.length();
            if (length <= len || !name.substring(length - len).equalsIgnoreCase(ext)) continue;
            files2.addAll(FilenameIndex.getVirtualFilesByName(project, name, searchScope));
        }
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            FilenameIndex.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    static FileNameIndexService getService() {
        return (FileNameIndexService)ServiceManager.getService(FileNameIndexService.class);
    }

    private static /* synthetic */ boolean lambda$getVirtualFilesByNameIgnoringCase$1(@NotNull String name, Set keys, String value) {
        if (name == null) {
            FilenameIndex.$$$reportNull$$$0(25);
        }
        if (name.equalsIgnoreCase(value)) {
            keys.add(value);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getAllFilenames$0(Set names, String s) {
        names.add(s);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilenames";
                break;
            }
            case 1: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/FilenameIndex";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesByNameIgnoringCase";
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFilesByExt";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processFilesByName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesByNameIgnoringCase";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAllFilesByExt";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getVirtualFilesByNameIgnoringCase$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

