/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonLayoutConfiguration {
    public final int iconPanelWidth;
    public final Dimension iconOffset;
    public final int topSpaceHeight;
    public final int titleContentSpaceHeight;
    public final int contentActionsSpaceHeight;
    public final int titleActionsSpaceHeight;
    public final int bottomSpaceHeight;
    public final int actionGap;
    public final Dimension rightActionsOffset;
    public final int closeOffset;
    public final int gearCloseSpace;
    public final int allActionsOffset;
    public final int beforeGearSpace;
    public static final int FixedWidth;
    public static final int MaxWidth;
    public static final int MaxFullContentWidth;
    public static final String MaxFullContentWidthStyle;
    public static final int MinWidth;
    public static final String MaxWidthStyle;
    public static final int NotificationSpace;

    @NotNull
    public static BalloonLayoutConfiguration create(@NotNull Notification notification, @NotNull BalloonLayoutData layoutData, boolean actions) {
        if (notification == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(0);
        }
        if (layoutData == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(1);
        }
        boolean hasTitle = notification.hasTitle();
        boolean hasContent = notification.hasContent();
        if (hasTitle && hasContent && actions) {
            BalloonLayoutConfiguration balloonLayoutConfiguration = BalloonLayoutConfiguration.treeLines();
            if (balloonLayoutConfiguration == null) {
                BalloonLayoutConfiguration.$$$reportNull$$$0(2);
            }
            return balloonLayoutConfiguration;
        }
        if (hasContent && NotificationsManagerImpl.calculateContentHeight(hasTitle || actions ? 1 : 2) < layoutData.fullHeight) {
            BalloonLayoutConfiguration balloonLayoutConfiguration = BalloonLayoutConfiguration.treeLines();
            if (balloonLayoutConfiguration == null) {
                BalloonLayoutConfiguration.$$$reportNull$$$0(3);
            }
            return balloonLayoutConfiguration;
        }
        BalloonLayoutConfiguration balloonLayoutConfiguration = BalloonLayoutConfiguration.twoLines();
        if (balloonLayoutConfiguration == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(4);
        }
        return balloonLayoutConfiguration;
    }

    @NotNull
    public BalloonLayoutConfiguration replace(int topSpaceHeight, int bottomSpaceHeight) {
        BalloonLayoutConfiguration balloonLayoutConfiguration = new BalloonLayoutConfiguration(this.iconPanelWidth, this.iconOffset, topSpaceHeight, this.titleContentSpaceHeight, this.contentActionsSpaceHeight, this.titleActionsSpaceHeight, bottomSpaceHeight, this.actionGap, null, 0, 0, 0);
        if (balloonLayoutConfiguration == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(5);
        }
        return balloonLayoutConfiguration;
    }

    @NotNull
    private static BalloonLayoutConfiguration twoLines() {
        BalloonLayoutConfiguration balloonLayoutConfiguration = new BalloonLayoutConfiguration((Dimension)new JBDimension(10, 11), JBUI.scale((int)11), JBUI.scale((int)5), JBUI.scale((int)5), JBUI.scale((int)5), JBUI.scale((int)14));
        if (balloonLayoutConfiguration == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(6);
        }
        return balloonLayoutConfiguration;
    }

    @NotNull
    private static BalloonLayoutConfiguration treeLines() {
        BalloonLayoutConfiguration balloonLayoutConfiguration = new BalloonLayoutConfiguration((Dimension)new JBDimension(10, 7), JBUI.scale((int)7), JBUI.scale((int)3), JBUI.scale((int)7), 0, JBUI.scale((int)8));
        if (balloonLayoutConfiguration == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(7);
        }
        return balloonLayoutConfiguration;
    }

    private BalloonLayoutConfiguration(@NotNull Dimension iconOffset, int topSpaceHeight, int titleContentSpaceHeight, int contentActionsSpaceHeight, int titleActionsSpaceHeight, int bottomSpaceHeight) {
        if (iconOffset == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(8);
        }
        this(JBUI.scale((int)32), iconOffset, topSpaceHeight, titleContentSpaceHeight, contentActionsSpaceHeight, titleActionsSpaceHeight, bottomSpaceHeight, JBUI.scale((int)16), (Dimension)new JBDimension(8, 6), JBUI.scale((int)7), JBUI.scale((int)5), JBUI.scale((int)15));
    }

    private BalloonLayoutConfiguration(int iconPanelWidth, @NotNull Dimension iconOffset, int topSpaceHeight, int titleContentSpaceHeight, int contentActionsSpaceHeight, int titleActionsSpaceHeight, int bottomSpaceHeight, int actionGap, @Nullable Dimension rightActionsOffset, int afterGearSpace, int beforeCloseSpace, int beforeGearSpace) {
        if (iconOffset == null) {
            BalloonLayoutConfiguration.$$$reportNull$$$0(9);
        }
        this.iconPanelWidth = iconPanelWidth;
        this.iconOffset = iconOffset;
        this.topSpaceHeight = topSpaceHeight;
        this.titleContentSpaceHeight = titleContentSpaceHeight;
        this.contentActionsSpaceHeight = contentActionsSpaceHeight;
        this.titleActionsSpaceHeight = titleActionsSpaceHeight;
        this.bottomSpaceHeight = bottomSpaceHeight;
        this.actionGap = actionGap;
        if (rightActionsOffset == null) {
            this.rightActionsOffset = new Dimension();
            this.closeOffset = 0;
            this.gearCloseSpace = 0;
            this.allActionsOffset = 0;
            this.beforeGearSpace = 0;
        } else {
            this.rightActionsOffset = rightActionsOffset;
            this.closeOffset = beforeCloseSpace + AllIcons.Ide.Notification.Close.getIconWidth() + rightActionsOffset.width;
            this.gearCloseSpace = afterGearSpace + beforeCloseSpace;
            this.allActionsOffset = this.closeOffset + afterGearSpace + AllIcons.Ide.Notification.Gear.getIconWidth();
            this.beforeGearSpace = beforeGearSpace;
        }
    }

    static {
        int styleWidth;
        int width;
        MaxFullContentWidth = JBUI.scale((int)350);
        MaxFullContentWidthStyle = "width:" + MaxFullContentWidth + "px;";
        MinWidth = JBUI.scale((int)100);
        if (SystemInfo.isMac) {
            width = 360;
            styleWidth = 240;
        } else if (SystemInfo.isLinux) {
            width = 410;
            styleWidth = 270;
        } else {
            width = 330;
            styleWidth = 205;
        }
        width += AllIcons.Ide.Notification.Shadow.Left.getIconWidth();
        FixedWidth = JBUI.scale((int)(width += AllIcons.Ide.Notification.Shadow.Right.getIconWidth()));
        MaxWidth = JBUI.scale((int)(width - 60));
        MaxWidthStyle = "width:" + JBUI.scale((int)styleWidth) + "px;";
        NotificationSpace = JBUI.scale((int)10);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/BalloonLayoutConfiguration";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/BalloonLayoutConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "twoLines";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "treeLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

