/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleRefGroup
implements RefGroup {
    @NotNull
    private final String myName;
    @NotNull
    private final List<VcsRef> myRefs;

    public SimpleRefGroup(@NotNull String name, @NotNull List<VcsRef> refs) {
        if (name == null) {
            SimpleRefGroup.$$$reportNull$$$0(0);
        }
        if (refs == null) {
            SimpleRefGroup.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myRefs = refs;
    }

    public boolean isExpanded() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            SimpleRefGroup.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public List<VcsRef> getRefs() {
        List<VcsRef> list2 = this.myRefs;
        if (list2 == null) {
            SimpleRefGroup.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public List<Color> getColors() {
        List<Color> list2 = SimpleRefGroup.getColors(this.myRefs);
        if (list2 == null) {
            SimpleRefGroup.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static List<Color> getColors(@NotNull Collection<VcsRef> refs) {
        MultiMap referencesByType;
        if (refs == null) {
            SimpleRefGroup.$$$reportNull$$$0(5);
        }
        if ((referencesByType = ContainerUtil.groupBy(refs, VcsRef::getType)).size() == 1) {
            Map.Entry firstItem = (Map.Entry)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)referencesByType.entrySet()));
            boolean multiple = ((Collection)firstItem.getValue()).size() > 1;
            Color color = ((VcsRefType)firstItem.getKey()).getBackgroundColor();
            List<Color> list2 = multiple ? Arrays.asList(color, color) : Collections.singletonList(color);
            if (list2 == null) {
                SimpleRefGroup.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList colorsList = ContainerUtil.newArrayList();
        for (VcsRefType type : referencesByType.keySet()) {
            if (referencesByType.get((Object)type).size() > 1) {
                colorsList.add(type.getBackgroundColor());
            }
            colorsList.add(type.getBackgroundColor());
        }
        ArrayList arrayList = colorsList;
        if (arrayList == null) {
            SimpleRefGroup.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public static void buildGroups(@NotNull MultiMap<VcsRefType, VcsRef> groupedRefs, boolean compact, boolean showTagNames, @NotNull List<RefGroup> result2) {
        if (groupedRefs == null) {
            SimpleRefGroup.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            SimpleRefGroup.$$$reportNull$$$0(9);
        }
        if (groupedRefs.isEmpty()) {
            return;
        }
        if (compact) {
            VcsRef firstRef = (VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)groupedRefs.values()));
            RefGroup group = (RefGroup)ContainerUtil.getFirstItem(result2);
            if (group == null) {
                result2.add(new SimpleRefGroup(firstRef.getType().isBranch() || showTagNames ? firstRef.getName() : "", ContainerUtil.newArrayList((Iterable)groupedRefs.values())));
            } else {
                group.getRefs().addAll(groupedRefs.values());
            }
        } else {
            for (Map.Entry entry : groupedRefs.entrySet()) {
                if (((VcsRefType)entry.getKey()).isBranch()) {
                    for (VcsRef ref : (Collection)entry.getValue()) {
                        result2.add(new SimpleRefGroup(ref.getName(), ContainerUtil.newArrayList((Object[])new VcsRef[]{ref})));
                    }
                    continue;
                }
                result2.add(new SimpleRefGroup(showTagNames ? ((VcsRef)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)((Collection)entry.getValue())))).getName() : "", ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue()))));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/SimpleRefGroup";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedRefs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/SimpleRefGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getColors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildGroups";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

