/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitPresentationUtil {
    @NotNull
    private static final Pattern HASH_PATTERN = Pattern.compile("[0-9a-f]{7,40}", 2);
    @NotNull
    static final String GO_TO_HASH = "go-to-hash:";
    @NotNull
    static final String SHOW_HIDE_BRANCHES = "show-hide-branches";

    @NotNull
    private static String escapeMultipleSpaces(@NotNull String text) {
        if (text == null) {
            CommitPresentationUtil.$$$reportNull$$$0(0);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == ' ') {
                if (i == text.length() - 1 || text.charAt(i + 1) != ' ') {
                    result2.append(' ');
                    continue;
                }
                result2.append("&nbsp;");
                continue;
            }
            result2.append(text.charAt(i));
        }
        String string = result2.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static Set<String> findHashes(@NotNull String text) {
        if (text == null) {
            CommitPresentationUtil.$$$reportNull$$$0(2);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        Matcher matcher = HASH_PATTERN.matcher(text);
        while (matcher.find()) {
            result2.add(matcher.group());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            CommitPresentationUtil.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private static String replaceHashes(@NotNull String s, @NotNull Set<String> resolvedHashes) {
        if (s == null) {
            CommitPresentationUtil.$$$reportNull$$$0(4);
        }
        if (resolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(5);
        }
        Matcher matcher = HASH_PATTERN.matcher(s);
        StringBuffer result2 = new StringBuffer();
        while (matcher.find()) {
            String hash = matcher.group();
            if (resolvedHashes.contains(hash)) {
                hash = "<a href=\"go-to-hash:" + hash + "\">" + hash + "</a>";
            }
            matcher.appendReplacement(result2, hash);
        }
        matcher.appendTail(result2);
        String string = result2.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static Set<String> findHashes(@NotNull Project project, @NotNull String subject, @NotNull String description) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(7);
        }
        if (subject == null) {
            CommitPresentationUtil.$$$reportNull$$$0(8);
        }
        if (description == null) {
            CommitPresentationUtil.$$$reportNull$$$0(9);
        }
        HashSet unresolvedHashes = ContainerUtil.newHashSet();
        Convertor convertor = s -> {
            unresolvedHashes.addAll(CommitPresentationUtil.findHashes(s));
            return s;
        };
        IssueLinkHtmlRenderer.formatTextWithLinks(project, subject, (Convertor<String, String>)convertor);
        IssueLinkHtmlRenderer.formatTextWithLinks(project, description, (Convertor<String, String>)convertor);
        HashSet hashSet = unresolvedHashes;
        if (hashSet == null) {
            CommitPresentationUtil.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @NotNull
    private static String formatCommitText(@NotNull Project project, @NotNull String subject, @NotNull String description, @NotNull Set<String> resolvedHashes) {
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(11);
        }
        if (subject == null) {
            CommitPresentationUtil.$$$reportNull$$$0(12);
        }
        if (description == null) {
            CommitPresentationUtil.$$$reportNull$$$0(13);
        }
        if (resolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(14);
        }
        Convertor convertor = s -> {
            if (resolvedHashes == null) {
                CommitPresentationUtil.$$$reportNull$$$0(38);
            }
            return CommitPresentationUtil.replaceHashes(s, resolvedHashes);
        };
        Font font = FontUtil.getCommitMessageFont();
        String string = "<b>" + FontUtil.getHtmlWithFonts(CommitPresentationUtil.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(project, subject, (Convertor<String, String>)convertor)), 1, font) + "</b>" + FontUtil.getHtmlWithFonts(CommitPresentationUtil.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(project, description, (Convertor<String, String>)convertor)), font.getStyle(), font);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getAuthorText(@NotNull VcsFullCommitDetails commit) {
        if (commit == null) {
            CommitPresentationUtil.$$$reportNull$$$0(16);
        }
        long authorTime = commit.getAuthorTime();
        long commitTime = commit.getCommitTime();
        String authorText = CommitPresentationUtil.getAuthorName(commit.getAuthor()) + CommitPresentationUtil.formatDateTime(authorTime);
        if (!VcsUserUtil.isSamePerson(commit.getAuthor(), commit.getCommitter())) {
            String commitTimeText = authorTime != commitTime ? CommitPresentationUtil.formatDateTime(commitTime) : "";
            authorText = authorText + "<br/>" + CommitPresentationUtil.getCommitterText(commit.getCommitter(), commitTimeText);
        } else if (authorTime != commitTime) {
            authorText = authorText + "<br/>" + CommitPresentationUtil.getCommitterText(null, CommitPresentationUtil.formatDateTime(commitTime));
        }
        String string = authorText;
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String getCommitterText(@Nullable VcsUser committer, @NotNull String commitTimeText) {
        if (commitTimeText == null) {
            CommitPresentationUtil.$$$reportNull$$$0(18);
        }
        String graySpan = "<span style='color:#" + ColorUtil.toHex((Color)JBColor.GRAY) + "'>";
        String text = graySpan + "committed";
        if (committer != null) {
            text = text + " by " + VcsUserUtil.getShortPresentation(committer);
            if (!committer.getEmail().isEmpty()) {
                text = text + "</span>" + CommitPresentationUtil.getEmailText(committer) + graySpan;
            }
        }
        String string = text = text + commitTimeText + "</span>";
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    private static String getAuthorName(@NotNull VcsUser user) {
        if (user == null) {
            CommitPresentationUtil.$$$reportNull$$$0(20);
        }
        String username = VcsUserUtil.getShortPresentation(user);
        String string = user.getEmail().isEmpty() ? username : username + CommitPresentationUtil.getEmailText(user);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String getEmailText(@NotNull VcsUser user) {
        if (user == null) {
            CommitPresentationUtil.$$$reportNull$$$0(22);
        }
        String string = " <a href='mailto:" + user.getEmail() + "'>&lt;" + user.getEmail() + "&gt;</a>";
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String formatDateTime(long time) {
        String string = " on " + DateFormatUtil.formatDate((long)time) + " at " + DateFormatUtil.formatTime((long)time);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static String formatCommitHashAndAuthor(@NotNull VcsFullCommitDetails commit) {
        if (commit == null) {
            CommitPresentationUtil.$$$reportNull$$$0(25);
        }
        Font font = FontUtil.getCommitMetadataFont();
        String string = FontUtil.getHtmlWithFonts(((Hash)commit.getId()).toShortString() + " " + CommitPresentationUtil.getAuthorText(commit), font.getStyle(), font);
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    static String getBranchesText(@Nullable List<String> branches, boolean expanded, int availableWidth, @NotNull FontMetrics metrics) {
        int tailWidth;
        if (metrics == null) {
            CommitPresentationUtil.$$$reportNull$$$0(27);
        }
        if (branches == null) {
            if ("In branches: loading..." == null) {
                CommitPresentationUtil.$$$reportNull$$$0(28);
            }
            return "In branches: loading...";
        }
        if (branches.isEmpty()) {
            if ("Not in any branch" == null) {
                CommitPresentationUtil.$$$reportNull$$$0(29);
            }
            return "Not in any branch";
        }
        String head = "In " + branches.size() + StringUtil.pluralize((String)" branch", (int)branches.size()) + ": ";
        if (expanded) {
            String string = head + "<a href=\"" + SHOW_HIDE_BRANCHES + "\">Hide</a><br/>" + StringUtil.join(branches, (String)"<br/>");
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(30);
            }
            return string;
        }
        String tail = "\u2026 <a href=\"show-hide-branches\">Show all</a>";
        int headWidth = metrics.stringWidth(head);
        if (availableWidth <= headWidth + (tailWidth = metrics.stringWidth(StringUtil.removeHtmlTags((String)tail)))) {
            String string = head + tail;
            if (string == null) {
                CommitPresentationUtil.$$$reportNull$$$0(31);
            }
            return string;
        }
        availableWidth -= headWidth;
        StringBuilder branchesText = new StringBuilder();
        for (int i = 0; i < branches.size(); ++i) {
            String branch = branches.get(i) + (i != branches.size() - 1 ? ", " : "");
            int branchWidth = metrics.stringWidth(branch);
            if (branchWidth + tailWidth < availableWidth) {
                branchesText.append(branch);
                availableWidth -= branchWidth;
                continue;
            }
            StringBuilder shortenedBranch = new StringBuilder();
            for (char c : branch.toCharArray()) {
                if (metrics.stringWidth(shortenedBranch.toString() + c) + tailWidth >= availableWidth) break;
                shortenedBranch.append(c);
            }
            branchesText.append((CharSequence)shortenedBranch);
            branchesText.append(tail);
            break;
        }
        String string = head + branchesText.toString();
        if (string == null) {
            CommitPresentationUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public static CommitPresentation buildPresentation(@NotNull Project project, @NotNull VcsFullCommitDetails commit, @NotNull Set<String> unresolvedHashes) {
        String fullMessage;
        int separator;
        if (project == null) {
            CommitPresentationUtil.$$$reportNull$$$0(33);
        }
        if (commit == null) {
            CommitPresentationUtil.$$$reportNull$$$0(34);
        }
        if (unresolvedHashes == null) {
            CommitPresentationUtil.$$$reportNull$$$0(35);
        }
        String subject = (separator = (fullMessage = commit.getFullMessage()).indexOf("\n\n")) > 0 ? fullMessage.substring(0, separator) : fullMessage;
        String description = fullMessage.substring(subject.length());
        String text = CommitPresentationUtil.formatCommitText(project, subject, description, Collections.emptySet());
        String hashAndAuthor = CommitPresentationUtil.formatCommitHashAndAuthor(commit);
        Set<String> unresolvedHashesForCommit = CommitPresentationUtil.findHashes(project, subject, description);
        if (unresolvedHashesForCommit.isEmpty()) {
            CommitPresentation commitPresentation = new CommitPresentation(text, hashAndAuthor, commit.getRoot(), (MultiMap<String, CommitId>)MultiMap.empty());
            if (commitPresentation == null) {
                CommitPresentationUtil.$$$reportNull$$$0(36);
            }
            return commitPresentation;
        }
        unresolvedHashes.addAll(unresolvedHashesForCommit);
        UnresolvedPresentation unresolvedPresentation = new UnresolvedPresentation(project, commit.getRoot(), subject, description, hashAndAuthor, text);
        if (unresolvedPresentation == null) {
            CommitPresentationUtil.$$$reportNull$$$0(37);
        }
        return unresolvedPresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: 
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedHashes";
                break;
            }
            case 7: 
            case 11: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 16: 
            case 25: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitTimeText";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unresolvedHashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeMultipleSpaces";
                break;
            }
            case 3: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findHashes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceHashes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommitText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitterText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmailText";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDateTime";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommitHashAndAuthor";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesText";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "escapeMultipleSpaces";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findHashes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceHashes";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "formatCommitText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCommitterText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAuthorName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getEmailText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "formatCommitHashAndAuthor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getBranchesText";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildPresentation";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$formatCommitText$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommitPresentation {
        @NotNull
        protected final String myText;
        @NotNull
        protected final String myHashAndAuthor;
        @NotNull
        protected final VirtualFile myRoot;
        @NotNull
        private final MultiMap<String, CommitId> myResolvedHashes;

        public CommitPresentation(@NotNull String text, @NotNull String hashAndAuthor, @NotNull VirtualFile root, @NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (text == null) {
                CommitPresentation.$$$reportNull$$$0(0);
            }
            if (hashAndAuthor == null) {
                CommitPresentation.$$$reportNull$$$0(1);
            }
            if (root == null) {
                CommitPresentation.$$$reportNull$$$0(2);
            }
            if (resolvedHashes == null) {
                CommitPresentation.$$$reportNull$$$0(3);
            }
            this.myText = text;
            this.myHashAndAuthor = hashAndAuthor;
            this.myRoot = root;
            this.myResolvedHashes = resolvedHashes;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                CommitPresentation.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getHashAndAuthor() {
            String string = this.myHashAndAuthor;
            if (string == null) {
                CommitPresentation.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public CommitId parseTargetCommit(@NotNull HyperlinkEvent e) {
            if (e == null) {
                CommitPresentation.$$$reportNull$$$0(6);
            }
            if (!e.getDescription().startsWith(CommitPresentationUtil.GO_TO_HASH)) {
                return null;
            }
            String hash = e.getDescription().substring(CommitPresentationUtil.GO_TO_HASH.length());
            Collection ids = this.myResolvedHashes.get((Object)hash);
            if (ids.size() <= 1) {
                return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
            }
            for (CommitId id : ids) {
                if (!this.myRoot.equals(id.getRoot())) continue;
                return id;
            }
            return (CommitId)ContainerUtil.getFirstItem((Collection)ids);
        }

        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (resolvedHashes == null) {
                CommitPresentation.$$$reportNull$$$0(7);
            }
            CommitPresentation commitPresentation = this;
            if (commitPresentation == null) {
                CommitPresentation.$$$reportNull$$$0(8);
            }
            return commitPresentation;
        }

        public boolean isResolved() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashAndAuthor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedHashes";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$CommitPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHashAndAuthor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "parseTargetCommit";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnresolvedPresentation
    extends CommitPresentation {
        private final Project myProject;
        private final String mySubject;
        private final String myDescription;

        public UnresolvedPresentation(@NotNull Project project, @NotNull VirtualFile root, @NotNull String subject, @NotNull String description, @NotNull String hashAndAuthor, @NotNull String text) {
            if (project == null) {
                UnresolvedPresentation.$$$reportNull$$$0(0);
            }
            if (root == null) {
                UnresolvedPresentation.$$$reportNull$$$0(1);
            }
            if (subject == null) {
                UnresolvedPresentation.$$$reportNull$$$0(2);
            }
            if (description == null) {
                UnresolvedPresentation.$$$reportNull$$$0(3);
            }
            if (hashAndAuthor == null) {
                UnresolvedPresentation.$$$reportNull$$$0(4);
            }
            if (text == null) {
                UnresolvedPresentation.$$$reportNull$$$0(5);
            }
            super(text, hashAndAuthor, root, (MultiMap<String, CommitId>)MultiMap.empty());
            this.myProject = project;
            this.mySubject = subject;
            this.myDescription = description;
        }

        @Override
        @NotNull
        public CommitPresentation resolve(@NotNull MultiMap<String, CommitId> resolvedHashes) {
            if (resolvedHashes == null) {
                UnresolvedPresentation.$$$reportNull$$$0(6);
            }
            String text = CommitPresentationUtil.formatCommitText(this.myProject, this.mySubject, this.myDescription, resolvedHashes.keySet());
            CommitPresentation commitPresentation = new CommitPresentation(text, this.myHashAndAuthor, this.myRoot, resolvedHashes);
            if (commitPresentation == null) {
                UnresolvedPresentation.$$$reportNull$$$0(7);
            }
            return commitPresentation;
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subject";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashAndAuthor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedHashes";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$UnresolvedPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/frame/CommitPresentationUtil$UnresolvedPresentation";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

