/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.graph.DefaultColorGenerator;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.paint.SimpleGraphCellPainter;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.table.GraphTableController;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.IndexSpeedSearch;
import com.intellij.vcs.log.ui.table.RootCellRenderer;
import com.intellij.vcs.log.ui.table.Selection;
import com.intellij.vcs.log.ui.table.TableWithProgress;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogGraphTable
extends TableWithProgress
implements DataProvider,
CopyProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogGraphTable.class);
    public static final int ROOT_INDICATOR_WHITE_WIDTH = 5;
    private static final int ROOT_INDICATOR_WIDTH = 13;
    private static final int ROOT_NAME_MAX_WIDTH = 200;
    private static final int MAX_DEFAULT_AUTHOR_COLUMN_WIDTH = 300;
    private static final int MAX_ROWS_TO_CALC_WIDTH = 1000;
    public static final String LOADING_COMMITS_TEXT = "Loading commits...";
    public static final String CHANGES_LOG_TEXT = "Changes log";
    @NotNull
    private final AbstractVcsLogUi myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MyDummyTableCellEditor myDummyEditor;
    @NotNull
    private final TableCellRenderer myDummyRenderer;
    @NotNull
    private final GraphCommitCellRenderer myGraphCommitCellRenderer;
    @NotNull
    private final GraphTableController myController;
    @NotNull
    private final StringCellRenderer myStringCellRenderer;
    private boolean myAuthorColumnInitialized;
    @Nullable
    private Selection mySelection;
    @NotNull
    private final Collection<VcsLogHighlighter> myHighlighters;

    public VcsLogGraphTable(@NotNull AbstractVcsLogUi ui, @NotNull VcsLogData logData, @NotNull VisiblePack initialDataPack) {
        if (ui == null) {
            VcsLogGraphTable.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogGraphTable.$$$reportNull$$$0(1);
        }
        if (initialDataPack == null) {
            VcsLogGraphTable.$$$reportNull$$$0(2);
        }
        super(new GraphTableModel(initialDataPack, logData, ui));
        this.myDummyEditor = new MyDummyTableCellEditor();
        this.myDummyRenderer = new MyDefaultTableCellRenderer();
        this.myAuthorColumnInitialized = false;
        this.mySelection = null;
        this.myHighlighters = ContainerUtil.newArrayList();
        this.myUi = ui;
        this.myLogData = logData;
        SimpleGraphCellPainter graphCellPainter = new SimpleGraphCellPainter(new DefaultColorGenerator()){

            @Override
            protected int getRowHeight() {
                return VcsLogGraphTable.this.getRowHeight();
            }
        };
        this.myGraphCommitCellRenderer = new GraphCommitCellRenderer(logData, graphCellPainter, this, true, false);
        this.myStringCellRenderer = new StringCellRenderer();
        this.getEmptyText().setText(CHANGES_LOG_TEXT);
        this.myLogData.getProgress().addProgressIndicatorListener(new MyProgressListener(), ui);
        this.initColumns();
        this.setDefaultRenderer(VirtualFile.class, new RootCellRenderer(this.myUi));
        this.setDefaultRenderer(GraphCommitCell.class, this.myGraphCommitCellRenderer);
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)this.myStringCellRenderer));
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.setTableHeader((JTableHeader)((Object)new InvisibleResizableHeader()));
        this.myController = new GraphTableController(this, ui, logData, graphCellPainter, this.myGraphCommitCellRenderer);
        this.getSelectionModel().addListSelectionListener(e -> {
            this.mySelection = null;
        });
        this.getColumnModel().setColumnSelectionAllowed(false);
        ScrollingUtil.installActions((JTable)((Object)this), (boolean)false);
        new IndexSpeedSearch(this.myLogData.getProject(), this.myLogData.getIndex(), this){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return VcsLogGraphTable.this.isSpeedSearchEnabled() && super.isSpeedSearchEnabled();
            }
        };
    }

    protected void initColumns() {
        this.setColumnModel(new MyTableColumnModel(this.myUi.getProperties()));
        this.createDefaultColumnsFromModel();
        this.setAutoCreateColumnsFromModel(false);
        this.onColumnOrderSettingChanged();
        this.setRootColumnSize();
        for (int column = 0; column < this.getColumnCount(); ++column) {
            this.getColumnByModelIndex(column).setResizable(column != 0);
        }
    }

    protected boolean isSpeedSearchEnabled() {
        return Registry.is((String)"vcs.log.speedsearch");
    }

    protected void updateEmptyText() {
        StatusText statusText = this.getEmptyText();
        VisiblePack visiblePack = this.getModel().getVisiblePack();
        if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0) {
            if (visiblePack.getFilters().isEmpty()) {
                statusText.setText("No changes committed.").appendSecondaryText("Commit local changes", VcsLogUiUtil.getLinkAttributes(), ActionUtil.createActionListener((String)"CheckinProject", (Component)((Object)this), (String)"unknown"));
                String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"CheckinProject");
                if (!shortcutText.isEmpty()) {
                    statusText.appendSecondaryText(" (" + shortcutText + ")", StatusText.DEFAULT_ATTRIBUTES, null);
                }
            } else {
                statusText.setText("No commits matching filters.").appendSecondaryText("Reset filters", VcsLogUiUtil.getLinkAttributes(), e -> this.myUi.getFilterUi().setFilter(null));
            }
        } else {
            statusText.setText(CHANGES_LOG_TEXT);
        }
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permGraphChanged) {
        if (visiblePack == null) {
            VcsLogGraphTable.$$$reportNull$$$0(3);
        }
        Selection previousSelection = this.getSelection();
        boolean filtersChanged = !this.getModel().getVisiblePack().getFilters().equals(visiblePack.getFilters());
        this.getModel().setVisiblePack(visiblePack);
        previousSelection.restore(visiblePack.getVisibleGraph(), true, permGraphChanged);
        for (VcsLogHighlighter highlighter : this.myHighlighters) {
            highlighter.update((VcsLogDataPack)visiblePack, permGraphChanged);
        }
        if (!this.getEmptyText().getText().equals(LOADING_COMMITS_TEXT)) {
            this.updateEmptyText();
        }
        this.setPaintBusy(false);
        this.myAuthorColumnInitialized = this.myAuthorColumnInitialized && !filtersChanged;
        this.reLayout();
    }

    public void onColumnOrderSettingChanged() {
        if (this.myUi.getProperties().exists(CommonUiProperties.COLUMN_ORDER)) {
            List<Integer> columnOrder = this.myUi.getProperties().get(CommonUiProperties.COLUMN_ORDER);
            int columnCount = this.getColumnModel().getColumnCount();
            boolean dataCorrect = true;
            if (columnOrder.size() != columnCount) {
                dataCorrect = false;
            } else {
                for (int i = 0; i < columnCount; ++i) {
                    Integer expectedColumnIndex = columnOrder.get(i);
                    if (expectedColumnIndex < 0 || expectedColumnIndex >= columnCount) {
                        dataCorrect = false;
                        break;
                    }
                    if (expectedColumnIndex.intValue() == this.getColumnModel().getColumn(i).getModelIndex()) continue;
                    int foundColumnIndex = -1;
                    for (int j = i + 1; j < columnCount; ++j) {
                        if (this.getColumnModel().getColumn(j).getModelIndex() != expectedColumnIndex.intValue()) continue;
                        foundColumnIndex = j;
                        break;
                    }
                    if (foundColumnIndex < 0) {
                        dataCorrect = false;
                        break;
                    }
                    ((MyTableColumnModel)this.getColumnModel()).moveWithoutChecks(foundColumnIndex, i);
                }
            }
            if (!dataCorrect) {
                if (!columnOrder.isEmpty()) {
                    LOG.debug("Incorrect column order was saved in properties " + columnOrder + ", replacing it with current order.");
                }
                this.saveColumnOrderToSettings();
            }
        }
    }

    private void saveColumnOrderToSettings() {
        if (this.myUi.getProperties().exists(CommonUiProperties.COLUMN_ORDER)) {
            ArrayList columnOrder = ContainerUtil.newArrayList();
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                columnOrder.add(this.getColumnModel().getColumn(i).getModelIndex());
            }
            this.myUi.getProperties().set(CommonUiProperties.COLUMN_ORDER, columnOrder);
        }
    }

    public void reLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateAuthorAndDataWidth();
            super.doLayout();
            this.repaint();
        }
    }

    public void forceReLayout(int column) {
        if (column == 2) {
            this.myAuthorColumnInitialized = false;
        }
        this.reLayout();
    }

    public void doLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateAuthorAndDataWidth();
        }
        super.doLayout();
    }

    public void resetColumnWidth(int column) {
        if (CommonUiProperties.getColumnWidth(this.myUi.getProperties(), column) != -1) {
            CommonUiProperties.saveColumnWidth(this.myUi.getProperties(), column, -1);
        } else {
            this.forceReLayout(column);
        }
    }

    private void updateAuthorAndDataWidth() {
        for (int i : new int[]{2, 3}) {
            int width = CommonUiProperties.getColumnWidth(this.myUi.getProperties(), i);
            if (width <= 0 || width > this.getWidth()) {
                width = i != 2 || !this.myAuthorColumnInitialized ? this.getColumnWidthFromData(i) : -1;
            }
            if (width <= 0 || width == this.getColumnByModelIndex(i).getPreferredWidth()) continue;
            this.getColumnByModelIndex(i).setPreferredWidth(width);
        }
        this.updateCommitColumnWidth();
    }

    private int getColumnWidthFromData(int i) {
        Font tableFont = VcsLogGraphTable.getTableFont();
        if (i == 2) {
            int width = this.getColumnByModelIndex(i).getPreferredWidth();
            if (this.getModel().getRowCount() > 0) {
                int maxRowsToCheck = Math.min(1000, this.getRowCount());
                int maxAuthorWidth = 0;
                int unloaded = 0;
                for (int row = 0; row < maxRowsToCheck; ++row) {
                    String value = this.getModel().getValueAt(row, 2).toString();
                    if (value.isEmpty()) {
                        ++unloaded;
                        continue;
                    }
                    Font font = tableFont;
                    VcsLogHighlighter.TextStyle style = this.getStyle(row, this.convertColumnIndexToView(2), false, false).getTextStyle();
                    if (VcsLogHighlighter.TextStyle.BOLD.equals((Object)style)) {
                        font = tableFont.deriveFont(1);
                    } else if (VcsLogHighlighter.TextStyle.ITALIC.equals((Object)style)) {
                        font = tableFont.deriveFont(2);
                    }
                    maxAuthorWidth = Math.max(this.getFontMetrics(font).stringWidth(value + "*"), maxAuthorWidth);
                }
                width = Math.min(maxAuthorWidth + this.myStringCellRenderer.getHorizontalTextPadding(), JBUI.scale((int)300));
                if (unloaded * 2 <= maxRowsToCheck) {
                    this.myAuthorColumnInitialized = true;
                }
            }
            return width;
        }
        if (i == 3) {
            return this.getFontMetrics(VcsLogGraphTable.getTableFont().deriveFont(1)).stringWidth(DateFormatUtil.formatDateTime((Date)new Date())) + this.myStringCellRenderer.getHorizontalTextPadding();
        }
        throw new IllegalArgumentException("Can only calculate author or date columns width from data, yet given column " + i);
    }

    @NotNull
    public TableColumn getColumnByModelIndex(int index) {
        TableColumn tableColumn = this.getColumnModel().getColumn(this.convertColumnIndexToView(index));
        if (tableColumn == null) {
            VcsLogGraphTable.$$$reportNull$$$0(4);
        }
        return tableColumn;
    }

    private static Font getTableFont() {
        return UIManager.getFont("Table.font");
    }

    private void updateCommitColumnWidth() {
        int size = this.getWidth();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i == 1) continue;
            TableColumn column = this.getColumnByModelIndex(i);
            size -= column.getPreferredWidth();
        }
        TableColumn commitColumn = this.getColumnByModelIndex(1);
        commitColumn.setPreferredWidth(size);
    }

    private void setRootColumnSize() {
        int rootWidth;
        TableColumn column = this.getColumnByModelIndex(0);
        if (!this.myUi.isMultipleRoots()) {
            rootWidth = 0;
        } else if (!this.myUi.isShowRootNames()) {
            rootWidth = JBUI.scale((int)13);
        } else {
            int width = 0;
            for (VirtualFile file2 : this.myLogData.getRoots()) {
                Font tableFont = VcsLogGraphTable.getTableFont();
                width = Math.max(this.getFontMetrics(tableFont).stringWidth(file2.getName() + "  "), width);
            }
            rootWidth = Math.min(width, JBUI.scale((int)200));
        }
        column.setMinWidth(rootWidth);
        column.setMaxWidth(rootWidth);
        column.setPreferredWidth(rootWidth);
    }

    public void rootColumnUpdated() {
        this.setRootColumnSize();
        this.reLayout();
        this.repaint();
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        Object at;
        if (event == null) {
            VcsLogGraphTable.$$$reportNull$$$0(5);
        }
        int row = this.rowAtPoint(event.getPoint());
        int column = this.convertColumnIndexToModel(this.columnAtPoint(event.getPoint()));
        if (column < 0 || row < 0) {
            return null;
        }
        if (column == 0 && (at = this.getValueAt(row, column)) instanceof VirtualFile) {
            return "<html><b>" + ((VirtualFile)at).getPresentableUrl() + "</b><br/>Click to " + (this.myUi.isShowRootNames() ? "collapse" : "expand") + "</html>";
        }
        return null;
    }

    public void jumpToRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= this.getRowCount() - 1) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
            this.setRowSelectionInterval(rowIndex, rowIndex);
            if (!this.hasFocus()) {
                IdeFocusManager.getInstance((Project)this.myLogData.getProject()).requestFocus((Component)((Object)this), true);
            }
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length == 0 || selectedRows.length > 1000) {
                return null;
            }
            Set roots = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row -> this.getModel().getRoot((int)row));
            if (roots.size() == 1) {
                return this.myLogData.getLogProvider((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)roots))).getSupportedVcs();
            }
        } else {
            if (VcsLogDataKeys.VCS_LOG_BRANCHES.is(dataId)) {
                int[] selectedRows = this.getSelectedRows();
                if (selectedRows.length != 1) {
                    return null;
                }
                return this.getModel().getBranchesAtRow(selectedRows[0]);
            }
            if (VcsDataKeys.PRESET_COMMIT_MESSAGE.is(dataId)) {
                int[] selectedRows = this.getSelectedRows();
                if (selectedRows.length == 0) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Math.min(1000, selectedRows.length); ++i) {
                    sb.append(this.getModel().getValueAt(selectedRows[i], 1).toString());
                    if (i == selectedRows.length - 1) continue;
                    sb.append("\n");
                }
                return sb.toString();
            }
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(6);
        }
        StringBuilder sb = new StringBuilder();
        int[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < Math.min(1000, selectedRows.length); ++i) {
            int row = selectedRows[i];
            for (int j = 1; j < this.getModel().getColumnCount(); ++j) {
                sb.append(this.getModel().getValueAt(row, j).toString());
                if (j >= this.getModel().getColumnCount() - 1) continue;
                sb.append(" ");
            }
            if (i == selectedRows.length - 1) continue;
            sb.append("\n");
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(7);
        }
        return this.getSelectedRowCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(8);
        }
        return true;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            VcsLogGraphTable.$$$reportNull$$$0(9);
        }
        this.myHighlighters.add(highlighter);
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            VcsLogGraphTable.$$$reportNull$$$0(10);
        }
        this.myHighlighters.remove(highlighter);
    }

    public void removeAllHighlighters() {
        this.myHighlighters.clear();
    }

    @NotNull
    public SimpleTextAttributes applyHighlighters(@NotNull Component rendererComponent, int row, int column, boolean hasFocus, boolean selected) {
        if (rendererComponent == null) {
            VcsLogGraphTable.$$$reportNull$$$0(11);
        }
        VcsLogHighlighter.VcsCommitStyle style = this.getStyle(row, column, hasFocus, selected);
        assert (style.getBackground() != null && style.getForeground() != null && style.getTextStyle() != null);
        rendererComponent.setBackground(style.getBackground());
        rendererComponent.setForeground(style.getForeground());
        switch (style.getTextStyle()) {
            case BOLD: {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                if (simpleTextAttributes == null) {
                    VcsLogGraphTable.$$$reportNull$$$0(12);
                }
                return simpleTextAttributes;
            }
            case ITALIC: {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                if (simpleTextAttributes == null) {
                    VcsLogGraphTable.$$$reportNull$$$0(13);
                }
                return simpleTextAttributes;
            }
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            VcsLogGraphTable.$$$reportNull$$$0(14);
        }
        return simpleTextAttributes;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getBaseStyle(int row, int column, boolean hasFocus, boolean selected) {
        Component dummyRendererComponent = this.myDummyRenderer.getTableCellRendererComponent((JTable)((Object)this), "", selected, hasFocus, row, column);
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle((Color)dummyRendererComponent.getForeground(), (Color)dummyRendererComponent.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        if (vcsCommitStyle == null) {
            VcsLogGraphTable.$$$reportNull$$$0(15);
        }
        return vcsCommitStyle;
    }

    @NotNull
    VcsLogHighlighter.VcsCommitStyle getStyle(int row, int column, boolean hasFocus, boolean selected) {
        VcsLogHighlighter.VcsCommitStyle baseStyle = this.getBaseStyle(row, column, hasFocus, selected);
        VisibleGraph<Integer> visibleGraph = this.getVisibleGraph();
        if (row < 0 || row >= visibleGraph.getVisibleCommitCount()) {
            LOG.error("Visible graph has " + visibleGraph.getVisibleCommitCount() + " commits, yet we want row " + row);
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = baseStyle;
            if (vcsCommitStyle == null) {
                VcsLogGraphTable.$$$reportNull$$$0(16);
            }
            return vcsCommitStyle;
        }
        RowInfo rowInfo = visibleGraph.getRowInfo(row);
        VcsLogHighlighter.VcsCommitStyle defaultStyle = VcsCommitStyleFactory.createStyle((Color)(rowInfo.getRowType() == RowType.UNMATCHED ? JBColor.GRAY : baseStyle.getForeground()), (Color)baseStyle.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        VcsShortCommitDetails details = this.myLogData.getMiniDetailsGetter().getCommitDataIfAvailable((Integer)rowInfo.getCommit());
        if (details == null) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = defaultStyle;
            if (vcsCommitStyle == null) {
                VcsLogGraphTable.$$$reportNull$$$0(17);
            }
            return vcsCommitStyle;
        }
        List styles = ContainerUtil.map(this.myHighlighters, highlighter -> highlighter.getStyle(details, selected));
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.combine((Collection)ContainerUtil.append((List)styles, (Object[])new VcsLogHighlighter.VcsCommitStyle[]{defaultStyle}));
        if (vcsCommitStyle == null) {
            VcsLogGraphTable.$$$reportNull$$$0(18);
        }
        return vcsCommitStyle;
    }

    public void viewportSet(JViewport viewport) {
        viewport.addChangeListener(e -> {
            GraphTableModel model = this.getModel();
            Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this));
            model.fireTableChanged(new TableModelEvent(model, (Integer)visibleRows.first - 1, (Integer)visibleRows.second, 0));
        });
    }

    public static JBColor getRootBackgroundColor(@NotNull VirtualFile root, @NotNull VcsLogColorManager colorManager) {
        if (root == null) {
            VcsLogGraphTable.$$$reportNull$$$0(19);
        }
        if (colorManager == null) {
            VcsLogGraphTable.$$$reportNull$$$0(20);
        }
        return VcsLogColorManagerImpl.getBackgroundColor(colorManager.getRootColor(root));
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Component layeredPane = UIUtil.findParentByCondition((Component)((Object)this), component -> component instanceof LoadingDecorator.CursorAware);
        if (layeredPane != null) {
            layeredPane.setCursor(cursor);
        }
    }

    @NotNull
    public GraphTableModel getModel() {
        GraphTableModel graphTableModel = (GraphTableModel)super.getModel();
        if (graphTableModel == null) {
            VcsLogGraphTable.$$$reportNull$$$0(21);
        }
        return graphTableModel;
    }

    @NotNull
    public Selection getSelection() {
        if (this.mySelection == null) {
            this.mySelection = new Selection(this);
        }
        Selection selection = this.mySelection;
        if (selection == null) {
            VcsLogGraphTable.$$$reportNull$$$0(22);
        }
        return selection;
    }

    public void handleAnswer(@Nullable GraphAnswer<Integer> answer) {
        this.myController.handleGraphAnswer(answer, true, null, null);
    }

    public void showTooltip(int row) {
        this.myController.showTooltip(row);
    }

    public void setCompactReferencesView(boolean compact) {
        this.myGraphCommitCellRenderer.setCompactReferencesView(compact);
        this.repaint();
    }

    public void setShowTagNames(boolean showTagsNames) {
        this.myGraphCommitCellRenderer.setShowTagsNames(showTagsNames);
        this.repaint();
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.getModel().getVisiblePack().getVisibleGraph();
        if (visibleGraph == null) {
            VcsLogGraphTable.$$$reportNull$$$0(23);
        }
        return visibleGraph;
    }

    public TableCellEditor getCellEditor() {
        return this.myDummyEditor;
    }

    public int getRowHeight() {
        return this.myGraphCommitCellRenderer.getPreferredHeight();
    }

    @Override
    protected void paintFooter(@NotNull Graphics g, int x, int y, int width, int height) {
        int lastRow;
        if (g == null) {
            VcsLogGraphTable.$$$reportNull$$$0(24);
        }
        if ((lastRow = this.getRowCount() - 1) >= 0) {
            g.setColor(this.getStyle(lastRow, this.convertColumnIndexToView(1), this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
            if (this.myUi.isMultipleRoots()) {
                g.setColor((Color)VcsLogGraphTable.getRootBackgroundColor(this.getModel().getRoot(lastRow), this.myUi.getColorManager()));
                int rootWidth = this.getColumnByModelIndex(0).getWidth();
                if (!this.myUi.isShowRootNames()) {
                    rootWidth -= JBUI.scale((int)5);
                }
                g.fillRect(x, y, rootWidth, height);
            }
        } else {
            g.setColor(this.getBaseStyle(lastRow, this.convertColumnIndexToView(1), this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
        }
    }

    public boolean isResizingColumns() {
        return this.getCursor() == Cursor.getPredefinedCursor(11);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialDataPack";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererComponent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnByModelIndex";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "applyHighlighters";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseStyle";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleGraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getToolTipText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyHighlighters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getRootBackgroundColor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "paintFooter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyTableColumnModel
    extends DefaultTableColumnModel {
        @NotNull
        private final VcsLogUiProperties myProperties;

        public MyTableColumnModel(VcsLogUiProperties properties) {
            if (properties == null) {
                MyTableColumnModel.$$$reportNull$$$0(0);
            }
            this.myProperties = properties;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VcsLogGraphTable.this.getTableHeader().getResizingColumn() == null) {
                return;
            }
            if ("width".equals(evt.getPropertyName())) {
                TableColumn authorColumn = VcsLogGraphTable.this.getColumnByModelIndex(2);
                if (authorColumn.equals(evt.getSource())) {
                    CommonUiProperties.saveColumnWidth(this.myProperties, 2, authorColumn.getWidth());
                } else {
                    TableColumn dateColumn = VcsLogGraphTable.this.getColumnByModelIndex(3);
                    if (dateColumn.equals(evt.getSource())) {
                        CommonUiProperties.saveColumnWidth(this.myProperties, 3, dateColumn.getWidth());
                    }
                }
            }
            super.propertyChange(evt);
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            if (VcsLogGraphTable.this.convertColumnIndexToModel(columnIndex) == 0 || VcsLogGraphTable.this.convertColumnIndexToModel(newIndex) == 0) {
                return;
            }
            this.moveWithoutChecks(columnIndex, newIndex);
            VcsLogGraphTable.this.saveColumnOrderToSettings();
        }

        public void moveWithoutChecks(int columnIndex, int newIndex) {
            super.moveColumn(columnIndex, newIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyTableColumnModel", "<init>"));
        }
    }

    private class MyProgressListener
    implements VcsLogProgress.ProgressListener {
        private MyProgressListener() {
        }

        @Override
        public void progressStarted() {
            VcsLogGraphTable.this.getEmptyText().setText(VcsLogGraphTable.LOADING_COMMITS_TEXT);
        }

        @Override
        public void progressStopped() {
            VcsLogGraphTable.this.updateEmptyText();
        }
    }

    private static class MyBasicTableHeaderUI
    extends BasicTableHeaderUI
    implements MouseInputListener {
        private int myStartXCoordinate;
        private int myStartYCoordinate;

        public MyBasicTableHeaderUI(@NotNull JTableHeader tableHeader) {
            if (tableHeader == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(0);
            }
            this.myStartXCoordinate = 0;
            this.myStartYCoordinate = 0;
            this.header = tableHeader;
            this.mouseInputListener = this.createMouseInputListener();
        }

        @NotNull
        private MouseEvent convertMouseEvent(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(1);
            }
            MouseEvent mouseEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), 0, e.getXOnScreen(), this.header.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            if (mouseEvent == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(2);
            }
            return mouseEvent;
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(3);
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(4);
            }
            if (this.isOnBorder(e) || this.isOnRootColumn(e)) {
                return;
            }
            this.myStartXCoordinate = e.getX();
            this.myStartYCoordinate = e.getY();
            this.mouseInputListener.mousePressed(this.convertMouseEvent(e));
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(5);
            }
            this.mouseInputListener.mouseReleased(this.convertMouseEvent(e));
            if (this.header.getCursor() == Cursor.getPredefinedCursor(13)) {
                this.header.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(6);
            }
            this.mouseInputListener.mouseEntered(this.convertMouseEvent(e));
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(7);
            }
            this.mouseInputListener.mouseExited(this.convertMouseEvent(e));
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(8);
            }
            if (!this.isDraggingEnabled(e)) {
                return;
            }
            this.mouseInputListener.mouseDragged(this.convertMouseEvent(e));
            if (this.header.getDraggedColumn() != null) {
                if (this.header.getCursor() == Cursor.getPredefinedCursor(0)) {
                    this.header.setCursor(Cursor.getPredefinedCursor(13));
                }
                int draggedColumn = this.header.getTable().convertColumnIndexToView(this.header.getDraggedColumn().getModelIndex());
                if (this.header.getTable().convertColumnIndexToView(0) == draggedColumn + (this.header.getDraggedDistance() < 0 ? -1 : 1)) {
                    this.mouseReleased(e);
                }
            }
        }

        private boolean isDraggingEnabled(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(9);
            }
            if (this.isOnBorder(e) || this.isOnRootColumn(e) || !SwingUtilities.isLeftMouseButton(e)) {
                return false;
            }
            if (this.header.getCursor() == Cursor.getPredefinedCursor(13) || this.header.getCursor() == Cursor.getPredefinedCursor(11)) {
                return true;
            }
            int deltaX = Math.abs(e.getX() - this.myStartXCoordinate);
            int deltaY = Math.abs(e.getY() - this.myStartYCoordinate);
            Point point = new Point(Math.min(Math.max(e.getX(), 0), this.header.getTable().getWidth() - 1), e.getY());
            boolean sameColumn = this.header.getDraggedColumn() == null ? true : this.header.getTable().getColumnModel().getColumn(this.header.getTable().columnAtPoint(point)) == this.header.getDraggedColumn();
            return deltaX >= 3 * deltaY && sameColumn;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(10);
            }
            if (this.isOnBorder(e)) {
                return;
            }
            this.mouseInputListener.mouseMoved(this.convertMouseEvent(e));
        }

        public boolean isOnBorder(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(11);
            }
            return Math.abs(this.header.getTable().getWidth() - e.getPoint().x) <= JBUI.scale((int)3);
        }

        public boolean isOnRootColumn(@NotNull MouseEvent e) {
            if (e == null) {
                MyBasicTableHeaderUI.$$$reportNull$$$0(12);
            }
            return this.header.getTable().getColumnModel().getColumnIndexAtX(e.getX()) == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableHeader";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertMouseEvent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "convertMouseEvent";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseClicked";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "mousePressed";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseReleased";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseEntered";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseExited";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseDragged";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isDraggingEnabled";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseMoved";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isOnBorder";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "isOnRootColumn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyTableCellRenderer
    implements TableCellRenderer {
        private EmptyTableCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setMaximumSize(new Dimension(0, 0));
            JPanel jPanel = panel2;
            if (jPanel == null) {
                EmptyTableCellRenderer.$$$reportNull$$$0(0);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$EmptyTableCellRenderer", "getTableCellRendererComponent"));
        }
    }

    private class InvisibleResizableHeader
    extends JBTable.JBTableHeader {
        @NotNull
        private final MyBasicTableHeaderUI myHeaderUI;
        @Nullable
        private Cursor myCursor;

        public InvisibleResizableHeader() {
            super((JBTable)VcsLogGraphTable.this);
            this.myCursor = null;
            this.myHeaderUI = new MyBasicTableHeaderUI((JTableHeader)((Object)this));
            this.setDefaultRenderer(new EmptyTableCellRenderer());
            this.setReorderingAllowed(true);
        }

        public void setTable(JTable table) {
            JTable oldTable = this.getTable();
            if (oldTable != null) {
                oldTable.removeMouseListener(this.myHeaderUI);
                oldTable.removeMouseMotionListener(this.myHeaderUI);
            }
            super.setTable(table);
            if (table != null) {
                table.addMouseListener(this.myHeaderUI);
                table.addMouseMotionListener(this.myHeaderUI);
            }
        }

        public void setCursor(@Nullable Cursor cursor) {
            JTable table = this.getTable();
            if (table != null) {
                table.setCursor(cursor);
                this.myCursor = cursor;
            } else {
                super.setCursor(cursor);
            }
        }

        public Cursor getCursor() {
            if (this.myCursor == null) {
                JTable table = this.getTable();
                if (table == null) {
                    return super.getCursor();
                }
                return table.getCursor();
            }
            return this.myCursor;
        }

        @NotNull
        public Rectangle getHeaderRect(int column) {
            Rectangle headerRect = super.getHeaderRect(column);
            Rectangle rectangle = new Rectangle(headerRect.x, headerRect.y, headerRect.width, 1);
            if (rectangle == null) {
                InvisibleResizableHeader.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$InvisibleResizableHeader", "getHeaderRect"));
        }
    }

    private class MyDummyTableCellEditor
    implements TableCellEditor {
        private MyDummyTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (!(anEvent instanceof MouseEvent)) {
                return true;
            }
            return VcsLogGraphTable.this.myController.findPrintElement((MouseEvent)anEvent) == null;
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private class StringCellRenderer
    extends ColoredTableCellRenderer {
        private StringCellRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setBorder(null);
            if (value == null) {
                return;
            }
            this.append(value.toString(), VcsLogGraphTable.this.applyHighlighters((Component)((Object)this), row, column, hasFocus, selected));
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }

        public int getHorizontalTextPadding() {
            Insets borderInsets = this.getMyBorder().getBorderInsets((Component)((Object)this));
            Insets ipad = this.getIpad();
            return borderInsets.left + borderInsets.right + ipad.left + ipad.right;
        }
    }

    private static class MyDefaultTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyDefaultTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setBackground(isSelected ? (table.hasFocus() ? UIUtil.getListSelectionBackground() : UIUtil.getListUnfocusedSelectionBackground()) : UIUtil.getListBackground());
            return component;
        }
    }
}

