/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class PromiseManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater;

    public PromiseManager(@NotNull AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater) {
        if (fieldUpdater == null) {
            PromiseManager.$$$reportNull$$$0(0);
        }
        this.fieldUpdater = fieldUpdater;
    }

    public PromiseManager(@NotNull Class<HOST> ownerClass) {
        if (ownerClass == null) {
            PromiseManager.$$$reportNull$$$0(1);
        }
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, Promise.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value) {
        if (host == null) {
            PromiseManager.$$$reportNull$$$0(2);
        }
        if (value == null) {
            PromiseManager.$$$reportNull$$$0(3);
        }
        return true;
    }

    @NotNull
    public abstract Promise<VALUE> load(@NotNull HOST var1);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value) {
        if (value == null) {
            this.reset(host);
        } else {
            ((AsyncPromise)this.getOrCreateAsyncResult(host, false, false)).setResult(value);
        }
    }

    public final boolean has(HOST host) {
        Promise result2 = (Promise)this.fieldUpdater.get(host);
        return result2 != null && result2.getState() == Promise.State.FULFILLED;
    }

    @Nullable
    public final Promise.State getState(HOST host) {
        Promise result2 = (Promise)this.fieldUpdater.get(host);
        return result2 == null ? null : result2.getState();
    }

    @NotNull
    public final Promise<VALUE> get(HOST host) {
        Promise<VALUE> promise2 = this.get(host, true);
        if (promise2 == null) {
            PromiseManager.$$$reportNull$$$0(4);
        }
        return promise2;
    }

    @NotNull
    public final Promise<VALUE> get(HOST host, boolean checkFreshness) {
        Promise<VALUE> promise2 = this.getOrCreateAsyncResult(host, checkFreshness, true);
        if (promise2 == null) {
            PromiseManager.$$$reportNull$$$0(5);
        }
        return promise2;
    }

    @NotNull
    private Promise<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load2) {
        Promise promise2 = (Promise)this.fieldUpdater.get(host);
        if (promise2 == null) {
            promise2 = new AsyncPromise();
            if (!this.fieldUpdater.compareAndSet(host, null, (Object)promise2)) {
                Promise promise3 = (Promise)this.fieldUpdater.get(host);
                if (promise3 == null) {
                    PromiseManager.$$$reportNull$$$0(6);
                }
                return promise3;
            }
        } else {
            Promise.State state = promise2.getState();
            if (state == Promise.State.PENDING) {
                Promise promise4 = promise2;
                if (promise4 == null) {
                    PromiseManager.$$$reportNull$$$0(7);
                }
                return promise4;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(host, ((Getter)promise2).get())) {
                    Promise promise5 = promise2;
                    if (promise5 == null) {
                        PromiseManager.$$$reportNull$$$0(8);
                    }
                    return promise5;
                }
                if (!this.fieldUpdater.compareAndSet(host, (Object)promise2, (Object)(promise2 = new AsyncPromise()))) {
                    Promise valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, (Object)promise2)) {
                            Promise<VALUE> promise6 = this.getPromise(host, load2, promise2);
                            if (promise6 == null) {
                                PromiseManager.$$$reportNull$$$0(9);
                            }
                            return promise6;
                        }
                        valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    }
                    Promise promise7 = valueFromAnotherThread;
                    if (promise7 == null) {
                        PromiseManager.$$$reportNull$$$0(10);
                    }
                    return promise7;
                }
            }
        }
        Promise<VALUE> promise8 = this.getPromise(host, load2, promise2);
        if (promise8 == null) {
            PromiseManager.$$$reportNull$$$0(11);
        }
        return promise8;
    }

    @NotNull
    private Promise<VALUE> getPromise(HOST host, boolean load2, Promise<VALUE> promise2) {
        if (!load2 || promise2.getState() != Promise.State.PENDING) {
            Promise<VALUE> promise3 = promise2;
            if (promise3 == null) {
                PromiseManager.$$$reportNull$$$0(12);
            }
            return promise3;
        }
        Promise<VALUE> effectivePromise = this.load(host);
        if (effectivePromise != promise2) {
            this.fieldUpdater.compareAndSet(host, promise2, effectivePromise);
            effectivePromise.notify((AsyncPromise)promise2);
        }
        Promise<VALUE> promise4 = effectivePromise;
        if (promise4 == null) {
            PromiseManager.$$$reportNull$$$0(13);
        }
        return promise4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldUpdater";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/concurrency/PromiseManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/concurrency/PromiseManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateAsyncResult";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

