/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunch;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SelectLocationDialog;

public class BranchConfigurationDialog
extends DialogWrapper {
    private JPanel myTopPanel;
    private TextFieldWithBrowseButton myTrunkLocationTextField;
    private final JBList<String> myBranchLocationsList;
    @NotNull
    private final MyListModel myBranchLocationsModel;
    private JPanel myListPanel;
    private JLabel myErrorPrompt;
    @NotNull
    private final NewRootBunch mySvnBranchConfigManager;
    @NotNull
    private final VirtualFile myRoot;

    public BranchConfigurationDialog(@NotNull Project project, @NotNull SvnBranchConfigurationNew configuration, @NotNull Url rootUrl, @NotNull VirtualFile root, @NotNull Url url) {
        if (project == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(1);
        }
        if (rootUrl == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(2);
        }
        if (root == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(3);
        }
        if (url == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(4);
        }
        super(project, true);
        this.myRoot = root;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(SvnBundle.message("configure.branches.title", new Object[0]));
        if (StringUtil.isEmptyOrSpaces((String)configuration.getTrunkUrl())) {
            configuration.setTrunkUrl(url.toString());
        }
        this.mySvnBranchConfigManager = SvnBranchConfigurationManager.getInstance(project).getSvnBranchConfigManager();
        this.myTrunkLocationTextField.setText(configuration.getTrunkUrl());
        this.myTrunkLocationTextField.addActionListener(e -> {
            Pair<Url, Url> selectionData;
            if (project == null) {
                BranchConfigurationDialog.$$$reportNull$$$0(9);
            }
            if (rootUrl == null) {
                BranchConfigurationDialog.$$$reportNull$$$0(10);
            }
            if ((selectionData = SelectLocationDialog.selectLocationAndRoot(project, rootUrl)) != null && selectionData.first != null) {
                this.myTrunkLocationTextField.setText(((Url)selectionData.first).toString());
            }
        });
        TrunkUrlValidator trunkUrlValidator = new TrunkUrlValidator(rootUrl, configuration);
        this.myTrunkLocationTextField.getTextField().getDocument().addDocumentListener((DocumentListener)((Object)trunkUrlValidator));
        trunkUrlValidator.textChanged(null);
        this.myErrorPrompt.setUI((LabelUI)new MultiLineLabelUI());
        this.myErrorPrompt.setForeground(SimpleTextAttributes.ERROR_ATTRIBUTES.getFgColor());
        this.myBranchLocationsModel = new MyListModel(configuration);
        this.myBranchLocationsList = new JBList((ListModel)this.myBranchLocationsModel);
        this.myListPanel.add((Component)this.wrapLocationsWithToolbar(project, rootUrl), "Center");
    }

    @NotNull
    private JPanel wrapLocationsWithToolbar(final @NotNull Project project, final @NotNull Url rootUrl) {
        if (project == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(5);
        }
        if (rootUrl == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(6);
        }
        JPanel jPanel = ToolbarDecorator.createDecorator(this.myBranchLocationsList).setAddAction(new AnActionButtonRunnable(){
            @Nullable
            private Url usedRootUrl;

            public void run(AnActionButton button) {
                Pair<Url, Url> result = SelectLocationDialog.selectLocationAndRoot(project, (Url)ObjectUtils.notNull((Object)this.usedRootUrl, (Object)rootUrl));
                if (result != null) {
                    Url selectedUrl = (Url)result.first;
                    this.usedRootUrl = (Url)result.second;
                    if (selectedUrl != null) {
                        String selectedUrlValue = selectedUrl.toString();
                        if (!BranchConfigurationDialog.this.myBranchLocationsModel.getConfiguration().getBranchUrls().contains(selectedUrlValue)) {
                            BranchConfigurationDialog.this.myBranchLocationsModel.getConfiguration().addBranches(selectedUrlValue, new InfoStorage<List<SvnBranchItem>>(new ArrayList(), InfoReliability.empty));
                            BranchConfigurationDialog.this.mySvnBranchConfigManager.reloadBranchesAsync(BranchConfigurationDialog.this.myRoot, selectedUrlValue, InfoReliability.setByUser);
                            BranchConfigurationDialog.this.myBranchLocationsModel.fireItemAdded();
                            BranchConfigurationDialog.this.myBranchLocationsList.setSelectedIndex(BranchConfigurationDialog.this.myBranchLocationsModel.getSize() - 1);
                        }
                    }
                }
            }
        }).setRemoveAction(button -> {
            int selectedIndex = this.myBranchLocationsList.getSelectedIndex();
            for (String url : this.myBranchLocationsList.getSelectedValuesList()) {
                int index = this.myBranchLocationsModel.getConfiguration().getBranchUrls().indexOf(url);
                this.myBranchLocationsModel.getConfiguration().removeBranch(url);
                this.myBranchLocationsModel.fireItemRemoved(index);
            }
            if (this.myBranchLocationsModel.getSize() > 0) {
                selectedIndex = Math.min(selectedIndex, this.myBranchLocationsModel.getSize() - 1);
                this.myBranchLocationsList.setSelectedIndex(selectedIndex);
            }
        }).disableUpDownActions().setToolbarPosition(ActionToolbarPosition.BOTTOM).createPanel();
        if (jPanel == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "Subversion.BranchConfigurationDialog";
    }

    public static void configureBranches(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            BranchConfigurationDialog.$$$reportNull$$$0(8);
        }
        if (file == null) {
            return;
        }
        RootUrlInfo wcRoot = SvnVcs.getInstance(project).getSvnFileUrlMapping().getWcRootForFilePath(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (wcRoot == null) {
            return;
        }
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(project).get(file);
        SvnBranchConfigurationNew clonedConfiguration = configuration.copy();
        if (new BranchConfigurationDialog(project, clonedConfiguration, wcRoot.getRepositoryUrl(), file, wcRoot.getUrl()).showAndGet()) {
            SvnBranchConfigurationManager.getInstance(project).setConfiguration(file, clonedConfiguration);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapLocationsWithToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrapLocationsWithToolbar";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureBranches";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("configure.branches.branch.locations"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("configure.branches.trunk.location"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTrunkLocationTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myErrorPrompt = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyListModel
    extends AbstractListModel<String> {
        @NotNull
        private final SvnBranchConfigurationNew myConfiguration;
        private List<String> myBranchUrls;

        public MyListModel(@NotNull SvnBranchConfigurationNew configuration) {
            if (configuration == null) {
                MyListModel.$$$reportNull$$$0(0);
            }
            this.myConfiguration = configuration;
            this.myBranchUrls = this.myConfiguration.getBranchUrls();
        }

        @NotNull
        public SvnBranchConfigurationNew getConfiguration() {
            SvnBranchConfigurationNew svnBranchConfigurationNew = this.myConfiguration;
            if (svnBranchConfigurationNew == null) {
                MyListModel.$$$reportNull$$$0(1);
            }
            return svnBranchConfigurationNew;
        }

        @Override
        public int getSize() {
            return this.myBranchUrls.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.myBranchUrls.get(index);
        }

        public void fireItemAdded() {
            int index = this.myConfiguration.getBranchUrls().size() - 1;
            this.myBranchUrls = this.myConfiguration.getBranchUrls();
            super.fireIntervalAdded(this, index, index);
        }

        public void fireItemRemoved(int index) {
            this.myBranchUrls = this.myConfiguration.getBranchUrls();
            super.fireIntervalRemoved(this, index, index);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog$MyListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog$MyListModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class TrunkUrlValidator
    extends DocumentAdapter {
        private final Url myRootUrl;
        private final SvnBranchConfigurationNew myConfiguration;

        private TrunkUrlValidator(Url rootUrl, SvnBranchConfigurationNew configuration) {
            this.myRootUrl = rootUrl;
            this.myConfiguration = configuration;
        }

        protected void textChanged(DocumentEvent e) {
            Url url = this.parseUrl(BranchConfigurationDialog.this.myTrunkLocationTextField.getText());
            if (url != null) {
                boolean areNotSame;
                boolean bl = areNotSame = SvnUtil.isAncestor(this.myRootUrl, url) && !url.equals(this.myRootUrl);
                if (areNotSame) {
                    this.myConfiguration.setTrunkUrl(url.toDecodedString());
                }
                BranchConfigurationDialog.this.myErrorPrompt.setText(areNotSame ? "" : SvnBundle.message("configure.branches.error.wrong.url", this.myRootUrl));
            }
        }

        @Nullable
        private Url parseUrl(@NotNull String url) {
            if (url == null) {
                TrunkUrlValidator.$$$reportNull$$$0(0);
            }
            Url result = null;
            try {
                result = SvnUtil.createUrl(url);
            }
            catch (SvnBindException e) {
                BranchConfigurationDialog.this.myErrorPrompt.setText(e.getMessage());
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/branchConfig/BranchConfigurationDialog$TrunkUrlValidator", "parseUrl"));
        }
    }
}

