/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;

public class WcInfoLoader {
    @NotNull
    private final SvnVcs myVcs;
    @Nullable
    private final RepositoryLocation myLocation;

    public WcInfoLoader(@NotNull SvnVcs vcs, @Nullable RepositoryLocation location) {
        if (vcs == null) {
            WcInfoLoader.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myLocation = location;
    }

    @NotNull
    public List<WCInfoWithBranches> loadRoots() {
        ArrayList result = ContainerUtil.newArrayList();
        for (WCInfo info : this.myVcs.getAllWcInfos()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)this.createInfo(info));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            WcInfoLoader.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public WCInfoWithBranches reloadInfo(@NotNull WCInfoWithBranches info) {
        if (info == null) {
            WcInfoLoader.$$$reportNull$$$0(2);
        }
        File file = info.getRootInfo().getIoFile();
        RootUrlInfo rootInfo = this.myVcs.getSvnFileUrlMapping().getWcRootForFilePath(file);
        return rootInfo != null ? this.createInfo(new WCInfo(rootInfo, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(this.myVcs, file))) : null;
    }

    @Nullable
    private WCInfoWithBranches createInfo(@NotNull WCInfo info) {
        if (info == null) {
            WcInfoLoader.$$$reportNull$$$0(3);
        }
        if (!info.getFormat().supportsMergeInfo()) {
            return null;
        }
        String url = info.getUrl().toString();
        if (this.myLocation != null && !this.myLocation.toPresentableString().startsWith(url) && !url.startsWith(this.myLocation.toPresentableString())) {
            return null;
        }
        if (!SvnUtil.checkRepositoryVersion15(this.myVcs, info.getUrl())) {
            return null;
        }
        RootUrlInfo rootForUrl = this.myVcs.getSvnFileUrlMapping().getWcRootForUrl(info.getUrl());
        return rootForUrl != null ? this.createInfoWithBranches(info, rootForUrl) : null;
    }

    @NotNull
    private WCInfoWithBranches createInfoWithBranches(@NotNull WCInfo info, @NotNull RootUrlInfo rootUrlInfo) {
        if (info == null) {
            WcInfoLoader.$$$reportNull$$$0(4);
        }
        if (rootUrlInfo == null) {
            WcInfoLoader.$$$reportNull$$$0(5);
        }
        SvnBranchConfigurationNew configuration = SvnBranchConfigurationManager.getInstance(this.myVcs.getProject()).get(rootUrlInfo.getVirtualFile());
        Ref workingCopyBranch = Ref.create();
        ArrayList branches = ContainerUtil.newArrayList();
        String url = info.getUrl().toString();
        String trunkUrl = configuration.getTrunkUrl();
        if (trunkUrl != null) {
            WcInfoLoader.add(url, trunkUrl, branches, (Ref<WCInfoWithBranches.Branch>)workingCopyBranch);
        }
        for (String branchUrl : configuration.getBranchUrls()) {
            for (SvnBranchItem branchItem : configuration.getBranches(branchUrl)) {
                WcInfoLoader.add(url, branchItem.getUrl(), branches, (Ref<WCInfoWithBranches.Branch>)workingCopyBranch);
            }
        }
        Collections.sort(branches, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getUrl()), (Comparable)((Object)o2.getUrl())));
        WCInfoWithBranches wCInfoWithBranches = new WCInfoWithBranches(info, branches, rootUrlInfo.getRoot(), (WCInfoWithBranches.Branch)workingCopyBranch.get());
        if (wCInfoWithBranches == null) {
            WcInfoLoader.$$$reportNull$$$0(6);
        }
        return wCInfoWithBranches;
    }

    private static void add(@NotNull String url, @NotNull String branchUrl, @NotNull List<WCInfoWithBranches.Branch> branches, @NotNull Ref<WCInfoWithBranches.Branch> workingCopyBranch) {
        if (url == null) {
            WcInfoLoader.$$$reportNull$$$0(7);
        }
        if (branchUrl == null) {
            WcInfoLoader.$$$reportNull$$$0(8);
        }
        if (branches == null) {
            WcInfoLoader.$$$reportNull$$$0(9);
        }
        if (workingCopyBranch == null) {
            WcInfoLoader.$$$reportNull$$$0(10);
        }
        WCInfoWithBranches.Branch branch = new WCInfoWithBranches.Branch(branchUrl);
        if (!Url.isAncestor(branchUrl, url)) {
            branches.add(branch);
        } else {
            workingCopyBranch.set((Object)branch);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/history/WcInfoLoader";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootUrlInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchUrl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingCopyBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/history/WcInfoLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfoWithBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reloadInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createInfoWithBranches";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

