/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.SvnInfoStructure;
import org.jetbrains.idea.svn.lock.Lock;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SvnInfoHandler
extends DefaultHandler {
    @Nullable
    private final File myBase;
    private final Consumer<org.jetbrains.idea.svn.info.Info> myInfoConsumer;
    private final Map<File, org.jetbrains.idea.svn.info.Info> myResultsMap;
    private SvnInfoStructure myPending;
    private final Map<String, Getter<ElementHandlerBase>> myElementsMap;
    private final List<ElementHandlerBase> myParseStack;
    private final StringBuilder mySb;

    public SvnInfoHandler(@Nullable File base, Consumer<org.jetbrains.idea.svn.info.Info> infoConsumer) {
        this.myBase = base;
        this.myInfoConsumer = infoConsumer;
        this.myPending = this.createPending();
        this.myElementsMap = new HashMap<String, Getter<ElementHandlerBase>>();
        this.fillElements();
        this.myParseStack = new ArrayList<ElementHandlerBase>();
        this.myParseStack.add(new Fake());
        this.myResultsMap = new HashMap<File, org.jetbrains.idea.svn.info.Info>();
        this.mySb = new StringBuilder();
    }

    private void switchPending() throws SAXException {
        org.jetbrains.idea.svn.info.Info info;
        try {
            info = this.myPending.convert();
        }
        catch (SvnBindException e) {
            throw new SAXException((Exception)((Object)e));
        }
        if (this.myInfoConsumer != null) {
            this.myInfoConsumer.consume((Object)info);
        }
        this.myResultsMap.put(info.getFile(), info);
        this.myPending = this.createPending();
    }

    private SvnInfoStructure createPending() {
        SvnInfoStructure pending = new SvnInfoStructure();
        pending.myDepth = org.jetbrains.idea.svn.api.Depth.INFINITY;
        return pending;
    }

    @Override
    public void endDocument() throws SAXException {
        SvnInfoHandler.assertSAX(!this.myParseStack.isEmpty());
        for (int i = this.myParseStack.size() - 1; i >= 0; --i) {
            ElementHandlerBase current = this.myParseStack.get(i);
            if (!(current instanceof Entry)) continue;
            this.switchPending();
            break;
        }
        this.myParseStack.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        SvnInfoHandler.assertSAX(!this.myParseStack.isEmpty());
        ElementHandlerBase current = this.myParseStack.get(this.myParseStack.size() - 1);
        while (true) {
            boolean createNewChild;
            if (createNewChild = current.startElement(uri, localName, qName, attributes)) {
                SvnInfoHandler.assertSAX(this.myElementsMap.containsKey(qName));
                ElementHandlerBase newChild = (ElementHandlerBase)this.myElementsMap.get(qName).get();
                newChild.setParent(current);
                newChild.updateInfo(attributes, this.myPending);
                this.myParseStack.add(newChild);
                return;
            }
            if (current instanceof Entry) {
                this.switchPending();
            }
            this.myParseStack.remove(this.myParseStack.size() - 1);
            SvnInfoHandler.assertSAX(!this.myParseStack.isEmpty());
            current = this.myParseStack.get(this.myParseStack.size() - 1);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ElementHandlerBase current = this.myParseStack.get(this.myParseStack.size() - 1);
        String value = this.mySb.toString().trim();
        if (!StringUtil.isEmpty((String)value)) {
            current.characters(value, this.myPending);
        }
        this.mySb.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        SvnInfoHandler.assertSAX(!this.myParseStack.isEmpty());
        this.mySb.append(ch, start, length);
    }

    public Map<String, Getter<ElementHandlerBase>> getElementsMap() {
        return this.myElementsMap;
    }

    private void fillElements() {
        this.myElementsMap.put("copy-from-url", (Getter<ElementHandlerBase>)((Getter)() -> new CopyFromUrl()));
        this.myElementsMap.put("copy-from-rev", (Getter<ElementHandlerBase>)((Getter)() -> new CopyFromRev()));
        this.myElementsMap.put("changelist", (Getter<ElementHandlerBase>)((Getter)() -> new ChangeList()));
        this.myElementsMap.put("author", (Getter<ElementHandlerBase>)((Getter)() -> new Author()));
        this.myElementsMap.put("checksum", (Getter<ElementHandlerBase>)((Getter)() -> new Checksum()));
        this.myElementsMap.put("commit", (Getter<ElementHandlerBase>)((Getter)() -> new Commit()));
        this.myElementsMap.put("conflict", (Getter<ElementHandlerBase>)((Getter)() -> new Conflict()));
        this.myElementsMap.put("cur-base-file", (Getter<ElementHandlerBase>)((Getter)() -> new CurBase()));
        this.myElementsMap.put("date", (Getter<ElementHandlerBase>)((Getter)() -> new Date()));
        this.myElementsMap.put("depth", (Getter<ElementHandlerBase>)((Getter)() -> new Depth()));
        this.myElementsMap.put("entry", (Getter<ElementHandlerBase>)((Getter)() -> new Entry(this.myBase)));
        this.myElementsMap.put("info", (Getter<ElementHandlerBase>)((Getter)() -> new Info()));
        this.myElementsMap.put("prev-base-file", (Getter<ElementHandlerBase>)((Getter)() -> new PrevBase()));
        this.myElementsMap.put("prev-wc-file", (Getter<ElementHandlerBase>)((Getter)() -> new PrevWc()));
        this.myElementsMap.put("prop-file", (Getter<ElementHandlerBase>)((Getter)() -> new PropFile()));
        this.myElementsMap.put("repository", (Getter<ElementHandlerBase>)((Getter)() -> new Repository()));
        this.myElementsMap.put("root", (Getter<ElementHandlerBase>)((Getter)() -> new Root()));
        this.myElementsMap.put("schedule", (Getter<ElementHandlerBase>)((Getter)() -> new Schedule()));
        this.myElementsMap.put("text-updated", (Getter<ElementHandlerBase>)((Getter)() -> new TextUpdated()));
        this.myElementsMap.put("tree-conflict", (Getter<ElementHandlerBase>)((Getter)() -> new TreeConflict()));
        this.myElementsMap.put("url", (Getter<ElementHandlerBase>)((Getter)() -> new Url()));
        this.myElementsMap.put("relative-url", (Getter<ElementHandlerBase>)((Getter)() -> new RelativeUrl()));
        this.myElementsMap.put("lock", (Getter<ElementHandlerBase>)((Getter)() -> new LockElement()));
        this.myElementsMap.put("token", (Getter<ElementHandlerBase>)((Getter)() -> new LockToken()));
        this.myElementsMap.put("owner", (Getter<ElementHandlerBase>)((Getter)() -> new LockOwner()));
        this.myElementsMap.put("comment", (Getter<ElementHandlerBase>)((Getter)() -> new LockComment()));
        this.myElementsMap.put("created", (Getter<ElementHandlerBase>)((Getter)() -> new LockCreated()));
        this.myElementsMap.put("uuid", (Getter<ElementHandlerBase>)((Getter)() -> new Uuid()));
        this.myElementsMap.put("version", (Getter<ElementHandlerBase>)((Getter)() -> new Version()));
        this.myElementsMap.put("wc-info", (Getter<ElementHandlerBase>)((Getter)() -> new WcInfo()));
        this.myElementsMap.put("moved-to", (Getter<ElementHandlerBase>)((Getter)() -> new MovedPath()));
        this.myElementsMap.put("moved-from", (Getter<ElementHandlerBase>)((Getter)() -> new MovedPath()));
        this.myElementsMap.put("wcroot-abspath", (Getter<ElementHandlerBase>)((Getter)() -> new WcRoot()));
    }

    public Map<File, org.jetbrains.idea.svn.info.Info> getResultsMap() {
        return this.myResultsMap;
    }

    private static void assertSAX(boolean shouldBeTrue) throws SAXException {
        if (!shouldBeTrue) {
            throw new SAXException("can not parse output");
        }
    }

    private static abstract class ElementHandlerBase {
        private final Set<String> myAwaitedChildren;
        private final Set<String> myAwaitedChildrenMultiple;
        private ElementHandlerBase parent;

        ElementHandlerBase(String[] awaitedChildren, String[] awaitedChildrenMultiple) {
            this.myAwaitedChildren = new HashSet<String>(Arrays.asList(awaitedChildren));
            this.myAwaitedChildrenMultiple = new HashSet<String>(Arrays.asList(awaitedChildrenMultiple));
        }

        @NotNull
        public ElementHandlerBase getParent() {
            ElementHandlerBase elementHandlerBase = this.parent;
            if (elementHandlerBase == null) {
                ElementHandlerBase.$$$reportNull$$$0(0);
            }
            return elementHandlerBase;
        }

        public void setParent(@NotNull ElementHandlerBase parent) {
            if (parent == null) {
                ElementHandlerBase.$$$reportNull$$$0(1);
            }
            this.parent = parent;
        }

        protected abstract void updateInfo(Attributes var1, SvnInfoStructure var2) throws SAXException;

        public boolean startElement(String uri, String localName, String qName, Attributes attributes) {
            if (this.myAwaitedChildrenMultiple.contains(qName)) {
                return true;
            }
            return this.myAwaitedChildren.remove(qName);
        }

        public abstract void characters(String var1, SvnInfoStructure var2) throws SAXException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/svn/info/SvnInfoHandler$ElementHandlerBase";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/svn/info/SvnInfoHandler$ElementHandlerBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setParent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Fake
    extends ElementHandlerBase {
        private Fake() {
            super(new String[]{"info"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Info
    extends ElementHandlerBase {
        private Info() {
            super(new String[0], new String[]{"entry"});
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Entry
    extends ElementHandlerBase {
        @Nullable
        private final File myBase;

        private Entry(@Nullable File base) {
            super(new String[]{"url", "relative-url", "lock", "repository", "wc-info", "commit", "tree-conflict"}, new String[]{"conflict"});
            this.myBase = base;
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
            String revision;
            String kind = attributes.getValue("kind");
            SvnInfoHandler.assertSAX(!StringUtil.isEmptyOrSpaces((String)kind));
            structure.myKind = NodeKind.from(kind);
            if (this.myBase != null) {
                String path = attributes.getValue("path");
                SvnInfoHandler.assertSAX(!StringUtil.isEmptyOrSpaces((String)path));
                structure.myFile = SvnUtil.resolvePath(this.myBase, path);
            }
            SvnInfoHandler.assertSAX(!StringUtil.isEmptyOrSpaces((String)(revision = attributes.getValue("revision"))));
            try {
                long number;
                structure.myRevision = number = Long.parseLong(revision);
            }
            catch (NumberFormatException e) {
                structure.myRevision = -1L;
            }
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class LockCreated
    extends ElementHandlerBase {
        private LockCreated() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myLockBuilder.setCreationDate(SvnUtil.parseDate(s));
        }
    }

    private static class LockComment
    extends ElementHandlerBase {
        private LockComment() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myLockBuilder.setComment(s);
        }
    }

    private static class LockOwner
    extends ElementHandlerBase {
        private LockOwner() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myLockBuilder.setOwner(s);
        }
    }

    private static class LockToken
    extends ElementHandlerBase {
        private LockToken() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myLockBuilder.setToken(s);
        }
    }

    private static class LockElement
    extends ElementHandlerBase {
        private LockElement() {
            super(new String[]{"token", "owner", "comment", "created"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
            structure.myLockBuilder = new Lock.Builder();
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class RelativeUrl
    extends Url {
        private RelativeUrl() {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.relativeUrl = s;
        }
    }

    private static class Url
    extends ElementHandlerBase {
        private Url() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            try {
                structure.myUrl = SvnUtil.createUrl(s);
            }
            catch (SvnBindException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    private static class Repository
    extends ElementHandlerBase {
        private Repository() {
            super(new String[]{"root", "uuid"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Root
    extends ElementHandlerBase {
        private Root() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            try {
                structure.myRootURL = SvnUtil.createUrl(s);
            }
            catch (SvnBindException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    private static class Uuid
    extends ElementHandlerBase {
        private Uuid() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myUuid = s;
        }
    }

    private static class WcInfo
    extends ElementHandlerBase {
        private WcInfo() {
            super(new String[]{"wcroot-abspath", "schedule", "depth", "text-updated", "checksum", "changelist", "copy-from-url", "copy-from-rev", "moved-to", "moved-from"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class CopyFromRev
    extends ElementHandlerBase {
        private CopyFromRev() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            try {
                long number;
                structure.myCopyFromRevision = number = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new SAXException(e);
            }
        }
    }

    private static class CopyFromUrl
    extends ElementHandlerBase {
        private CopyFromUrl() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) throws SAXException {
            try {
                structure.myCopyFromURL = SvnUtil.createUrl(s);
            }
            catch (SvnBindException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    private static class ChangeList
    extends ElementHandlerBase {
        private ChangeList() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myChangelistName = s;
        }
    }

    private static class WcRoot
    extends ElementHandlerBase {
        private WcRoot() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Schedule
    extends ElementHandlerBase {
        private Schedule() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.mySchedule = s;
        }
    }

    private static class Depth
    extends ElementHandlerBase {
        private Depth() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myDepth = org.jetbrains.idea.svn.api.Depth.from(s);
        }
    }

    private static class TextUpdated
    extends ElementHandlerBase {
        private TextUpdated() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myTextTime = s;
        }
    }

    private static class MovedPath
    extends ElementHandlerBase {
        private MovedPath() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Checksum
    extends ElementHandlerBase {
        private Checksum() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myChecksum = s;
        }
    }

    private static class Commit
    extends ElementHandlerBase {
        private Commit() {
            super(new String[]{"author", "date"}, new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) throws SAXException {
            String revision = attributes.getValue("revision");
            try {
                long number;
                structure.myCommittedRevision = number = Long.parseLong(revision);
            }
            catch (NumberFormatException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Author
    extends ElementHandlerBase {
        private Author() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myAuthor = s;
        }
    }

    private static class Date
    extends ElementHandlerBase {
        private Date() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myCommittedDate = s;
        }
    }

    private static class Conflict
    extends ElementHandlerBase {
        private Conflict() {
            super(new String[]{"prev-base-file", "prev-wc-file", "cur-base-file", "prop-file"}, new String[]{"version"});
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class PrevBase
    extends ElementHandlerBase {
        private PrevBase() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myConflictOld = new File(s).getName();
        }
    }

    private static class PrevWc
    extends ElementHandlerBase {
        private PrevWc() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myConflictWorking = new File(s).getName();
        }
    }

    private static class CurBase
    extends ElementHandlerBase {
        private CurBase() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myConflictNew = new File(s).getName();
        }
    }

    private static class PropFile
    extends ElementHandlerBase {
        private PropFile() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
            structure.myPropRejectFile = s;
        }
    }

    private static class TreeConflict
    extends ElementHandlerBase {
        private TreeConflict() {
            super(new String[0], new String[]{"version"});
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
            String action;
            String victim;
            String reason;
            String kind;
            SvnInfoStructure.TreeConflictDescription d;
            structure.myTreeConflict = d = new SvnInfoStructure.TreeConflictDescription();
            String operation = attributes.getValue("operation");
            if (!StringUtil.isEmptyOrSpaces((String)operation)) {
                d.myOperation = operation;
            }
            if (!StringUtil.isEmptyOrSpaces((String)(kind = attributes.getValue("kind")))) {
                d.myKind = kind;
            }
            if (!StringUtil.isEmptyOrSpaces((String)(reason = attributes.getValue("reason")))) {
                d.myReason = reason;
            }
            if (!StringUtil.isEmptyOrSpaces((String)(victim = attributes.getValue("victim")))) {
                d.myVictim = victim;
            }
            if (!StringUtil.isEmptyOrSpaces((String)(action = attributes.getValue("action")))) {
                d.myAction = action;
            }
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }

    private static class Version
    extends ElementHandlerBase {
        private Version() {
            super(new String[0], new String[0]);
        }

        @Override
        protected void updateInfo(Attributes attributes, SvnInfoStructure structure) {
            if (this.getParent() instanceof Conflict) {
                return;
            }
            String side = attributes.getValue("side");
            if ("source-left".equals(side)) {
                SvnInfoStructure.ConflictVersion conflictVersion;
                structure.myTreeConflict.mySourceLeft = conflictVersion = new SvnInfoStructure.ConflictVersion();
                this.setConflictFields(attributes, conflictVersion);
            } else if ("source-right".equals(side)) {
                SvnInfoStructure.ConflictVersion conflictVersion;
                structure.myTreeConflict.mySourceRight = conflictVersion = new SvnInfoStructure.ConflictVersion();
                this.setConflictFields(attributes, conflictVersion);
            }
        }

        private void setConflictFields(Attributes attributes, SvnInfoStructure.ConflictVersion conflictVersion) {
            conflictVersion.myKind = attributes.getValue("kind");
            conflictVersion.myPathInRepo = attributes.getValue("path-in-repos");
            conflictVersion.myRepoUrl = attributes.getValue("repos-url");
            conflictVersion.myRevision = attributes.getValue("revision");
        }

        @Override
        public void characters(String s, SvnInfoStructure structure) {
        }
    }
}

