/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStaticGroup
extends XValueGroup
implements NodeDescriptorProvider {
    private final StaticDescriptorImpl myStaticDescriptor;
    private final EvaluationContextImpl myEvaluationContext;
    private final NodeManagerImpl myNodeManager;

    public JavaStaticGroup(StaticDescriptorImpl staticDescriptor, EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager) {
        super(staticDescriptor.getName());
        this.myStaticDescriptor = staticDescriptor;
        this.myEvaluationContext = evaluationContext;
        this.myNodeManager = nodeManager;
    }

    @Nullable
    public String getComment() {
        String res = NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.myStaticDescriptor.getType().name());
        if (!StringUtil.isEmpty((String)res)) {
            return " members of " + res;
        }
        return res;
    }

    @NotNull
    public String getSeparator() {
        if ("" == null) {
            JavaStaticGroup.$$$reportNull$$$0(0);
        }
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Static;
    }

    @Override
    public NodeDescriptorImpl getDescriptor() {
        return this.myStaticDescriptor;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            JavaStaticGroup.$$$reportNull$$$0(1);
        }
        JavaValue.scheduleCommand(this.myEvaluationContext, node, new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                if (suspendContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                XValueChildrenList children = new XValueChildrenList();
                ReferenceType refType = JavaStaticGroup.this.myStaticDescriptor.getType();
                List<Field> fields = refType.allFields();
                ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
                for (Field field : fields) {
                    if (!field.isStatic()) continue;
                    boolean isSynthetic = DebuggerUtils.isSynthetic((TypeComponent)field);
                    if (!classRenderer.SHOW_SYNTHETICS && isSynthetic) continue;
                    FieldDescriptorImpl fieldDescriptor = JavaStaticGroup.this.myNodeManager.getFieldDescriptor(JavaStaticGroup.this.myStaticDescriptor, null, field);
                    children.add((XNamedValue)JavaValue.create(fieldDescriptor, JavaStaticGroup.this.myEvaluationContext, JavaStaticGroup.this.myNodeManager));
                }
                node.addChildren(children, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaStaticGroup$1", "contextAction"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaStaticGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaStaticGroup";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

