/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.events;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuspendContextCommandImpl
extends DebuggerCommandImpl {
    private static final Logger LOG = Logger.getInstance(SuspendContextCommand.class);
    private final SuspendContextImpl mySuspendContext;

    protected SuspendContextCommandImpl(@Nullable SuspendContextImpl suspendContext) {
        this.mySuspendContext = suspendContext;
    }

    @Deprecated
    public void contextAction() throws Exception {
        throw new AbstractMethodError();
    }

    public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
        if (suspendContext == null) {
            SuspendContextCommandImpl.$$$reportNull$$$0(0);
        }
        this.contextAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void action() throws Exception {
        SuspendContextImpl suspendContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying " + this);
        }
        if ((suspendContext = this.getSuspendContext()) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skip processing - context is null " + this);
            }
            this.notifyCancelled();
            return;
        }
        if (suspendContext.myInProgress) {
            suspendContext.postponeCommand(this);
        } else {
            try {
                if (!suspendContext.isResumed()) {
                    suspendContext.myInProgress = true;
                    this.contextAction(suspendContext);
                } else {
                    this.notifyCancelled();
                }
            }
            finally {
                suspendContext.myInProgress = false;
                if (suspendContext.isResumed()) {
                    SuspendContextCommandImpl postponed = suspendContext.pollPostponedCommand();
                    while (postponed != null) {
                        postponed.notifyCancelled();
                        postponed = suspendContext.pollPostponedCommand();
                    }
                } else {
                    SuspendContextCommandImpl postponed = suspendContext.pollPostponedCommand();
                    if (postponed != null) {
                        Stack stack = new Stack();
                        while (postponed != null) {
                            stack.push((Object)postponed);
                            postponed = suspendContext.pollPostponedCommand();
                        }
                        DebuggerManagerThreadImpl managerThread = suspendContext.getDebugProcess().getManagerThread();
                        while (!stack.isEmpty()) {
                            managerThread.pushBack((DebuggerCommandImpl)stack.pop());
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/events/SuspendContextCommandImpl", "contextAction"));
    }
}

