/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.CompoundRendererConfigurable;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.InternalIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public final class UserRenderersConfigurable
extends JPanel
implements ConfigurableUi<NodeRendererSettings>,
Disposable {
    private final JPanel myNameFieldPanel;
    private final JTextField myNameField;
    private final ElementsChooser<NodeRenderer> myRendererChooser;
    private NodeRenderer myCurrentRenderer = null;
    private final CompoundRendererConfigurable myRendererDataConfigurable = new CompoundRendererConfigurable(this);

    public UserRenderersConfigurable() {
        super(new BorderLayout(4, 0));
        this.myRendererChooser = new ElementsChooser(true);
        this.setupRenderersList();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)((JTable)this.myRendererChooser.getComponent()));
        decorator.setToolbarPosition(ActionToolbarPosition.TOP);
        decorator.setAddAction((AnActionButtonRunnable)new AddAction());
        decorator.setRemoveAction((AnActionButtonRunnable)new RemoveAction());
        decorator.setMoveUpAction((AnActionButtonRunnable)new MoveAction(true));
        decorator.setMoveDownAction((AnActionButtonRunnable)new MoveAction(false));
        decorator.addExtraAction((AnActionButton)new CopyAction());
        this.myNameField = new JTextField();
        this.myNameFieldPanel = new JPanel(new BorderLayout());
        this.myNameFieldPanel.add((Component)new JLabel(DebuggerBundle.message((String)"label.user.renderers.configurable.renderer.name", (Object[])new Object[0])), "West");
        this.myNameFieldPanel.add((Component)this.myNameField, "Center");
        this.myNameFieldPanel.setVisible(false);
        JPanel center = new JPanel(new BorderLayout(0, 4));
        center.add((Component)this.myNameFieldPanel, "North");
        center.add((Component)this.myRendererDataConfigurable, "Center");
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (UserRenderersConfigurable.this.myCurrentRenderer != null) {
                    UserRenderersConfigurable.this.myCurrentRenderer.setName(UserRenderersConfigurable.this.myNameField.getText());
                    UserRenderersConfigurable.this.myRendererChooser.refresh((Object)UserRenderersConfigurable.this.myCurrentRenderer);
                }
            }
        });
        Splitter splitter = new Splitter(false);
        splitter.setProportion(0.3f);
        splitter.setFirstComponent((JComponent)decorator.createPanel());
        splitter.setSecondComponent((JComponent)center);
        this.add((Component)splitter, "Center");
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        UserRenderersConfigurable userRenderersConfigurable = this;
        if (userRenderersConfigurable == null) {
            UserRenderersConfigurable.$$$reportNull$$$0(0);
        }
        return userRenderersConfigurable;
    }

    private void setupRenderersList() {
        this.myRendererChooser.getEmptyText().setText(DebuggerBundle.message((String)"text.user.renderers.configurable.no.renderers", (Object[])new Object[0]));
        this.myRendererChooser.addElementsMarkListener(NodeRenderer::setEnabled);
        this.myRendererChooser.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateCurrentRenderer(this.myRendererChooser.getSelectedElements());
            }
        });
    }

    private void updateCurrentRenderer(List<NodeRenderer> selectedElements) {
        if (selectedElements.size() != 1) {
            this.setCurrentRenderer(null);
        } else {
            this.setCurrentRenderer(selectedElements.get(0));
        }
    }

    private void setCurrentRenderer(NodeRenderer renderer) {
        if (this.myCurrentRenderer == renderer) {
            return;
        }
        if (this.myRendererDataConfigurable.isModified()) {
            this.myRendererDataConfigurable.apply();
        }
        this.myCurrentRenderer = renderer;
        if (renderer != null) {
            this.myNameFieldPanel.setVisible(true);
            this.myNameField.setText(renderer.getName());
        } else {
            this.myNameFieldPanel.setVisible(false);
            this.myNameField.setText("");
        }
        this.myRendererDataConfigurable.setRenderer(renderer);
    }

    public void apply(@NotNull NodeRendererSettings settings) {
        if (settings == null) {
            UserRenderersConfigurable.$$$reportNull$$$0(1);
        }
        this.myRendererDataConfigurable.apply();
        this.flushTo(settings.getCustomRenderers());
        settings.fireRenderersChanged();
    }

    private void flushTo(RendererConfiguration rendererConfiguration) {
        int count = this.myRendererChooser.getElementCount();
        ArrayList<NodeRenderer> renderers = new ArrayList<NodeRenderer>(count);
        for (int idx = 0; idx < count; ++idx) {
            renderers.add((NodeRenderer)this.myRendererChooser.getElementAt(idx));
        }
        rendererConfiguration.setRenderers(renderers);
    }

    public boolean isModified(@NotNull NodeRendererSettings settings) {
        if (settings == null) {
            UserRenderersConfigurable.$$$reportNull$$$0(2);
        }
        if (this.myRendererDataConfigurable.isModified()) {
            return true;
        }
        RendererConfiguration rendererConfiguration = settings.getCustomRenderers();
        if (this.myRendererChooser.getElementCount() != rendererConfiguration.getRendererCount()) {
            return true;
        }
        RendererConfiguration uiConfiguration = new RendererConfiguration(settings);
        this.flushTo(uiConfiguration);
        return !uiConfiguration.equals(rendererConfiguration);
    }

    public void reset(@NotNull NodeRendererSettings settings) {
        if (settings == null) {
            UserRenderersConfigurable.$$$reportNull$$$0(3);
        }
        this.myRendererChooser.removeAllElements();
        RendererConfiguration rendererConfiguration = settings.getCustomRenderers();
        ArrayList<NodeRenderer> elementsToSelect = new ArrayList<NodeRenderer>(1);
        rendererConfiguration.iterateRenderers((InternalIterator<NodeRenderer>)((InternalIterator)renderer -> {
            NodeRenderer clonedRenderer = (NodeRenderer)renderer.clone();
            this.myRendererChooser.addElement((Object)clonedRenderer, clonedRenderer.isEnabled());
            if (elementsToSelect.size() == 0) {
                elementsToSelect.add(clonedRenderer);
            }
            return true;
        }));
        this.myRendererChooser.selectElements(elementsToSelect);
        this.updateCurrentRenderer(elementsToSelect);
        this.myRendererDataConfigurable.reset();
    }

    public void addRenderer(NodeRenderer renderer) {
        this.myRendererChooser.addElement((Object)renderer, renderer.isEnabled());
        this.myRendererChooser.moveElement((Object)renderer, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/settings/UserRenderersConfigurable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/settings/UserRenderersConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MoveAction
    implements AnActionButtonRunnable {
        private final boolean myMoveUp;

        public MoveAction(boolean up) {
            this.myMoveUp = up;
        }

        public void run(AnActionButton button) {
            int selectedRow = UserRenderersConfigurable.this.myRendererChooser.getSelectedElementRow();
            if (selectedRow < 0) {
                return;
            }
            int newRow = selectedRow + (this.myMoveUp ? -1 : 1);
            if (newRow < 0) {
                newRow = UserRenderersConfigurable.this.myRendererChooser.getElementCount() - 1;
            } else if (newRow >= UserRenderersConfigurable.this.myRendererChooser.getElementCount()) {
                newRow = 0;
            }
            UserRenderersConfigurable.this.myRendererChooser.moveElement(UserRenderersConfigurable.this.myRendererChooser.getElementAt(selectedRow), newRow);
        }
    }

    private class CopyAction
    extends AnActionButton {
        public CopyAction() {
            super(DebuggerBundle.message((String)"button.copy", (Object[])new Object[0]), DebuggerBundle.message((String)"user.renderers.configurable.button.description.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            NodeRenderer selectedElement = (NodeRenderer)UserRenderersConfigurable.this.myRendererChooser.getSelectedElement();
            if (selectedElement != null) {
                UserRenderersConfigurable.this.myRendererChooser.addElement((Object)((NodeRenderer)selectedElement.clone()), true);
            }
        }

        public void updateButton(AnActionEvent e) {
            super.updateButton(e);
            e.getPresentation().setEnabled(UserRenderersConfigurable.this.myRendererChooser.getSelectedElement() != null);
        }
    }

    private class RemoveAction
    implements AnActionButtonRunnable {
        private RemoveAction() {
        }

        public void run(AnActionButton button) {
            UserRenderersConfigurable.this.myRendererChooser.getSelectedElements().forEach(arg_0 -> ((ElementsChooser)UserRenderersConfigurable.this.myRendererChooser).removeElement(arg_0));
        }
    }

    private class AddAction
    implements AnActionButtonRunnable {
        private AddAction() {
        }

        public void run(AnActionButton button) {
            NodeRenderer renderer = (NodeRenderer)NodeRendererSettings.getInstance().createRenderer("CompoundTypeRenderer");
            renderer.setEnabled(true);
            UserRenderersConfigurable.this.addRenderer(renderer);
        }
    }
}

