/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.JavaValueModifier;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ArrayElementDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XValueModifier;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

public class ArrayElementDescriptorImpl
extends ValueDescriptorImpl
implements ArrayElementDescriptor {
    private final int myIndex;
    private final ArrayReference myArray;

    public ArrayElementDescriptorImpl(Project project2, ArrayReference array, int index) {
        super(project2);
        this.myArray = array;
        this.myIndex = index;
        this.setLvalue(true);
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public ArrayReference getArray() {
        return this.myArray;
    }

    @Override
    public String getName() {
        return String.valueOf(this.myIndex);
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return ArrayElementDescriptorImpl.getArrayElement(this.myArray, this.myIndex);
    }

    public static Value getArrayElement(ArrayReference reference, int idx) throws EvaluateException {
        try {
            return reference.getValue(idx);
        }
        catch (ObjectCollectedException e) {
            throw EvaluateExceptionUtil.ARRAY_WAS_COLLECTED;
        }
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext context) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        try {
            return elementFactory.createExpressionFromText("this[" + this.myIndex + "]", null);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public XValueModifier getModifier(JavaValue value) {
        return new JavaValueModifier(value){

            @Override
            protected void setValueImpl(@NotNull XExpression expression, @NotNull XValueModifier.XModificationCallback callback) {
                ArrayElementDescriptorImpl elementDescriptor;
                ArrayReference array;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callback == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((array = (elementDescriptor = ArrayElementDescriptorImpl.this).getArray()) != null) {
                    if (VirtualMachineProxyImpl.isCollected(array)) {
                        Messages.showWarningDialog((Project)ArrayElementDescriptorImpl.this.getProject(), (String)(DebuggerBundle.message((String)"evaluation.error.array.collected", (Object[])new Object[0]) + "\n" + DebuggerBundle.message((String)"warning.recalculate", (Object[])new Object[0])), (String)DebuggerBundle.message((String)"title.set.value", (Object[])new Object[0]));
                        return;
                    }
                    final ArrayType arrType = (ArrayType)array.referenceType();
                    final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(ArrayElementDescriptorImpl.this.getProject()).getContext();
                    this.set(expression, callback, debuggerContext, new JavaValueModifier.SetValueRunnable(){

                        @Override
                        public void setValue(EvaluationContextImpl evaluationContext, Value newValue) throws ClassNotLoadedException, InvalidTypeException, EvaluateException {
                            array.setValue(elementDescriptor.getIndex(), 1.preprocessValue(evaluationContext, newValue, arrType.componentType()));
                            1.update(debuggerContext);
                        }

                        @Override
                        public ReferenceType loadClass(EvaluationContextImpl evaluationContext, String className) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
                            return evaluationContext.getDebugProcess().loadClass(evaluationContext, className, arrType.classLoader());
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callback";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/ui/impl/watch/ArrayElementDescriptorImpl$1";
                objectArray[2] = "setValueImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }
}

