/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BasicRendererProperties;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleColoredComponent;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeRendererImpl
implements NodeRenderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.NodeRendererImpl");
    protected BasicRendererProperties myProperties;

    protected NodeRendererImpl() {
        this("unnamed");
    }

    protected NodeRendererImpl(@NotNull String presentableName) {
        if (presentableName == null) {
            NodeRendererImpl.$$$reportNull$$$0(0);
        }
        this(presentableName, false);
    }

    protected NodeRendererImpl(@NotNull String presentableName, boolean enabledDefaultValue) {
        if (presentableName == null) {
            NodeRendererImpl.$$$reportNull$$$0(1);
        }
        this.myProperties = new BasicRendererProperties(enabledDefaultValue);
        this.myProperties.setName(presentableName);
        this.myProperties.setEnabled(enabledDefaultValue);
    }

    @Override
    public String getName() {
        return this.myProperties.getName();
    }

    @Override
    public void setName(String name2) {
        this.myProperties.setName(name2);
    }

    @Override
    public boolean isEnabled() {
        return this.myProperties.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myProperties.setEnabled(enabled);
    }

    public boolean isShowType() {
        return this.myProperties.isShowType();
    }

    public void setShowType(boolean showType) {
        this.myProperties.setShowType(showType);
    }

    @Override
    public Icon calcValueIcon(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        return null;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return null;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }

    @Override
    public NodeRendererImpl clone() {
        try {
            NodeRendererImpl cloned = (NodeRendererImpl)super.clone();
            cloned.myProperties = this.myProperties.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void readExternal(Element element) {
        this.myProperties.readExternal(element);
    }

    public void writeExternal(Element element) {
        this.myProperties.writeExternal(element);
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public String getIdLabel(Value value, DebugProcess process2) {
        return value instanceof ObjectReference && this.isShowType() ? ValueDescriptorImpl.getIdLabel((ObjectReference)value) : null;
    }

    public boolean hasOverhead() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/debugger/ui/tree/render/NodeRendererImpl", "<init>"));
    }

    public static class Overhead
    implements OverheadProducer {
        private final NodeRendererImpl myRenderer;

        public Overhead(@NotNull NodeRendererImpl renderer) {
            if (renderer == null) {
                Overhead.$$$reportNull$$$0(0);
            }
            this.myRenderer = renderer;
        }

        @Override
        public boolean isEnabled() {
            return this.myRenderer.isEnabled();
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.myRenderer.setEnabled(enabled);
            NodeRendererSettings.getInstance().fireRenderersChanged();
        }

        @Override
        public void customizeRenderer(SimpleColoredComponent renderer) {
            renderer.append(this.myRenderer.getName() + " renderer");
        }

        public int hashCode() {
            return this.myRenderer.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Overhead && this.myRenderer.equals(((Overhead)obj).myRenderer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/debugger/ui/tree/render/NodeRendererImpl$Overhead", "<init>"));
        }
    }
}

