/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.applet.AppletConfiguration;
import com.intellij.execution.applet.AppletConfigurationOptions;
import com.intellij.execution.applet.AppletParameter;
import com.intellij.execution.impl.CheckableRunConfigurationEditor;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AppletConfigurable
extends SettingsEditor<AppletConfiguration>
implements CheckableRunConfigurationEditor<AppletConfiguration>,
PanelWithAnchor {
    private JPanel myWholePanel;
    private JRadioButton myMainClass;
    private JRadioButton myURL;
    private JPanel myClassOptions;
    private JPanel myHTMLOptions;
    private LabeledComponent<TextFieldWithBrowseButton> myPolicyFile;
    private LabeledComponent<RawCommandLineEditor> myVMParameters;
    private EditorTextFieldWithBrowseButton myClassName;
    private TextFieldWithBrowseButton myHtmlFile;
    private JTextField myWidth;
    private JTextField myHeight;
    private LabeledComponent<ModulesComboBox> myModule;
    private JPanel myTablePlace;
    private JBLabel myHtmlFileLabel;
    private JBLabel myClassNameLabel;
    private JBLabel myWidthLabel;
    private JLabel myHeightLabel;
    private JrePathEditor myJrePathEditor;
    private final ButtonGroup myAppletRadioButtonGroup;
    private JComponent anchor;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private static final ColumnInfo[] PARAMETER_COLUMNS = new ColumnInfo[]{new MyColumnInfo(ExecutionBundle.message((String)"applet.configuration.parameter.name.column", (Object[])new Object[0])){

        public String valueOf(AppletParameter appletParameter) {
            return appletParameter.getName();
        }

        public void setValue(AppletParameter appletParameter, String name2) {
            appletParameter.setName(name2);
        }
    }, new MyColumnInfo(ExecutionBundle.message((String)"applet.configuration.parameter.value.column", (Object[])new Object[0])){

        public String valueOf(AppletParameter appletParameter) {
            return appletParameter.getValue();
        }

        public void setValue(AppletParameter appletParameter, String value) {
            appletParameter.setValue(value);
        }
    }};
    private final ListTableModel<AppletParameter> myParameters;
    private final TableView myTable;
    @NonNls
    protected static final String HTTP_PREFIX = "http:/";

    private void changePanel() {
        if (this.myMainClass.isSelected()) {
            this.myClassOptions.setVisible(true);
            this.myHTMLOptions.setVisible(false);
        } else {
            this.myHTMLOptions.setVisible(true);
            this.myClassOptions.setVisible(false);
        }
    }

    public AppletConfigurable(Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.myClassNameLabel.setLabelFor((Component)this.myClassName.getChildComponent());
        this.myHtmlFileLabel.setLabelFor((Component)this.myHtmlFile.getTextField());
        this.myWidthLabel.setLabelFor((Component)this.myWidth);
        this.myHeightLabel.setLabelFor(this.myHeight);
        this.myModuleSelector = new ConfigurationModuleSelector(project2, this.getModuleComponent());
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromModuleDependencies(this.getModuleComponent(), true));
        this.myTablePlace.setLayout(new BorderLayout());
        this.myParameters = new ListTableModel(PARAMETER_COLUMNS);
        this.myTable = new TableView(this.myParameters);
        this.myTable.getEmptyText().setText(ExecutionBundle.message((String)"no.parameters", (Object[])new Object[0]));
        this.myTablePlace.add((Component)ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AppletConfigurable.this.addParameter();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AppletConfigurable.this.removeParameter();
            }
        }).disableUpDownActions().createPanel(), "Center");
        this.myAppletRadioButtonGroup = new ButtonGroup();
        this.myAppletRadioButtonGroup.add(this.myMainClass);
        this.myAppletRadioButtonGroup.add(this.myURL);
        this.getVMParametersComponent().setDialogCaption(this.myVMParameters.getRawText());
        this.myMainClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletConfigurable.this.changePanel();
            }
        });
        this.myURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletConfigurable.this.changePanel();
            }
        });
        this.getPolicyFileComponent().addBrowseFolderListener(ExecutionBundle.message((String)"select.applet.policy.file.dialog.title", (Object[])new Object[0]), null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.getHtmlPathComponent().addBrowseFolderListener(ExecutionBundle.message((String)"choose.html.file.dialog.title", (Object[])new Object[0]), null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        ClassBrowser.createAppletClassBrowser(this.myProject, this.myModuleSelector).setField((ComponentWithBrowseButton)this.getClassNameComponent());
        this.myHTMLOptions.setVisible(false);
        this.setAnchor((JComponent)this.myVMParameters.getLabel());
    }

    private void removeParameter() {
        TableUtil.removeSelectedItems((JTable)this.myTable);
    }

    private void addParameter() {
        ArrayList<AppletParameter> newItems = new ArrayList<AppletParameter>(this.myParameters.getItems());
        AppletParameter parameter = new AppletParameter("newParameter", "");
        newItems.add(parameter);
        this.myParameters.setItems(newItems);
        int index = newItems.size() - 1;
        this.myTable.getSelectionModel().setSelectionInterval(index, index);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(index, 0, true));
    }

    private ModulesComboBox getModuleComponent() {
        return (ModulesComboBox)this.myModule.getComponent();
    }

    private TextFieldWithBrowseButton getPolicyFileComponent() {
        return (TextFieldWithBrowseButton)this.myPolicyFile.getComponent();
    }

    private static List<AppletParameter> cloneParameters(@NotNull List<AppletParameter> items) {
        if (items == null) {
            AppletConfigurable.$$$reportNull$$$0(0);
        }
        SmartList params = new SmartList();
        for (AppletParameter appletParameter : items) {
            params.add(new AppletParameter(appletParameter.getName(), appletParameter.getValue()));
        }
        return params;
    }

    private JTextField getWidthComponent() {
        return this.myWidth;
    }

    private EditorTextFieldWithBrowseButton getClassNameComponent() {
        return this.myClassName;
    }

    private TextFieldWithBrowseButton getHtmlPathComponent() {
        return this.myHtmlFile;
    }

    private static String toSystemFormat(String s) {
        return (s = s.trim()).length() == 0 ? null : s.replace(File.separatorChar, '/');
    }

    public void applyEditorTo(@NotNull AppletConfiguration configuration) {
        if (configuration == null) {
            AppletConfigurable.$$$reportNull$$$0(1);
        }
        this.checkEditorData(configuration);
        this.myTable.stopEditing();
        configuration.getOptions().setAppletParameters(AppletConfigurable.cloneParameters(this.myParameters.getItems()));
    }

    public void resetEditorFrom(@NotNull AppletConfiguration runConfiguration) {
        if (runConfiguration == null) {
            AppletConfigurable.$$$reportNull$$$0(2);
        }
        AppletConfigurationOptions configuration = runConfiguration.getOptions();
        this.getClassNameComponent().setText(configuration.getMainClassName());
        String presentableHtmlName = configuration.getHtmlFileName();
        if (presentableHtmlName != null && !StringUtil.startsWithIgnoreCase((String)presentableHtmlName, (String)HTTP_PREFIX)) {
            presentableHtmlName = presentableHtmlName.replace('/', File.separatorChar);
        }
        this.getHtmlPathComponent().setText(presentableHtmlName);
        this.getPolicyFileComponent().setText(runConfiguration.getPolicyFile());
        this.getVMParametersComponent().setText(configuration.getVmParameters());
        this.getWidthComponent().setText(Integer.toString(configuration.getWidth()));
        this.getHeightComponent().setText(Integer.toString(configuration.getHeight()));
        (configuration.getHtmlUsed() ? this.myURL : this.myMainClass).setSelected(true);
        this.changePanel();
        this.myParameters.setItems(AppletConfigurable.cloneParameters(configuration.getAppletParameters()));
        this.myModuleSelector.reset(runConfiguration);
        this.myJrePathEditor.setPathOrName(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
    }

    private RawCommandLineEditor getVMParametersComponent() {
        return (RawCommandLineEditor)this.myVMParameters.getComponent();
    }

    private JTextField getHeightComponent() {
        return this.myHeight;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            AppletConfigurable.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void checkEditorData(@NotNull AppletConfiguration runConfiguration) {
        if (runConfiguration == null) {
            AppletConfigurable.$$$reportNull$$$0(4);
        }
        AppletConfigurationOptions configuration = runConfiguration.getOptions();
        runConfiguration.setMainClassName(this.getClassNameComponent().getText().trim());
        configuration.setHtmlFileName(AppletConfigurable.toSystemFormat(this.getHtmlPathComponent().getText()));
        configuration.setVmParameters(this.getVMParametersComponent().getText().trim());
        runConfiguration.setPolicyFile(this.getPolicyFileComponent().getText());
        this.myModuleSelector.applyTo(runConfiguration);
        try {
            configuration.setWidth(Integer.parseInt(this.getWidthComponent().getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            configuration.setHeight(Integer.parseInt(this.getHeightComponent().getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        configuration.setHtmlUsed(this.myURL.isSelected());
        configuration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        configuration.setAlternativeJrePathEnabled(this.myJrePathEditor.isAlternativeJreSelected());
    }

    private void createUIComponents() {
        this.myClassName = new EditorTextFieldWithBrowseButton(this.myProject, true);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModule.setAnchor(anchor);
        this.myPolicyFile.setAnchor(anchor);
        this.myVMParameters.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.myHtmlFileLabel.setAnchor(anchor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/applet/AppletConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/applet/AppletConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cloneParameters";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkEditorData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JrePathEditor jrePathEditor;
        JTextField jTextField;
        JLabel jLabel;
        JTextField jTextField2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel3;
        JPanel jPanel3;
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel4;
        this.createUIComponents();
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, null, null));
        this.myMainClass = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.class.option"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myURL = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.url.label"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPolicyFile = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent3.setLabelInsets(new Insets(0, 0, 0, 0));
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.policy.file.label"));
        jPanel4.add((Component)labeledComponent3, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myVMParameters = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        labeledComponent2.setLabelInsets(new Insets(0, 0, 0, 0));
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.vm.parameters.for.appletviewer.label"));
        jPanel4.add((Component)labeledComponent2, new GridConstraints(4, 0, 1, 1, 1, 1, 3, 0, null, new Dimension(400, -1), null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel4.add((Component)labeledComponent, new GridConstraints(5, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHTMLOptions = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        jPanel6.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 7, null, null, null));
        this.myHtmlFileLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.url.html.file.label"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHtmlFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 3, 3, 0, null, null, null));
        this.myClassOptions = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(true);
        jPanel2.putClientProperty("BorderFactoryClass", "");
        jPanel6.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel7, new GridConstraints(3, 0, 1, 2, 1, 1, 3, 0, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.parameters.label"), (int)0, (int)0, null, null));
        this.myTablePlace = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        this.myClassNameLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.class.label"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextFieldWithBrowseButton editorTextFieldWithBrowseButton = this.myClassName;
        editorTextFieldWithBrowseButton.setText("");
        jPanel2.add((Component)editorTextFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 3, 3, 0, null, null, null));
        this.myWidthLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.width.label"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWidth = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myHeightLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.height.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeight = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(50, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel4.add((Component)jSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 7, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel4.add((Component)((Object)jrePathEditor), new GridConstraints(6, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static abstract class MyColumnInfo
    extends ColumnInfo<AppletParameter, String> {
        public MyColumnInfo(String name2) {
            super(name2);
        }

        public TableCellEditor getEditor(AppletParameter item) {
            JTextField textField = new JTextField();
            textField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            return new DefaultCellEditor(textField);
        }

        public boolean isCellEditable(AppletParameter appletParameter) {
            return true;
        }
    }
}

