/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.remote;

import com.intellij.application.options.ModuleDescriptionsComboBox;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.ui.ConfigurationArgumentsHelpArea;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoteConfigurable
extends SettingsEditor<RemoteConfiguration> {
    JPanel myPanel;
    private JRadioButton myRbSocket;
    private JRadioButton myRbShmem;
    private JRadioButton myRbListen;
    private JRadioButton myRbAttach;
    private JTextField myAddressField;
    private JTextField myHostField;
    private IntegerField myPortField;
    private JPanel myShmemPanel;
    private JPanel mySocketPanel;
    private ConfigurationArgumentsHelpArea myHelpArea;
    private LabeledComponent<ModuleDescriptionsComboBox> myModule;
    private ComboBox<JDKVersionItem> myJDKVersion;
    private String myHostName = "";
    @NonNls
    protected static final String LOCALHOST = "localhost";
    private final ConfigurationModuleSelector myModuleSelector;

    public RemoteConfigurable(Project project2) {
        this.$$$setupUI$$$();
        this.myHelpArea.setLabelText(null);
        this.myHelpArea.setToolbarVisible();
        ButtonGroup transportGroup = new ButtonGroup();
        transportGroup.add(this.myRbSocket);
        transportGroup.add(this.myRbShmem);
        ButtonGroup connectionGroup = new ButtonGroup();
        connectionGroup.add(this.myRbListen);
        connectionGroup.add(this.myRbAttach);
        DocumentAdapter helpTextUpdater = new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myAddressField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myHostField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myPortField.getDocument().addDocumentListener((DocumentListener)helpTextUpdater);
        this.myRbSocket.setSelected(true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source.equals(RemoteConfigurable.this.myRbSocket)) {
                    RemoteConfigurable.this.myShmemPanel.setVisible(false);
                    RemoteConfigurable.this.mySocketPanel.setVisible(true);
                } else if (source.equals(RemoteConfigurable.this.myRbShmem)) {
                    RemoteConfigurable.this.myShmemPanel.setVisible(true);
                    RemoteConfigurable.this.mySocketPanel.setVisible(false);
                }
                RemoteConfigurable.this.myPanel.repaint();
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myRbShmem.addActionListener(listener);
        this.myRbSocket.addActionListener(listener);
        ItemListener updateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean isAttach = RemoteConfigurable.this.myRbAttach.isSelected();
                if (!isAttach && RemoteConfigurable.this.myHostField.isEditable()) {
                    RemoteConfigurable.this.myHostName = RemoteConfigurable.this.myHostField.getText();
                }
                RemoteConfigurable.this.myHostField.setEditable(isAttach);
                RemoteConfigurable.this.myHostField.setEnabled(isAttach);
                RemoteConfigurable.this.myHostField.setText(isAttach ? RemoteConfigurable.this.myHostName : RemoteConfigurable.LOCALHOST);
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myRbAttach.addItemListener(updateListener);
        this.myRbListen.addItemListener(updateListener);
        FocusAdapter fieldFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RemoteConfigurable.this.updateHelpText();
            }
        };
        this.myAddressField.addFocusListener(fieldFocusListener);
        this.myPortField.addFocusListener((FocusListener)fieldFocusListener);
        ((ModuleDescriptionsComboBox)this.myModule.getComponent()).allowEmptySelection("<whole project>");
        this.myModuleSelector = new ConfigurationModuleSelector(project2, (ModuleDescriptionsComboBox)this.myModule.getComponent());
        JavaSdkVersion version = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)ProjectRootManager.getInstance((Project)project2).getProjectSdk());
        boolean selected = false;
        for (JDKVersionItem value : JDKVersionItem.values()) {
            this.myJDKVersion.addItem((Object)value);
            if (selected || version == null || !version.isAtLeast(value.myVersion)) continue;
            this.myJDKVersion.setSelectedItem((Object)value);
            selected = true;
        }
        this.myJDKVersion.addItemListener(event -> this.updateHelpText());
    }

    public void applyEditorTo(@NotNull RemoteConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            RemoteConfigurable.$$$reportNull$$$0(0);
        }
        configuration.HOST = (this.myHostField.isEditable() ? this.myHostField.getText() : this.myHostName).trim();
        if (configuration.HOST != null && configuration.HOST.isEmpty()) {
            configuration.HOST = null;
        }
        configuration.PORT = this.myPortField.getText().trim();
        if (configuration.PORT != null && configuration.PORT.isEmpty()) {
            configuration.PORT = null;
        }
        configuration.SHMEM_ADDRESS = this.myAddressField.getText().trim();
        if (configuration.SHMEM_ADDRESS != null && configuration.SHMEM_ADDRESS.isEmpty()) {
            configuration.SHMEM_ADDRESS = null;
        }
        configuration.USE_SOCKET_TRANSPORT = this.myRbSocket.isSelected();
        if (configuration.USE_SOCKET_TRANSPORT) {
            this.myPortField.validateContent();
        }
        configuration.SERVER_MODE = this.myRbListen.isSelected();
        this.myModuleSelector.applyTo(configuration);
    }

    public void resetEditorFrom(@NotNull RemoteConfiguration configuration) {
        if (configuration == null) {
            RemoteConfigurable.$$$reportNull$$$0(1);
        }
        if (!SystemInfo.isWindows) {
            configuration.USE_SOCKET_TRANSPORT = true;
            this.myRbShmem.setEnabled(false);
            this.myAddressField.setEditable(false);
        }
        this.myAddressField.setText(configuration.SHMEM_ADDRESS);
        this.myHostName = configuration.HOST;
        this.myHostField.setText(configuration.HOST);
        this.myPortField.setText(configuration.PORT);
        if (configuration.USE_SOCKET_TRANSPORT) {
            this.myRbSocket.doClick();
        } else {
            this.myRbShmem.doClick();
        }
        if (configuration.SERVER_MODE) {
            this.myRbListen.doClick();
        } else {
            this.myRbAttach.doClick();
        }
        this.myRbShmem.setEnabled(SystemInfo.isWindows);
        this.myModuleSelector.reset(configuration);
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            RemoteConfigurable.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void updateHelpText() {
        boolean useSockets = !this.myRbShmem.isSelected();
        RemoteConnection connection = new RemoteConnection(useSockets, this.myHostName, useSockets ? this.myPortField.getText().trim() : this.myAddressField.getText().trim(), this.myRbListen.isSelected());
        this.myHelpArea.updateText(((JDKVersionItem)((Object)this.myJDKVersion.getSelectedItem())).getLaunchCommandLine(connection));
    }

    private void createUIComponents() {
        this.myPortField = new IntegerField("Port", 0, 65535);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/remote/RemoteConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/remote/RemoteConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        LabeledComponent labeledComponent;
        ConfigurationArgumentsHelpArea configurationArgumentsHelpArea;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JTextField jTextField;
        JPanel jPanel;
        JTextField jTextField2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.settings.border"), (int)0, (int)0, null, null));
        this.mySocketPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myHostField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.host.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.port.label"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        IntegerField integerField = this.myPortField;
        jPanel2.add((Component)integerField, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, new Dimension(150, -1), null));
        this.myShmemPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.shared.memory.address.label"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAddressField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.transport.label"));
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbSocket = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.socket.radio"));
        jPanel4.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbShmem = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.shared.memory.radio"));
        jPanel4.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.debugger.mode.label"));
        jPanel4.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbAttach = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.attach.radio"));
        jPanel4.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRbListen = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.listen.radio"));
        jPanel4.add((Component)jRadioButton, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myHelpArea = configurationArgumentsHelpArea = new ConfigurationArgumentsHelpArea();
        ((Component)configurationArgumentsHelpArea).setVisible(true);
        jPanel3.add((Component)configurationArgumentsHelpArea, new GridConstraints(1, 0, 1, 2, 9, 1, 3, 1, null, null, null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.application.options.ModuleDescriptionsComboBox");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Search sources using m&odule's classpath:");
        labeledComponent.setVisible(true);
        jPanel3.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/ExecutionBundle").getString("remote.configuration.remote.debugging.allows.you.to.connect.idea.to.a.running.jvm.label"));
        jPanel3.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJDKVersion = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static enum JDKVersionItem {
        JDK9(JavaSdkVersion.JDK_1_9){

            @Override
            String getLaunchCommandLine(RemoteConnection connection) {
                String commandLine = JDK5to8.getLaunchCommandLine(connection);
                if (connection.isUseSockets() && !connection.isServerMode()) {
                    commandLine = commandLine.replace(connection.getAddress(), "*:" + connection.getAddress());
                }
                return commandLine;
            }

            public String toString() {
                return "9 and after";
            }
        }
        ,
        JDK5to8(JavaSdkVersion.JDK_1_5){

            @Override
            String getLaunchCommandLine(RemoteConnection connection) {
                return connection.getLaunchCommandLine().replace("-Xdebug", "").replace("-Xrunjdwp:", "-agentlib:jdwp=").trim();
            }

            public String toString() {
                return "5 - 8";
            }
        }
        ,
        JDK1_4(JavaSdkVersion.JDK_1_4){

            @Override
            String getLaunchCommandLine(RemoteConnection connection) {
                return connection.getLaunchCommandLine();
            }

            public String toString() {
                return "1.4.x";
            }
        }
        ,
        JDK1_3(JavaSdkVersion.JDK_1_3){

            @Override
            String getLaunchCommandLine(RemoteConnection connection) {
                return "-Xnoagent -Djava.compiler=NONE " + connection.getLaunchCommandLine();
            }

            public String toString() {
                return "1.3.x or earlier";
            }
        };

        private final JavaSdkVersion myVersion;

        private JDKVersionItem(JavaSdkVersion version) {
            this.myVersion = version;
        }

        abstract String getLaunchCommandLine(RemoteConnection var1);
    }
}

