/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemNodeAction<T>
extends ExternalSystemAction {
    private final Class<T> myExternalDataClazz;

    public ExternalSystemNodeAction(Class<T> externalDataClazz) {
        this.myExternalDataClazz = externalDataClazz;
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        return super.isEnabled(e) && this.getSystemId(e) != null && this.getExternalData(e, this.myExternalDataClazz) != null;
    }

    protected abstract void perform(@NotNull Project var1, @NotNull ProjectSystemId var2, @NotNull T var3, @NotNull AnActionEvent var4);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ExternalSystemNodeAction.$$$reportNull$$$0(0);
        }
        if ((project2 = this.getProject(e)) == null) {
            return;
        }
        ProjectSystemId projectSystemId = this.getSystemId(e);
        if (projectSystemId == null) {
            return;
        }
        T data = this.getExternalData(e, this.myExternalDataClazz);
        if (data == null) {
            return;
        }
        this.perform(project2, projectSystemId, data, e);
    }

    @Nullable
    protected ExternalSystemUiAware getExternalSystemUiAware(AnActionEvent e) {
        return (ExternalSystemUiAware)ExternalSystemDataKeys.UI_AWARE.getData(e.getDataContext());
    }

    @Nullable
    protected <T> T getExternalData(AnActionEvent e, Class<T> dataClass) {
        ExternalSystemNode node = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext())));
        return node != null && dataClass.isInstance(node.getData()) ? (T)node.getData() : null;
    }

    protected boolean isIgnoredNode(AnActionEvent e) {
        ExternalSystemNode node = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext())));
        return node != null && this.myExternalDataClazz.isInstance(node.getData()) && node.isIgnored();
    }

    @Nullable
    protected VirtualFile getExternalConfig(@NotNull ExternalConfigPathAware data, ProjectSystemId externalSystemId) {
        if (data == null) {
            ExternalSystemNodeAction.$$$reportNull$$$0(1);
        }
        String path = data.getLinkedExternalProjectPath();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile externalSystemConfigPath = fileSystem.refreshAndFindFileByPath(path);
        if (externalSystemConfigPath == null) {
            return null;
        }
        VirtualFile toOpen = externalSystemConfigPath;
        for (ExternalSystemConfigLocator locator : (ExternalSystemConfigLocator[])ExternalSystemConfigLocator.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals((Object)locator.getTargetExternalSystemId())) continue;
            if ((toOpen = locator.adjust(toOpen)) != null) break;
            return null;
        }
        return toOpen.isDirectory() ? null : toOpen;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/ExternalSystemNodeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExternalConfig";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

