/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class RefreshAllExternalProjectsAction
extends AnAction
implements AnAction.TransparentUpdate {
    public RefreshAllExternalProjectsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.all.projects.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.all.projects.description", (Object[])new Object[]{"external"}));
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String name2 = StringUtil.join(systemIds, projectSystemId -> projectSystemId.getReadableName(), (String)",");
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.refresh.all.projects.text", (Object[])new Object[]{name2}));
        e.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.all.projects.description", (Object[])new Object[]{name2}));
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        e.getPresentation().setEnabled(!processingManager.hasTaskOfTypeInProgress(ExternalSystemTaskType.RESOLVE_PROJECT, project2));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (ProjectSystemId externalSystemId : systemIds) {
            ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project2, externalSystemId).forceWhenUptodate(true).use(ProgressExecutionMode.IN_BACKGROUND_ASYNC));
        }
    }

    private static List<ProjectSystemId> getSystemIds(AnActionEvent e) {
        ArrayList systemIds = ContainerUtil.newArrayList();
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        if (externalSystemId != null) {
            systemIds.add(externalSystemId);
        } else {
            for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                systemIds.add(manager.getSystemId());
            }
        }
        return systemIds;
    }
}

