/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemSettingsControlCustomizer;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectSettingsControl<S extends ExternalProjectSettings>
implements ExternalSystemSettingsControl<S> {
    @Nullable
    private Project myProject;
    @NotNull
    private final S myInitialSettings;
    @Nullable
    private JBCheckBox myUseAutoImportBox;
    @Nullable
    private JBCheckBox myCreateEmptyContentRootDirectoriesBox;
    private JBRadioButton myUseQualifiedModuleNamesRadioButton;
    private JBRadioButton myUseModuleGroupsRadioButton;
    @NotNull
    private final ExternalSystemSettingsControlCustomizer myCustomizer;

    protected AbstractExternalProjectSettingsControl(@NotNull S initialSettings) {
        if (initialSettings == null) {
            AbstractExternalProjectSettingsControl.$$$reportNull$$$0(0);
        }
        this(null, initialSettings, null);
    }

    protected AbstractExternalProjectSettingsControl(@Nullable Project project2, @NotNull S initialSettings, @Nullable ExternalSystemSettingsControlCustomizer controlCustomizer) {
        if (initialSettings == null) {
            AbstractExternalProjectSettingsControl.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myInitialSettings = initialSettings;
        this.myCustomizer = controlCustomizer == null ? new ExternalSystemSettingsControlCustomizer() : controlCustomizer;
    }

    @NotNull
    public S getInitialSettings() {
        S s = this.myInitialSettings;
        if (s == null) {
            AbstractExternalProjectSettingsControl.$$$reportNull$$$0(2);
        }
        return s;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        if (canvas == null) {
            AbstractExternalProjectSettingsControl.$$$reportNull$$$0(3);
        }
        if (!this.myCustomizer.isUseAutoImportBoxHidden()) {
            this.myUseAutoImportBox = new JBCheckBox(ExternalSystemBundle.message((String)"settings.label.use.auto.import", (Object[])new Object[0]));
            canvas.add((Component)this.myUseAutoImportBox, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden()) {
            this.myCreateEmptyContentRootDirectoriesBox = new JBCheckBox(ExternalSystemBundle.message((String)"settings.label.create.empty.content.root.directories", (Object[])new Object[0]));
            canvas.add((Component)this.myCreateEmptyContentRootDirectoriesBox, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        }
        JPanel organizeModuleNamesPanel = new JPanel(new FlowLayout(0));
        organizeModuleNamesPanel.add((Component)new JBLabel(ExternalSystemBundle.message((String)"settings.label.group.modules", (Object[])new Object[0])));
        this.myUseModuleGroupsRadioButton = new JBRadioButton(ExternalSystemBundle.message((String)"settings.radio.button.use.module.groups", (Object[])new Object[0]), true);
        organizeModuleNamesPanel.add((Component)this.myUseModuleGroupsRadioButton);
        this.myUseQualifiedModuleNamesRadioButton = new JBRadioButton(ExternalSystemBundle.message((String)"settings.radio.button.use.qualified.name", (Object[])new Object[0]));
        organizeModuleNamesPanel.add((Component)this.myUseQualifiedModuleNamesRadioButton);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myUseModuleGroupsRadioButton);
        group.add((AbstractButton)this.myUseQualifiedModuleNamesRadioButton);
        canvas.add((Component)organizeModuleNamesPanel, ExternalSystemUiUtil.getFillLineConstraints(indentLevel));
        this.fillExtraControls(canvas, indentLevel);
    }

    protected abstract void fillExtraControls(@NotNull PaintAwarePanel var1, int var2);

    @Override
    public boolean isModified() {
        boolean result = false;
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            boolean bl = result = this.myUseAutoImportBox.isSelected() != this.getInitialSettings().isUseAutoImport();
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            result = result || this.myCreateEmptyContentRootDirectoriesBox.isSelected() != this.getInitialSettings().isCreateEmptyContentRootDirectories();
        }
        return (result |= this.myUseQualifiedModuleNamesRadioButton.isSelected() != this.getInitialSettings().isUseQualifiedModuleNames()) || this.isExtraSettingModified();
    }

    protected abstract boolean isExtraSettingModified();

    @Override
    public void reset() {
        this.reset(false);
    }

    @Override
    public void reset(@Nullable WizardContext wizardContext) {
        this.reset(false, wizardContext);
    }

    public void reset(boolean isDefaultModuleCreation) {
        this.reset(isDefaultModuleCreation, null);
    }

    public void reset(boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext) {
        boolean useQualifiedModuleNames;
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            this.myUseAutoImportBox.setSelected(this.getInitialSettings().isUseAutoImport());
        }
        if (isDefaultModuleCreation && this.myCreateEmptyContentRootDirectoriesBox != null) {
            this.myCreateEmptyContentRootDirectoriesBox.getParent().remove((Component)this.myCreateEmptyContentRootDirectoriesBox);
            this.myCreateEmptyContentRootDirectoriesBox = null;
        }
        if (!isDefaultModuleCreation && !this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            this.myCreateEmptyContentRootDirectoriesBox.setSelected(this.getInitialSettings().isCreateEmptyContentRootDirectories());
        }
        this.myUseModuleGroupsRadioButton.setSelected(!(useQualifiedModuleNames = this.getInitialSettings().isUseQualifiedModuleNames()));
        this.myUseQualifiedModuleNamesRadioButton.setSelected(useQualifiedModuleNames);
        this.resetExtraSettings(isDefaultModuleCreation, wizardContext);
    }

    protected abstract void resetExtraSettings(boolean var1);

    protected void resetExtraSettings(boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext) {
        this.resetExtraSettings(isDefaultModuleCreation);
    }

    @Override
    public void apply(@NotNull S settings) {
        if (settings == null) {
            AbstractExternalProjectSettingsControl.$$$reportNull$$$0(4);
        }
        settings.setModules(this.myInitialSettings.getModules());
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            settings.setUseAutoImport(this.myUseAutoImportBox.isSelected());
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            settings.setCreateEmptyContentRootDirectories(this.myCreateEmptyContentRootDirectoriesBox.isSelected());
        }
        if (this.myInitialSettings.getExternalProjectPath() != null) {
            settings.setExternalProjectPath(this.myInitialSettings.getExternalProjectPath());
        }
        settings.setUseQualifiedModuleNames(this.myUseQualifiedModuleNamesRadioButton.isSelected());
        this.applyExtraSettings(settings);
    }

    protected abstract void applyExtraSettings(@NotNull S var1);

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi(this, show);
    }

    public void updateInitialSettings() {
        if (!this.myCustomizer.isUseAutoImportBoxHidden() && this.myUseAutoImportBox != null) {
            this.myInitialSettings.setUseAutoImport(this.myUseAutoImportBox.isSelected());
        }
        if (!this.myCustomizer.isCreateEmptyContentRootDirectoriesBoxHidden() && this.myCreateEmptyContentRootDirectoriesBox != null) {
            this.myInitialSettings.setCreateEmptyContentRootDirectories(this.myCreateEmptyContentRootDirectoriesBox.isSelected());
        }
        this.myInitialSettings.setUseQualifiedModuleNames(this.myUseQualifiedModuleNamesRadioButton.isSelected());
        this.updateInitialExtraSettings();
    }

    protected void updateInitialExtraSettings() {
    }

    public void setCurrentProject(@Nullable Project project2) {
        this.myProject = project2;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canvas";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/settings/AbstractExternalProjectSettingsControl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillUi";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

