/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddNewLibraryDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.classpath.ChooseLibrariesDialogBase;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureChooseLibrariesDialog
extends ChooseLibrariesFromTablesDialog {
    private final ClasspathPanel myClasspathPanel;
    private final StructureConfigurableContext myContext;
    private final Predicate<Library> myAcceptedLibraries;
    private final List<Library> myCreatedModuleLibraries = new ArrayList<Library>();
    private JButton myCreateLibraryButton;

    public ProjectStructureChooseLibrariesDialog(ClasspathPanel classpathPanel, StructureConfigurableContext context, Predicate<Library> acceptedLibraries) {
        super(classpathPanel.getComponent(), "Choose Libraries", classpathPanel.getProject(), true);
        this.myClasspathPanel = classpathPanel;
        this.myContext = context;
        this.myAcceptedLibraries = acceptedLibraries;
        this.setOKButtonText("Add Selected");
        this.init();
    }

    @Override
    protected void doOKAction() {
        super.doOKAction();
        this.removeCreatedModuleLibraries(this.getSelectedLibraries());
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeCreatedModuleLibraries(Collections.emptyList());
    }

    private void removeCreatedModuleLibraries(Collection<Library> selected) {
        for (Library library : this.myCreatedModuleLibraries) {
            if (selected.contains(library)) continue;
            this.myClasspathPanel.getRootModel().getModuleLibraryTable().removeLibrary(library);
        }
    }

    @Override
    protected void collectChildren(Object element, List<Object> result) {
        if (element instanceof Application && !this.myCreatedModuleLibraries.isEmpty()) {
            result.add(this.myClasspathPanel.getRootModel().getModuleLibraryTable());
        }
        super.collectChildren(element, result);
    }

    @Override
    @NotNull
    protected Library[] getLibraries(@NotNull LibraryTable table) {
        if (table == null) {
            ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(0);
        }
        if (table.getTableLevel().equals("module")) {
            Library[] libraryArray = this.myCreatedModuleLibraries.toArray(Library.EMPTY_ARRAY);
            if (libraryArray == null) {
                ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(1);
            }
            return libraryArray;
        }
        LibrariesModifiableModel model = this.getLibrariesModifiableModel(table);
        if (model == null) {
            if (Library.EMPTY_ARRAY == null) {
                ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(2);
            }
            return Library.EMPTY_ARRAY;
        }
        Library[] libraryArray = model.getLibraries();
        if (libraryArray == null) {
            ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(3);
        }
        return libraryArray;
    }

    @Nullable
    private LibrariesModifiableModel getLibrariesModifiableModel(LibraryTable table) {
        return table != null ? this.myContext.myLevel2Providers.get(table.getTableLevel()) : null;
    }

    @Override
    protected boolean acceptsElement(Object element) {
        if (element instanceof Library) {
            Library library = (Library)element;
            return this.myAcceptedLibraries.apply((Object)library);
        }
        return true;
    }

    @NotNull
    private String getLibraryName(@NotNull Library library) {
        LibrariesModifiableModel model;
        if (library == null) {
            ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(4);
        }
        if ((model = this.getLibrariesModifiableModel(library.getTable())) != null && model.hasLibraryEditor(library)) {
            String string = model.getLibraryEditor(library).getName();
            if (string == null) {
                ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = library.getName();
        if (string == null) {
            ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected Action[] createActions() {
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getCancelAction(), new CreateNewLibraryAction(), this.getOKAction()};
            if (actionArray == null) {
                ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(7);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), new CreateNewLibraryAction(), this.getCancelAction()};
        if (actionArray == null) {
            ProjectStructureChooseLibrariesDialog.$$$reportNull$$$0(8);
        }
        return actionArray;
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action instanceof CreateNewLibraryAction) {
            this.myCreateLibraryButton = button;
        }
        return button;
    }

    @Override
    protected ChooseLibrariesDialogBase.LibrariesTreeNodeBase<Library> createLibraryDescriptor(NodeDescriptor parentDescriptor, Library library) {
        String libraryName = this.getLibraryName(library);
        return new LibraryEditorDescriptor(this.getProject(), parentDescriptor, library, libraryName, this.myContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CreateNewLibraryAction
    extends DialogWrapper.DialogWrapperAction {
        private CreateNewLibraryAction() {
            super((DialogWrapper)ProjectStructureChooseLibrariesDialog.this, "New Library...");
            this.putValue("MnemonicKey", 78);
        }

        protected void doAction(ActionEvent e) {
            AddNewLibraryDependencyAction.chooseTypeAndCreate(ProjectStructureChooseLibrariesDialog.this.myClasspathPanel, ProjectStructureChooseLibrariesDialog.this.myContext, ProjectStructureChooseLibrariesDialog.this.myCreateLibraryButton, new AddNewLibraryDependencyAction.LibraryCreatedCallback(){

                @Override
                public void libraryCreated(@NotNull Library library) {
                    if (library == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (library.getTable() == null) {
                        ProjectStructureChooseLibrariesDialog.this.myCreatedModuleLibraries.add(library);
                    }
                    ProjectStructureChooseLibrariesDialog.this.queueUpdateAndSelect(library);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/classpath/ProjectStructureChooseLibrariesDialog$CreateNewLibraryAction$1", "libraryCreated"));
                }
            });
        }
    }

    private static class LibraryEditorDescriptor
    extends ChooseLibrariesDialogBase.LibrariesTreeNodeBase<Library> {
        protected LibraryEditorDescriptor(Project project2, NodeDescriptor parentDescriptor, Library element, String libraryName, StructureConfigurableContext context) {
            super(project2, parentDescriptor, element);
            PresentationData templatePresentation = this.getTemplatePresentation();
            Icon icon = LibraryPresentationManager.getInstance().getNamedLibraryIcon(element, context);
            templatePresentation.setIcon(icon);
            templatePresentation.addText(libraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

