/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.module;

import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.CreateFromSourcesMode;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.module.CloudModuleBuilder;
import com.intellij.remoteServer.impl.module.CloudModuleBuilderContribution;
import com.intellij.remoteServer.impl.module.CloudSourceApplicationConfigurable;
import com.intellij.remoteServer.impl.module.CloudSourceApplicationConfiguration;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.CloudRunConfigurationUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.SshKeyChecker;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudModuleBuilderSourceContribution<SC extends CloudConfigurationBase, DC extends CloudDeploymentNameConfiguration, AC extends CloudSourceApplicationConfiguration, SR extends CloudMultiSourceServerRuntimeInstance<DC, ?, ?, ?>>
extends CloudModuleBuilderContribution {
    private CloudNotifier myNotifier;

    public CloudModuleBuilderSourceContribution(CloudModuleBuilder moduleBuilder, ServerType<SC> cloudType) {
        super(moduleBuilder, cloudType);
    }

    @Override
    public void configureModule(final Module module2) {
        final CloudModuleBuilder moduleBuilder = this.getModuleBuilder();
        RemoteServer<?> account = moduleBuilder.getAccount();
        final CloudSourceApplicationConfiguration applicationConfiguration = (CloudSourceApplicationConfiguration)moduleBuilder.getApplicationConfiguration();
        DC deploymentConfiguration = this.createDeploymentConfiguration();
        if (applicationConfiguration.isExisting()) {
            deploymentConfiguration.setDefaultDeploymentName(false);
            deploymentConfiguration.setDeploymentName(applicationConfiguration.getExistingAppName());
        }
        final DeployToServerRunConfiguration runConfiguration = CloudRunConfigurationUtil.createRunConfiguration(account, (Module)module2, deploymentConfiguration);
        ServerType cloudType = account.getType();
        final Project project2 = module2.getProject();
        new CloudConnectionTask<Object, SC, DC, SR>(project2, CloudBundle.getText((String)"cloud.support", (Object[])new Object[]{cloudType.getPresentableName()}), account){
            boolean myFirstAttempt;
            {
                super(arg0, arg1, arg2);
                this.myFirstAttempt = true;
            }

            protected Object run(SR serverRuntime) throws ServerRuntimeException {
                CloudModuleBuilderSourceContribution.this.doConfigureModule(applicationConfiguration, runConfiguration, this.myFirstAttempt, serverRuntime);
                return null;
            }

            protected void runtimeErrorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myFirstAttempt = false;
                new SshKeyChecker().checkServerError(errorMessage, CloudModuleBuilderSourceContribution.this.getNotifier(), project2, (CloudConnectionTask)this);
            }

            protected void postPerform(Object result) {
                CloudModuleBuilderSourceContribution.this.detectModuleStructure(module2, moduleBuilder.getContentEntryPath());
            }

            protected boolean shouldStartInBackground() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/remoteServer/impl/module/CloudModuleBuilderSourceContribution$1", "runtimeErrorOccurred"));
            }
        }.performAsync();
    }

    private CloudNotifier getNotifier() {
        if (this.myNotifier == null) {
            this.myNotifier = new CloudNotifier(this.getCloudType().getPresentableName());
        }
        return this.myNotifier;
    }

    private void detectModuleStructure(Module module2, final String contentPath) {
        final CreateFromSourcesMode mode = new CreateFromSourcesMode(){

            @Override
            public boolean isAvailable(WizardContext context) {
                return true;
            }

            @Override
            public void addSteps(WizardContext context, ModulesProvider modulesProvider, StepSequence sequence, String specific) {
                super.addSteps(context, modulesProvider, sequence, specific);
                this.myProjectBuilder.setFileToImport(contentPath);
            }
        };
        final Project project2 = module2.getProject();
        final WizardContext context = new WizardContext(project2);
        final StepSequence stepSequence = mode.getSteps(context, DefaultModulesProvider.createForProject((Project)context.getProject()));
        if (stepSequence == null) {
            return;
        }
        Disposer.register((Disposable)project2, (Disposable)new Disposable(){

            public void dispose() {
                for (ModuleWizardStep step : stepSequence.getAllSteps()) {
                    step.disposeUIResources();
                }
            }
        });
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, CloudBundle.getText((String)"detect.module.structure", (Object[])new Object[]{this.getCloudType().getPresentableName()}), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                ModuleWizardStep step = (ModuleWizardStep)ContainerUtil.getFirstItem(stepSequence.getSelectedSteps());
                while (step != null) {
                    if (step instanceof AbstractStepWithProgress) {
                        ((AbstractStepWithProgress)step).performStep();
                    } else {
                        step.updateDataModel();
                    }
                    step = stepSequence.getNextStep(step);
                }
                CloudAccountSelectionEditor.unsetAccountOnContext((WizardContext)context, CloudModuleBuilderSourceContribution.this.getCloudType());
            }

            public boolean shouldStartInBackground() {
                return false;
            }

            public void onSuccess() {
                ProjectBuilder moduleBuilder = mode.getModuleBuilder();
                if (moduleBuilder == null) {
                    return;
                }
                moduleBuilder.commit(project2);
                CloudModuleBuilderSourceContribution.this.getNotifier().showMessage(CloudBundle.getText((String)"cloud.support.added", (Object[])new Object[]{CloudModuleBuilderSourceContribution.this.getCloudType().getPresentableName()}), MessageType.INFO);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/remoteServer/impl/module/CloudModuleBuilderSourceContribution$4", "run"));
            }
        });
    }

    @Override
    protected abstract CloudSourceApplicationConfigurable<SC, DC, SR, AC> createApplicationConfigurable(@Nullable Project var1, Disposable var2);

    protected abstract DC createDeploymentConfiguration();

    protected abstract void doConfigureModule(AC var1, DeployToServerRunConfiguration<SC, DC> var2, boolean var3, SR var4) throws ServerRuntimeException;
}

