/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchProfileBase;
import com.intellij.structuralsearch.XmlStructuralSearchProfile;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchUtil {
    private static final String REG_EXP_META_CHARS = ".$|()[]{}^?*+\\";
    private static final Key<StructuralSearchProfile> STRUCTURAL_SEARCH_PROFILE_KEY = new Key("Structural Search Profile");
    private static LanguageFileType ourDefaultFileType = null;
    public static boolean ourUseUniversalMatchingAlgorithm = false;
    private static StructuralSearchProfile[] ourNewStyleProfiles;
    private static List<Configuration> ourPredefinedConfigurations;

    private StructuralSearchUtil() {
    }

    @Nullable
    public static StructuralSearchProfile getProfileByPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchUtil.$$$reportNull$$$0(0);
        }
        return StructuralSearchUtil.getProfileByLanguage(element.getLanguage());
    }

    @Contract(value="null -> false")
    public static boolean isIdentifier(PsiElement element) {
        if (element == null) {
            return false;
        }
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile2 != null && profile2.isIdentifier(element);
    }

    public static PsiElement getParentIfIdentifier(PsiElement element) {
        return !StructuralSearchUtil.isIdentifier(element) ? element : element.getParent();
    }

    @NotNull
    public static PsiElement getPresentableElement(@NotNull PsiElement element) {
        StructuralSearchProfile profile2;
        if (element == null) {
            StructuralSearchUtil.$$$reportNull$$$0(1);
        }
        if ((profile2 = StructuralSearchUtil.getProfileByPsiElement(element)) == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                StructuralSearchUtil.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        PsiElement psiElement = profile2.getPresentableElement(element);
        if (psiElement == null) {
            StructuralSearchUtil.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    private static StructuralSearchProfile[] getNewStyleProfiles() {
        if (ourNewStyleProfiles == null) {
            ArrayList<StructuralSearchProfile> list = new ArrayList<StructuralSearchProfile>();
            for (StructuralSearchProfile profile2 : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions()) {
                if (!(profile2 instanceof StructuralSearchProfileBase)) continue;
                list.add(profile2);
            }
            list.add(new XmlStructuralSearchProfile());
            ourNewStyleProfiles = list.toArray(new StructuralSearchProfile[0]);
        }
        return ourNewStyleProfiles;
    }

    private static StructuralSearchProfile[] getProfiles() {
        return ourUseUniversalMatchingAlgorithm ? StructuralSearchUtil.getNewStyleProfiles() : (StructuralSearchProfile[])StructuralSearchProfile.EP_NAME.getExtensions();
    }

    public static FileType getDefaultFileType() {
        if (ourDefaultFileType == null) {
            for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
                ourDefaultFileType = profile2.getDefaultFileType(ourDefaultFileType);
            }
            if (ourDefaultFileType == null) {
                ourDefaultFileType = StdFileTypes.XML;
            }
        }
        assert (ourDefaultFileType instanceof LanguageFileType) : "file type not valid for structural search: " + ourDefaultFileType.getName();
        return ourDefaultFileType;
    }

    public static void clearProfileCache(@NotNull Language language) {
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(4);
        }
        language.putUserData(STRUCTURAL_SEARCH_PROFILE_KEY, null);
    }

    @Nullable
    public static StructuralSearchProfile getProfileByLanguage(@NotNull Language language) {
        StructuralSearchProfile cachedProfile;
        if (language == null) {
            StructuralSearchUtil.$$$reportNull$$$0(5);
        }
        if ((cachedProfile = (StructuralSearchProfile)language.getUserData(STRUCTURAL_SEARCH_PROFILE_KEY)) != null) {
            return cachedProfile;
        }
        for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
            if (!profile2.isMyLanguage(language)) continue;
            language.putUserData(STRUCTURAL_SEARCH_PROFILE_KEY, (Object)profile2);
            return profile2;
        }
        return null;
    }

    public static boolean isTypedVariable(@NotNull String name2) {
        if (name2 == null) {
            StructuralSearchUtil.$$$reportNull$$$0(6);
        }
        return name2.length() > 1 && name2.charAt(0) == '$' && name2.charAt(name2.length() - 1) == '$';
    }

    @Nullable
    public static StructuralSearchProfile getProfileByFileType(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        LanguageFileType languageFileType = (LanguageFileType)fileType;
        return StructuralSearchUtil.getProfileByLanguage(languageFileType.getLanguage());
    }

    @NotNull
    public static FileType[] getSuitableFileTypes() {
        HashSet<LanguageFileType> allFileTypes = new HashSet<LanguageFileType>();
        Collections.addAll(allFileTypes, FileTypeManager.getInstance().getRegisteredFileTypes());
        for (Language language : Language.getRegisteredLanguages()) {
            LanguageFileType fileType = language.getAssociatedFileType();
            if (fileType == null) continue;
            allFileTypes.add(fileType);
        }
        ArrayList<LanguageFileType> result = new ArrayList<LanguageFileType>();
        for (LanguageFileType fileType : allFileTypes) {
            if (!(fileType instanceof LanguageFileType)) continue;
            result.add(fileType);
        }
        FileType[] fileTypeArray = result.toArray(FileType.EMPTY_ARRAY);
        if (fileTypeArray == null) {
            StructuralSearchUtil.$$$reportNull$$$0(7);
        }
        return fileTypeArray;
    }

    public static boolean containsRegExpMetaChar(String s) {
        return s.chars().anyMatch(StructuralSearchUtil::isRegExpMetaChar);
    }

    private static boolean isRegExpMetaChar(int ch) {
        return REG_EXP_META_CHARS.indexOf(ch) >= 0;
    }

    public static String shieldRegExpMetaChars(String word) {
        StringBuilder buf = new StringBuilder(word.length());
        for (int i = 0; i < word.length(); ++i) {
            if (StructuralSearchUtil.isRegExpMetaChar(word.charAt(i))) {
                buf.append("\\");
            }
            buf.append(word.charAt(i));
        }
        return buf.toString();
    }

    public static List<Configuration> getPredefinedTemplates() {
        if (ourPredefinedConfigurations == null) {
            ArrayList result = new ArrayList();
            for (StructuralSearchProfile profile2 : StructuralSearchUtil.getProfiles()) {
                Collections.addAll(result, profile2.getPredefinedTemplates());
            }
            Collections.sort(result);
            ourPredefinedConfigurations = Collections.unmodifiableList(result);
        }
        return ourPredefinedConfigurations;
    }

    public static boolean isDocCommentOwner(PsiElement match) {
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(match);
        return profile2 != null && profile2.isDocCommentOwner(match);
    }

    public static Class getElementContextByPsi(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        StructuralSearchProfile profile2 = StructuralSearchUtil.getProfileByPsiElement(element);
        return profile2 == null ? element.getClass() : profile2.getElementContextByPsi(element);
    }

    static {
        ourPredefinedConfigurations = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByPsiElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearProfileCache";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProfileByLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTypedVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

