/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.plugin.StructuralReplaceAction;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.util.Producer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIUtil {
    private static final String MODIFY_EDITOR_CONTENT = SSRBundle.message("modify.editor.content.command.name", new Object[0]);
    @NonNls
    private static final String SS_GROUP = "structuralsearchgroup";

    @NotNull
    public static Editor createEditor(Document doc, Project project2, boolean editable, @Nullable TemplateContextType contextType) {
        Editor editor = UIUtil.createEditor(doc, project2, editable, false, contextType);
        if (editor == null) {
            UIUtil.$$$reportNull$$$0(0);
        }
        return editor;
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project2, boolean editable, boolean addToolTipForVariableHandler, @Nullable TemplateContextType contextType) {
        if (doc == null) {
            UIUtil.$$$reportNull$$$0(1);
        }
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project2) : EditorFactory.getInstance().createViewer(doc, project2);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color c = globalScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (c == null) {
                c = globalScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(c);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)contextType);
        if (addToolTipForVariableHandler) {
            SubstitutionShortInfoHandler.install(editor);
        }
        Editor editor2 = editor;
        if (editor2 == null) {
            UIUtil.$$$reportNull$$$0(2);
        }
        return editor2;
    }

    public static JComponent createOptionLine(JComponent[] options) {
        JPanel tmp = new JPanel();
        tmp.setLayout(new BoxLayout(tmp, 0));
        for (int i = 0; i < options.length; ++i) {
            if (i != 0) {
                tmp.add(Box.createHorizontalStrut(10));
            }
            tmp.add(options[i]);
        }
        tmp.add(Box.createHorizontalGlue());
        return tmp;
    }

    public static JComponent createOptionLine(JComponent option) {
        return UIUtil.createOptionLine(new JComponent[]{option});
    }

    public static void setContent(Editor editor, String text) {
        String value = text != null ? text : "";
        CommandProcessor.getInstance().executeCommand(editor.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> editor.getDocument().replaceString(0, editor.getDocument().getTextLength(), (CharSequence)value)), MODIFY_EDITOR_CONTENT, (Object)SS_GROUP);
    }

    public static void invokeAction(Configuration config, SearchContext context) {
        if (config instanceof SearchConfiguration) {
            StructuralSearchAction.triggerAction(config, context);
        } else {
            StructuralReplaceAction.triggerAction(config, context);
        }
    }

    public static void updateHighlighter(Editor editor, StructuralSearchProfile profile2) {
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)profile2.getTemplateContextType());
    }

    public static MatchVariableConstraint getOrAddVariableConstraint(String varName, Configuration configuration) {
        MatchVariableConstraint varInfo = configuration.getMatchOptions().getVariableConstraint(varName);
        if (varInfo == null) {
            varInfo = new MatchVariableConstraint();
            varInfo.setName(varName);
            configuration.getMatchOptions().addVariableConstraint(varInfo);
        }
        return varInfo;
    }

    public static boolean isTarget(String varName, MatchOptions matchOptions) {
        if ("__context__".equals(varName)) {
            for (String name2 : matchOptions.getVariableConstraintNames()) {
                if (name2.equals("__context__") || !matchOptions.getVariableConstraint(name2).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint constraint = matchOptions.getVariableConstraint(varName);
        if (constraint == null) {
            return false;
        }
        return constraint.isPartOfSearchResults();
    }

    @NotNull
    public static JComponent createCompleteMatchInfo(final Producer<Configuration> configurationProducer) {
        JLabel completeMatchInfo = new JLabel(AllIcons.RunConfigurations.Variables);
        Point location = completeMatchInfo.getLocation();
        final JLabel label = new JLabel(SSRBundle.message("complete.match.variable.tooltip.message", SSRBundle.message("no.constraints.specified.tooltip.message", new Object[0])));
        final IdeTooltip tooltip = new IdeTooltip((Component)completeMatchInfo, location, (JComponent)label, new Object[0]);
        tooltip.setPreferredPosition(Balloon.Position.atRight).setCalloutShift(6).setHint(true).setExplicitClose(true);
        completeMatchInfo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Configuration configuration = (Configuration)configurationProducer.produce();
                if (configuration == null) {
                    return;
                }
                MatchOptions matchOptions = configuration.getMatchOptions();
                MatchVariableConstraint constraint = UIUtil.getOrAddVariableConstraint("__context__", configuration);
                if (UIUtil.isTarget("__context__", matchOptions)) {
                    constraint.setPartOfSearchResults(true);
                }
                label.setText(SSRBundle.message("complete.match.variable.tooltip.message", SubstitutionShortInfoHandler.getShortParamString(constraint)));
                IdeTooltipManager.getInstance().show(tooltip, true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                IdeTooltipManager.getInstance().hide(tooltip);
            }
        });
        JLabel jLabel = completeMatchInfo;
        if (jLabel == null) {
            UIUtil.$$$reportNull$$$0(3);
        }
        return jLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompleteMatchInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

