/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.lang.Language;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.RegExp;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public abstract class UsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA;
    private static final String DEFAULT_SETTINGS_EXTERNALIZED;
    private static final String ORIGINAL_TEMP_DIR;
    private static final Map<String, Long> TOTAL_SETUP_COST_MILLIS;
    private static final Map<String, Long> TOTAL_TEARDOWN_COST_MILLIS;
    protected static final Logger LOG;
    @NotNull
    private final Disposable myTestRootDisposable = new TestDisposable();
    static String ourPathToKeep;
    private final List<String> myPathsToKeep = new ArrayList<String>();
    private CodeStyleSettings myOldCodeStyleSettings;
    private String myTempDir;
    static final Key<String> CREATION_PLACE;
    private static final Set<String> DELETE_ON_EXIT_HOOK_DOT_FILES;
    private static final Class DELETE_ON_EXIT_HOOK_CLASS;
    @Deprecated
    public static final String IDEA_MARKER_CLASS = "com.intellij.openapi.roots.IdeaModifiableModelsProvider";

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.shouldContainTempFiles()) {
            String testName = FileUtil.sanitizeFileName((String)this.getTestName(true));
            if (StringUtil.isEmptyOrSpaces((String)testName)) {
                testName = "";
            }
            testName = new File(testName).getName();
            this.myTempDir = new File(ORIGINAL_TEMP_DIR, TEMP_DIR_MARKER + testName).getPath();
            FileUtil.resetCanonicalTempPathCache((String)this.myTempDir);
        }
        boolean isStressTest = this.isStressTest();
        ApplicationInfoImpl.setInStressTest((boolean)isStressTest);
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        Disposer.setDebugMode((!isStressTest ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        try {
            new RunAll(() -> this.disposeRootDisposable(), () -> UsefulTestCase.cleanupSwingDataStructures(), () -> UsefulTestCase.cleanupDeleteOnExitHookList(), () -> Disposer.setDebugMode((boolean)true), () -> {
                if (this.shouldContainTempFiles()) {
                    FileUtil.resetCanonicalTempPathCache((String)ORIGINAL_TEMP_DIR);
                    if (this.hasTmpFilesToKeep()) {
                        File[] files = new File(this.myTempDir).listFiles();
                        if (files != null) {
                            for (File file : files) {
                                if (this.shouldKeepTmpFile(file)) continue;
                                FileUtil.delete((File)file);
                            }
                        }
                    } else {
                        FileUtil.delete((File)new File(this.myTempDir));
                    }
                }
            }, () -> UIUtil.removeLeakingAppleListeners()).run();
        }
        finally {
            super.tearDown();
        }
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull File file) {
        if (file == null) {
            UsefulTestCase.$$$reportNull$$$0(0);
        }
        this.myPathsToKeep.add(file.getPath());
    }

    private boolean hasTmpFilesToKeep() {
        return ourPathToKeep != null && FileUtil.isAncestor((String)this.myTempDir, (String)ourPathToKeep, (boolean)false) || !this.myPathsToKeep.isEmpty();
    }

    private boolean shouldKeepTmpFile(@NotNull File file) {
        String path;
        if (file == null) {
            UsefulTestCase.$$$reportNull$$$0(1);
        }
        if (FileUtil.pathsEqual((String)(path = file.getPath()), (String)ourPathToKeep)) {
            return true;
        }
        for (String pathToKeep : this.myPathsToKeep) {
            if (!FileUtil.pathsEqual((String)path, (String)pathToKeep)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupDeleteOnExitHookList() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        ArrayList<String> list;
        Class clazz = DELETE_ON_EXIT_HOOK_CLASS;
        synchronized (clazz) {
            if (DELETE_ON_EXIT_HOOK_DOT_FILES.isEmpty()) {
                return;
            }
            list = new ArrayList<String>(DELETE_ON_EXIT_HOOK_DOT_FILES);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String path = (String)list.get(i);
            File file = new File(path);
            if (!file.delete() && file.exists()) continue;
            Class clazz2 = DELETE_ON_EXIT_HOOK_CLASS;
            synchronized (clazz2) {
                DELETE_ON_EXIT_HOOK_DOT_FILES.remove(path);
                continue;
            }
        }
    }

    private static void cleanupSwingDataStructures() throws Exception {
        Object manager = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map componentKeyStrokeMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"componentKeyStrokeMap");
        componentKeyStrokeMap.clear();
        Map containerMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"containerMap");
        containerMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForJdkTableLeaks(@NotNull Sdk[] oldSdks) {
        Sdk[] jdks;
        ProjectJdkTable table;
        if (oldSdks == null) {
            UsefulTestCase.$$$reportNull$$$0(2);
        }
        if ((table = ProjectJdkTable.getInstance()) != null && (jdks = table.getAllJdks()).length != 0) {
            THashSet leaked = new THashSet(Arrays.asList(jdks));
            THashSet old = new THashSet(Arrays.asList(oldSdks));
            leaked.removeAll((Collection<?>)old);
            try {
                if (!leaked.isEmpty()) {
                    UsefulTestCase.fail((String)("Leaked SDKs: " + leaked));
                }
            }
            finally {
                for (Sdk jdk : leaked) {
                    WriteAction.run(() -> table.removeJdk(jdk));
                }
            }
        }
    }

    protected void checkForSettingsDamage() {
        Application app = ApplicationManager.getApplication();
        if (this.isStressTest() || app == null || app instanceof MockApplication) {
            return;
        }
        CodeStyleSettings oldCodeStyleSettings = this.myOldCodeStyleSettings;
        if (oldCodeStyleSettings == null) {
            return;
        }
        this.myOldCodeStyleSettings = null;
        UsefulTestCase.doCheckForSettingsDamage(oldCodeStyleSettings, CodeStyle.getDefaultSettings());
    }

    public static void doCheckForSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) {
        if (oldCodeStyleSettings == null) {
            UsefulTestCase.$$$reportNull$$$0(3);
        }
        if (currentCodeStyleSettings == null) {
            UsefulTestCase.$$$reportNull$$$0(4);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            try {
                Element newS = new Element("temp");
                settings.writeExternal(newS);
                Assert.assertEquals((String)"Code insight settings damaged", (Object)DEFAULT_SETTINGS_EXTERNALIZED, (Object)JDOMUtil.writeElement((Element)newS));
            }
            catch (AssertionError error) {
                CodeInsightSettings clean = new CodeInsightSettings();
                for (Field field : clean.getClass().getFields()) {
                    try {
                        ReflectionUtil.copyFieldValue((Object)clean, (Object)settings, (Field)field);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw error;
            }
        }).append(() -> {
            if (currentCodeStyleSettings == null) {
                UsefulTestCase.$$$reportNull$$$0(90);
            }
            if (oldCodeStyleSettings == null) {
                UsefulTestCase.$$$reportNull$$$0(91);
            }
            currentCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
            try {
                UsefulTestCase.checkSettingsEqual(oldCodeStyleSettings, currentCodeStyleSettings);
            }
            finally {
                currentCodeStyleSettings.clearCodeStyleSettings();
            }
        }).append(() -> InplaceRefactoring.checkCleared()).append(() -> StartMarkAction.checkCleared()).run();
    }

    void storeSettings() {
        if (!this.isStressTest() && ApplicationManager.getApplication() != null) {
            this.myOldCodeStyleSettings = CodeStyle.getDefaultSettings().clone();
            this.myOldCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
        }
    }

    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyle.getDefaultSettings();
        if (codeStyleSettings == null) {
            UsefulTestCase.$$$reportNull$$$0(5);
        }
        return codeStyleSettings;
    }

    protected final CommonCodeStyleSettings getLanguageSettings(@NotNull Language language) {
        if (language == null) {
            UsefulTestCase.$$$reportNull$$$0(6);
        }
        return this.getCurrentCodeStyleSettings().getCommonSettings(language);
    }

    protected final <T extends CustomCodeStyleSettings> CustomCodeStyleSettings getCustomSettings(@NotNull Class<T> settingsClass) {
        if (settingsClass == null) {
            UsefulTestCase.$$$reportNull$$$0(7);
        }
        return this.getCurrentCodeStyleSettings().getCustomSettings(settingsClass);
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable = this.myTestRootDisposable;
        if (disposable == null) {
            UsefulTestCase.$$$reportNull$$$0(8);
        }
        return disposable;
    }

    protected void runTest() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        Runnable runnable = () -> {
            try {
                super.runTest();
                TestLoggerFactory.onTestFinished(true);
            }
            catch (InvocationTargetException e) {
                TestLoggerFactory.onTestFinished(false);
                e.fillInStackTrace();
                throwables[0] = e.getTargetException();
            }
            catch (IllegalAccessException e) {
                TestLoggerFactory.onTestFinished(false);
                e.fillInStackTrace();
                throwables[0] = e;
            }
            catch (Throwable e) {
                TestLoggerFactory.onTestFinished(false);
                throwables[0] = e;
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected boolean shouldRunTest() {
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(9);
        }
        EdtTestUtilKt.runInEdtAndWait((Function0<Unit>)((Function0)() -> {
            if (runnable == null) {
                UsefulTestCase.$$$reportNull$$$0(89);
            }
            runnable.run();
            return null;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void defaultRunBare() throws Throwable {
        Throwable exception;
        block13: {
            exception = null;
            long setupStart = System.nanoTime();
            this.setUp();
            long setupCost = (System.nanoTime() - setupStart) / 1000000L;
            this.logPerClassCost(setupCost, TOTAL_SETUP_COST_MILLIS);
            this.runTest();
            try {
                long teardownStart = System.nanoTime();
                this.tearDown();
                long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
            }
            catch (Throwable tearingDown) {
                if (exception == null) {
                    exception = tearingDown;
                    break block13;
                }
                exception = new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
            }
            break block13;
            catch (Throwable running) {
                try {
                    exception = running;
                }
                catch (Throwable throwable) {
                    try {
                        long teardownStart = System.nanoTime();
                        this.tearDown();
                        long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                        this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                    }
                    catch (Throwable tearingDown) {
                        exception = exception == null ? tearingDown : new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
                    }
                    throw throwable;
                }
                try {
                    long teardownStart = System.nanoTime();
                    this.tearDown();
                    long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                    this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                }
                catch (Throwable tearingDown) {
                    if (exception == null) {
                        exception = tearingDown;
                        break block13;
                    }
                    exception = new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logPerClassCost(long cost, @NotNull Map<String, Long> map) {
        Class<?> superclass;
        void costMap;
        Long oldCost;
        if (map == null) {
            UsefulTestCase.$$$reportNull$$$0(10);
        }
        long newCost = (oldCost = (Long)costMap.get((superclass = ((Object)((Object)this)).getClass().getSuperclass()).getName())) == null ? cost : oldCost + cost;
        costMap.put(superclass.getName(), newCost);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long totalSetup = 0L;
        for (Map.Entry<String, Long> entry : TOTAL_SETUP_COST_MILLIS.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            totalSetup += entry.getValue().longValue();
        }
        System.out.println("Teardown costs");
        long totalTeardown = 0L;
        for (Map.Entry<String, Long> entry : TOTAL_TEARDOWN_COST_MILLIS.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            totalTeardown += entry.getValue().longValue();
        }
        System.out.println(String.format("Total overhead: setup %d ms, teardown %d ms", totalSetup, totalTeardown));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']", totalSetup));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']", totalTeardown));
    }

    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        if (this.runInDispatchThread()) {
            TestRunnerUtil.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)this::defaultRunBare));
        } else {
            this.defaultRunBare();
        }
    }

    protected boolean runInDispatchThread() {
        return true;
    }

    protected void edt(@NotNull ThrowableRunnable<Throwable> runnable) {
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(11);
        }
        EdtTestUtil.runInEdtAndWait(runnable);
    }

    public static String toString(@NotNull Iterable<?> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(12);
        }
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof THashSet) {
                builder.append(new TreeSet((THashSet)o));
            } else {
                builder.append(o);
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull T[] actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(13);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(14);
        }
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<T> actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(15);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(16);
        }
        UsefulTestCase.assertOrderedEquals(null, actual, expected);
    }

    public static void assertOrderedEquals(@NotNull byte[] actual, @NotNull byte[] expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(17);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(18);
        }
        UsefulTestCase.assertEquals((int)actual.length, (int)expected.length);
        for (int i = 0; i < actual.length; ++i) {
            byte a = actual[i];
            byte e = expected[i];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i), (byte)e, (byte)a);
        }
    }

    public static void assertOrderedEquals(@NotNull int[] actual, @NotNull int[] expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(19);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(20);
        }
        if (actual.length != expected.length) {
            UsefulTestCase.fail((String)("Expected size: " + expected.length + "; actual: " + actual.length + "\nexpected: " + Arrays.toString(expected) + "\nactual  : " + Arrays.toString(actual)));
        }
        for (int i = 0; i < actual.length; ++i) {
            int a = actual[i];
            int e = expected[i];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i), (int)e, (int)a);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(String errorMsg, @NotNull Iterable<T> actual, T ... expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(21);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(22);
        }
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(23);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(24);
        }
        UsefulTestCase.assertOrderedEquals(null, actual, expected);
    }

    public static <T> void assertOrderedEquals(String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(25);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(26);
        }
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, expected, Equality.CANONICAL);
    }

    public static <T> void assertOrderedEquals(String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected, @NotNull Equality<? super T> comparator) {
        if (actual == null) {
            UsefulTestCase.$$$reportNull$$$0(27);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(28);
        }
        if (comparator == null) {
            UsefulTestCase.$$$reportNull$$$0(29);
        }
        if (!UsefulTestCase.equals(actual, expected, comparator)) {
            String expectedString = UsefulTestCase.toString(expected);
            String actualString = UsefulTestCase.toString(actual);
            Assert.assertEquals((String)errorMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    private static <T> boolean equals(@NotNull Iterable<? extends T> a1, @NotNull Iterable<? extends T> a2, @NotNull Equality<? super T> comparator) {
        if (a1 == null) {
            UsefulTestCase.$$$reportNull$$$0(30);
        }
        if (a2 == null) {
            UsefulTestCase.$$$reportNull$$$0(31);
        }
        if (comparator == null) {
            UsefulTestCase.$$$reportNull$$$0(32);
        }
        Iterator<T> it1 = a1.iterator();
        Iterator<T> it2 = a2.iterator();
        while (it1.hasNext() || it2.hasNext()) {
            if (!it1.hasNext() || !it2.hasNext()) {
                return false;
            }
            if (comparator.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(33);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(34);
        }
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull T[] collection, T ... expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(35);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(36);
        }
        UsefulTestCase.assertSameElements(Arrays.asList(collection), expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(37);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(38);
        }
        UsefulTestCase.assertSameElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> collection, @NotNull Collection<T> expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(39);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(40);
        }
        UsefulTestCase.assertSameElements(null, collection, expected);
    }

    public static <T> void assertSameElements(String message, @NotNull Collection<? extends T> collection, @NotNull Collection<T> expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(41);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(42);
        }
        if (collection.size() != expected.size() || !new HashSet<T>(expected).equals(new HashSet<T>(collection))) {
            Assert.assertEquals((String)message, (Object)UsefulTestCase.toString(expected, "\n"), (Object)UsefulTestCase.toString(collection, "\n"));
            Assert.assertEquals((String)message, new HashSet<T>(expected), new HashSet<T>(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(43);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(44);
        }
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<T> expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(45);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(46);
        }
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertOrderedEquals(UsefulTestCase.toString(collection), copy, expected);
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(47);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(48);
        }
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<T> expected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(49);
        }
        if (expected == null) {
            UsefulTestCase.$$$reportNull$$$0(50);
        }
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), copy, expected);
    }

    @NotNull
    public static String toString(@NotNull Object[] collection, @NotNull String separator) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(51);
        }
        if (separator == null) {
            UsefulTestCase.$$$reportNull$$$0(52);
        }
        String string = UsefulTestCase.toString(Arrays.asList(collection), separator);
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(53);
        }
        return string;
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(54);
        }
        if (notExpected == null) {
            UsefulTestCase.$$$reportNull$$$0(55);
        }
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(notExpected));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<T> notExpected) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(56);
        }
        if (notExpected == null) {
            UsefulTestCase.$$$reportNull$$$0(57);
        }
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        UsefulTestCase.assertSameElements(collection, expected);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(58);
        }
        if (separator == null) {
            UsefulTestCase.$$$reportNull$$$0(59);
        }
        List list = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        String string = builder.toString();
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(60);
        }
        return string;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(61);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(62);
        }
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i = 0;
        for (T actual : collection) {
            try {
                checkers[i].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i + ": " + actual);
                throw e;
            }
            ++i;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(63);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(64);
        }
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(65);
        }
        if (checkers == null) {
            UsefulTestCase.$$$reportNull$$$0(66);
        }
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        HashSet<Consumer<T>> checkerSet = new HashSet<Consumer<T>>(Arrays.asList(checkers));
        int i = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer consumer : checkerSet) {
                Throwable error = UsefulTestCase.accepts(consumer, actual);
                if (error == null) {
                    checkerSet.remove(consumer);
                    flag = false;
                    break;
                }
                lastError = error;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i + "): " + actual));
            }
            ++i;
        }
    }

    private static <T> Throwable accepts(@NotNull Consumer<T> condition, T actual) {
        if (condition == null) {
            UsefulTestCase.$$$reportNull$$$0(67);
        }
        try {
            condition.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    @Contract(value="null, _ -> fail")
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        if (aClass == null) {
            UsefulTestCase.$$$reportNull$$$0(68);
        }
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: " + null), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object t = o;
        return (T)t;
    }

    public static <T> T assertOneElement(@NotNull Collection<T> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(69);
        }
        Iterator<T> iterator = collection.iterator();
        String toString = UsefulTestCase.toString(collection);
        Assert.assertTrue((String)toString, (boolean)iterator.hasNext());
        T t = iterator.next();
        Assert.assertFalse((String)toString, (boolean)iterator.hasNext());
        return t;
    }

    public static <T> T assertOneElement(@NotNull T[] ts) {
        if (ts == null) {
            UsefulTestCase.$$$reportNull$$$0(70);
        }
        Assert.assertEquals((String)Arrays.asList(ts).toString(), (long)1L, (long)ts.length);
        return ts[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value, T ... values) {
        if (values == null) {
            UsefulTestCase.$$$reportNull$$$0(71);
        }
        boolean found = false;
        for (T v : values) {
            if (value != v && (value == null || !value.equals(v))) continue;
            found = true;
        }
        Assert.assertTrue((String)(value + " should be equal to one of " + Arrays.toString(values)), (boolean)found);
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
    }

    public static void assertEmpty(@NotNull Object[] array) {
        if (array == null) {
            UsefulTestCase.$$$reportNull$$$0(72);
        }
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        if (collection == null) {
            UsefulTestCase.$$$reportNull$$$0(73);
        }
        UsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty(null, collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static <T> void assertEmpty(String errorMsg, Collection<T> collection) {
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, Collections.emptyList());
    }

    public static void assertSize(int expectedSize, Object[] array) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
    }

    public static void assertSize(int expectedSize, Collection<?> c) {
        UsefulTestCase.assertEquals((String)UsefulTestCase.toString(c), (int)expectedSize, (int)c.size());
    }

    protected <T extends Disposable> T disposeOnTearDown(T disposable) {
        Disposer.register((Disposable)this.getTestRootDisposable(), disposable);
        return disposable;
    }

    public static void assertSameLines(String expected, String actual) {
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual.trim());
        Assert.assertEquals((Object)expectedText, (Object)actualText);
    }

    public static void assertExists(@NotNull File file) {
        if (file == null) {
            UsefulTestCase.$$$reportNull$$$0(74);
        }
        UsefulTestCase.assertTrue((String)("File should exist " + file), (boolean)file.exists());
    }

    public static void assertDoesntExist(@NotNull File file) {
        if (file == null) {
            UsefulTestCase.$$$reportNull$$$0(75);
        }
        UsefulTestCase.assertFalse((String)("File should not exist " + file), (boolean)file.exists());
    }

    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        String string = UsefulTestCase.getTestName(this.getName(), lowercaseFirstLetter);
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(76);
        }
        return string;
    }

    @NotNull
    public static String getTestName(String name2, boolean lowercaseFirstLetter) {
        String string = name2 == null ? "" : PlatformTestUtil.getTestName(name2, lowercaseFirstLetter);
        if (string == null) {
            UsefulTestCase.$$$reportNull$$$0(77);
        }
        return string;
    }

    protected String getTestDirectoryName() {
        String testName = this.getTestName(true);
        return testName.replaceAll("_.*", "");
    }

    public static void assertSameLinesWithFile(String filePath, String actualText) {
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true);
    }

    public static void assertSameLinesWithFile(String filePath, String actualText, boolean trimBeforeComparing) {
        String fileText;
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(filePath, actualText);
                System.out.println("File " + filePath + " created.");
            }
            fileText = FileUtil.loadFile((File)new File(filePath), (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData(filePath, actualText);
            throw new AssertionFailedError("No output text found. File " + filePath + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? fileText.trim() : fileText));
        String actual = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? actualText.trim() : actualText));
        if (!Comparing.equal((String)expected, (String)actual)) {
            throw new FileComparisonFailure(null, expected, actual, filePath);
        }
    }

    protected static void clearFields(@NotNull Object test) throws IllegalAccessException {
        if (test == null) {
            UsefulTestCase.$$$reportNull$$$0(78);
        }
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(Object test, Class aClass) throws IllegalAccessException {
        if (aClass == null) {
            return;
        }
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name2 = field.getDeclaringClass().getName();
            if (name2.startsWith("junit.framework.") || name2.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    private static void checkSettingsEqual(CodeStyleSettings expected, CodeStyleSettings settings) throws Exception {
        if (expected == null || settings == null) {
            return;
        }
        Element oldS = new Element("temp");
        expected.writeExternal(oldS);
        Element newS = new Element("temp");
        settings.writeExternal(newS);
        String newString = JDOMUtil.writeElement((Element)newS);
        String oldString = JDOMUtil.writeElement((Element)oldS);
        Assert.assertEquals((String)"Code style settings damaged", (Object)oldString, (Object)newString);
    }

    public boolean isPerformanceTest() {
        String testName = this.getName();
        String className = ((Object)((Object)this)).getClass().getName();
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)className);
    }

    public boolean isStressTest() {
        return UsefulTestCase.isStressTest(this.getName(), ((Object)((Object)this)).getClass().getName());
    }

    private static boolean isStressTest(String testName, String className) {
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)className) || UsefulTestCase.containsStressWords(testName) || UsefulTestCase.containsStressWords(className);
    }

    private static boolean containsStressWords(@Nullable String name2) {
        return name2 != null && (name2.contains("Stress") || name2.contains("Slow"));
    }

    public static void doPostponedFormatting(Project project2) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
        });
    }

    protected void assertException(AbstractExceptionCase exceptionCase) throws Throwable {
        this.assertException(exceptionCase, null);
    }

    protected void assertException(AbstractExceptionCase exceptionCase, @Nullable String expectedErrorMsg) throws Throwable {
        UsefulTestCase.assertExceptionOccurred(true, exceptionCase, expectedErrorMsg);
    }

    public static <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable) throws T {
        if (exceptionClass == null) {
            UsefulTestCase.$$$reportNull$$$0(79);
        }
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(80);
        }
        UsefulTestCase.assertThrows(exceptionClass, null, runnable);
    }

    public static <T extends Throwable> void assertThrows(final @NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsg, final @NotNull ThrowableRunnable<T> runnable) throws T {
        if (exceptionClass == null) {
            UsefulTestCase.$$$reportNull$$$0(81);
        }
        if (runnable == null) {
            UsefulTestCase.$$$reportNull$$$0(82);
        }
        UsefulTestCase.assertExceptionOccurred(true, new AbstractExceptionCase(){

            public Class<Throwable> getExpectedExceptionClass() {
                return exceptionClass;
            }

            @Override
            public void tryClosure() throws Throwable {
                runnable.run();
            }
        }, expectedErrorMsg);
    }

    protected <T extends Throwable> void assertNoException(AbstractExceptionCase<T> exceptionCase) throws T {
        UsefulTestCase.assertExceptionOccurred(false, exceptionCase, null);
    }

    protected void assertNoThrowable(Runnable closure) {
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Throwable> void assertExceptionOccurred(boolean shouldOccur, AbstractExceptionCase<T> exceptionCase, String expectedErrorMsg) throws T {
        block9: {
            boolean wasThrown = false;
            try {
                exceptionCase.tryClosure();
            }
            catch (Throwable e) {
                if (shouldOccur) {
                    wasThrown = true;
                    String errorMessage = exceptionCase.getAssertionErrorMessage();
                    UsefulTestCase.assertEquals((String)errorMessage, exceptionCase.getExpectedExceptionClass(), e.getClass());
                    if (expectedErrorMsg != null) {
                        UsefulTestCase.assertEquals((String)"Compare error messages", (String)expectedErrorMsg, (String)e.getMessage());
                    }
                    break block9;
                }
                if (exceptionCase.getExpectedExceptionClass().equals(e.getClass())) {
                    wasThrown = true;
                    System.out.println("");
                    e.printStackTrace(System.out);
                    UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + e.getMessage()));
                    break block9;
                }
                throw e;
            }
            finally {
                if (shouldOccur && !wasThrown) {
                    UsefulTestCase.fail((String)exceptionCase.getAssertionErrorMessage());
                }
            }
        }
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            UsefulTestCase.$$$reportNull$$$0(83);
        }
        String methodName = "test" + this.getTestName(false);
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method = ReflectionUtil.getDeclaredMethod(aClass, (String)methodName, (Class[])new Class[0])) == null) continue;
            if (method.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    protected String getHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    public static void refreshRecursively(@NotNull VirtualFile file) {
        if (file == null) {
            UsefulTestCase.$$$reportNull$$$0(84);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                file.getChildren();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/UsefulTestCase$2", "visitFile"));
            }
        });
        file.refresh(false, true);
    }

    @NotNull
    public static Test filteredSuite(@RegExp String regexp, @NotNull Test test) {
        if (test == null) {
            UsefulTestCase.$$$reportNull$$$0(85);
        }
        final Pattern pattern = Pattern.compile(regexp);
        final TestSuite testSuite = new TestSuite();
        new Processor<Test>(){

            public boolean process(Test test) {
                if (test instanceof TestSuite) {
                    int len = ((TestSuite)test).testCount();
                    for (int i = 0; i < len; ++i) {
                        this.process(((TestSuite)test).testAt(i));
                    }
                } else if (pattern.matcher(test.toString()).find()) {
                    testSuite.addTest(test);
                }
                return false;
            }
        }.process(test);
        TestSuite testSuite2 = testSuite;
        if (testSuite2 == null) {
            UsefulTestCase.$$$reportNull$$$0(86);
        }
        return testSuite2;
    }

    @Nullable
    public static VirtualFile refreshAndFindFile(@NotNull File file) {
        if (file == null) {
            UsefulTestCase.$$$reportNull$$$0(87);
        }
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> {
            if (file == null) {
                UsefulTestCase.$$$reportNull$$$0(88);
            }
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        });
    }

    static {
        Class<?> aClass;
        IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
        OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
        ORIGINAL_TEMP_DIR = FileUtil.getTempDirectory();
        TOTAL_SETUP_COST_MILLIS = new HashMap();
        TOTAL_TEARDOWN_COST_MILLIS = new HashMap();
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
        Logger.setFactory(TestLoggerFactory.class);
        LOG = Logger.getInstance(UsefulTestCase.class);
        CREATION_PLACE = Key.create((String)"CREATION_PLACE");
        System.setProperty("apple.awt.UIElement", "true");
        try {
            CodeInsightSettings defaultSettings = new CodeInsightSettings();
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement((Element)oldS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            aClass = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set files = (Set)ReflectionUtil.getStaticFieldValue(aClass, Set.class, (String)"files");
        DELETE_ON_EXIT_HOOK_CLASS = aClass;
        DELETE_ON_EXIT_HOOK_DOT_FILES = files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSdks";
                break;
            }
            case 3: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCodeStyleSettings";
                break;
            }
            case 4: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCodeStyleSettings";
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/UsefulTestCase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 9: 
            case 11: 
            case 80: 
            case 82: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "costMap";
                break;
            }
            case 12: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 58: 
            case 61: 
            case 63: 
            case 65: 
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 28: 
            case 36: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 34: 
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 52: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notExpected";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ts";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 78: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/UsefulTestCase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCodeStyleSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
            case 53: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredSuite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTmpFileToKeep";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldKeepTmpFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkForJdkTableLeaks";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCheckForSettingsDamage";
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeTestRunnable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logPerClassCost";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "edt";
                break;
            }
            case 12: 
            case 51: 
            case 52: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedEquals";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 33: 
            case 34: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedCollection";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "assertSameElements";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsOrdered";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsElements";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntContain";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "assertUnorderedCollection";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "assertInstanceOf";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "assertOneElement";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "assertOneOf";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "assertEmpty";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "assertExists";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntExist";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "clearFields";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "assertThrows";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "annotatedWith";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "refreshRecursively";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "filteredSuite";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFile";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "lambda$refreshAndFindFile$14";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invokeTestRunnable$12";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCheckForSettingsDamage$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 53: 
            case 60: 
            case 76: 
            case 77: 
            case 86: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class TestDisposable
    implements Disposable {
        private volatile boolean myDisposed;

        public void dispose() {
            this.myDisposed = true;
        }

        public boolean isDisposed() {
            return this.myDisposed;
        }

        public String toString() {
            String testName = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (StringUtil.isEmpty((String)testName) ? "" : ".test" + testName);
        }
    }
}

