/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class MavenDuplicatePluginInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public MavenDuplicatePluginInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    public void checkFileElement(DomFileElement<MavenDomProjectModel> domFileElement, DomElementAnnotationHolder holder) {
        MavenDomProjectModel projectModel = (MavenDomProjectModel)domFileElement.getRootElement();
        MultiMap duplicates = MultiMap.createSet();
        for (MavenDomPlugin plugin : projectModel.getBuild().getPlugins().getPlugins()) {
            String groupId = plugin.getGroupId().getStringValue();
            String artifactId = plugin.getArtifactId().getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)artifactId)) continue;
            if ("".equals(groupId) || "org.apache.maven.plugins".equals(groupId) || "org.codehaus.mojo".equals(groupId)) {
                groupId = null;
            }
            duplicates.putValue((Object)Pair.create((Object)groupId, (Object)artifactId), (Object)plugin);
        }
        for (Map.Entry entry : duplicates.entrySet()) {
            Collection set = (Collection)entry.getValue();
            if (set.size() <= 1) continue;
            for (MavenDomPlugin dependency : set) {
                holder.createProblem((DomElement)dependency, HighlightSeverity.WARNING, "Duplicated plugin declaration");
            }
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            MavenDuplicatePluginInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = MavenDomBundle.message("inspection.duplicate.plugin.declaration", new Object[0]);
        if (string == null) {
            MavenDuplicatePluginInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("MavenDuplicatePluginInspection" == null) {
            MavenDuplicatePluginInspection.$$$reportNull$$$0(2);
        }
        return "MavenDuplicatePluginInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            MavenDuplicatePluginInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/dom/inspections/MavenDuplicatePluginInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

