/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenExplicitProfiles;
import org.jetbrains.idea.maven.utils.Path;

public class MavenRunnerParameters
implements Cloneable {
    private final boolean isPomExecution;
    private Path myWorkingDirPath;
    private String myPomFileName;
    private final List<String> myGoals;
    private boolean myResolveToWorkspace;
    private final Map<String, Boolean> myProfilesMap;
    private final Collection<String> myEnabledProfilesForXmlSerializer;

    public MavenRunnerParameters() {
        this(true, "", null, null, null, null);
    }

    @Deprecated
    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(0);
        }
        this(isPomExecution, workingDirPath, null, goals, explicitEnabledProfiles, null);
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable String pomFileName, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(1);
        }
        this(isPomExecution, workingDirPath, pomFileName, goals, explicitEnabledProfiles, null);
    }

    @Deprecated
    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable List<String> goals, @NotNull MavenExplicitProfiles explicitProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(2);
        }
        if (explicitProfiles == null) {
            MavenRunnerParameters.$$$reportNull$$$0(3);
        }
        this(isPomExecution, workingDirPath, null, goals, explicitProfiles);
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable String pomFileName, @Nullable List<String> goals, @NotNull MavenExplicitProfiles explicitProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(4);
        }
        if (explicitProfiles == null) {
            MavenRunnerParameters.$$$reportNull$$$0(5);
        }
        this(isPomExecution, workingDirPath, pomFileName, goals, explicitProfiles.getEnabledProfiles(), explicitProfiles.getDisabledProfiles());
    }

    @Deprecated
    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles, @Nullable Collection<String> explicitDisabledProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(6);
        }
        this(isPomExecution, workingDirPath, null, goals, explicitEnabledProfiles, explicitDisabledProfiles);
    }

    public MavenRunnerParameters(boolean isPomExecution, @NotNull String workingDirPath, @Nullable String pomFileName, @Nullable List<String> goals, @Nullable Collection<String> explicitEnabledProfiles, @Nullable Collection<String> explicitDisabledProfiles) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(7);
        }
        this.myGoals = new ArrayList<String>();
        this.myProfilesMap = new LinkedHashMap<String, Boolean>();
        this.myEnabledProfilesForXmlSerializer = new TreeSet<String>();
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.myPomFileName = pomFileName;
        this.setGoals(goals);
        if (explicitEnabledProfiles != null) {
            for (String profile : explicitEnabledProfiles) {
                this.myProfilesMap.put(profile, Boolean.TRUE);
            }
        }
        if (explicitDisabledProfiles != null) {
            for (String profile : explicitDisabledProfiles) {
                this.myProfilesMap.put(profile, Boolean.FALSE);
            }
        }
    }

    public MavenRunnerParameters(String workingDirPath, String pomFileName, boolean isPomExecution, @Nullable List<String> goals, @NotNull Map<String, Boolean> profilesMap) {
        if (profilesMap == null) {
            MavenRunnerParameters.$$$reportNull$$$0(8);
        }
        this.myGoals = new ArrayList<String>();
        this.myProfilesMap = new LinkedHashMap<String, Boolean>();
        this.myEnabledProfilesForXmlSerializer = new TreeSet<String>();
        this.isPomExecution = isPomExecution;
        this.setWorkingDirPath(workingDirPath);
        this.setPomFileName(pomFileName);
        this.setGoals(goals);
        this.setProfilesMap(profilesMap);
    }

    public MavenRunnerParameters(MavenRunnerParameters that) {
        this(that.getWorkingDirPath(), that.myPomFileName, that.isPomExecution, that.myGoals, that.myProfilesMap);
        this.myResolveToWorkspace = that.myResolveToWorkspace;
    }

    public boolean isPomExecution() {
        return this.isPomExecution;
    }

    @NotNull
    public String getWorkingDirPath() {
        String string = this.myWorkingDirPath.getPath();
        if (string == null) {
            MavenRunnerParameters.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setWorkingDirPath(@NotNull String workingDirPath) {
        if (workingDirPath == null) {
            MavenRunnerParameters.$$$reportNull$$$0(10);
        }
        this.myWorkingDirPath = new Path(workingDirPath);
    }

    @NotNull
    public File getWorkingDirFile() {
        File file = new File(this.myWorkingDirPath.getPath());
        if (file == null) {
            MavenRunnerParameters.$$$reportNull$$$0(11);
        }
        return file;
    }

    public void setPomFileName(String pomFileName) {
        this.myPomFileName = pomFileName;
    }

    public String getPomFileName() {
        return this.myPomFileName;
    }

    public List<String> getGoals() {
        return this.myGoals;
    }

    public void setGoals(@Nullable List<String> goals) {
        if (this.myGoals == goals) {
            return;
        }
        this.myGoals.clear();
        if (goals != null) {
            this.myGoals.addAll(goals);
        }
    }

    @Deprecated
    @OptionTag(value="profiles")
    public Collection<String> getEnabledProfilesForXmlSerializer() {
        return this.myEnabledProfilesForXmlSerializer;
    }

    @Deprecated
    public void setEnabledProfilesForXmlSerializer(@Nullable Collection<String> enabledProfilesForXmlSerializer) {
        if (enabledProfilesForXmlSerializer != null) {
            if (this.myEnabledProfilesForXmlSerializer == enabledProfilesForXmlSerializer) {
                return;
            }
            this.myEnabledProfilesForXmlSerializer.retainAll(enabledProfilesForXmlSerializer);
            this.myEnabledProfilesForXmlSerializer.addAll(enabledProfilesForXmlSerializer);
        }
    }

    public void fixAfterLoadingFromOldFormat() {
        for (String profile : this.myEnabledProfilesForXmlSerializer) {
            this.myProfilesMap.put(profile, true);
        }
        this.myEnabledProfilesForXmlSerializer.clear();
        File workingDir = this.getWorkingDirFile();
        if ("pom.xml".equals(workingDir.getName())) {
            this.setWorkingDirPath(workingDir.getParent());
        }
    }

    @OptionTag(value="profilesMap")
    @MapAnnotation(sortBeforeSave=false)
    public Map<String, Boolean> getProfilesMap() {
        return this.myProfilesMap;
    }

    public void setProfilesMap(@NotNull Map<String, Boolean> profilesMap) {
        if (profilesMap == null) {
            MavenRunnerParameters.$$$reportNull$$$0(12);
        }
        if (this.myProfilesMap == profilesMap) {
            return;
        }
        this.myProfilesMap.clear();
        for (Map.Entry<String, Boolean> entry : profilesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.myProfilesMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Transient
    public Collection<String> getProfiles() {
        return Maps.filterValues(this.myProfilesMap, (Predicate)Predicates.equalTo((Object)true)).keySet();
    }

    public void setProfiles(@Nullable Collection<String> profiles) {
        if (profiles != null) {
            for (String profile : profiles) {
                this.myProfilesMap.put(profile, true);
            }
        }
    }

    public boolean isResolveToWorkspace() {
        return this.myResolveToWorkspace;
    }

    public void setResolveToWorkspace(boolean resolveToWorkspace) {
        this.myResolveToWorkspace = resolveToWorkspace;
    }

    public MavenRunnerParameters clone() {
        return new MavenRunnerParameters(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRunnerParameters that = (MavenRunnerParameters)o;
        if (this.isPomExecution != that.isPomExecution) {
            return false;
        }
        if (this.myResolveToWorkspace != that.myResolveToWorkspace) {
            return false;
        }
        if (!this.myGoals.equals(that.myGoals)) {
            return false;
        }
        if (this.myWorkingDirPath != null ? !this.myWorkingDirPath.equals(that.myWorkingDirPath) : that.myWorkingDirPath != null) {
            return false;
        }
        return this.myProfilesMap.equals(that.myProfilesMap);
    }

    public int hashCode() {
        int result = this.isPomExecution ? 1 : 0;
        result = 31 * result + (this.myWorkingDirPath != null ? this.myWorkingDirPath.hashCode() : 0);
        result = 31 * result + this.myGoals.hashCode();
        result = 31 * result + this.myProfilesMap.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirPath";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitProfiles";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilesMap";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenRunnerParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenRunnerParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProfilesMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

