/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.idea.maven.dom.MavenVersionComparable;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchResult;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;

public abstract class MavenSearcher<RESULT_TYPE extends MavenArtifactSearchResult> {
    public List<RESULT_TYPE> search(Project project, String pattern, int maxResult) {
        return this.sort(this.searchImpl(project, pattern, maxResult));
    }

    protected abstract List<RESULT_TYPE> searchImpl(Project var1, String var2, int var3);

    private List<RESULT_TYPE> sort(List<RESULT_TYPE> result) {
        for (MavenArtifactSearchResult each : result) {
            if (each.versions.size() <= 1) continue;
            TreeMap tree = new TreeMap(Collections.reverseOrder());
            for (MavenArtifactInfo artifactInfo : each.versions) {
                tree.put(new MavenVersionComparable(artifactInfo.getVersion()), artifactInfo);
            }
            each.versions.clear();
            each.versions.addAll(tree.values());
        }
        Collections.sort(result, Comparator.comparing(this::makeSortKey));
        return result;
    }

    protected String makeSortKey(RESULT_TYPE result) {
        return this.makeKey(((MavenArtifactSearchResult)result).versions.get(0));
    }

    protected String makeKey(MavenArtifactInfo result) {
        return result.getGroupId() + ":" + result.getArtifactId();
    }
}

