/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.Convertor;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.data.GithubUserDetailed;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.ui.GithubLoginDialog;
import org.jetbrains.plugins.github.util.AuthLevel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

public class GithubUtil {
    public static final Logger LOG = Logger.getInstance((String)"github");

    public static <T> T runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(0);
        }
        if (authHolder == null) {
            GithubUtil.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(2);
        }
        if (task == null) {
            GithubUtil.$$$reportNull$$$0(3);
        }
        return GithubUtil.runTask(project, authHolder, indicator, AuthLevel.LOGGED, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T runTask(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull AuthLevel authLevel, @NotNull ThrowableConvertor<GithubConnection, T, IOException> task) throws IOException {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(4);
        }
        if (authHolder == null) {
            GithubUtil.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(6);
        }
        if (authLevel == null) {
            GithubUtil.$$$reportNull$$$0(7);
        }
        if (task == null) {
            GithubUtil.$$$reportNull$$$0(8);
        }
        GithubAuthData auth = authHolder.getAuthData();
        try {
            if (!authLevel.accepts(auth)) {
                throw new GithubAuthenticationException("Expected other authentication type: " + authLevel);
            }
            GithubConnection connection = new GithubConnection(auth, true);
            ScheduledFuture<?> future = null;
            try {
                future = GithubUtil.addCancellationListener(indicator, connection);
                Object object = task.convert((Object)connection);
                return (T)object;
            }
            finally {
                connection.close();
                if (future != null) {
                    future.cancel(true);
                }
            }
        }
        catch (GithubTwoFactorAuthenticationException e) {
            GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
            return GithubUtil.runTask(project, authHolder, indicator, authLevel, task);
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, authLevel, auth);
            return GithubUtil.runTask(project, authHolder, indicator, authLevel, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static GithubUserDetailed testConnection(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(9);
        }
        if (authHolder == null) {
            GithubUtil.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(11);
        }
        GithubAuthData auth = authHolder.getAuthData();
        GithubConnection connection = new GithubConnection(auth, true);
        ScheduledFuture<?> future = null;
        future = GithubUtil.addCancellationListener(indicator, connection);
        GithubUserDetailed githubUserDetailed = GithubApiUtil.getCurrentUser(connection);
        connection.close();
        if (future != null) {
            future.cancel(true);
        }
        GithubUserDetailed githubUserDetailed2 = githubUserDetailed;
        if (githubUserDetailed2 == null) {
            GithubUtil.$$$reportNull$$$0(12);
        }
        return githubUserDetailed2;
        {
            catch (Throwable throwable) {
                try {
                    connection.close();
                    if (future != null) {
                        future.cancel(true);
                    }
                    throw throwable;
                }
                catch (GithubTwoFactorAuthenticationException e) {
                    GithubUtil.getTwoFactorAuthData(project, authHolder, indicator, auth);
                    GithubUserDetailed githubUserDetailed3 = GithubUtil.testConnection(project, authHolder, indicator);
                    if (githubUserDetailed3 == null) {
                        GithubUtil.$$$reportNull$$$0(13);
                    }
                    return githubUserDetailed3;
                }
            }
        }
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull Runnable run) {
        if (run == null) {
            GithubUtil.$$$reportNull$$$0(14);
        }
        ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(run, 1000L, 300L, TimeUnit.MILLISECONDS);
        if (scheduledFuture == null) {
            GithubUtil.$$$reportNull$$$0(15);
        }
        return scheduledFuture;
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull ProgressIndicator indicator, @NotNull GithubConnection connection) {
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(16);
        }
        if (connection == null) {
            GithubUtil.$$$reportNull$$$0(17);
        }
        ScheduledFuture<?> scheduledFuture = GithubUtil.addCancellationListener(() -> {
            if (indicator == null) {
                GithubUtil.$$$reportNull$$$0(80);
            }
            if (connection == null) {
                GithubUtil.$$$reportNull$$$0(81);
            }
            if (indicator.isCanceled()) {
                connection.abort();
            }
        });
        if (scheduledFuture == null) {
            GithubUtil.$$$reportNull$$$0(18);
        }
        return scheduledFuture;
    }

    @NotNull
    private static ScheduledFuture<?> addCancellationListener(@NotNull ProgressIndicator indicator, @NotNull Thread thread) {
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(19);
        }
        if (thread == null) {
            GithubUtil.$$$reportNull$$$0(20);
        }
        ScheduledFuture<?> scheduledFuture = GithubUtil.addCancellationListener(() -> {
            if (indicator == null) {
                GithubUtil.$$$reportNull$$$0(78);
            }
            if (thread == null) {
                GithubUtil.$$$reportNull$$$0(79);
            }
            if (indicator.isCanceled()) {
                thread.interrupt();
            }
        });
        if (scheduledFuture == null) {
            GithubUtil.$$$reportNull$$$0(21);
        }
        return scheduledFuture;
    }

    private static void getValidAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull AuthLevel authLevel, @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(22);
        }
        if (authHolder == null) {
            GithubUtil.$$$reportNull$$$0(23);
        }
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(24);
        }
        if (authLevel == null) {
            GithubUtil.$$$reportNull$$$0(25);
        }
        if (oldAuth == null) {
            GithubUtil.$$$reportNull$$$0(26);
        }
        authHolder.runTransaction(oldAuth, () -> {
            if (project == null) {
                GithubUtil.$$$reportNull$$$0(71);
            }
            if (oldAuth == null) {
                GithubUtil.$$$reportNull$$$0(72);
            }
            if (authLevel == null) {
                GithubUtil.$$$reportNull$$$0(73);
            }
            if (indicator == null) {
                GithubUtil.$$$reportNull$$$0(74);
            }
            GithubAuthData[] authData = new GithubAuthData[1];
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (project == null) {
                    GithubUtil.$$$reportNull$$$0(75);
                }
                if (oldAuth == null) {
                    GithubUtil.$$$reportNull$$$0(76);
                }
                if (authLevel == null) {
                    GithubUtil.$$$reportNull$$$0(77);
                }
                GithubLoginDialog dialog = new GithubLoginDialog(project, oldAuth, authLevel);
                DialogManager.show((DialogWrapper)dialog);
                if (dialog.isOK()) {
                    authData[0] = dialog.getAuthData();
                    if (!authLevel.isOnetime()) {
                        GithubSettings.getInstance().setAuthData(authData[0], dialog.isSavePasswordSelected());
                    }
                }
            }, indicator.getModalityState());
            if (authData[0] == null) {
                throw new GithubOperationCanceledException("Can't get valid credentials");
            }
            return authData[0];
        });
    }

    private static void getTwoFactorAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator, @NotNull GithubAuthData oldAuth) throws GithubOperationCanceledException {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(27);
        }
        if (authHolder == null) {
            GithubUtil.$$$reportNull$$$0(28);
        }
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(29);
        }
        if (oldAuth == null) {
            GithubUtil.$$$reportNull$$$0(30);
        }
        authHolder.runTransaction(oldAuth, () -> {
            if (authHolder == null) {
                GithubUtil.$$$reportNull$$$0(66);
            }
            if (oldAuth == null) {
                GithubUtil.$$$reportNull$$$0(67);
            }
            if (project == null) {
                GithubUtil.$$$reportNull$$$0(68);
            }
            if (indicator == null) {
                GithubUtil.$$$reportNull$$$0(69);
            }
            if (authHolder.getAuthData().getAuthType() != GithubAuthData.AuthType.BASIC) {
                throw new GithubOperationCanceledException("Two factor authentication can be used only with Login/Password");
            }
            GithubApiUtil.askForTwoFactorCodeSMS(new GithubConnection(oldAuth, false));
            Ref codeRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (project == null) {
                    GithubUtil.$$$reportNull$$$0(70);
                }
                codeRef.set((Object)Messages.showInputDialog((Project)project, (String)"Authentication Code", (String)"Github Two-Factor Authentication", null));
            }, indicator.getModalityState());
            if (codeRef.isNull()) {
                throw new GithubOperationCanceledException("Can't get two factor authentication code");
            }
            GithubSettings settings = GithubSettings.getInstance();
            if (settings.getAuthType() == GithubAuthData.AuthType.BASIC && StringUtil.equalsIgnoreCase((CharSequence)settings.getLogin(), (CharSequence)oldAuth.getBasicAuth().getLogin())) {
                settings.setValidGitAuth(false);
            }
            return oldAuth.copyWithTwoFactorCode((String)codeRef.get());
        });
    }

    @NotNull
    public static GithubAuthDataHolder getValidAuthDataHolderFromConfig(@NotNull Project project, @NotNull AuthLevel authLevel, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthDataHolder githubAuthDataHolder;
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(31);
        }
        if (authLevel == null) {
            GithubUtil.$$$reportNull$$$0(32);
        }
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(33);
        }
        GithubAuthData auth = GithubAuthData.createFromSettings();
        GithubAuthDataHolder authHolder = new GithubAuthDataHolder(auth);
        try {
            if (!authLevel.accepts(auth)) {
                throw new GithubAuthenticationException("Expected other authentication type: " + authLevel);
            }
            GithubUtil.checkAuthData(project, authHolder, indicator);
            githubAuthDataHolder = authHolder;
        }
        catch (GithubAuthenticationException e) {
            GithubUtil.getValidAuthData(project, authHolder, indicator, authLevel, auth);
            GithubAuthDataHolder githubAuthDataHolder2 = authHolder;
            if (githubAuthDataHolder2 == null) {
                GithubUtil.$$$reportNull$$$0(35);
            }
            return githubAuthDataHolder2;
        }
        if (githubAuthDataHolder == null) {
            GithubUtil.$$$reportNull$$$0(34);
        }
        return githubAuthDataHolder;
    }

    @NotNull
    public static GithubUserDetailed checkAuthData(@NotNull Project project, @NotNull GithubAuthDataHolder authHolder, @NotNull ProgressIndicator indicator) throws IOException {
        GithubAuthData auth;
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(36);
        }
        if (authHolder == null) {
            GithubUtil.$$$reportNull$$$0(37);
        }
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(38);
        }
        if (StringUtil.isEmptyOrSpaces((String)(auth = authHolder.getAuthData()).getHost())) {
            throw new GithubAuthenticationException("Target host not defined");
        }
        try {
            new URI(auth.getHost());
        }
        catch (URISyntaxException e) {
            throw new GithubAuthenticationException("Invalid host URL");
        }
        switch (auth.getAuthType()) {
            case BASIC: {
                GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
                assert (basicAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)basicAuth.getLogin()) && !StringUtil.isEmptyOrSpaces((String)basicAuth.getPassword())) break;
                throw new GithubAuthenticationException("Empty login or password");
            }
            case TOKEN: {
                GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
                assert (tokenAuth != null);
                if (!StringUtil.isEmptyOrSpaces((String)tokenAuth.getToken())) break;
                throw new GithubAuthenticationException("Empty token");
            }
            case ANONYMOUS: {
                throw new GithubAuthenticationException("Anonymous connection not allowed");
            }
        }
        GithubUserDetailed githubUserDetailed = GithubUtil.testConnection(project, authHolder, indicator);
        if (githubUserDetailed == null) {
            GithubUtil.$$$reportNull$$$0(39);
        }
        return githubUserDetailed;
    }

    public static <T> T computeValueInModalIO(@NotNull Project project, @NotNull String caption, final @NotNull ThrowableConvertor<ProgressIndicator, T, IOException> task) throws IOException {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(40);
        }
        if (caption == null) {
            GithubUtil.$$$reportNull$$$0(41);
        }
        if (task == null) {
            GithubUtil.$$$reportNull$$$0(42);
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, IOException>(project, caption, true){

            protected T compute(@NotNull ProgressIndicator indicator) throws IOException {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return task.convert((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil$1", "compute"));
            }
        });
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, @NotNull Convertor<ProgressIndicator, T> task) {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(43);
        }
        if (caption == null) {
            GithubUtil.$$$reportNull$$$0(44);
        }
        if (task == null) {
            GithubUtil.$$$reportNull$$$0(45);
        }
        return GithubUtil.computeValueInModal(project, caption, true, task);
    }

    public static <T> T computeValueInModal(@NotNull Project project, @NotNull String caption, boolean canBeCancelled, final @NotNull Convertor<ProgressIndicator, T> task) {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(46);
        }
        if (caption == null) {
            GithubUtil.$$$reportNull$$$0(47);
        }
        if (task == null) {
            GithubUtil.$$$reportNull$$$0(48);
        }
        return (T)ProgressManager.getInstance().run(new Task.WithResult<T, RuntimeException>(project, caption, canBeCancelled){

            protected T compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return task.convert((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil$2", "compute"));
            }
        });
    }

    public static void computeValueInModal(@NotNull Project project, @NotNull String caption, boolean canBeCancelled, final @NotNull Consumer<ProgressIndicator> task) {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(49);
        }
        if (caption == null) {
            GithubUtil.$$$reportNull$$$0(50);
        }
        if (task == null) {
            GithubUtil.$$$reportNull$$$0(51);
        }
        ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<Void, RuntimeException>(project, caption, canBeCancelled){

            protected Void compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                task.consume((Object)indicator);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/util/GithubUtil$3", "compute"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInterruptable(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, IOException> task) throws IOException {
        if (indicator == null) {
            GithubUtil.$$$reportNull$$$0(52);
        }
        if (task == null) {
            GithubUtil.$$$reportNull$$$0(53);
        }
        ScheduledFuture<?> future = null;
        try {
            Thread thread = Thread.currentThread();
            future = GithubUtil.addCancellationListener(indicator, thread);
            Object object = task.compute();
            return (T)object;
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            Thread.interrupted();
        }
    }

    @Nullable
    public static String findGithubRemoteUrl(@NotNull GitRepository repository) {
        Pair<GitRemote, String> remote;
        if (repository == null) {
            GithubUtil.$$$reportNull$$$0(54);
        }
        if ((remote = GithubUtil.findGithubRemote(repository)) == null) {
            return null;
        }
        return (String)remote.getSecond();
    }

    @Nullable
    public static Pair<GitRemote, String> findGithubRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            GithubUtil.$$$reportNull$$$0(55);
        }
        Pair githubRemote = null;
        block0: for (GitRemote gitRemote : repository.getRemotes()) {
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                String remoteName = gitRemote.getName();
                if ("github".equals(remoteName) || "origin".equals(remoteName)) {
                    return Pair.create((Object)gitRemote, (Object)remoteUrl);
                }
                if (githubRemote != null) continue block0;
                githubRemote = Pair.create((Object)gitRemote, (Object)remoteUrl);
                continue block0;
            }
        }
        return githubRemote;
    }

    @Nullable
    public static String findUpstreamRemote(@NotNull GitRepository repository) {
        if (repository == null) {
            GithubUtil.$$$reportNull$$$0(56);
        }
        for (GitRemote gitRemote : repository.getRemotes()) {
            String remoteName = gitRemote.getName();
            if (!"upstream".equals(remoteName)) continue;
            for (String remoteUrl : gitRemote.getUrls()) {
                if (!GithubUrlUtil.isGithubUrl(remoteUrl)) continue;
                return remoteUrl;
            }
            return gitRemote.getFirstUrl();
        }
        return null;
    }

    public static boolean testGitExecutable(Project project) {
        return GitExecutableManager.getInstance().testGitExecutableVersionValid(project);
    }

    public static boolean isRepositoryOnGitHub(@NotNull GitRepository repository) {
        if (repository == null) {
            GithubUtil.$$$reportNull$$$0(57);
        }
        return GithubUtil.findGithubRemoteUrl(repository) != null;
    }

    @NotNull
    public static String getErrorTextFromException(@NotNull Exception e) {
        if (e == null) {
            GithubUtil.$$$reportNull$$$0(58);
        }
        if (e instanceof UnknownHostException) {
            String string = "Unknown host: " + e.getMessage();
            if (string == null) {
                GithubUtil.$$$reportNull$$$0(59);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)e.getMessage(), (String)"Unknown error");
        if (string == null) {
            GithubUtil.$$$reportNull$$$0(60);
        }
        return string;
    }

    @Nullable
    public static GitRepository getGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        GitRepository repository;
        GitRepositoryManager manager;
        List repositories;
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(61);
        }
        if ((repositories = (manager = GitUtil.getRepositoryManager((Project)project)).getRepositories()).size() == 0) {
            return null;
        }
        if (repositories.size() == 1) {
            return (GitRepository)repositories.get(0);
        }
        if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
            return repository;
        }
        return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
    }

    public static boolean addGithubRemote(@NotNull Project project, @NotNull GitRepository repository, @NotNull String remote, @NotNull String url) {
        if (project == null) {
            GithubUtil.$$$reportNull$$$0(62);
        }
        if (repository == null) {
            GithubUtil.$$$reportNull$$$0(63);
        }
        if (remote == null) {
            GithubUtil.$$$reportNull$$$0(64);
        }
        if (url == null) {
            GithubUtil.$$$reportNull$$$0(65);
        }
        GitLineHandler handler = new GitLineHandler(project, repository.getRoot(), GitCommand.REMOTE);
        handler.setSilent(true);
        try {
            handler.addParameters(new String[]{"add", remote, url});
            GitCommandResult result = Git.getInstance().runCommand(handler);
            result.getOutputOrThrow(new int[0]);
            if (result.getExitCode() != 0) {
                GithubNotifications.showError(project, "Can't add remote", "Failed to add GitHub remote: '" + url + "'. " + result.getErrorOutputAsJoinedString());
                return false;
            }
            repository.update();
            return true;
        }
        catch (VcsException e) {
            GithubNotifications.showError(project, "Can't add remote", (Exception)((Object)e));
            return false;
        }
    }

    public static Couple<String> getGithubLikeFormattedDescriptionMessage(String commitMessage) {
        String description;
        String subject;
        String message;
        String string = message = commitMessage == null ? "" : commitMessage.trim();
        if (message.isEmpty()) {
            return Couple.of((Object)"", (Object)"");
        }
        int firstLineEnd = message.indexOf("\n");
        if (firstLineEnd > -1) {
            subject = message.substring(0, firstLineEnd).trim();
            description = message.substring(firstLineEnd + 1).trim();
        } else {
            subject = message;
            description = "";
        }
        return Couple.of((Object)subject, (Object)description);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 34: 
            case 35: 
            case 39: 
            case 59: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 34: 
            case 35: 
            case 39: 
            case 59: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 23: 
            case 28: 
            case 37: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authHolder";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 16: 
            case 19: 
            case 24: 
            case 29: 
            case 33: 
            case 38: 
            case 52: 
            case 69: 
            case 74: 
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 8: 
            case 42: 
            case 45: 
            case 48: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 7: 
            case 25: 
            case 32: 
            case 73: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authLevel";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 34: 
            case 35: 
            case 39: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/util/GithubUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "run";
                break;
            }
            case 17: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 20: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 26: 
            case 30: 
            case 67: 
            case 72: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldAuth";
                break;
            }
            case 41: 
            case 44: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/util/GithubUtil";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "testConnection";
                break;
            }
            case 15: 
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "addCancellationListener";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidAuthDataHolderFromConfig";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAuthData";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorTextFromException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "testConnection";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 34: 
            case 35: 
            case 39: 
            case 59: 
            case 60: {
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addCancellationListener";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getValidAuthData";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTwoFactorAuthData";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getValidAuthDataHolderFromConfig";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkAuthData";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "computeValueInModalIO";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "computeValueInModal";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "runInterruptable";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findGithubRemoteUrl";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findGithubRemote";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findUpstreamRemote";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isRepositoryOnGitHub";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getErrorTextFromException";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getGitRepository";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addGithubRemote";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTwoFactorAuthData$5";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getValidAuthData$3";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCancellationListener$1";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addCancellationListener$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 34: 
            case 35: 
            case 39: 
            case 59: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

