/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KtElementImpl
extends ASTWrapperPsiElement
implements KtElement {
    public KtElementImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        return KotlinLanguage.INSTANCE;
    }

    @Override
    public String toString() {
        return this.getNode().getElementType().toString();
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof KtVisitor) {
            this.accept((KtVisitor)visitor2, null);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public KtFile getContainingKtFile() {
        PsiFile file2 = this.getContainingFile();
        assert (file2 instanceof KtFile) : "KtElement not inside KtFile: " + file2 + (file2 == null ? "" : " " + file2.getText());
        return (KtFile)file2;
    }

    @Override
    public <D> void acceptChildren(@NotNull KtVisitor<Void, D> visitor2, D data) {
        KtPsiUtil.visitChildren(this, visitor2, data);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitKtElement(this, data);
    }

    @Override
    public void delete() throws IncorrectOperationException {
        KtElementUtilsKt.deleteSemicolon(this);
        super.delete();
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references.length == 1) {
            return references[0];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, PsiReferenceService.Hints.NO_HINTS);
    }

    @Override
    @NotNull
    public KtElement getPsiOrParent() {
        return this;
    }

    @Override
    public PsiElement getParent() {
        PsiElement substitute2 = KtPsiUtilKt.getParentSubstitute(this);
        return substitute2 != null ? substitute2 : super.getParent();
    }
}

