/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrientationMenuAction
extends DropDownAction {
    private final ConfigurationHolder myRenderContext;
    private final EditorDesignSurface mySurface;

    public OrientationMenuAction(@NotNull ConfigurationHolder renderContext, @Nullable EditorDesignSurface surface) {
        if (renderContext == null) {
            OrientationMenuAction.$$$reportNull$$$0(0);
        }
        super("", "Orientation in Editor", StudioIcons.LayoutEditor.Toolbar.ROTATE_BUTTON);
        this.myRenderContext = renderContext;
        this.mySurface = surface;
    }

    @NotNull
    private static String getPresentationDescription(@NotNull State state) {
        if (state == null) {
            OrientationMenuAction.$$$reportNull$$$0(1);
        }
        String string = String.format("Switch to %1$s", state.getName());
        if (string == null) {
            OrientationMenuAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected boolean updateActions() {
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            Device device = configuration.getDevice();
            if (device != null) {
                List states = device.getAllStates();
                State current = configuration.getDeviceState();
                if (states.size() > 1 && current != null) {
                    State flip = configuration.getNextDeviceState(current);
                    State nextSate = flip == null ? current : flip;
                    String title = OrientationMenuAction.getPresentationDescription(nextSate);
                    this.add(new SetDeviceStateAction(this.myRenderContext, title, nextSate, true));
                    this.addSeparator();
                }
                for (State config : states) {
                    String stateName;
                    String title = stateName = config.getName();
                    VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, stateName, null, null);
                    if (better != null) {
                        title = ConfigurationAction.getBetterMatchLabel(stateName, better, configuration.getFile());
                    }
                    this.add(new SetDeviceStateAction(this.myRenderContext, title, config, false));
                }
                this.addSeparator();
            }
            this.addSeparator();
            DefaultActionGroup uiModeGroup = new DefaultActionGroup("_UI Mode", true);
            UiMode currentUiMode = configuration.getUiMode();
            for (State uiMode : UiMode.values()) {
                String title = uiMode.getShortDisplayValue();
                boolean checked = uiMode == currentUiMode;
                uiModeGroup.add((AnAction)new SetUiModeAction(this.myRenderContext, title, (UiMode)uiMode, checked));
            }
            this.add((AnAction)uiModeGroup);
            this.addSeparator();
            DefaultActionGroup nightModeGroup = new DefaultActionGroup("_Night Mode", true);
            NightMode currentNightMode = configuration.getNightMode();
            for (NightMode nightMode : NightMode.values()) {
                String title = nightMode.getShortDisplayValue();
                boolean checked = nightMode == currentNightMode;
                nightModeGroup.add((AnAction)new SetNightModeAction(this.myRenderContext, title, nightMode, checked));
            }
            this.add((AnAction)nightModeGroup);
            if (this.mySurface != null) {
                this.addSeparator();
                this.createVariationsActions(configuration, this.mySurface);
            }
        }
        return true;
    }

    private void createVariationsActions(@NotNull Configuration configuration, @NotNull EditorDesignSurface surface) {
        VirtualFile virtualFile;
        if (configuration == null) {
            OrientationMenuAction.$$$reportNull$$$0(3);
        }
        if (surface == null) {
            OrientationMenuAction.$$$reportNull$$$0(4);
        }
        if ((virtualFile = configuration.getFile()) != null) {
            ResourceFolderType folderType;
            Module module = configuration.getModule();
            if (module == null) {
                return;
            }
            Project project = module.getProject();
            List<VirtualFile> variations = ResourceHelper.getResourceVariations(virtualFile, true);
            if (variations.size() > 1) {
                for (VirtualFile file : variations) {
                    String title = String.format("Switch to %1$s", file.getParent().getName());
                    this.add(new SwitchToVariationAction(title, project, file, virtualFile.equals(file)));
                }
                this.addSeparator();
            }
            if ((folderType = ResourceHelper.getFolderType(configuration.getFile())) == ResourceFolderType.LAYOUT) {
                boolean haveLandscape = false;
                boolean haveLarge = false;
                for (VirtualFile file : variations) {
                    ScreenSizeQualifier size;
                    FolderConfiguration config;
                    String name = file.getParent().getName();
                    if (!name.startsWith("layout") || (config = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
                    ScreenOrientationQualifier orientation = config.getScreenOrientationQualifier();
                    if (orientation != null && orientation.getValue() == ScreenOrientation.LANDSCAPE) {
                        haveLandscape = true;
                        if (haveLarge) break;
                    }
                    if ((size = config.getScreenSizeQualifier()) == null || size.getValue() != ScreenSize.XLARGE) continue;
                    haveLarge = true;
                    if (!haveLandscape) continue;
                    break;
                }
                if (!haveLandscape) {
                    this.add(new CreateVariationAction(surface, "Create Landscape Variation", "layout-land"));
                }
                if (!haveLarge) {
                    this.add(new CreateVariationAction(surface, "Create layout-xlarge Variation", "layout-xlarge"));
                }
                this.add(new CreateVariationAction(surface, "Create Other...", null));
            } else {
                this.add(new CreateVariationAction(surface, "Create Alternative...", null));
            }
        }
    }

    @NotNull
    public static Icon getOrientationIcon(@NotNull ScreenOrientation orientation, boolean flip) {
        if (orientation == null) {
            OrientationMenuAction.$$$reportNull$$$0(5);
        }
        switch (orientation) {
            case LANDSCAPE: {
                Icon icon = flip ? AndroidIcons.FlipLandscape : AndroidIcons.Landscape;
                if (icon == null) {
                    OrientationMenuAction.$$$reportNull$$$0(6);
                }
                return icon;
            }
            case SQUARE: {
                Icon icon = AndroidIcons.Square;
                if (icon == null) {
                    OrientationMenuAction.$$$reportNull$$$0(7);
                }
                return icon;
            }
        }
        Icon icon = flip ? AndroidIcons.FlipPortrait : AndroidIcons.Portrait;
        if (icon == null) {
            OrientationMenuAction.$$$reportNull$$$0(8);
        }
        return icon;
    }

    @NotNull
    public static ScreenOrientation getOrientation(@NotNull State state) {
        if (state == null) {
            OrientationMenuAction.$$$reportNull$$$0(9);
        }
        FolderConfiguration config = DeviceConfigHelper.getFolderConfig((State)state);
        ScreenOrientation orientation = null;
        if (config != null && config.getScreenOrientationQualifier() != null) {
            orientation = config.getScreenOrientationQualifier().getValue();
        }
        if (orientation == null) {
            orientation = ScreenOrientation.PORTRAIT;
        }
        ScreenOrientation screenOrientation = orientation;
        if (screenOrientation == null) {
            OrientationMenuAction.$$$reportNull$$$0(10);
        }
        return screenOrientation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderContext";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/OrientationMenuAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationDescription";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientationIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationDescription";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVariationsActions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrientationIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrientation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateVariationAction
    extends AnAction {
        @NotNull
        private EditorDesignSurface mySurface;
        @Nullable
        private String myNewFolder;

        public CreateVariationAction(@NotNull EditorDesignSurface surface, @NotNull String title, @Nullable String newFolder) {
            if (surface == null) {
                CreateVariationAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                CreateVariationAction.$$$reportNull$$$0(1);
            }
            super(title, null, null);
            this.mySurface = surface;
            this.myNewFolder = newFolder;
        }

        public void actionPerformed(AnActionEvent e) {
            OverrideResourceAction.forkResourceFile(this.mySurface, this.myNewFolder, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "surface";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/configurations/OrientationMenuAction$CreateVariationAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SwitchToVariationAction
    extends AnAction {
        private final Project myProject;
        private final VirtualFile myFile;

        public SwitchToVariationAction(@NotNull String title, @NotNull Project project, @NotNull VirtualFile file, boolean select) {
            if (title == null) {
                SwitchToVariationAction.$$$reportNull$$$0(0);
            }
            if (project == null) {
                SwitchToVariationAction.$$$reportNull$$$0(1);
            }
            if (file == null) {
                SwitchToVariationAction.$$$reportNull$$$0(2);
            }
            super(title, null, null);
            this.myFile = file;
            this.myProject = project;
            if (select) {
                Presentation templatePresentation = this.getTemplatePresentation();
                templatePresentation.setIcon(AllIcons.Actions.Checked);
                templatePresentation.setEnabled(false);
            }
        }

        public void actionPerformed(AnActionEvent e) {
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myFile, -1);
            FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SwitchToVariationAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SetNightModeAction
    extends ConfigurationAction {
        @NotNull
        private final NightMode myNightMode;

        private SetNightModeAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull NightMode nightMode, boolean checked) {
            if (renderContext == null) {
                SetNightModeAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetNightModeAction.$$$reportNull$$$0(1);
            }
            if (nightMode == null) {
                SetNightModeAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myNightMode = nightMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetNightModeAction.$$$reportNull$$$0(3);
            }
            configuration.setNightMode(this.myNightMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nightMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SetNightModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SetUiModeAction
    extends ConfigurationAction {
        @NotNull
        private final UiMode myUiMode;

        private SetUiModeAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull UiMode uiMode, boolean checked) {
            if (renderContext == null) {
                SetUiModeAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetUiModeAction.$$$reportNull$$$0(1);
            }
            if (uiMode == null) {
                SetUiModeAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myUiMode = uiMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetUiModeAction.$$$reportNull$$$0(3);
            }
            configuration.setUiMode(this.myUiMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SetUiModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SetDeviceStateAction
    extends ConfigurationAction {
        @NotNull
        private final State myState;

        private SetDeviceStateAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull State state, boolean flip) {
            if (renderContext == null) {
                SetDeviceStateAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetDeviceStateAction.$$$reportNull$$$0(1);
            }
            if (state == null) {
                SetDeviceStateAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myState = state;
            ScreenOrientation orientation = OrientationMenuAction.getOrientation(state);
            this.getTemplatePresentation().setIcon(OrientationMenuAction.getOrientationIcon(orientation, flip));
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetDeviceStateAction.$$$reportNull$$$0(3);
            }
            configuration.setDeviceState(this.myState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SetDeviceStateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

