/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.adb;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tools.idea.ddms.adb.AdbLogOutput;
import com.android.tools.idea.ddms.adb.AdbOptionsService;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.actions.AndroidEnableAdbServiceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbService
implements Disposable,
AdbOptionsService.AdbOptionsListener {
    private static final Logger LOG = Logger.getInstance(AdbService.class);
    public static final int TIMEOUT = 3000000;
    @Nullable
    private ListenableFuture<AndroidDebugBridge> myFuture;
    private final AtomicReference<File> myAdb = new AtomicReference();
    private static final Object ADB_INIT_LOCK = new Object();

    public static AdbService getInstance() {
        return (AdbService)ServiceManager.getService(AdbService.class);
    }

    private AdbService() {
        String defaultLogLevel = AdbLogOutput.SystemLogRedirecter.getLogger().isTraceEnabled() ? Log.LogLevel.VERBOSE.getStringValue() : (AdbLogOutput.SystemLogRedirecter.getLogger().isDebugEnabled() ? Log.LogLevel.DEBUG.getStringValue() : Log.LogLevel.INFO.getStringValue());
        DdmPreferences.setLogLevel((String)defaultLogLevel);
        DdmPreferences.setTimeOut((int)3000000);
        Log.addLogger((Log.ILogOutput)new AdbLogOutput.SystemLogRedirecter());
        AdbOptionsService.getInstance().addListener(this);
    }

    public void dispose() {
        this.terminateDdmlib();
        AdbOptionsService.getInstance().removeListener(this);
    }

    public synchronized ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull File adb) {
        if (adb == null) {
            AdbService.$$$reportNull$$$0(0);
        }
        this.myAdb.set(adb);
        if (this.myFuture != null && this.myFuture.isDone() && !AdbService.wasSuccessful(this.myFuture)) {
            this.terminateDdmlib();
        }
        if (this.myFuture == null) {
            Future future = ApplicationManager.getApplication().executeOnPooledThread((Callable)new CreateBridgeTask(adb));
            this.myFuture = AdbService.makeTimedFuture(future, 20L, TimeUnit.SECONDS);
        }
        return this.myFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminateDdmlib() {
        if (this.myFuture != null) {
            this.myFuture.cancel(true);
            this.myFuture = null;
        }
        Object object = ADB_INIT_LOCK;
        synchronized (object) {
            AndroidDebugBridge.disconnectBridge();
            AndroidDebugBridge.terminate();
        }
    }

    public static boolean isDdmsCorrupted(@NotNull AndroidDebugBridge bridge) {
        IDevice[] devices;
        if (bridge == null) {
            AdbService.$$$reportNull$$$0(1);
        }
        if ((devices = bridge.getDevices()).length > 0) {
            for (IDevice device : devices) {
                Client[] clients = device.getClients();
                if (clients.length <= 0) continue;
                ClientData clientData = clients[0].getClientData();
                return clientData.getVmIdentifier() == null;
            }
        }
        return false;
    }

    @NotNull
    public synchronized ListenableFuture<AndroidDebugBridge> restartDdmlib(@NotNull File adb) {
        if (adb == null) {
            AdbService.$$$reportNull$$$0(2);
        }
        this.terminateDdmlib();
        ListenableFuture<AndroidDebugBridge> listenableFuture = this.getDebugBridge(adb);
        if (listenableFuture == null) {
            AdbService.$$$reportNull$$$0(3);
        }
        return listenableFuture;
    }

    private static boolean wasSuccessful(Future<AndroidDebugBridge> future) {
        if (!future.isDone()) {
            return false;
        }
        try {
            AndroidDebugBridge bridge = future.get();
            return bridge != null && bridge.isConnected();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void optionsChanged() {
        File adb = this.myAdb.get();
        if (adb != null) {
            LOG.info("Terminating adb server");
            this.terminateDdmlib();
            LOG.info("Restart adb server");
            this.getDebugBridge(adb);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ListenableFuture<AndroidDebugBridge> makeTimedFuture(@NotNull Future<BridgeConnectionResult> delegate, long timeout, @NotNull TimeUnit timeUnit) {
        void unit;
        if (delegate == null) {
            AdbService.$$$reportNull$$$0(4);
        }
        if (timeUnit == null) {
            AdbService.$$$reportNull$$$0(5);
        }
        SettableFuture future = SettableFuture.create();
        ApplicationManager.getApplication().executeOnPooledThread(() -> AdbService.lambda$makeTimedFuture$0(delegate, timeout, (TimeUnit)unit, future));
        return future;
    }

    public static String getDebugBridgeDiagnosticErrorMessage(@NotNull Throwable t, @NotNull File adb) {
        if (t == null) {
            AdbService.$$$reportNull$$$0(6);
        }
        if (adb == null) {
            AdbService.$$$reportNull$$$0(7);
        }
        String msg = t.getMessage() != null ? t.getMessage() : String.format("Unable to establish a connection to adb.\n\nCheck the Event Log for possible issues.\nThis can happen if you have an incompatible version of adb running already.\nTry re-opening %1$s after killing any existing adb daemons.\n\nIf this happens repeatedly, please file a bug at http://b.android.com including the following:\n  1. Output of the command: '%2$s devices'\n  2. Your idea.log file (Help | Show Log in Explorer)\n", ApplicationNamesInfo.getInstance().getProductName(), adb.getAbsolutePath());
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$makeTimedFuture$0(@NotNull Future delegate, long timeout, @NotNull TimeUnit unit, SettableFuture settableFuture) {
        void future;
        if (delegate == null) {
            AdbService.$$$reportNull$$$0(8);
        }
        if (unit == null) {
            AdbService.$$$reportNull$$$0(9);
        }
        try {
            BridgeConnectionResult value = (BridgeConnectionResult)delegate.get(timeout, unit);
            if (value.error != null) {
                future.setException((Throwable)new RuntimeException("Unable to create Debug Bridge: " + value.error));
            } else {
                future.set((Object)value.bridge);
            }
        }
        catch (ExecutionException e) {
            future.setException(e.getCause());
        }
        catch (InterruptedException | TimeoutException e) {
            delegate.cancel(true);
            future.setException((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adb";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridge";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/adb/AdbService";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/adb/AdbService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "restartDdmlib";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDebugBridge";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDdmsCorrupted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restartDdmlib";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeTimedFuture";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDebugBridgeDiagnosticErrorMessage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$makeTimedFuture$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BridgeConnectionResult {
        @Nullable
        public final AndroidDebugBridge bridge;
        @Nullable
        public final String error;

        private BridgeConnectionResult(@Nullable AndroidDebugBridge bridge, @Nullable String error) {
            this.bridge = bridge;
            this.error = error;
        }

        public static BridgeConnectionResult make(@NotNull AndroidDebugBridge bridge) {
            if (bridge == null) {
                BridgeConnectionResult.$$$reportNull$$$0(0);
            }
            return new BridgeConnectionResult(bridge, null);
        }

        public static BridgeConnectionResult make(@NotNull String error) {
            if (error == null) {
                BridgeConnectionResult.$$$reportNull$$$0(1);
            }
            return new BridgeConnectionResult(null, error);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bridge";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "error";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/ddms/adb/AdbService$BridgeConnectionResult";
            objectArray[2] = "make";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CreateBridgeTask
    implements Callable<BridgeConnectionResult> {
        private final File myAdb;

        public CreateBridgeTask(@NotNull File adb) {
            if (adb == null) {
                CreateBridgeTask.$$$reportNull$$$0(0);
            }
            this.myAdb = adb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BridgeConnectionResult call() throws Exception {
            boolean clientSupport = AndroidEnableAdbServiceAction.isAdbServiceEnabled();
            LOG.info("Initializing adb using: " + this.myAdb.getAbsolutePath() + ", client support = " + clientSupport);
            ImmutableMap env = ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode() ? ImmutableMap.of((Object)"HOME", (Object)Files.createTempDir().getAbsolutePath()) : ImmutableMap.of();
            AdbLogOutput.ToStringLogger toStringLogger = new AdbLogOutput.ToStringLogger();
            Log.addLogger((Log.ILogOutput)toStringLogger);
            try {
                AndroidDebugBridge bridge;
                Object object = ADB_INIT_LOCK;
                synchronized (object) {
                    AndroidDebugBridge.init((boolean)clientSupport, (boolean)AdbOptionsService.getInstance().shouldUseLibusb(), (Map)env);
                    bridge = AndroidDebugBridge.createBridge((String)this.myAdb.getPath(), (boolean)false);
                }
                if (bridge == null) {
                    object = BridgeConnectionResult.make("Unable to start adb server: " + toStringLogger.getOutput());
                    return object;
                }
                while (!bridge.isConnected()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        BridgeConnectionResult bridgeConnectionResult = BridgeConnectionResult.make("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                        Log.removeLogger((Log.ILogOutput)toStringLogger);
                        return bridgeConnectionResult;
                    }
                }
                LOG.info("Successfully connected to adb");
                object = BridgeConnectionResult.make(bridge);
                return object;
            }
            finally {
                Log.removeLogger((Log.ILogOutput)toStringLogger);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adb", "com/android/tools/idea/ddms/adb/AdbService$CreateBridgeTask", "<init>"));
        }
    }
}

