/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hprof.views;

import com.android.tools.idea.editors.hprof.HprofEditor;
import com.android.tools.idea.editors.hprof.HprofView;
import com.android.tools.idea.editors.hprof.views.SelectionModel;
import com.android.tools.idea.profiling.view.AnalysisContentsDelegate;
import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.heap.ArrayInstance;
import com.android.tools.perflib.heap.ClassInstance;
import com.android.tools.perflib.heap.ClassObj;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.memoryanalyzer.DuplicatedStringsAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.LeakedActivityAnalyzerTask;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalysisResultEntry;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import icons.AndroidIcons;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HprofAnalysisContentsDelegate
extends AnalysisContentsDelegate {
    @NotNull
    private static final Logger LOG = Logger.getInstance(HprofAnalysisContentsDelegate.class);

    public HprofAnalysisContentsDelegate(@NotNull HprofEditor editor) {
        if (editor == null) {
            HprofAnalysisContentsDelegate.$$$reportNull$$$0(0);
        }
        super(editor.getCapturePanel());
        HprofView hprofView = editor.getView();
        assert (hprofView != null);
        final SelectionModel selectionModel = hprofView.getSelectionModel();
        this.myResultsTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath path = treeSelectionEvent.getPath();
                if (path.getPath().length <= 1) {
                    return;
                }
                Object component2 = path.getLastPathComponent();
                if (component2 instanceof DefaultMutableTreeNode) {
                    component2 = ((DefaultMutableTreeNode)component2).getUserObject();
                }
                if (component2 instanceof InstanceListItem) {
                    Instance instance = ((InstanceListItem)component2).myInstance;
                    Heap heap = instance.getHeap();
                    ClassObj classObj = instance instanceof ClassObj ? (ClassObj)instance : instance.getClassObj();
                    selectionModel.setHeap(heap);
                    selectionModel.setClassObj(classObj);
                    if (instance instanceof ClassInstance || instance instanceof ArrayInstance) {
                        selectionModel.setInstance(instance);
                    }
                }
            }
        });
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            HprofAnalysisContentsDelegate.$$$reportNull$$$0(1);
        }
        if (value instanceof DefaultMutableTreeNode) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof EntryListItem) {
                int index = ((EntryListItem)userObject).myIndex;
                AnalysisResultEntry resultEntry = ((EntryListItem)userObject).myEntry;
                if (resultEntry instanceof DuplicatedStringsAnalyzerTask.DuplicatedStringsEntry) {
                    DuplicatedStringsAnalyzerTask.DuplicatedStringsEntry entry = (DuplicatedStringsAnalyzerTask.DuplicatedStringsEntry)resultEntry;
                    this.append(Integer.toString(index), XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                    this.append(" = ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.append(String.format("\"%s\" (%d instances)", entry.getOffender().getOffendingDescription(), entry.getOffender().getOffenders().size()), SimpleTextAttributes.fromTextAttributes((TextAttributes)DebuggerUIUtil.getColorScheme(null).getAttributes(JavaHighlightingColors.STRING)));
                }
            } else if (userObject instanceof InstanceListItem) {
                int index = ((InstanceListItem)userObject).myIndex;
                Instance instance = ((InstanceListItem)userObject).myInstance;
                this.append(Integer.toString(index), XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                this.append(" = ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String className = null;
                if (instance instanceof ClassInstance) {
                    this.setIcon(AllIcons.Debugger.Value);
                    className = instance.getClassObj().getClassName();
                } else if (instance instanceof ClassObj) {
                    this.setIcon(PlatformIcons.CLASS_ICON);
                    className = ((ClassObj)instance).getClassName();
                } else if (instance instanceof ArrayInstance) {
                    this.setIcon(AllIcons.Debugger.Db_array);
                    className = instance.getClassObj().getClassName();
                }
                if (className != null) {
                    int i = className.lastIndexOf(46);
                    if (i != -1) {
                        className = className.substring(i + 1);
                    }
                    long id = instance.getUniqueId();
                    this.append(String.format("{%s@%d (0x%x)}", className, id, id), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            } else if (userObject instanceof String) {
                this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            } else if (userObject != null) {
                LOG.warn("Unhandled user object type: " + userObject.getClass().getSimpleName());
            }
        } else if (value != null) {
            LOG.warn("Invalid tree node type: " + value.getClass().getSimpleName());
        }
    }

    @Override
    @NotNull
    public Icon getToolIcon() {
        Icon icon = AndroidIcons.ToolWindows.HeapAnalysis;
        if (icon == null) {
            HprofAnalysisContentsDelegate.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Nullable
    public DefaultMutableTreeNode getNodeForEntry(int index, @NotNull AnalysisResultEntry entry) {
        if (entry == null) {
            HprofAnalysisContentsDelegate.$$$reportNull$$$0(3);
        }
        if (!(entry instanceof MemoryAnalysisResultEntry)) {
            return null;
        }
        DefaultMutableTreeNode subtreeRoot = new DefaultMutableTreeNode();
        if (entry instanceof DuplicatedStringsAnalyzerTask.DuplicatedStringsEntry) {
            DuplicatedStringsAnalyzerTask.DuplicatedStringsEntry duplicatedStringsEntry = (DuplicatedStringsAnalyzerTask.DuplicatedStringsEntry)entry;
            subtreeRoot.setUserObject(new EntryListItem(index, (AnalysisResultEntry)duplicatedStringsEntry));
            for (Instance instance : duplicatedStringsEntry.getOffender().getOffenders()) {
                subtreeRoot.add(new DefaultMutableTreeNode(new InstanceListItem(subtreeRoot.getChildCount(), instance)));
            }
        } else if (entry instanceof LeakedActivityAnalyzerTask.LeakedActivityEntry) {
            LeakedActivityAnalyzerTask.LeakedActivityEntry leakedActivityEntry = (LeakedActivityAnalyzerTask.LeakedActivityEntry)entry;
            subtreeRoot.setUserObject(new InstanceListItem(index, (Instance)leakedActivityEntry.getOffender().getOffenders().get(0)));
        } else {
            throw new RuntimeException("Failed to handle a subtype of MemoryAnalysisResultEntry \"" + entry.getClass().getSimpleName() + "\". Perhaps this method needs to be updated?");
        }
        return subtreeRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/hprof/views/HprofAnalysisContentsDelegate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/hprof/views/HprofAnalysisContentsDelegate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "customizeCellRenderer";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EntryListItem {
        public int myIndex;
        public AnalysisResultEntry myEntry;

        public EntryListItem(int index, @NotNull AnalysisResultEntry entry) {
            if (entry == null) {
                EntryListItem.$$$reportNull$$$0(0);
            }
            this.myIndex = index;
            this.myEntry = entry;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/android/tools/idea/editors/hprof/views/HprofAnalysisContentsDelegate$EntryListItem", "<init>"));
        }
    }

    private static class InstanceListItem {
        public int myIndex;
        public Instance myInstance;

        public InstanceListItem(int index, @NotNull Instance instance) {
            if (instance == null) {
                InstanceListItem.$$$reportNull$$$0(0);
            }
            this.myIndex = index;
            this.myInstance = instance;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instance", "com/android/tools/idea/editors/hprof/views/HprofAnalysisContentsDelegate$InstanceListItem", "<init>"));
        }
    }
}

