/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.res2.ResourceItem;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.psi.PsiFile;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteStringAction
extends AbstractAction {
    private final StringResourceViewPanel myPanel;

    public DeleteStringAction(@NotNull StringResourceViewPanel panel) {
        if (panel == null) {
            DeleteStringAction.$$$reportNull$$$0(0);
        }
        super("Delete");
        this.myPanel = panel;
    }

    public void update(@NotNull JMenuItem delete, @NotNull MouseEvent e) {
        if (delete == null) {
            DeleteStringAction.$$$reportNull$$$0(1);
        }
        if (e == null) {
            DeleteStringAction.$$$reportNull$$$0(2);
        }
        StringResourceTable table = this.myPanel.getTable();
        int[] rows = table.getSelectedRowModelIndices();
        int[] cols = table.getSelectedColumnModelIndices();
        int tableRow = table.rowAtPoint(e.getPoint());
        int tableColumn = table.columnAtPoint(e.getPoint());
        if ((rows.length == 0 || cols.length == 0) && tableRow >= 0 && tableColumn >= 0) {
            table.setRowSelectionInterval(tableRow, tableRow);
            table.setColumnSelectionInterval(tableColumn, tableColumn);
            rows = table.getSelectedRowModelIndices();
            cols = table.getSelectedColumnModelIndices();
        }
        for (int col : cols) {
            if (col != 0 && col != 1 && col != 2) continue;
            delete.setText("Delete Key(s)");
            delete.setVisible(true);
            return;
        }
        StringResourceTableModel model = table.getModel();
        for (int row : rows) {
            for (int column : cols) {
                ResourceItem item;
                Locale locale = model.getLocale(column);
                StringResource resource = model.getStringResourceAt(row);
                ResourceItem resourceItem = item = locale == null ? resource.getDefaultValueAsResourceItem() : resource.getTranslationAsResourceItem(locale);
                if (item == null) continue;
                delete.setText("Delete String(s)");
                delete.setVisible(true);
                return;
            }
        }
        delete.setVisible(false);
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        int[] cols;
        final StringResourceTable table = this.myPanel.getTable();
        for (int col : cols = table.getSelectedColumnModelIndices()) {
            if (col != 0 && col != 1 && col != 2) continue;
            this.myPanel.removeSelectedKeys();
            return;
        }
        final int[] rows = table.getSelectedRowModelIndices();
        if (rows.length == 1 && cols.length == 1) {
            table.getModel().setValueAt("", rows[0], cols[0]);
        } else {
            new WriteCommandAction.Simple(this.myPanel.getFacet().getModule().getProject(), "Delete multiple strings", new PsiFile[0]){

                protected void run() throws Throwable {
                    for (int row : rows) {
                        for (int col : cols) {
                            table.getModel().setValueAt("", row, col);
                        }
                    }
                }
            }.execute();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delete";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/editors/strings/DeleteStringAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

